/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.RunIntoMethodActionSupport;
import org.netbeans.modules.debugger.jpda.actions.StepOperationActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class JPDAMethodChooserUtils {
    private JPDAMethodChooserUtils() {
    }

    public static void doStepInto(final JPDADebuggerImpl debugger, EditorContext.Operation operation, final Location location, final ExpressionPool.Interval expressionLines) {
        final String name = operation.getMethodName();
        final boolean isNative = operation.isNative();
        final String methodClassType = operation.getMethodClassType();
        debugger.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                RunIntoMethodActionSupport.doAction(debugger, name, methodClassType, isNative, location, expressionLines, true, MethodEntry.SELECTED);
            }
        });
    }

    public static Params init(JPDADebuggerImpl debugger, JPDAThread currentThread, String url, ReleaseUIListener ruil) {
        Params params = new Params();
        return JPDAMethodChooserUtils.init(debugger, currentThread, url, params, ruil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Params init(JPDADebuggerImpl debugger, JPDAThread currentThread, String url, Params params, ReleaseUIListener ruil) {
        int i;
        int i2;
        EditorContext.Operation selectedOp;
        int x;
        int index;
        params.operations = new EditorContext.Operation[0];
        Method method = ((JPDAThreadImpl)currentThread).getTopMethod();
        List<Object> locs = Collections.emptyList();
        try {
            for (int methodLine = currentThread.getLineNumber(null); methodLine > 0 && (locs = MethodWrapper.locationsOfLine(method, methodLine)).isEmpty(); --methodLine) {
            }
        }
        catch (InternalExceptionWrapper aiex) {
        }
        catch (VMDisconnectedExceptionWrapper aiex) {
            return params;
        }
        catch (AbsentInformationException aiex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)aiex, (Level)Level.INFO));
        }
        if (locs.isEmpty()) {
            return params;
        }
        ExpressionPool.Expression expr = debugger.getExpressionPool().getExpressionAt((Location)locs.get(0), url);
        if (expr == null) {
            return params;
        }
        params.expressionLines = expr.getInterval();
        EditorContext.Operation currOp = currentThread.getCurrentOperation();
        List lastOpsList = currentThread.getLastOperations();
        EditorContext.Operation lastOp = lastOpsList != null && lastOpsList.size() > 0 ? (EditorContext.Operation)lastOpsList.get(lastOpsList.size() - 1) : null;
        EditorContext.Operation[] tempOps = expr.getOperations();
        if (tempOps.length == 0) {
            return params;
        }
        Location[] tempLocs = expr.getLocations();
        params.operations = new EditorContext.Operation[tempOps.length];
        params.locations = new Location[tempOps.length];
        int l1 = Integer.MAX_VALUE;
        int l2 = 0;
        for (int x2 = 0; x2 < tempOps.length; ++x2) {
            EditorContext.Operation op;
            params.operations[x2] = op = tempOps[x2];
            params.locations[x2] = tempLocs[x2];
            int sl = op.getMethodStartPosition().getLine();
            int el = op.getMethodEndPosition().getLine();
            if (sl < l1) {
                l1 = sl;
            }
            if (el <= l2) continue;
            l2 = el;
        }
        params.startLine = l1;
        params.endLine = l2;
        int currOpIndex = -1;
        int lastOpIndex = -1;
        int operationsLength = params.operations.length;
        if (currOp != null) {
            index = currOp.getBytecodeIndex();
            for (x = 0; x < operationsLength; ++x) {
                if (params.operations[x].getBytecodeIndex() != index) continue;
                currOpIndex = x;
                break;
            }
        }
        if (lastOp != null) {
            index = lastOp.getBytecodeIndex();
            for (x = 0; x < operationsLength; ++x) {
                if (params.operations[x].getBytecodeIndex() != index) continue;
                lastOpIndex = x;
                break;
            }
        }
        EditorContext.Operation opToExecute = null;
        if (currOpIndex == -1) {
            selectedOp = params.operations[operationsLength - 1];
            opToExecute = params.operations[0];
        } else {
            int splitIndex;
            int n = splitIndex = currOpIndex == lastOpIndex ? currOpIndex : currOpIndex - 1;
            if (splitIndex + 1 < operationsLength) {
                opToExecute = params.operations[splitIndex + 1];
            }
            tempOps = new EditorContext.Operation[operationsLength - 1 - splitIndex];
            tempLocs = new Location[operationsLength - 1 - splitIndex];
            for (int x3 = 0; x3 < tempOps.length; ++x3) {
                tempOps[x3] = params.operations[x3 + splitIndex + 1];
                tempLocs[x3] = params.locations[x3 + splitIndex + 1];
            }
            params.operations = tempOps;
            params.locations = tempLocs;
            operationsLength = params.operations.length;
            if (operationsLength == 0) {
                return params;
            }
            selectedOp = params.operations[0];
        }
        Object[][] elems = new Object[operationsLength][2];
        for (i2 = 0; i2 < operationsLength; ++i2) {
            elems[i2][0] = params.operations[i2];
            elems[i2][1] = params.locations[i2];
        }
        Arrays.sort(elems, new OperatorsComparator());
        Params.access$102(params, new boolean[operationsLength]);
        for (i2 = 0; i2 < operationsLength; ++i2) {
            params.operations[i2] = (EditorContext.Operation)elems[i2][0];
            params.locations[i2] = (Location)elems[i2][1];
            ((Params)params).isCertainlyReachable[i2] = true;
        }
        int[] flags = new int[operationsLength];
        for (int i3 = 0; i3 < flags.length; ++i3) {
            flags[i3] = 0;
        }
        JPDAMethodChooserUtils.detectUnreachableOps(url, params.operations, flags, currOp);
        int count = 0;
        for (int i4 = 0; i4 < flags.length; ++i4) {
            if (flags[i4] >= 2) continue;
            ++count;
        }
        tempOps = params.operations;
        tempLocs = params.locations;
        params.operations = new EditorContext.Operation[count];
        params.locations = new Location[count];
        Params.access$102(params, new boolean[count]);
        operationsLength = count;
        int index2 = 0;
        int opToExecuteIndex = -1;
        for (i = 0; i < flags.length; ++i) {
            if (flags[i] >= 2) continue;
            params.operations[index2] = tempOps[i];
            params.locations[index2] = tempLocs[i];
            boolean bl = ((Params)params).isCertainlyReachable[index2] = flags[i] == 0;
            if (opToExecute == params.operations[index2]) {
                opToExecuteIndex = index2;
            }
            ++index2;
        }
        params.selectedIndex = 0;
        for (i = 0; i < operationsLength; ++i) {
            if (!params.operations[i].equals((Object)selectedOp) || !params.isCertainlyReachable[i]) continue;
            params.selectedIndex = i;
        }
        if (opToExecuteIndex >= 0 && !params.isCertainlyReachable[opToExecuteIndex]) {
            PropertyChangeListener pcl;
            if (params.chooserPropertyChangeListener == null) {
                pcl = new StepOpActionListener(debugger, currentThread, ruil);
                params.chooserPropertyChangeListener = pcl;
            } else {
                pcl = params.chooserPropertyChangeListener;
            }
            PropertyChangeListener propertyChangeListener = pcl;
            synchronized (propertyChangeListener) {
                StepOperationActionProvider.doAction(debugger, pcl);
                try {
                    pcl.wait();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return JPDAMethodChooserUtils.init(debugger, currentThread, url, params, ruil);
        }
        if (operationsLength == 1) {
            EditorContext.Operation op = params.operations[params.selectedIndex];
            String name = op.getMethodName();
            if ("<init>".equals(name)) {
                name = op.getMethodClassType();
            }
            RunIntoMethodActionSupport.doAction(debugger, name, op.getMethodClassType(), op.isNative(), params.locations[params.selectedIndex], expr.getInterval(), true, MethodEntry.DIRECT);
            params.continuedDirectly = true;
        } else {
            params.continuedDirectly = false;
        }
        return params;
    }

    private static void detectUnreachableOps(String url, final EditorContext.Operation[] operations, final int[] flags, final EditorContext.Operation currOp) {
        FileObject fileObj = null;
        try {
            fileObj = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (fileObj == null) {
            return;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)fileObj);
        if (js == null) {
            return;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController ci) throws Exception {
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        Logger.getLogger(JPDAMethodChooserUtils.class.getName()).warning("Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    SourcePositions positions = ci.getTrees().getSourcePositions();
                    CompilationUnitTree compUnit = ci.getCompilationUnit();
                    TreeUtilities treeUtils = ci.getTreeUtilities();
                    int pcOffset = currOp == null ? 0 : currOp.getMethodStartPosition().getOffset() + 1;
                    for (int i = 0; i < operations.length; ++i) {
                        int offset = operations[i].getMethodStartPosition().getOffset() + 1;
                        for (TreePath path = treeUtils.pathFor(offset); path != null; path = path.getParentPath()) {
                            Tree tree = path.getLeaf();
                            if (tree instanceof ConditionalExpressionTree) {
                                ConditionalExpressionTree ternaryOpTree = (ConditionalExpressionTree)tree;
                                ExpressionTree trueTree = ternaryOpTree.getTrueExpression();
                                ExpressionTree falseTree = ternaryOpTree.getFalseExpression();
                                long trueStart = positions.getStartPosition(compUnit, trueTree);
                                long trueEnd = positions.getEndPosition(compUnit, trueTree);
                                long falseStart = positions.getStartPosition(compUnit, falseTree);
                                long falseEnd = positions.getEndPosition(compUnit, falseTree);
                                if (trueStart <= (long)offset && (long)offset <= trueEnd) {
                                    if ((long)pcOffset >= trueStart) continue;
                                    this.markSegment(i, false);
                                    continue;
                                }
                                if (falseStart > (long)offset || (long)offset > falseEnd) continue;
                                if ((long)pcOffset < trueStart) {
                                    this.markSegment(i, false);
                                    continue;
                                }
                                if (trueStart > (long)pcOffset || (long)pcOffset > trueEnd) continue;
                                this.markSegment(i, true);
                                continue;
                            }
                            if (tree.getKind() != Tree.Kind.CONDITIONAL_AND && tree.getKind() != Tree.Kind.CONDITIONAL_OR) continue;
                            BinaryTree binaryTree = (BinaryTree)tree;
                            ExpressionTree rightTree = binaryTree.getRightOperand();
                            long rightStart = positions.getStartPosition(compUnit, rightTree);
                            long rightEnd = positions.getEndPosition(compUnit, rightTree);
                            if (rightStart > (long)offset || (long)offset > rightEnd || (long)pcOffset >= rightStart) continue;
                            this.markSegment(i, false);
                        }
                    }
                }

                public void markSegment(int index, boolean excludeSegment) {
                    if (flags[index] == 2) {
                        return;
                    }
                    flags[index] = excludeSegment ? 2 : 1;
                }
            }, true);
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
        }
    }

    public static interface ReleaseUIListener {
        public void releaseUI();
    }

    private static class StepOpActionListener
    implements PropertyChangeListener {
        private final JPDADebugger debugger;
        private final JPDAThread currentThread;
        private final ReleaseUIListener ruil;

        public StepOpActionListener(JPDADebugger debugger, JPDAThread currentThread, ReleaseUIListener ruil) {
            this.debugger = debugger;
            this.currentThread = currentThread;
            this.ruil = ruil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("exec".equals(evt.getPropertyName())) {
                StepOpActionListener stepOpActionListener = this;
                synchronized (stepOpActionListener) {
                    this.notifyAll();
                }
            }
            if (this.debugger.getState() == 4 || this.currentThread != this.debugger.getCurrentThread() || !this.currentThread.isSuspended()) {
                StepOpActionListener stepOpActionListener = this;
                synchronized (stepOpActionListener) {
                    this.notifyAll();
                }
                this.ruil.releaseUI();
            }
        }
    }

    public static final class Params {
        EditorContext.Operation[] operations;
        ExpressionPool.Interval expressionLines;
        Location[] locations;
        int startLine;
        int endLine;
        private boolean[] isCertainlyReachable;
        private int selectedIndex;
        private boolean continuedDirectly;
        private PropertyChangeListener chooserPropertyChangeListener;

        Params() {
        }

        public EditorContext.Operation[] getOperations() {
            return this.operations;
        }

        public ExpressionPool.Interval getExpressionLines() {
            return this.expressionLines;
        }

        public Location[] getLocations() {
            return this.locations;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public boolean[] getIsCertainlyReachable() {
            return this.isCertainlyReachable;
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public boolean isContinuedDirectly() {
            return this.continuedDirectly;
        }

        public PropertyChangeListener getChoosertPropertyChangeListener() {
            return this.chooserPropertyChangeListener;
        }

        static /* synthetic */ boolean[] access$102(Params x0, boolean[] x1) {
            x0.isCertainlyReachable = x1;
            return x1;
        }
    }

    private static final class OperatorsComparator
    implements Comparator {
        private OperatorsComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object[] a1 = (Object[])o1;
            Object[] a2 = (Object[])o2;
            EditorContext.Operation op1 = (EditorContext.Operation)a1[0];
            EditorContext.Operation op2 = (EditorContext.Operation)a2[0];
            return op1.getMethodStartPosition().getOffset() - op2.getMethodStartPosition().getOffset();
        }
    }

    public static enum MethodEntry {
        SELECTED,
        DIRECT;

    }
}

