/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.openide.util.WeakListeners;

class SourceRootsCache {
    private final SourcePath sourcePath;
    private final SourceRootsChangedListener chListener;
    private Set<String> rootPaths;
    private Set<File> rootFiles;
    private Set<String> projectRootPaths;
    private Set<File> projectRootFiles;

    SourceRootsCache(SourcePath sourcePath) {
        this.sourcePath = sourcePath;
        this.chListener = new SourceRootsChangedListener();
        sourcePath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.chListener, (Object)sourcePath));
    }

    SourcePath getSourcePath() {
        return this.sourcePath;
    }

    synchronized Set<String> getRootPaths() {
        if (this.rootPaths == null) {
            String[] sourceRoots = this.sourcePath.getSourceRoots();
            this.rootPaths = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(sourceRoots)));
        }
        return this.rootPaths;
    }

    synchronized Set<File> getRootCanonicalFiles() {
        if (this.rootFiles == null) {
            String[] sourceRoots = this.sourcePath.getSourceRoots();
            this.rootFiles = SourceRootsCache.getCanonicalFiles(sourceRoots);
        }
        return this.rootFiles;
    }

    synchronized Set<String> getProjectRootPaths() {
        if (this.projectRootPaths == null) {
            String[] sourceRoots = this.sourcePath.getProjectSourceRoots();
            this.projectRootPaths = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(sourceRoots)));
        }
        return this.projectRootPaths;
    }

    synchronized Set<File> getProjectRootCanonicalFiles() {
        if (this.projectRootFiles == null) {
            String[] sourceRoots = this.sourcePath.getProjectSourceRoots();
            this.projectRootFiles = SourceRootsCache.getCanonicalFiles(sourceRoots);
        }
        return this.projectRootFiles;
    }

    private static Set<File> getCanonicalFiles(String[] paths) {
        HashSet<File> files = new HashSet<File>(paths.length);
        for (String root : paths) {
            File rootFile = new File(root);
            try {
                rootFile = rootFile.getCanonicalFile();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            files.add(rootFile);
        }
        return Collections.unmodifiableSet(files);
    }

    private class SourceRootsChangedListener
    implements PropertyChangeListener {
        private SourceRootsChangedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("sourceRoots".equals(evt.getPropertyName())) {
                SourceRootsCache sourceRootsCache = SourceRootsCache.this;
                synchronized (sourceRootsCache) {
                    SourceRootsCache.this.rootPaths = null;
                    SourceRootsCache.this.rootFiles = null;
                }
            }
        }
    }
}

