/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi.event;

import com.sun.jdi.InternalException;
import com.sun.jdi.Mirror;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class EventWrapper {
    private EventWrapper() {
    }

    public static EventRequest request(Event a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.event.Event", "request", "JDI CALL: com.sun.jdi.event.Event({0}).request()", new Object[]{a});
        }
        Object retValue = null;
        try {
            EventRequest ret = a.request();
            retValue = ret;
            EventRequest eventRequest = ret;
            return eventRequest;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.event.Event", "request", retValue);
            }
        }
    }
}

