/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.netbeans.modules.cloud.amazon.ui.AmazonWizardPanel;
import org.openide.util.NbBundle;

public class AmazonWizardComponent
extends JPanel
implements DocumentListener {
    private AmazonWizardPanel panel;
    private List<Region> regions;
    private JTextField accessKey;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox jRegionComboBox;
    private JPasswordField secret;

    public AmazonWizardComponent(AmazonWizardPanel panel, AmazonInstance ai) {
        this.panel = panel;
        this.initComponents();
        this.initRegions();
        this.jRegionComboBox.setModel(new DefaultComboBoxModel<Object>(this.regions.toArray()));
        this.setName(NbBundle.getBundle(AmazonWizardComponent.class).getString("LBL_Name"));
        if (ai != null) {
            this.accessKey.setText(ai.getKeyId());
            this.secret.setText(ai.getKey());
            this.accessKey.setEditable(false);
            this.secret.setEditable(false);
            this.jRegionComboBox.setEnabled(false);
            this.jRegionComboBox.setSelectedItem(this.findRegion(ai.getRegionURL()));
        }
        this.accessKey.getDocument().addDocumentListener(this);
        this.secret.getDocument().addDocumentListener(this);
    }

    private void initRegions() {
        this.regions = new ArrayList<Region>();
        this.regions.add(new Region("US East (Northern Virginia) Region", "elasticbeanstalk.us-east-1.amazonaws.com"));
        this.regions.add(new Region("US West (Northern California) Region", "elasticbeanstalk.us-west-1.amazonaws.com"));
        this.regions.add(new Region("US West (Oregon) Region", "elasticbeanstalk.us-west-2.amazonaws.com"));
        this.regions.add(new Region("EU (Ireland) Region", "elasticbeanstalk.eu-west-1.amazonaws.com"));
        this.regions.add(new Region("Asia Pacific (Singapore) Region", "elasticbeanstalk.ap-southeast-1.amazonaws.com"));
        this.regions.add(new Region("Asia Pacific (Sydney) Region", "elasticbeanstalk.ap-southeast-2.amazonaws.com"));
        this.regions.add(new Region("Asia Pacific (Tokyo) Region", "elasticbeanstalk.ap-northeast-1.amazonaws.com"));
        this.regions.add(new Region("South America (Sao Paulo) Region", "elasticbeanstalk.sa-east-1.amazonaws.com"));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.accessKey = new JTextField();
        this.jLabel2 = new JLabel();
        this.secret = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.jRegionComboBox = new JComboBox();
        this.jLabel1.setText(NbBundle.getMessage(AmazonWizardComponent.class, (String)"AmazonWizardComponent.jLabel1.text"));
        this.accessKey.setText(NbBundle.getMessage(AmazonWizardComponent.class, (String)"AmazonWizardComponent.accessKey.text"));
        this.jLabel2.setText(NbBundle.getMessage(AmazonWizardComponent.class, (String)"AmazonWizardComponent.jLabel2.text"));
        this.secret.setText(NbBundle.getMessage(AmazonWizardComponent.class, (String)"AmazonWizardComponent.secret.text"));
        this.jLabel3.setText(NbBundle.getMessage(AmazonWizardComponent.class, (String)"AmazonWizardComponent.jLabel3.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.secret, -1, 173, Short.MAX_VALUE).addComponent(this.accessKey, -1, 173, Short.MAX_VALUE).addComponent(this.jRegionComboBox, 0, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jRegionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accessKey, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.secret, -2, -1, -2)).addContainerGap(39, Short.MAX_VALUE)));
    }

    public String getKeyId() {
        return this.accessKey.getText();
    }

    public String getKey() {
        return String.valueOf(this.secret.getPassword());
    }

    public String getRegionUrl() {
        return ((Region)this.jRegionComboBox.getSelectedItem()).getUrl();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.panel != null) {
            this.panel.fireChange();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.panel != null) {
            this.panel.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.panel != null) {
            this.panel.fireChange();
        }
    }

    private Object findRegion(String regionURL) {
        for (Region r : this.regions) {
            if (!r.getUrl().equals(regionURL)) continue;
            return r;
        }
        return this.regions.get(0);
    }

    private static class Region {
        private String name;
        private String url;

        public Region(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.name;
        }
    }
}

