/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java.jni.actions;

import javax.swing.text.Document;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.netbeans.modules.cnd.mixeddev.java.JavaContextSupport;
import org.netbeans.modules.cnd.mixeddev.java.jni.actions.AbstractJNIAction;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaClassInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaEntityInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaFieldInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaMethodInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaParameterInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaTypeInfo;

public abstract class AbstractCopyJNIAccessCodeAction
extends AbstractJNIAction {
    @Override
    protected boolean isEnabledAtPosition(Document doc, int caret) {
        JavaEntityInfo entity = this.resolveJavaEntity(doc, caret);
        if (entity != null) {
            if (entity instanceof JavaMethodInfo) {
                return !((JavaMethodInfo)entity).isNative();
            }
            return true;
        }
        return false;
    }

    protected String generateEntityGetter(JavaEntityInfo entity) {
        StringBuilder sb = new StringBuilder();
        if (entity instanceof JavaClassInfo) {
            this.generateJavaClassAccess(sb, (JavaClassInfo)entity);
        } else if (entity instanceof JavaMethodInfo) {
            this.generateJavaMethodCall(sb, (JavaMethodInfo)entity);
        } else if (entity instanceof JavaFieldInfo) {
            this.generateJavaFieldGetValue(sb, (JavaFieldInfo)entity);
        }
        return sb.toString();
    }

    protected String generateEntitySetter(JavaEntityInfo entity) {
        StringBuilder sb = new StringBuilder();
        if (entity instanceof JavaFieldInfo) {
            this.generateJavaFieldSetValue(sb, (JavaFieldInfo)entity);
        }
        return sb.toString();
    }

    private void generateJavaClassAccess(StringBuilder sb, JavaClassInfo cls) {
        sb.append("jclass cls = env->FindClass(\"").append(JavaContextSupport.renderQualifiedName(cls.getQualifiedName())).append("\");\n");
    }

    private void generateJavaMethodCall(StringBuilder sb, JavaMethodInfo mtd) {
        sb.append("jclass cls = env->FindClass(\"").append(JavaContextSupport.renderQualifiedName(mtd.getQualifiedName().subList(0, mtd.getQualifiedName().size() - 1))).append("\");\n");
        sb.append("jmethodID mtdId = env->").append(mtd.isStatic() ? "GetStaticMethodID" : "GetMethodID").append("(cls, \"").append(mtd.getName()).append("\", \"").append(JNISupport.getJNISignature(mtd)).append("\");\n");
        sb.append("env->");
        sb.append("Call");
        if (mtd.isStatic()) {
            sb.append("Static");
        }
        sb.append(this.getTypeSpelling(mtd.getReturnType()));
        sb.append("Method(cls, mtdId");
        for (JavaParameterInfo param : mtd.getParameters()) {
            sb.append(", ").append(param.getName());
        }
        sb.append(");");
    }

    private void generateJavaFieldAccess(StringBuilder sb, JavaFieldInfo fld) {
        sb.append("jclass cls = env->FindClass(\"").append(JavaContextSupport.renderQualifiedName(fld.getQualifiedName().subList(0, fld.getQualifiedName().size() - 1))).append("\");\n");
        sb.append("jmethodID fieldId = env->").append(fld.isStatic() ? "GetStaticFieldID" : "GetFieldID").append("(cls, \"").append(fld.getName()).append("\", \"").append(JNISupport.getJNISignature(fld)).append("\");\n");
    }

    private void generateJavaFieldGetValue(StringBuilder sb, JavaFieldInfo fld) {
        this.generateJavaFieldAccess(sb, fld);
        sb.append("env->Get");
        if (fld.isStatic()) {
            sb.append("Static");
        }
        sb.append(this.getTypeSpelling(fld.getType()));
        sb.append("Field(cls, fieldId);");
    }

    private void generateJavaFieldSetValue(StringBuilder sb, JavaFieldInfo fld) {
        this.generateJavaFieldAccess(sb, fld);
        sb.append("env->Set");
        if (fld.isStatic()) {
            sb.append("Static");
        }
        sb.append(this.getTypeSpelling(fld.getType()));
        sb.append("Field(cls, fieldId, value);");
    }

    private String getTypeSpelling(JavaTypeInfo type) {
        if (type != null) {
            String typeName;
            switch (typeName = type.getName().toString()) {
                case "boolean": {
                    return "Boolean";
                }
                case "byte": {
                    return "Byte";
                }
                case "char": {
                    return "Char";
                }
                case "short": {
                    return "Short";
                }
                case "int": {
                    return "Int";
                }
                case "long": {
                    return "Long";
                }
                case "float": {
                    return "Float";
                }
                case "double": {
                    return "Double";
                }
                case "void": {
                    return "Void";
                }
            }
            return "Object";
        }
        return "";
    }
}

