/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

abstract class AbstractDatetime
extends AbstractDatatype {
    private static int[] DAYS_IN_MONTHS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    AbstractDatetime() {
    }

    private void checkMonth(String year, String month) throws DatatypeException {
        this.checkMonth(Integer.parseInt(year), Integer.parseInt(month));
    }

    private void checkMonth(int year, int month) throws DatatypeException {
        if (year < 1) {
            throw this.newDatatypeException("Year cannot be less than 1.");
        }
        if (month < 1) {
            throw this.newDatatypeException("Month cannot be less than 1.");
        }
        if (month > 12) {
            throw this.newDatatypeException("Month cannot be greater than 12.");
        }
    }

    private void checkDate(String year, String month, String day) throws DatatypeException {
        this.checkDate(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
    }

    private void checkDate(int year, int month, int day) throws DatatypeException {
        if (year < 1) {
            throw this.newDatatypeException("Year cannot be less than 1.");
        }
        if (month < 1) {
            throw this.newDatatypeException("Month cannot be less than 1.");
        }
        if (month > 12) {
            throw this.newDatatypeException("Month cannot be greater than 12.");
        }
        if (day < 1) {
            throw this.newDatatypeException("Day cannot be less than 1.");
        }
        if (!(day <= DAYS_IN_MONTHS[month - 1] || day == 29 && month == 2 && this.isLeapYear(year))) {
            throw this.newDatatypeException("Day out of range.");
        }
    }

    private boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    private void checkYearlessDate(String month, String day) throws DatatypeException {
        this.checkYearlessDate(Integer.parseInt(month), Integer.parseInt(day));
    }

    private void checkYearlessDate(int month, int day) throws DatatypeException {
        if (month < 1) {
            throw this.newDatatypeException("Month cannot be less than 1.");
        }
        if (month > 12) {
            throw this.newDatatypeException("Month cannot be greater than 12.");
        }
        if (day < 1) {
            throw this.newDatatypeException("Day cannot be less than 1.");
        }
    }

    private void checkWeek(String year, String week) throws DatatypeException {
        this.checkWeek(Integer.parseInt(year), Integer.parseInt(week));
    }

    private void checkWeek(int year, int week) throws DatatypeException {
        if (year < 1) {
            throw this.newDatatypeException("Year cannot be less than 1.");
        }
        if (week < 1) {
            throw this.newDatatypeException("Week cannot be less than 1.");
        }
        if (week > 53) {
            throw this.newDatatypeException("Week cannot be greater than 53.");
        }
    }

    protected final void checkHour(String hour) throws DatatypeException {
        this.checkHour(Integer.parseInt(hour));
    }

    private void checkHour(int hour) throws DatatypeException {
        if (hour > 23) {
            throw this.newDatatypeException("Hour cannot be greater than 23.");
        }
    }

    protected final void checkMinute(String minute) throws DatatypeException {
        this.checkMinute(Integer.parseInt(minute));
    }

    private void checkMinute(int minute) throws DatatypeException {
        if (minute > 59) {
            throw this.newDatatypeException("Minute cannot be greater than 59.");
        }
    }

    protected final void checkSecond(String second) throws DatatypeException {
        this.checkSecond(Integer.parseInt(second));
    }

    private void checkSecond(int second) throws DatatypeException {
        if (second > 59) {
            throw this.newDatatypeException("Second cannot be greater than 59.");
        }
    }

    protected final void checkMilliSecond(String millisecond) throws DatatypeException {
        if (millisecond.length() > 3) {
            throw this.newDatatypeException("A fraction of a second must be one, two, or three digits.");
        }
    }

    private void checkTzd(String hours, String minutes) throws DatatypeException {
        if (hours.charAt(0) == '+') {
            hours = hours.substring(1);
        }
        this.checkTzd(Integer.parseInt(hours), Integer.parseInt(minutes));
    }

    private void checkTzd(int hours, int minutes) throws DatatypeException {
        if (hours < -23 || hours > 23) {
            throw this.newDatatypeException("Hours out of range in time zone designator.");
        }
        if (minutes > 59) {
            throw this.newDatatypeException("Minutes out of range in time zone designator.");
        }
    }

    protected abstract Pattern getPattern();

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        Matcher m = this.getPattern().matcher(literal);
        if (m.matches()) {
            String year = m.group(1);
            String month = m.group(2);
            if (year != null) {
                this.checkMonth(year, month);
                return;
            }
            year = m.group(3);
            month = m.group(4);
            String day = m.group(5);
            if (year != null) {
                this.checkDate(year, month, day);
                return;
            }
            month = m.group(6);
            day = m.group(7);
            if (year != null) {
                this.checkYearlessDate(month, day);
                return;
            }
            String hour = m.group(8);
            String minute = m.group(9);
            String seconds = m.group(10);
            String milliseconds = m.group(11);
            if (hour != null) {
                this.checkHour(hour);
                this.checkMinute(minute);
                if (seconds != null) {
                    this.checkSecond(seconds);
                }
                if (milliseconds != null) {
                    this.checkMilliSecond(milliseconds);
                }
                return;
            }
            year = m.group(12);
            month = m.group(13);
            day = m.group(14);
            hour = m.group(15);
            minute = m.group(16);
            seconds = m.group(17);
            milliseconds = m.group(18);
            if (year != null) {
                this.checkDate(year, month, day);
                this.checkHour(hour);
                this.checkMinute(minute);
                if (seconds != null) {
                    this.checkSecond(seconds);
                }
                if (milliseconds != null) {
                    this.checkMilliSecond(milliseconds);
                }
                return;
            }
            String tzdHours = m.group(19);
            String tzdMinutes = m.group(20);
            if (tzdHours != null) {
                this.checkTzd(tzdHours, tzdMinutes);
                return;
            }
            year = m.group(21);
            month = m.group(22);
            day = m.group(23);
            hour = m.group(24);
            minute = m.group(25);
            seconds = m.group(26);
            milliseconds = m.group(27);
            tzdHours = m.group(28);
            tzdMinutes = m.group(29);
            if (year != null) {
                this.checkDate(year, month, day);
                this.checkHour(hour);
                this.checkMinute(minute);
                if (seconds != null) {
                    this.checkSecond(seconds);
                }
                if (milliseconds != null) {
                    this.checkMilliSecond(milliseconds);
                }
                if (tzdHours != null) {
                    this.checkTzd(tzdHours, tzdMinutes);
                }
                return;
            }
            year = m.group(30);
            String week = m.group(31);
            if (year != null) {
                this.checkWeek(year, week);
            }
            if ((year = m.group(32)) != null && Integer.parseInt(year) < 1) {
                throw this.newDatatypeException("Year cannot be less than 1.");
            }
            milliseconds = m.group(33);
            if (milliseconds != null) {
                this.checkMilliSecond(milliseconds);
                return;
            }
            milliseconds = m.group(34);
            if (milliseconds != null) {
                this.checkMilliSecond(milliseconds);
                return;
            }
        } else {
            throw this.newDatatypeException("The literal did not satisfy the " + this.getName() + " format.");
        }
    }
}

