/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatetime;

public final class Time
extends AbstractDatetime {
    public static final Time THE_INSTANCE = new Time();
    private static final Pattern THE_PATTERN = Pattern.compile("^([0-9]{2}):([0-9]{2})(?::([0-9]{2})(?:\\.[0-9]{1,3})?)?$");

    private Time() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        Matcher m = this.getPattern().matcher(literal);
        if (m.matches()) {
            this.checkHour(m.group(1));
            this.checkMinute(m.group(2));
            String seconds = m.group(3);
            if (seconds != null) {
                this.checkSecond(seconds);
            }
        } else {
            throw this.newDatatypeException("The literal did not satisfy the format for time.");
        }
    }

    @Override
    protected final Pattern getPattern() {
        return THE_PATTERN;
    }

    @Override
    public String getName() {
        return "time";
    }
}

