/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class InternalVSEMetaDataImpl
implements VisualSQLEditorMetaData {
    private DatabaseMetaData databaseMetaData = null;
    private DatabaseConnection dbconn;
    private List<String> schemas;
    private List<List<String>> allTables = null;
    private int hashSizeForTables = 30;
    private Hashtable fkExportedTable = new Hashtable(30);
    private Hashtable fkImportedTable = new Hashtable(30);
    private Hashtable columnNameTable = new Hashtable(30);
    private Hashtable allColumnsTable = new Hashtable(400);
    private Hashtable pkTable = new Hashtable(30);
    private String identifierQuoteString = null;

    public InternalVSEMetaDataImpl(DatabaseConnection dbconn) {
        this.dbconn = dbconn;
        try {
            this.initMetaData();
        }
        catch (SQLException sqle) {
            Log.getLogger().warning("Could not create cache for " + sqle.getLocalizedMessage());
        }
    }

    @Override
    public List<String> getSchemas() {
        if (this.schemas != null) {
            return this.schemas;
        }
        this.schemas = new ArrayList<String>();
        this.schemas.add(this.dbconn.getSchema());
        return this.schemas;
    }

    @Override
    public List<List<String>> getTables() throws SQLException {
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if (this.allTables != null) {
            return this.allTables;
        }
        Log.getLogger().finest(" loading tables");
        this.allTables = new ArrayList<List<String>>();
        List<String> tmpSchemas = this.getSchemas();
        if (tmpSchemas != null && tmpSchemas.size() > 0) {
            for (String schema : tmpSchemas) {
                Log.getLogger().finest("  schema: " + schema);
                ResultSet rs = this.databaseMetaData.getTables(null, schema, "%", new String[]{"TABLE", "VIEW"});
                while (rs.next()) {
                    ArrayList<String> table = new ArrayList<String>();
                    table.add(rs.getString("TABLE_SCHEM"));
                    table.add(rs.getString("TABLE_NAME"));
                    this.allTables.add(table);
                }
            }
        } else {
            Log.getLogger().finest(" all schemas");
            ResultSet rs = this.databaseMetaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                ArrayList<String> table = new ArrayList<String>();
                table.add(rs.getString("TABLE_SCHEM"));
                table.add(rs.getString("TABLE_NAME"));
                this.allTables.add(table);
            }
        }
        Log.getLogger().finest(" tables loaded " + this.allTables.size());
        return this.allTables;
    }

    @Override
    public List<String> getColumns(String schema, String table) throws SQLException {
        Log.getLogger().entering("InternalVSEMetaDataImpl", "getColumns", new Object[]{schema, table});
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        String fullTableName = InternalVSEMetaDataImpl.mergeTableName(schema, table);
        ArrayList<String> columnNames = (ArrayList<String>)this.columnNameTable.get(fullTableName);
        Log.getLogger().finest("    cache hit=" + (columnNames != null));
        if (columnNames != null) {
            return columnNames;
        }
        columnNames = new ArrayList<String>();
        ResultSet rs = this.databaseMetaData.getColumns(null, schema, table, "%");
        if (rs != null) {
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            if (Log.getLogger().isLoggable(Level.FINEST)) {
                for (int j = 0; j < columnNames.size(); ++j) {
                    Log.getLogger().finest("     Column:" + (String)columnNames.get(j));
                }
            }
        }
        Log.getLogger().finest("   getColumnNames loaded  " + columnNames.size());
        this.columnNameTable.put(fullTableName, columnNames);
        return columnNames;
    }

    @Override
    public List<String> getPrimaryKeys(String schema, String table) throws SQLException {
        String fullTableName;
        ArrayList<String> primaryKeys;
        Log.getLogger().entering("InternalVSEMetaDataImpl", "getPrimaryKeys", new Object[]{schema, table});
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if ((primaryKeys = (ArrayList<String>)this.pkTable.get(fullTableName = InternalVSEMetaDataImpl.mergeTableName(schema, table))) != null) {
            return primaryKeys;
        }
        primaryKeys = new ArrayList<String>();
        String[] tableDesrip = InternalVSEMetaDataImpl.parseTableName(fullTableName);
        ResultSet rs = this.databaseMetaData.getPrimaryKeys(null, schema, table);
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                primaryKeys.add(name);
            }
            rs.close();
        }
        this.pkTable.put(fullTableName, primaryKeys);
        return primaryKeys;
    }

    @Override
    public List<List<String>> getImportedKeys(String schema, String table) throws SQLException {
        return this.getForeignKeys(schema, table, false);
    }

    @Override
    public List<List<String>> getExportedKeys(String schema, String table) throws SQLException {
        return this.getForeignKeys(schema, table, true);
    }

    private List<List<String>> getForeignKeys(String schema, String table, boolean exported) throws SQLException {
        ResultSet rs;
        String fullTableName;
        Hashtable lookupTable;
        ArrayList<List<String>> keys;
        Log.getLogger().entering("InternalVSEMetaDataImpl", "getForeignKeys", new Object[]{schema, table});
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if ((keys = (ArrayList<List<String>>)(lookupTable = exported ? this.fkExportedTable : this.fkImportedTable).get(fullTableName = InternalVSEMetaDataImpl.mergeTableName(schema, table))) != null) {
            return keys;
        }
        keys = new ArrayList<List<String>>();
        ResultSet resultSet = rs = exported ? this.databaseMetaData.getExportedKeys(null, schema, table) : this.databaseMetaData.getImportedKeys(null, schema, table);
        if (rs != null) {
            while (rs.next()) {
                String fschem = rs.getString("FKTABLE_SCHEM");
                String pschem = rs.getString("PKTABLE_SCHEM");
                List<String> key = Arrays.asList((fschem != null ? fschem + "." : "") + rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), (pschem != null ? pschem + "." : "") + rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                keys.add(key);
            }
            rs.close();
        }
        lookupTable.put(fullTableName, keys);
        return keys;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if (this.identifierQuoteString != null) {
            return this.identifierQuoteString;
        }
        this.identifierQuoteString = this.databaseMetaData.getIdentifierQuoteString();
        return this.identifierQuoteString;
    }

    private void initMetaData() throws SQLException {
        this.databaseMetaData = this.getMetaData();
        this.refreshCacheTables();
    }

    private void refresh() {
        Log.getLogger().entering("InternalVSEMetaDataImpl", "refresh");
        this.databaseMetaData = null;
        this.refreshCacheTables();
    }

    private void refreshCacheTables() {
        this.schemas = null;
        this.columnNameTable.clear();
        this.fkExportedTable.clear();
        this.fkImportedTable.clear();
        this.allTables = null;
        this.allColumnsTable.clear();
        this.pkTable.clear();
        this.identifierQuoteString = null;
    }

    private static String[] parseTableName(String fullTableName) {
        String[] retVal = new String[2];
        String[] table = fullTableName.split("\\.");
        if (table.length > 1) {
            retVal[0] = table[0];
            retVal[1] = table[1];
        } else {
            retVal[0] = null;
            retVal[1] = table[0];
        }
        return retVal;
    }

    private static String mergeTableName(String schema, String table) {
        return schema == null || schema.equals("") ? table : schema + "." + table;
    }

    private DatabaseMetaData getMetaData() throws SQLException {
        if (this.databaseMetaData == null) {
            Connection conn = this.dbconn.getJDBCConnection();
            if (conn == null) {
                String msg = NbBundle.getMessage(QueryBuilder.class, (String)"CANNOT_ESTABLISH_CONNECTION");
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            } else {
                this.databaseMetaData = this.dbconn.getJDBCConnection().getMetaData();
            }
        }
        return this.databaseMetaData;
    }
}

