/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.metamodel;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelFactory;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModelProvider;
import org.netbeans.modules.web.jsf.api.metamodel.ModelUnit;
import org.netbeans.modules.web.jsf.impl.metamodel.JsfModelImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public final class JsfModelProviderImpl
implements JsfModelProvider {
    private static final Logger LOG = Logger.getLogger(JsfModelProviderImpl.class.getName());
    private MetadataModel<JsfModel> model = null;
    private final Project project;

    public JsfModelProviderImpl(Project project) {
        this.project = project;
    }

    @Override
    public synchronized MetadataModel<JsfModel> getModel() {
        if (this.model == null) {
            LOG.log(Level.FINEST, "JsfModel requested and not created yet, initializing it.");
            long startTime = System.currentTimeMillis();
            ModelUnit unit = JsfModelProviderImpl.getUnit(this.project);
            if (unit == null) {
                return null;
            }
            this.model = JsfModelProviderImpl.createMetaModel(unit);
            LOG.log(Level.FINEST, "JsfModel created in {0} ms.", System.currentTimeMillis() - startTime);
        }
        return this.model;
    }

    public static MetadataModel<JsfModel> createMetaModel(ModelUnit unit) {
        return MetadataModelFactory.createMetadataModel(JsfModelImplementation.create(unit));
    }

    private static ModelUnit getUnit(Project project) {
        if (project == null) {
            return null;
        }
        ClassPath boot = JsfModelProviderImpl.getClassPath(project, "classpath/boot");
        ClassPath compile = JsfModelProviderImpl.getClassPath(project, "classpath/compile");
        ClassPath src = JsfModelProviderImpl.getClassPath(project, "classpath/source");
        return src == null ? null : ModelUnit.create(boot, compile, src, project);
    }

    private static ClassPath getClassPath(Project project, String type) {
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        int i$ = 0;
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        SourceGroup[] arr$ = sourceGroups;
        int len$ = arr$.length;
        if (i$ < len$) {
            SourceGroup sourceGroup = arr$[i$];
            FileObject rootFolder = sourceGroup.getRootFolder();
            ClassPath path = provider.findClassPath(rootFolder, type);
            return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{path});
        }
        return null;
    }
}

