/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.project;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.content.project.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.GraphContainerKey;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class GraphContainer
extends ProjectComponent
implements CsmProgressListener {
    private static final GraphContainer EMPTY = new GraphContainer(){

        @Override
        public void put() {
        }

        @Override
        public void putFile(CsmFile master) {
        }
    };
    private final LinkedList<WeakReference<HotSpotFile>> hotSpot = new LinkedList();
    private static final int HOT_SPOT_SIZE = 10;
    private final Map<CsmUID<CsmFile>, NodeLink> graph = new HashMap<CsmUID<CsmFile>, NodeLink>();
    private final ReadWriteLock graphLock = new ReentrantReadWriteLock();

    public GraphContainer(ProjectBase project) {
        super(new GraphContainerKey(project.getUnitId()));
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
        this.put();
    }

    public GraphContainer(RepositoryDataInput input) throws IOException {
        super(input);
        assert (input != null);
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
        GraphContainer.readUIDToNodeLinkMap(input, this.graph);
    }

    private GraphContainer() {
        super((Key)null);
    }

    public static GraphContainer empty() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(CsmFile master) {
        CsmUID<CsmFile> key = UIDCsmConverter.fileToUID(master);
        if (key != null) {
            this.graphLock.writeLock().lock();
            try {
                NodeLink node = this.graph.get(key);
                if (node != null) {
                    Set outLink = node.getOutLinks();
                    for (CsmUID out : outLink) {
                        NodeLink pair = this.graph.get(out);
                        if (pair == null) continue;
                        pair.removeInLink((CsmUID<CsmFile>)key);
                    }
                    outLink.clear();
                } else {
                    node = new NodeLink();
                    this.graph.put(key, node);
                }
                for (CsmInclude include : master.getIncludes()) {
                    CsmFile to = include.getIncludeFile();
                    if (to == null) continue;
                    CsmUID<CsmFile> out = UIDCsmConverter.fileToUID(to);
                    NodeLink pair = this.graph.get(out);
                    if (pair == null) {
                        pair = new NodeLink();
                        this.graph.put(out, pair);
                    }
                    node.addOutLink((CsmUID<CsmFile>)out);
                    pair.addInLink((CsmUID<CsmFile>)key);
                }
            }
            finally {
                this.graphLock.writeLock().unlock();
            }
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(CsmFile master) {
        CsmUID<CsmFile> key = UIDCsmConverter.fileToUID(master);
        if (key != null) {
            this.graphLock.writeLock().lock();
            try {
                NodeLink node = this.graph.get(key);
                if (node != null) {
                    Set inLink = node.getInLinks();
                    for (CsmUID in : inLink) {
                        NodeLink pair = this.graph.get(in);
                        if (pair == null) continue;
                        pair.removeOutLink((CsmUID<CsmFile>)key);
                    }
                    inLink.clear();
                    Set outLink = node.getOutLinks();
                    for (CsmUID out : outLink) {
                        NodeLink pair = this.graph.get(out);
                        if (pair == null) continue;
                        pair.removeInLink((CsmUID<CsmFile>)key);
                    }
                    outLink.clear();
                    this.graph.remove(key);
                }
            }
            finally {
                this.graphLock.writeLock().unlock();
            }
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmUID<CsmFile>> getIncludedFilesUids(CsmFile referencedFile) {
        HashSet<CsmUID<CsmFile>> res = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> keyFrom = UIDCsmConverter.fileToUID(referencedFile);
        if (keyFrom != null) {
            this.graphLock.readLock().lock();
            try {
                this.getIncludedFiles(res, keyFrom);
            }
            finally {
                this.graphLock.readLock().unlock();
            }
        }
        return res;
    }

    public Set<CsmFile> getIncludedFiles(CsmFile referencedFile) {
        return GraphContainer.convertToFiles(this.getIncludedFilesUids(referencedFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileIncluded(CsmFile sourceFile, CsmFile headerFile) {
        block13: {
            CsmUID<CsmFile> keyFrom = UIDCsmConverter.fileToUID(sourceFile);
            CsmUID<CsmFile> keyTo = UIDCsmConverter.fileToUID(headerFile);
            if (keyFrom == null || keyTo == null) break block13;
            LinkedList<WeakReference<HotSpotFile>> linkedList = this.hotSpot;
            synchronized (linkedList) {
                Iterator iterator = this.hotSpot.iterator();
                while (iterator.hasNext()) {
                    WeakReference ref = (WeakReference)iterator.next();
                    HotSpotFile file = (HotSpotFile)ref.get();
                    if (file != null) {
                        if (!file.from.equals(keyFrom)) continue;
                        return file.to.contains(keyTo);
                    }
                    iterator.remove();
                }
            }
            HashSet<CsmUID<CsmFile>> res = new HashSet<CsmUID<CsmFile>>();
            HashMap<Integer, GraphContainer> map = new HashMap<Integer, GraphContainer>();
            try {
                this.gatherIncludedFiles(map, res, keyFrom);
            }
            catch (Throwable throwable) {
                for (GraphContainer current : map.values()) {
                    current.graphLock.readLock().unlock();
                }
                throw throwable;
            }
            for (GraphContainer current : map.values()) {
                current.graphLock.readLock().unlock();
            }
            LinkedList<WeakReference<HotSpotFile>> linkedList2 = this.hotSpot;
            synchronized (linkedList2) {
                if (this.hotSpot.size() > 10) {
                    this.hotSpot.removeFirst();
                }
                this.hotSpot.addLast(new WeakReference<HotSpotFile>(new HotSpotFile(keyFrom, res)));
                return res.contains(keyTo);
            }
        }
        return false;
    }

    private void gatherIncludedFiles(Map<Integer, GraphContainer> map, Set<CsmUID<CsmFile>> res, CsmUID<CsmFile> keyFrom) {
        NodeLink node;
        GraphContainer current = map.get(UIDUtilities.getProjectID(keyFrom));
        if (current == null) {
            CsmFile file = UIDCsmConverter.UIDtoFile(keyFrom);
            if (file == null || !file.isValid()) {
                return;
            }
            current = ((ProjectBase)file.getProject()).getGraphStorage();
            if (current == null) {
                return;
            }
            map.put(UIDUtilities.getProjectID(keyFrom), current);
            current.graphLock.readLock().lock();
        }
        if ((node = current.graph.get(keyFrom)) != null) {
            for (CsmUID uid : node.getOutLinks()) {
                if (!res.add((CsmUID<CsmFile>)uid)) continue;
                this.gatherIncludedFiles(map, res, (CsmUID<CsmFile>)uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmUID<CsmFile>> getParentFilesUids(CsmFile referencedFile) {
        HashSet<CsmUID<CsmFile>> res = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> keyTo = UIDCsmConverter.fileToUID(referencedFile);
        if (keyTo != null) {
            this.graphLock.readLock().lock();
            try {
                this.getParentFiles(res, keyTo);
            }
            finally {
                this.graphLock.readLock().unlock();
            }
        }
        return res;
    }

    public Set<CsmFile> getParentFiles(CsmFile referencedFile) {
        return GraphContainer.convertToFiles(this.getParentFilesUids(referencedFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentFiles getTopParentFiles(CsmFile referencedFile) {
        HashSet<CsmUID<CsmFile>> parent = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID> top = new HashSet<CsmUID>();
        CsmUID<CsmFile> keyTo = UIDCsmConverter.fileToUID(referencedFile);
        if (keyTo != null) {
            this.graphLock.readLock().lock();
            try {
                this.getParentFiles(parent, keyTo);
                if (parent.isEmpty()) {
                    parent.add(keyTo);
                }
                for (CsmUID csmUID : parent) {
                    NodeLink link = this.graph.get(csmUID);
                    if (link == null || !link.getInLinks().isEmpty()) continue;
                    top.add(csmUID);
                }
            }
            finally {
                this.graphLock.readLock().unlock();
            }
        }
        return new ParentFiles(top, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoherenceFiles getCoherenceFiles(CsmFile referencedFile) {
        HashSet<CsmUID<CsmFile>> parent = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> coherence = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> keyTo = UIDCsmConverter.fileToUID(referencedFile);
        if (keyTo != null) {
            this.graphLock.readLock().lock();
            try {
                this.getParentFiles(parent, keyTo);
                if (parent.isEmpty()) {
                    parent.add(keyTo);
                }
                coherence.addAll(parent);
                for (CsmUID csmUID : parent) {
                    this.getIncludedFiles(coherence, (CsmUID<CsmFile>)csmUID);
                }
            }
            finally {
                this.graphLock.readLock().unlock();
            }
        }
        return new CoherenceFiles(parent, coherence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmUID<CsmFile>> getInLinksUids(CsmFile referencedFile) {
        HashSet<CsmUID<CsmFile>> res = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> keyTo = UIDCsmConverter.fileToUID(referencedFile);
        if (keyTo != null) {
            this.graphLock.readLock().lock();
            try {
                NodeLink node = this.graph.get(keyTo);
                if (node != null) {
                    for (CsmUID uid : node.getInLinks()) {
                        res.add((CsmUID<CsmFile>)uid);
                    }
                }
            }
            finally {
                this.graphLock.readLock().unlock();
            }
        }
        return res;
    }

    public Set<CsmFile> getInLinks(CsmFile referencedFile) {
        return GraphContainer.convertToFiles(this.getInLinksUids(referencedFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmUID<CsmFile>> getOutLinksUids(CsmFile referencedFile) {
        HashSet<CsmUID<CsmFile>> res = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> keyTo = UIDCsmConverter.fileToUID(referencedFile);
        if (keyTo != null) {
            this.graphLock.readLock().lock();
            try {
                NodeLink node = this.graph.get(keyTo);
                if (node != null) {
                    for (CsmUID uid : node.getOutLinks()) {
                        res.add((CsmUID<CsmFile>)uid);
                    }
                }
            }
            finally {
                this.graphLock.readLock().unlock();
            }
        }
        return res;
    }

    public Set<CsmFile> getOutLinks(CsmFile referencedFile) {
        return GraphContainer.convertToFiles(this.getOutLinksUids(referencedFile));
    }

    public static Set<CsmFile> convertToFiles(Set<CsmUID<CsmFile>> res) {
        HashSet<CsmFile> res2 = new HashSet<CsmFile>();
        for (CsmUID<CsmFile> uid : res) {
            CsmFile file = UIDCsmConverter.UIDtoFile(uid);
            if (file == null || !file.isValid()) continue;
            res2.add(file);
        }
        return res2;
    }

    private void getIncludedFiles(Set<CsmUID<CsmFile>> res, CsmUID<CsmFile> keyFrom) {
        NodeLink node = this.graph.get(keyFrom);
        if (node != null) {
            for (CsmUID uid : node.getOutLinks()) {
                if (!res.add((CsmUID<CsmFile>)uid)) continue;
                this.getIncludedFiles(res, (CsmUID<CsmFile>)uid);
            }
        }
    }

    private void getParentFiles(Set<CsmUID<CsmFile>> res, CsmUID<CsmFile> keyTo) {
        NodeLink node = this.graph.get(keyTo);
        if (node != null) {
            for (CsmUID uid : node.getInLinks()) {
                if (!res.add((CsmUID<CsmFile>)uid)) continue;
                this.getParentFiles(res, (CsmUID<CsmFile>)uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.graphLock.writeLock().lock();
        try {
            this.graph.clear();
        }
        finally {
            this.graphLock.writeLock().unlock();
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        this.graphLock.writeLock().lock();
        try {
            GraphContainer.writeUIDToNodeLinkMap(output, this.graph);
        }
        finally {
            this.graphLock.writeLock().unlock();
        }
    }

    private static void writeUIDToNodeLinkMap(RepositoryDataOutput output, Map<CsmUID<CsmFile>, NodeLink> aMap) throws IOException {
        assert (output != null);
        assert (aMap != null);
        UIDObjectFactory uidFactory = UIDObjectFactory.getDefaultFactory();
        assert (uidFactory != null);
        output.writeInt(aMap.size());
        Set<Map.Entry<CsmUID<CsmFile>, NodeLink>> entrySet = aMap.entrySet();
        for (Map.Entry<CsmUID<CsmFile>, NodeLink> anEntry : entrySet) {
            assert (anEntry != null);
            uidFactory.writeUID(anEntry.getKey(), output);
            anEntry.getValue().write(output);
        }
    }

    private static void readUIDToNodeLinkMap(RepositoryDataInput input, Map<CsmUID<CsmFile>, NodeLink> aMap) throws IOException {
        assert (input != null);
        assert (aMap != null);
        UIDObjectFactory uidFactory = UIDObjectFactory.getDefaultFactory();
        assert (uidFactory != null);
        aMap.clear();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            CsmUID uid = uidFactory.readUID(input);
            NodeLink link = new NodeLink(input);
            assert (uid != null);
            assert (link != null);
            aMap.put(uid, link);
        }
    }

    public void projectParsingStarted(CsmProject project) {
    }

    public void projectFilesCounted(CsmProject project, int filesCount) {
    }

    public void projectParsingFinished(CsmProject project) {
    }

    public void projectParsingCancelled(CsmProject project) {
    }

    public void projectLoaded(CsmProject project) {
    }

    public void fileInvalidated(CsmFile file) {
    }

    public void fileAddedToParse(CsmFile file) {
    }

    public void fileParsingStarted(CsmFile file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileParsingFinished(CsmFile sourceFile) {
        LinkedList<WeakReference<HotSpotFile>> linkedList = this.hotSpot;
        synchronized (linkedList) {
            this.hotSpot.clear();
        }
    }

    public void parserIdle() {
    }

    public void fileRemoved(CsmFile file) {
    }

    private static final class HotSpotFile {
        private final CsmUID<CsmFile> from;
        private final Set<CsmUID<CsmFile>> to;

        private HotSpotFile(CsmUID<CsmFile> from, Set<CsmUID<CsmFile>> to) {
            this.from = from;
            this.to = to;
        }
    }

    public static final class CoherenceFiles {
        private final Set<CsmUID<CsmFile>> coherenceFiles;
        private final Set<CsmUID<CsmFile>> parentFiles;

        private CoherenceFiles(Set<CsmUID<CsmFile>> parentFiles, Set<CsmUID<CsmFile>> coherenceFiles) {
            this.parentFiles = parentFiles;
            this.coherenceFiles = coherenceFiles;
        }

        public Set<CsmFile> getCoherenceFiles() {
            return GraphContainer.convertToFiles(this.coherenceFiles);
        }

        public Set<CsmUID<CsmFile>> getCoherenceFilesUids() {
            return this.coherenceFiles;
        }

        public Set<CsmFile> getParentFiles() {
            return GraphContainer.convertToFiles(this.parentFiles);
        }

        public Set<CsmUID<CsmFile>> getParentFilesUids() {
            return this.parentFiles;
        }
    }

    public static final class ParentFiles {
        private final Set<CsmUID<CsmFile>> comilationUnits;
        private final Set<CsmUID<CsmFile>> parentFiles;

        private ParentFiles(Set<CsmUID<CsmFile>> comilationUnits, Set<CsmUID<CsmFile>> parentFiles) {
            this.comilationUnits = comilationUnits;
            this.parentFiles = parentFiles;
        }

        public Set<CsmFile> getCompilationUnits() {
            return GraphContainer.convertToFiles(this.comilationUnits);
        }

        public Set<CsmUID<CsmFile>> getCompilationUnitsUids() {
            return this.comilationUnits;
        }

        public Set<CsmFile> getParentFiles() {
            return GraphContainer.convertToFiles(this.parentFiles);
        }

        public Set<CsmUID<CsmFile>> getParentFilesUids() {
            return this.parentFiles;
        }
    }

    private static class NodeLink
    implements SelfPersistent,
    Persistent {
        final Set<CsmUID<CsmFile>> in;
        final Set<CsmUID<CsmFile>> out;

        private NodeLink() {
            this.in = new HashSet<CsmUID<CsmFile>>();
            this.out = new HashSet<CsmUID<CsmFile>>();
        }

        private NodeLink(RepositoryDataInput input) throws IOException {
            assert (input != null);
            UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
            assert (factory != null);
            int collSize = input.readInt();
            this.in = collSize < 0 ? new HashSet<CsmUID<CsmFile>>(0) : new HashSet<CsmUID<CsmFile>>(collSize);
            factory.readUIDCollection(this.in, input, collSize);
            collSize = input.readInt();
            this.out = collSize < 0 ? new HashSet<CsmUID<CsmFile>>(0) : new HashSet<CsmUID<CsmFile>>(collSize);
            factory.readUIDCollection(this.out, input, collSize);
        }

        private void addInLink(CsmUID<CsmFile> inLink) {
            this.in.add(inLink);
        }

        private void removeInLink(CsmUID<CsmFile> inLink) {
            this.in.remove(inLink);
        }

        private Set<CsmUID<CsmFile>> getInLinks() {
            return this.in;
        }

        private void addOutLink(CsmUID<CsmFile> inLink) {
            this.out.add(inLink);
        }

        private void removeOutLink(CsmUID<CsmFile> inLink) {
            this.out.remove(inLink);
        }

        private Set<CsmUID<CsmFile>> getOutLinks() {
            return this.out;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            assert (output != null);
            assert (this.in != null);
            assert (this.out != null);
            UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
            assert (factory != null);
            factory.writeUIDCollection(this.in, output, false);
            factory.writeUIDCollection(this.out, output, false);
        }
    }
}

