/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmBuiltIn;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmPackageAccessor;
import org.netbeans.modules.cnd.modelimpl.csm.AccessorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.ObjectBasedUID;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public class BuiltinTypes {
    private static final ConcurrentMap<CharSequence, CsmBuiltIn> types;

    private BuiltinTypes() {
    }

    public static CsmBuiltIn getBuiltIn(AST ast) {
        assert (ast.getType() == 526);
        StringBuilder sb = new StringBuilder();
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(AstUtil.getText(token));
        }
        assert (sb.length() > 0) : "no name in " + AstUtil.toString(ast);
        return BuiltinTypes.getBuiltIn(sb);
    }

    public static CsmBuiltIn getBuiltIn(CharSequence text) {
        CsmBuiltIn old;
        assert (text != null && text.length() > 0);
        text = QualifiedNameCache.getManager().getString(text);
        CsmBuiltIn builtIn = (CsmBuiltIn)types.get(text);
        if (builtIn == null && (old = types.putIfAbsent(text, builtIn = new BuiltinImpl(text))) != null) {
            builtIn = old;
        }
        return builtIn;
    }

    public static ObjectBasedUID<CsmBuiltIn> readUID(RepositoryDataInput aStream) throws IOException {
        CharSequence name = PersistentUtils.readUTF(aStream, QualifiedNameCache.getManager());
        CsmBuiltIn builtIn = BuiltinTypes.getBuiltIn(name);
        CsmUID anUID = UIDs.get((Object)builtIn);
        assert (anUID != null);
        return (ObjectBasedUID)anUID;
    }

    static {
        CsmPackageAccessor.register(new AccessorImpl());
        types = new ConcurrentHashMap<CharSequence, CsmBuiltIn>();
    }

    public static final class BuiltInUID
    extends ObjectBasedUID<CsmBuiltIn> {
        private BuiltInUID(CsmBuiltIn decl) {
            super(decl);
        }

        @Override
        public String toString() {
            String retValue = "<BUILT-IN UID> " + super.toString();
            return retValue;
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            BuiltinImpl ref = (BuiltinImpl)this.getObject();
            assert (ref != null);
            assert (ref.getName() != null);
            PersistentUtils.writeUTF(ref.getName(), output);
        }
    }

    private static class BuiltinImpl
    implements CsmBuiltIn,
    CsmIdentifiable {
        private final CharSequence name;
        private final CsmUID<CsmBuiltIn> uid;

        private BuiltinImpl(CharSequence name) {
            this.name = name;
            this.uid = new BuiltInUID(this);
        }

        public CharSequence getQualifiedName() {
            return this.getName();
        }

        public CharSequence getUniqueName() {
            return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(this.getKind()), (char)':', (CharSequence)this.getQualifiedName()));
        }

        public CharSequence getName() {
            assert (this.name != null && this.name.length() > 0);
            return this.name;
        }

        public CsmDeclaration.Kind getKind() {
            return CsmDeclaration.Kind.BUILT_IN;
        }

        public CsmScope getScope() {
            return null;
        }

        public CsmUID<CsmBuiltIn> getUID() {
            return this.uid;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            BuiltinImpl other = (BuiltinImpl)obj;
            return this.name.equals(other.name);
        }

        public String toString() {
            return "" + this.getKind() + " " + this.getQualifiedName();
        }

        public boolean isValid() {
            return true;
        }
    }
}

