/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.EnumeratorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.SelectImpl;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public class EnumImpl
extends ClassEnumBase<CsmEnum>
implements CsmEnum,
SelectImpl.FilterableEnumerators {
    private final boolean stronglyTyped;
    private final List<CsmUID<CsmEnumerator>> enumerators;

    private EnumImpl(AST ast, NameHolder name, CsmFile file) {
        super(name, file, ast);
        this.stronglyTyped = EnumImpl.isStronglyTypedEnum(ast);
        this.enumerators = new ArrayList<CsmUID<CsmEnumerator>>();
    }

    protected EnumImpl(CharSequence name, CharSequence qName, boolean stronglyTyped, CsmFile file, int startOffset, int endOffset) {
        super(name, qName, file, startOffset, endOffset);
        this.stronglyTyped = stronglyTyped;
        this.enumerators = new ArrayList<CsmUID<CsmEnumerator>>();
    }

    public void init(CsmScope scope, AST ast, CsmFile file, boolean register) {
        this.initScope(scope);
        if (register) {
            this.register(scope, true);
        }
    }

    public static EnumImpl create(AST ast, CsmScope scope, CsmFile file, FileContent fileContent, boolean register) {
        NameHolder nameHolder = NameHolder.createEnumName(ast);
        EnumImpl impl = new EnumImpl(ast, nameHolder, file);
        impl.init2(scope, ast, file, fileContent, register);
        nameHolder.addReference(fileContent, impl);
        return impl;
    }

    void init2(CsmScope scope, AST ast, CsmFile file, FileContent fileContent, boolean register) {
        this.initScope(scope);
        EnumImpl.temporaryRepositoryRegistration(register, this);
        this.initEnumDefinition(scope);
        this.initEnumeratorList(ast, file, fileContent, register);
        if (register) {
            this.register(scope, true);
        }
    }

    private void initEnumDefinition(CsmScope scope) {
        ClassImpl.MemberForwardDeclaration mfd = this.findMemberForwardDeclaration(scope);
        if (mfd instanceof ClassImpl.EnumMemberForwardDeclaration && CsmKindUtilities.isEnum((CsmObject)this)) {
            ClassImpl.EnumMemberForwardDeclaration fd = (ClassImpl.EnumMemberForwardDeclaration)mfd;
            fd.setCsmEnum(this);
            CsmClass containingClass = fd.getContainingClass();
            if (containingClass != null) {
                this.initScope((CsmScope)containingClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEnumerator(String name, int startOffset, int endOffset, boolean register) {
        EnumeratorImpl ei = EnumeratorImpl.create(this, name, startOffset, endOffset, register);
        CsmUID<EnumeratorImpl> uid = UIDCsmConverter.objectToUID(ei);
        List<CsmUID<CsmEnumerator>> list = this.enumerators;
        synchronized (list) {
            this.enumerators.add(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEnumerator(EnumeratorImpl ei) {
        CsmUID<EnumeratorImpl> uid = UIDCsmConverter.objectToUID(ei);
        List<CsmUID<CsmEnumerator>> list = this.enumerators;
        synchronized (list) {
            this.enumerators.add(uid);
        }
    }

    @Override
    public String toString() {
        if (this.stronglyTyped) {
            return "[Strongly Typed]" + super.toString();
        }
        return super.toString();
    }

    public final void fixFakeRender(FileContent fileContent, AST ast, boolean localClass) {
        this.initEnumeratorList(ast, fileContent.getFile(), fileContent, !localClass);
    }

    private void initEnumeratorList(AST ast, CsmFile file, FileContent fileContent, boolean global) {
        AST token;
        for (token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            if (token.getType() != 556) continue;
            this.addList(token, file, fileContent, global);
            return;
        }
        token = ast.getNextSibling();
        if (token != null) {
            AST enumList = null;
            if (token.getType() == 91) {
                token = token.getNextSibling();
            }
            if (token.getType() == 16) {
                enumList = token.getNextSibling();
            }
            if (enumList != null && enumList.getType() == 556) {
                this.addList(enumList, file, fileContent, global);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addList(AST token, CsmFile file, FileContent fileContent, boolean global) {
        for (AST t = token.getFirstChild(); t != null; t = t.getNextSibling()) {
            if (t.getType() != 91) continue;
            EnumeratorImpl ei = EnumeratorImpl.create(t, file, fileContent, this, global);
            CsmUID<EnumeratorImpl> uid = UIDCsmConverter.objectToUID(ei);
            List<CsmUID<CsmEnumerator>> list = this.enumerators;
            synchronized (list) {
                this.enumerators.add(uid);
                continue;
            }
        }
    }

    public boolean isStronglyTyped() {
        return this.stronglyTyped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmEnumerator> getEnumerators() {
        List<CsmUID<CsmEnumerator>> list = this.enumerators;
        synchronized (list) {
            return UIDCsmConverter.UIDsToDeclarations(this.enumerators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CsmEnumerator> getEnumerators(CsmSelect.CsmFilter filter) {
        ArrayList uids = new ArrayList();
        List<CsmUID<CsmEnumerator>> list = this.enumerators;
        synchronized (list) {
            uids.addAll(this.enumerators);
        }
        return UIDCsmConverter.UIDsToDeclarations(uids, filter);
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getEnumerators();
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUM;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._clearEnumerators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearEnumerators() {
        List<CsmUID<CsmEnumerator>> list = this.enumerators;
        synchronized (list) {
            Collection<CsmEnumerator> enumers = this.getEnumerators();
            Utils.disposeAll(enumers);
            RepositoryUtils.remove(this.enumerators);
        }
    }

    static boolean isStronglyTypedEnum(AST ast) {
        AST nextSibling;
        assert (ast.getType() == 513 || ast.getType() == 514 || ast.getType() == 118) : ast;
        if (ast.getType() == 513 || ast.getType() == 514) {
            AST child = ast.getFirstChild();
            if (child == null) {
                CndUtils.assertTrueInConsole((boolean)false, (String)"incomplete enum ", (Object)ast);
                return false;
            }
            ast = child;
        }
        while (ast.getType() != 118) {
            AST sibling = ast.getNextSibling();
            if (sibling == null) {
                CndUtils.assertTrueInConsole((boolean)false, (String)"incomplete enum ", (Object)ast);
                return false;
            }
            ast = sibling;
        }
        assert (ast.getType() == 118) : ast;
        if (ast.getType() == 118 && (nextSibling = ast.getNextSibling()) != null) {
            switch (nextSibling.getType()) {
                case 158: 
                case 159: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        output.writeBoolean(this.stronglyTyped);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enumerators, output, true);
    }

    public EnumImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.stronglyTyped = input.readBoolean();
        int collSize = input.readInt();
        this.enumerators = collSize < 0 ? new ArrayList<CsmUID<CsmEnumerator>>(0) : new ArrayList<CsmUID<CsmEnumerator>>(collSize);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enumerators, input, collSize);
    }

    public static class EnumBuilder
    extends OffsetableDeclarationBase.SimpleDeclarationBuilder
    implements ClassImpl.MemberBuilder {
        private boolean stronglyTyped = false;
        private final List<EnumeratorImpl.EnumeratorBuilder> enumeratorBuilders = new ArrayList<EnumeratorImpl.EnumeratorBuilder>();
        private EnumImpl instance;
        private CsmVisibility visibility = CsmVisibility.PUBLIC;

        public void setStronglyTyped() {
            this.stronglyTyped = true;
        }

        public void addEnumerator(EnumeratorImpl.EnumeratorBuilder eb) {
            this.enumeratorBuilders.add(eb);
        }

        @Override
        public void setVisibility(CsmVisibility visibility) {
            this.visibility = visibility;
        }

        public EnumImpl getEnumDefinitionInstance() {
            CsmOffsetableDeclaration decl;
            if (this.instance != null) {
                return this.instance;
            }
            MutableDeclarationsContainer container = null;
            if (this.getParent() == null) {
                container = this.getFileContent();
            } else if (this.getParent() instanceof NamespaceDefinitionImpl.NamespaceBuilder) {
                container = ((NamespaceDefinitionImpl.NamespaceBuilder)this.getParent()).getNamespaceDefinitionInstance();
            }
            if (container != null && this.getName() != null && (decl = container.findExistingDeclaration(this.getStartOffset(), this.getName(), CsmDeclaration.Kind.ENUM)) != null && EnumImpl.class.equals(decl.getClass())) {
                this.instance = (EnumImpl)decl;
            }
            return this.instance;
        }

        @Override
        public CharSequence getName() {
            return super.getName() == null ? this.getNameHolder().getName() : super.getName();
        }

        @Override
        public EnumImpl create(CsmParserProvider.ParserErrorDelegate delegate) {
            EnumImpl impl = this.getEnumDefinitionInstance();
            if (impl == null) {
                impl = new EnumImpl(this.getName(), this.getName(), this.stronglyTyped, this.getFile(), this.getStartOffset(), this.getEndOffset());
                impl.setVisibility(this.visibility);
                impl.initScope(this.getScope());
                impl.register(this.getScope(), true);
                this.getNameHolder().addReference(this.getFileContent(), impl);
                EnumImpl.temporaryRepositoryRegistration(true, impl);
                for (EnumeratorImpl.EnumeratorBuilder enumeratorBuilder : this.enumeratorBuilders) {
                    enumeratorBuilder.setEnum(impl);
                    EnumeratorImpl ei = enumeratorBuilder.create(true);
                    impl.addEnumerator(ei);
                }
                this.addDeclaration(impl);
            }
            return impl;
        }
    }
}

