/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class InheritanceImpl
extends OffsetableIdentifiableBase<CsmInheritance>
implements CsmInheritance {
    private CsmVisibility visibility;
    private boolean virtual;
    private CsmType ancestorType;
    private CsmClassifier resolvedClassifier;
    private final CsmUID<CsmScope> scope;

    private InheritanceImpl(AST ast, CsmFile file, CsmScope scope) {
        super(file, InheritanceImpl.getStartOffset(ast), InheritanceImpl.getEndOffset(ast));
        this.scope = UIDCsmConverter.scopeToUID(scope);
        this.visibility = ((CsmDeclaration)scope).getKind() == CsmDeclaration.Kind.STRUCT ? CsmVisibility.PUBLIC : CsmVisibility.PRIVATE;
        block7: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 166: {
                    this.visibility = CsmVisibility.PRIVATE;
                    continue block7;
                }
                case 164: {
                    this.visibility = CsmVisibility.PUBLIC;
                    continue block7;
                }
                case 165: {
                    this.visibility = CsmVisibility.PROTECTED;
                    continue block7;
                }
                case 125: {
                    this.virtual = true;
                    continue block7;
                }
                case 91: 
                case 527: {
                    this.ancestorType = TemplateUtils.checkTemplateType((CsmType)TypeFactory.createType(token, this.getContainingFile(), null, 0, scope), (CsmObject)scope);
                    return;
                }
            }
        }
    }

    private InheritanceImpl(CsmType type, CsmVisibility visibility, boolean virtual, CsmScope scope, CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        this.scope = UIDCsmConverter.scopeToUID(scope);
        this.visibility = visibility;
        this.virtual = virtual;
        this.ancestorType = TemplateUtils.checkTemplateType(type, (CsmObject)scope);
    }

    public static InheritanceImpl create(AST ast, CsmFile file, CsmScope scope, boolean isGlobal) {
        InheritanceImpl inheritanceImpl = new InheritanceImpl(ast, file, scope);
        if (!isGlobal) {
            Utils.setSelfUID(inheritanceImpl);
        }
        return inheritanceImpl;
    }

    private InheritanceImpl(CsmFile file, CsmScope scope, CsmType ancestorType, CsmVisibility visibility, boolean virtual, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        this.scope = UIDCsmConverter.scopeToUID(scope);
        this.visibility = visibility == null ? (((CsmDeclaration)scope).getKind() == CsmDeclaration.Kind.STRUCT ? CsmVisibility.PUBLIC : CsmVisibility.PRIVATE) : visibility;
        this.virtual = virtual;
        this.ancestorType = ancestorType;
    }

    public static InheritanceImpl create(CsmFile file, CsmScope scope, CsmType ancestorType, CsmVisibility visibility, boolean virtual, int startOffset, int endOffset) {
        return new InheritanceImpl(file, scope, ancestorType, visibility, virtual, startOffset, endOffset);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public CsmType getAncestorType() {
        return this.ancestorType;
    }

    public CsmClassifier getClassifier() {
        if (!CsmBaseUtilities.isValid((CsmObject)this.resolvedClassifier)) {
            this.resolvedClassifier = this.getAncestorType().getClassifier();
        }
        return this.resolvedClassifier;
    }

    @Override
    protected CsmUID<CsmInheritance> createUID() {
        return UIDUtilities.createInheritanceUID(this);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 11 * hash + this.visibility.hashCode();
        hash = 11 * hash + (this.virtual ? 1 : 0);
        hash = 11 * hash + (this.ancestorType != null ? this.ancestorType.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InheritanceImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InheritanceImpl other = (InheritanceImpl)obj;
        if (this.visibility != other.visibility) {
            return false;
        }
        if (this.virtual != other.virtual) {
            return false;
        }
        return this.ancestorType == other.ancestorType || this.ancestorType != null && this.ancestorType.equals(other.ancestorType);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeVisibility(this.visibility, output);
        output.writeBoolean(this.virtual);
        PersistentUtils.writeType(this.ancestorType, output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUID(this.scope, output);
        CsmUID<CsmClassifier> toSave = UIDCsmConverter.objectToUID(this.resolvedClassifier);
        if (!UIDProviderIml.isPersistable(toSave)) {
            toSave = null;
        }
        factory.writeUID(toSave, output);
    }

    public InheritanceImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.visibility = PersistentUtils.readVisibility(input);
        this.virtual = input.readBoolean();
        this.ancestorType = PersistentUtils.readType(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.scope = factory.readUID(input);
        CsmUID uid = factory.readUID(input);
        this.resolvedClassifier = (CsmClassifier)UIDCsmConverter.UIDtoIdentifiable(uid);
    }

    @Override
    public String toString() {
        return "INHERITANCE " + this.visibility + " " + (this.isVirtual() ? "virtual " : "") + this.ancestorType.getText() + this.getOffsetString();
    }

    public CsmScope getScope() {
        return UIDCsmConverter.UIDtoScope(this.scope);
    }

    public static class InheritanceBuilder
    extends OffsetableDeclarationBase.ScopedDeclarationBuilder {
        private CsmVisibility visibility = CsmVisibility.PUBLIC;
        private boolean _virtual = false;
        private TypeFactory.TypeBuilder typeBuilder;

        public void setTypeBuilder(TypeFactory.TypeBuilder type) {
            this.typeBuilder = type;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        public void setVisibility(CsmVisibility visibility) {
            this.visibility = visibility;
        }

        public boolean isVirtual() {
            return this._virtual;
        }

        public void setVirtual() {
            this._virtual = true;
        }

        public InheritanceImpl create() {
            InheritanceImpl impl = new InheritanceImpl(this.getType(), this.getVisibility(), this._virtual, this.getScope(), this.getFile(), this.getStartOffset(), this.getEndOffset());
            return impl;
        }

        private CsmType getType() {
            CsmType type = null;
            if (this.typeBuilder != null) {
                this.typeBuilder.setScope(this.getScope());
                type = this.typeBuilder.create();
            }
            if (type == null) {
                type = TypeFactory.createSimpleType((CsmClassifier)BuiltinTypes.getBuiltIn("int"), this.getFile(), this.getStartOffset(), this.getStartOffset());
            }
            return type;
        }
    }
}

