/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndCollectionUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public final class TemplateDescriptor {
    private final Collection<CsmUID<CsmTemplateParameter>> templateParams;
    private final CharSequence templateSuffix;
    private final int inheritedTemplateParametersNumber;
    private final boolean specialization;

    public TemplateDescriptor(List<CsmTemplateParameter> templateParams, CharSequence templateSuffix, boolean specialization, boolean global) {
        this(templateParams, templateSuffix, 0, specialization, global);
    }

    public TemplateDescriptor(List<CsmTemplateParameter> templateParams, CharSequence templateSuffix, int inheritedTemplateParametersNumber, boolean specialization, boolean global) {
        this.register(templateParams, global);
        this.templateParams = UIDCsmConverter.objectsToUIDs(templateParams);
        this.templateSuffix = NameCache.getManager().getString(templateSuffix);
        this.inheritedTemplateParametersNumber = inheritedTemplateParametersNumber;
        this.specialization = specialization;
    }

    public TemplateDescriptor(List<CsmTemplateParameter> templateParams, CharSequence templateSuffix, int inheritedTemplateParametersNumber, boolean specialization) {
        this.templateParams = UIDCsmConverter.objectsToUIDs(templateParams);
        this.templateSuffix = NameCache.getManager().getString(templateSuffix);
        this.inheritedTemplateParametersNumber = inheritedTemplateParametersNumber;
        this.specialization = specialization;
    }

    private void register(List<CsmTemplateParameter> templateParams, boolean global) {
        for (CsmTemplateParameter par : templateParams) {
            if (global) {
                RepositoryUtils.put(par);
                continue;
            }
            Utils.setSelfUID((CsmObject)par);
        }
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        if (this.templateParams != null && !this.templateParams.isEmpty()) {
            ArrayList<CsmTemplateParameter> res = new ArrayList<CsmTemplateParameter>(this.templateParams.size());
            for (CsmTemplateParameter par : UIDCsmConverter.UIDsToCsmObjects(this.templateParams)) {
                res.add(par);
            }
            return res;
        }
        return Collections.emptyList();
    }

    public CharSequence getTemplateSuffix() {
        return this.templateSuffix;
    }

    public int getInheritedTemplateParametersNumber() {
        return this.inheritedTemplateParametersNumber;
    }

    public static TemplateDescriptor createIfNeeded(AST ast, CsmFile file, CsmScope scope, boolean global) {
        AST start;
        if (ast == null) {
            return null;
        }
        for (AST token = start = TemplateUtils.getTemplateStart(ast.getFirstChild()); token != null; token = token.getNextSibling()) {
            if (token.getType() != 116) continue;
            CharSequence classSpecializationSuffix = TemplateUtils.getClassSpecializationSuffix(token, null);
            return new TemplateDescriptor(TemplateUtils.getTemplateParameters(token, file, scope, global), CharSequenceUtils.concatenate((CharSequence)"<", (CharSequence)classSpecializationSuffix, (CharSequence)">"), classSpecializationSuffix.length() > 0, global);
        }
        return null;
    }

    public String toString() {
        return this.getTemplateSuffix().toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + CndCollectionUtils.hashCode(this.templateParams);
        hash = 67 * hash + Objects.hashCode(this.templateSuffix);
        hash = 67 * hash + this.inheritedTemplateParametersNumber;
        hash = 67 * hash + (this.specialization ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateDescriptor other = (TemplateDescriptor)obj;
        if (this.inheritedTemplateParametersNumber != other.inheritedTemplateParametersNumber) {
            return false;
        }
        if (this.specialization != other.specialization) {
            return false;
        }
        if (!Objects.equals(this.templateSuffix, other.templateSuffix)) {
            return false;
        }
        return CndCollectionUtils.equals(this.templateParams, other.templateParams);
    }

    public TemplateDescriptor(RepositoryDataInput input) throws IOException {
        int collSize = input.readInt();
        this.templateParams = collSize < 0 ? null : UIDObjectFactory.getDefaultFactory().readUIDCollection(new ArrayList(collSize), input, collSize);
        this.templateSuffix = PersistentUtils.readUTF(input, NameCache.getManager());
        this.inheritedTemplateParametersNumber = input.readInt();
        this.specialization = input.readBoolean();
    }

    public void write(RepositoryDataOutput output) throws IOException {
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.templateParams, output, false);
        PersistentUtils.writeUTF(this.templateSuffix, output);
        output.writeInt(this.inheritedTemplateParametersNumber);
        output.writeBoolean(this.specialization);
    }

    boolean isSpecialization() {
        return this.specialization;
    }

    public static class TemplateDescriptorBuilder
    extends OffsetableDeclarationBase.ScopedDeclarationBuilder {
        private final List<TemplateParameterImpl.TemplateParameterBuilder> parameterBuilders = new ArrayList<TemplateParameterImpl.TemplateParameterBuilder>();
        private int inheritedTemplateParametersNumber = 0;
        private boolean specialization = false;
        private static final CharSequence TEMP_PARAM = CharSequences.create((CharSequence)"<T>");

        public void addParameterBuilder(TemplateParameterImpl.TemplateParameterBuilder parameterBuilser) {
            this.parameterBuilders.add(parameterBuilser);
        }

        public void addTemplateDescriptorBuilder(TemplateDescriptorBuilder builder) {
            this.inheritedTemplateParametersNumber = this.parameterBuilders.size();
            for (TemplateParameterImpl.TemplateParameterBuilder templateParameterBuilder : builder.parameterBuilders) {
                this.addParameterBuilder(templateParameterBuilder);
            }
        }

        public void setSpecialization() {
            this.specialization = true;
        }

        public TemplateDescriptor create() {
            ArrayList<CsmTemplateParameter> templateParams = new ArrayList<CsmTemplateParameter>();
            for (TemplateParameterImpl.TemplateParameterBuilder paramBuilder : this.parameterBuilders) {
                paramBuilder.setScope(this.getScope());
                templateParams.add((CsmTemplateParameter)paramBuilder.create());
            }
            for (CsmTemplateParameter param : templateParams) {
                if (this.isGlobal()) {
                    RepositoryUtils.put(param);
                    continue;
                }
                Utils.setSelfUID((CsmObject)param);
            }
            TemplateDescriptor descriptor = new TemplateDescriptor(templateParams, NameCache.getManager().getString(TEMP_PARAM), this.inheritedTemplateParametersNumber, this.specialization);
            return descriptor;
        }
    }
}

