/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.util.Collection;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ConditionDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ConditionExpressionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.DeepUtil;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;

public final class LoopStatementImpl
extends StatementBase
implements CsmLoopStatement {
    private CsmCondition condition;
    private CsmStatement body;
    private final boolean postCheck;

    private LoopStatementImpl(AST ast, CsmFile file, boolean postCheck, CsmScope scope) {
        super(ast, file, scope);
        this.postCheck = postCheck;
    }

    private LoopStatementImpl(boolean postCheck, CsmScope scope, CsmFile file, int start, int end) {
        super(file, start, end, scope);
        this.postCheck = postCheck;
    }

    public static LoopStatementImpl create(AST ast, CsmFile file, boolean postCheck, CsmScope scope) {
        LoopStatementImpl stmt = new LoopStatementImpl(ast, file, postCheck, scope);
        stmt.init(ast);
        return stmt;
    }

    private void init(AST ast) {
        this.render(ast);
    }

    public CsmCondition getCondition() {
        return this.condition;
    }

    public CsmStatement getBody() {
        return this.body;
    }

    public boolean isPostCheck() {
        return this.postCheck;
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.WHILE;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.condition instanceof Disposable) {
            ((Disposable)this.condition).dispose();
        }
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    private void render(AST ast) {
        AstRenderer renderer = new AstRenderer((FileImpl)this.getContainingFile());
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            int type = token.getType();
            if (type == 599) {
                this.condition = renderer.renderCondition(token, (CsmScope)this);
                continue;
            }
            if (AstRenderer.isExpression(type)) {
                this.condition = ConditionExpressionImpl.create(token, this.getContainingFile(), (CsmScope)this);
                continue;
            }
            if (!AstRenderer.isStatement(type)) continue;
            this.body = AstRenderer.renderStatement(token, this.getContainingFile(), (CsmScope)this);
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return DeepUtil.merge(this.getCondition(), this.getBody());
    }

    public static class LoopStatementBuilder
    extends StatementBase.StatementBuilder
    implements StatementBase.StatementBuilderContainer {
        boolean postCheck;
        ConditionExpressionImpl.ConditionExpressionBuilder conditionExpression;
        ConditionDeclarationImpl.ConditionDeclarationBuilder conditionDeclaration;
        StatementBase.StatementBuilder body;

        public void setPostCheck() {
            this.postCheck = true;
        }

        public void setConditionExpression(ConditionExpressionImpl.ConditionExpressionBuilder conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public void setConditionDeclaration(ConditionDeclarationImpl.ConditionDeclarationBuilder conditionDeclaration) {
            this.conditionDeclaration = conditionDeclaration;
        }

        public void setBody(StatementBase.StatementBuilder body) {
            this.body = body;
        }

        @Override
        public LoopStatementImpl create() {
            LoopStatementImpl stmt = new LoopStatementImpl(this.postCheck, this.getScope(), this.getFile(), this.getStartOffset(), this.getEndOffset());
            if (this.body != null) {
                this.body.setScope((CsmScope)stmt);
                stmt.body = this.body.create();
            }
            if (this.conditionDeclaration != null) {
                this.conditionDeclaration.setScope((CsmScope)stmt);
                stmt.condition = this.conditionDeclaration.create();
            } else if (this.conditionExpression != null) {
                this.conditionExpression.setScope((CsmScope)stmt);
                stmt.condition = this.conditionExpression.create();
            }
            return stmt;
        }

        @Override
        public void addStatementBuilder(StatementBase.StatementBuilder builder) {
            this.body = builder;
        }
    }
}

