/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver3;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;

public class ResolverFactory {
    private static final ThreadLocal<LinkedList<Resolver>> stack = new ThreadLocal<LinkedList<Resolver>>(){

        @Override
        protected LinkedList<Resolver> initialValue() {
            return new LinkedList<Resolver>();
        }
    };
    private static final Resolver EMPTY_RESOLVER = new EmptyResolver();

    private ResolverFactory() {
    }

    public static Resolver createResolver(CsmOffsetable context) {
        return ResolverFactory.createResolver(context.getContainingFile(), context.getStartOffset());
    }

    public static Resolver createResolver(CsmFile file, int offset) {
        return ResolverFactory.createResolver(file, offset, null);
    }

    public static Resolver createResolver(CsmOffsetable context, CsmFile contextFile) {
        return ResolverFactory.createResolver(context.getContainingFile(), context.getStartOffset(), contextFile);
    }

    public static void releaseResolver(Resolver resolver) {
        LinkedList<Resolver> aStack = stack.get();
        assert (!aStack.isEmpty());
        Resolver removeLast = aStack.removeLast();
        assert (resolver == removeLast);
    }

    public static Resolver getCurrentResolver() {
        LinkedList<Resolver> aStack = stack.get();
        if (aStack.isEmpty()) {
            return null;
        }
        return aStack.peekLast();
    }

    public static CsmUID<CsmFile> getCurrentStartFile(CsmOffsetable context) {
        Resolver parent = null;
        LinkedList<Resolver> aStack = stack.get();
        parent = !aStack.isEmpty() ? aStack.getLast() : null;
        CsmFile curFile = parent == null ? context.getContainingFile() : parent.getStartFile();
        return UIDCsmConverter.fileToUID(curFile);
    }

    private static Resolver createResolver(CsmFile file, int offset, CsmFile contextFile) {
        Resolver parent = null;
        LinkedList<Resolver> aStack = stack.get();
        parent = !aStack.isEmpty() ? aStack.getLast() : null;
        if (file == null || aStack.size() > 200) {
            if (file == null) {
                System.err.println("FALLBACK INTO EMPTY RESOLVER");
            } else if (parent instanceof Resolver3) {
                // empty if block
            }
            aStack.addLast(EMPTY_RESOLVER);
            return EMPTY_RESOLVER;
        }
        if (contextFile == null) {
            if (parent == null) {
                for (CsmCompilationUnit cu : CsmFileInfoQuery.getDefault().getCompilationUnits(file, offset)) {
                    CsmFile startFile = cu.getStartFile();
                    if (startFile == null) continue;
                    contextFile = startFile;
                    break;
                }
                if (contextFile == null) {
                    contextFile = file;
                }
            } else {
                contextFile = parent.getStartFile();
            }
        }
        Resolver3 aResolver = new Resolver3(file, offset, parent, contextFile);
        aStack.addLast(aResolver);
        return aResolver;
    }

    private static final class EmptyResolver
    implements Resolver {
        private EmptyResolver() {
        }

        @Override
        public Collection<CsmProject> getLibraries() {
            return Collections.emptyList();
        }

        @Override
        public CsmFile getStartFile() {
            return null;
        }

        @Override
        public CsmObject resolve(CharSequence[] nameTokens, int interestedKind) {
            return null;
        }

        @Override
        public boolean isRecursionOnResolving(int maxRecursion) {
            return true;
        }

        @Override
        public CsmClassifier getOriginalClassifier(CsmClassifier orig) {
            return null;
        }
    }
}

