/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.openide.util.CharSequences;

public final class LabelResolverImpl
extends CsmLabelResolver {
    public Collection<CsmReference> getLabels(CsmFunctionDefinition referencedFunction, CharSequence label, Set<CsmLabelResolver.LabelKind> kinds) {
        Context res = new Context(referencedFunction, label, kinds);
        if (referencedFunction != null) {
            this.processInnerStatements((CsmStatement)referencedFunction.getBody(), res);
        }
        return res.collection;
    }

    private void processInnerStatements(CsmStatement statement, Context res) {
        if (statement != null) {
            switch (statement.getKind()) {
                case LABEL: {
                    res.addLabelDefinition((CsmLabel)statement);
                    break;
                }
                case GOTO: {
                    res.addLabelReference((CsmGotoStatement)statement);
                    break;
                }
                case COMPOUND: {
                    for (CsmStatement stmt : ((CsmCompoundStatement)statement).getStatements()) {
                        this.processInnerStatements(stmt, res);
                    }
                    break;
                }
                case WHILE: 
                case DO_WHILE: 
                case FOR: {
                    this.processInnerStatements(((CsmLoopStatement)statement).getBody(), res);
                    break;
                }
                case IF: {
                    this.processInnerStatements(((CsmIfStatement)statement).getThen(), res);
                    this.processInnerStatements(((CsmIfStatement)statement).getElse(), res);
                    break;
                }
                case SWITCH: {
                    this.processInnerStatements(((CsmSwitchStatement)statement).getBody(), res);
                    break;
                }
                case TRY_CATCH: {
                    this.processInnerStatements(((CsmTryCatchStatement)statement).getTryStatement(), res);
                    break;
                }
            }
        }
    }

    private static final class Context {
        private final Collection<CsmReference> collection = new ArrayList<CsmReference>();
        private final CharSequence label;
        private final Set<CsmLabelResolver.LabelKind> kinds;

        private Context(CsmFunctionDefinition owner, CharSequence label, Set<CsmLabelResolver.LabelKind> kinds) {
            this.label = label;
            this.kinds = kinds;
        }

        private void addLabelDefinition(CsmLabel stmt) {
            if (this.kinds.contains(CsmLabelResolver.LabelKind.Definiton) && (this.label == null || CharSequences.comparator().compare(this.label, stmt.getLabel()) == 0)) {
                this.collection.add(new CsmLabelReferenceImpl(stmt.getLabel(), (CsmOffsetable)stmt, CsmReferenceKind.DEFINITION));
            }
        }

        private void addLabelReference(CsmGotoStatement stmt) {
            if (this.kinds.contains(CsmLabelResolver.LabelKind.Reference) && (this.label == null || CharSequences.comparator().compare(this.label, stmt.getLabel()) == 0)) {
                this.collection.add(new CsmLabelReferenceImpl(stmt.getLabel(), (CsmOffsetable)stmt, CsmReferenceKind.DIRECT_USAGE));
            }
        }

        private static class CsmLabelReferenceImpl
        implements CsmReference {
            private final CharSequence label;
            private final CsmOffsetable owner;
            private final CsmReferenceKind kind;
            private volatile CsmObject closest = null;

            public CsmLabelReferenceImpl(CharSequence label, CsmOffsetable owner, CsmReferenceKind kind) {
                this.label = label;
                this.owner = owner;
                this.kind = kind;
            }

            public CsmReferenceKind getKind() {
                return this.kind;
            }

            public CsmObject getReferencedObject() {
                return this.owner;
            }

            public CsmObject getOwner() {
                return this.owner;
            }

            public CsmObject getClosestTopLevelObject() {
                if (this.closest == null) {
                    this.closest = CsmBaseUtilities.findClosestTopLevelObject((CsmObject)this.owner);
                }
                return this.closest;
            }

            public CsmFile getContainingFile() {
                return this.owner.getContainingFile();
            }

            public int getStartOffset() {
                return this.owner.getStartOffset();
            }

            public int getEndOffset() {
                return this.owner.getEndOffset();
            }

            public CsmOffsetable.Position getStartPosition() {
                return this.owner.getStartPosition();
            }

            public CsmOffsetable.Position getEndPosition() {
                return this.owner.getEndPosition();
            }

            public CharSequence getText() {
                return this.label;
            }

            public String toString() {
                return "" + this.label + "[" + this.kind + "] " + this.owner;
            }
        }
    }
}

