/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTError;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTPragma;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.SimpleOffsetableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTBasedPCStateBuilder;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTProjectFileBasedWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTTokenStreamProducer;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;

public class APTParseFileWalker
extends APTProjectFileBasedWalker {
    private FileContent fileContent;
    private final boolean triggerParsingActivity;
    private final EvalCallback evalCallback;
    private static final EvalCallback EMPTY_EVAL_CALLBACK = new EvalCallback(){

        @Override
        public void onEval(APT apt, boolean result) {
        }

        @Override
        public void onErrorDirective(APT apt) {
        }

        @Override
        public void onPragmaOnceDirective(APT apt) {
        }
    };
    private final CsmCorePackageAccessor csmCorePackageAccessor;
    private static final String DISABLE_LDSCOPE = "disable_ldscope";
    private static final String ENABLE_LDSCOPE = "enable_ldscope";
    private boolean ldScopeEnabled = true;

    public APTParseFileWalker(ProjectBase base, APTFile apt, FileImpl file, PreprocHandler preprocHandler, boolean triggerParsingActivity, EvalCallback evalCallback, APTFileCacheEntry cacheEntry) {
        super(base, apt, file, preprocHandler, cacheEntry);
        this.evalCallback = evalCallback != null ? evalCallback : EMPTY_EVAL_CALLBACK;
        this.triggerParsingActivity = triggerParsingActivity;
        this.csmCorePackageAccessor = CsmCorePackageAccessor.get();
    }

    public void setFileContent(FileContent content) {
        this.fileContent = content;
    }

    protected boolean needMacroAndIncludes() {
        return this.fileContent != null;
    }

    public final boolean isTriggerParsingActivity() {
        return this.triggerParsingActivity;
    }

    protected boolean needPPTokens() {
        return TraceFlags.PARSE_HEADERS_WITH_SOURCES;
    }

    public TokenStream getFilteredTokenStream(APTLanguageFilter lang) {
        LdScopeFilter ts = new LdScopeFilter(lang.getFilteredStream(this.getTokenStream()));
        return ts;
    }

    public TokenStream getTokenStream() {
        return this.getTokenStream(true);
    }

    public TokenStream getTokenStream(boolean filterOutComments) {
        this.setMode(1);
        TokenStream ts = super.getTokenStream();
        ts = new APTMacroExpandedStream(ts, (APTMacroCallback)this.getMacroMap(), !filterOutComments);
        if (filterOutComments) {
            ts = new APTCommentsFilter(ts);
        }
        return ts;
    }

    protected void onDefine(APT apt) {
        super.onDefine(apt);
        if (this.needMacroAndIncludes()) {
            CsmMacro macro = this.createMacro((APTDefine)apt);
            this.fileContent.addMacro(macro);
        }
    }

    protected void onErrorNode(APT apt) {
        super.onErrorNode(apt);
        this.evalCallback.onErrorDirective(apt);
        if (this.needMacroAndIncludes()) {
            this.fileContent.addError(this.createError((APTError)apt));
        }
    }

    protected void onPragmaNode(APT apt) {
        super.onPragmaNode(apt);
        if (this.isStopped()) {
            this.evalCallback.onPragmaOnceDirective(apt);
        } else {
            APTPragma pragma = (APTPragma)apt;
            APTToken name = pragma.getName();
            if (name != null) {
                CharSequence textID = name.getTextID();
                if (DISABLE_LDSCOPE.contentEquals(textID)) {
                    this.ldScopeEnabled = false;
                } else if (ENABLE_LDSCOPE.contentEquals(textID)) {
                    this.ldScopeEnabled = true;
                }
            }
        }
    }

    @Override
    protected void postInclude(APTInclude apt, FileImpl included, PPIncludeHandler.IncludeState pushIncludeState) {
        if (this.needMacroAndIncludes()) {
            int includeDirectiveIndex = super.getCurIncludeDirectiveFileIndex();
            this.fileContent.addInclude(this.createInclude(apt, included, pushIncludeState == PPIncludeHandler.IncludeState.Recursive, includeDirectiveIndex), pushIncludeState != PPIncludeHandler.IncludeState.Success);
        }
    }

    protected boolean hasIncludeActionSideEffects() {
        return this.needMacroAndIncludes();
    }

    @Override
    protected FileImpl includeAction(ProjectBase inclFileOwner, CharSequence inclPath, int mode, APTInclude apt, PostIncludeData postIncludeState) throws IOException {
        try {
            APTPreprocHandler preprocHandler = this.getPreprocHandler();
            FileImpl includedFile = inclFileOwner.prepareIncludedFile(inclFileOwner, inclPath, (PreprocHandler)preprocHandler);
            if (includedFile != null) {
                ProjectBase startProject = this.getStartProject();
                if (inclFileOwner.isDisposing() || startProject.isDisposing()) {
                    if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                        System.err.printf("onFileIncluded: %s file [%s] is interrupted on disposing project%n", inclPath, inclFileOwner.getName());
                    }
                } else {
                    FileIncludeInParams params = new FileIncludeInParams(inclFileOwner, startProject, includedFile, inclPath, (PreprocHandler)preprocHandler, postIncludeState, mode, this.isTriggerParsingActivity());
                    if (this.isTokenProducer() && TraceFlags.PARSE_HEADERS_WITH_SOURCES) {
                        FileIncludeOutParams inclInfo = this.includeFileWithTokens(params);
                        if (inclInfo != null) {
                            super.putNodeProperty((APT)apt, FileIncludeOutParams.class, (Object)inclInfo);
                        }
                    } else {
                        FileIncludeOutParams inclInfo = this.includeFileWithoutTokens(params);
                        if (this.isTriggerParsingActivity() && inclInfo != null) {
                            inclFileOwner.postIncludeFile(startProject, includedFile, inclPath, inclInfo.getStatePair(), inclInfo.aptCacheEntry);
                        }
                    }
                }
            }
            return includedFile;
        }
        catch (NullPointerException ex) {
            APTUtils.LOG.log(Level.SEVERE, "NPE when processing file " + inclPath, ex);
            DiagnosticExceptoins.register(ex);
            return null;
        }
    }

    protected void popInclude(APTInclude aptInclude, ResolvedPath resolvedPath, PPIncludeHandler.IncludeState pushState) {
        if (pushState == PPIncludeHandler.IncludeState.Success) {
            FileIncludeOutParams inclInfo;
            super.popInclude(aptInclude, resolvedPath, pushState);
            if (this.isTokenProducer() && TraceFlags.PARSE_HEADERS_WITH_SOURCES && (inclInfo = (FileIncludeOutParams)super.getNodeProperty((APT)aptInclude, FileIncludeOutParams.class)) != null) {
                inclInfo.inParams.inclFileOwner.postIncludeFile(inclInfo.inParams.startProject, inclInfo.inParams.includedFile, inclInfo.inParams.includedPath, inclInfo.getStatePair(), inclInfo.aptCacheEntry);
            }
        }
    }

    static int[] getDefineOffsets(APTDefine define, APTToken lastParam) {
        int startOffset = define.getToken().getOffset();
        List bodyTokens = define.getBody();
        APTToken last = bodyTokens.isEmpty() ? define.getName() : (APTToken)bodyTokens.get(bodyTokens.size() - 1);
        int endOffset = last != null && !APTUtils.isEOF((Token)last) && last.getEndOffset() > 0 ? last.getEndOffset() : startOffset;
        return new int[]{startOffset, endOffset};
    }

    private FileIncludeOutParams includeFileWithTokens(FileIncludeInParams params) throws IOException {
        APTFile aptFile = APTTokenStreamProducer.getFileAPT(params.includedFile, true);
        if (aptFile != null) {
            PreprocHandler.State ppIncludeState = params.preprocHandler.getState();
            APTFileCacheEntry aptCacheEntry = params.includedFile.getAPTCacheEntry(ppIncludeState, Boolean.TRUE);
            APTBasedPCStateBuilder pcBuilder = new APTBasedPCStateBuilder(params.includedFile.getAbsolutePath());
            APTParseFileWalker walker = new APTParseFileWalker(params.startProject, aptFile, params.includedFile, params.preprocHandler, params.triggerParsingActivity, pcBuilder, aptCacheEntry);
            FileContent inclFileContent = params.includedFile.prepareIncludedFileParsingContent();
            walker.setFileContent(inclFileContent);
            this.includeStream(aptFile, (APTWalker)walker);
            return new FileIncludeOutParams(params, ppIncludeState, pcBuilder, aptCacheEntry);
        }
        Utils.LOG.log(Level.INFO, "Can not find or build APT for file {0}", params.includedFile);
        return null;
    }

    private CsmCorePackageAccessor getCsmCorePackageAccessor() {
        return this.csmCorePackageAccessor;
    }

    private FileIncludeOutParams includeFileWithoutTokens(FileIncludeInParams params) throws IOException {
        boolean isFileCacheApplicable;
        assert (params.preprocHandler != null) : "null preprocHandler for " + FileIncludeInParams.access$500(params);
        assert (params.includedFile != null) : "null FileImpl for " + FileIncludeInParams.access$500(params);
        PreprocHandler.State newState = params.preprocHandler.getState();
        PreprocessorStatePair cachedOut = null;
        APTFileCacheEntry aptCacheEntry = null;
        FilePreprocessorConditionState pcState = null;
        boolean foundInCache = false;
        if (params.postIncludeState != null && params.postIncludeState.hasPostIncludeMacroState() && params.postIncludeState.hasDeadBlocks()) {
            pcState = FilePreprocessorConditionState.build(params.includedPath, params.postIncludeState.getDeadBlocks());
            params.preprocHandler.getMacroMap().setState(params.postIncludeState.getPostIncludeMacroState());
            foundInCache = true;
        }
        boolean bl = isFileCacheApplicable = params.mode == 1 && APTHandlersSupport.getIncludeStackDepth((PreprocHandler.State)newState) == 1;
        if (!foundInCache && isFileCacheApplicable && (cachedOut = this.getCsmCorePackageAccessor().getCachedVisitedState(params.includedFile, newState)) != null) {
            params.preprocHandler.getMacroMap().setState(APTHandlersSupport.extractMacroMapState((PreprocHandler.State)cachedOut.state));
            pcState = cachedOut.pcState;
            foundInCache = true;
        }
        if (!foundInCache) {
            APTFile aptLight = APTTokenStreamProducer.getFileAPT(params.includedFile, false);
            if (aptLight == null) {
                Utils.LOG.log(Level.INFO, "Can not find or build APT for file {0}", params.includedPath);
                return null;
            }
            APTBasedPCStateBuilder pcBuilder = new APTBasedPCStateBuilder(params.includedFile.getAbsolutePath());
            aptCacheEntry = params.includedFile.getAPTCacheEntry(newState, Boolean.TRUE);
            APTParseFileWalker walker = new APTParseFileWalker(params.startProject, aptLight, params.includedFile, params.preprocHandler, params.triggerParsingActivity, pcBuilder, aptCacheEntry);
            walker.visit();
            pcState = pcBuilder.build();
        }
        if (params.postIncludeState != null && !params.postIncludeState.hasDeadBlocks()) {
            int[] deadBlocks = this.getCsmCorePackageAccessor().getPCStateDeadBlocks(pcState);
            params.postIncludeState.setDeadBlocks(deadBlocks);
        }
        if (cachedOut == null && isFileCacheApplicable) {
            this.getCsmCorePackageAccessor().cacheVisitedState(params.includedFile, newState, params.preprocHandler, pcState);
        }
        return new FileIncludeOutParams(params, newState, pcState, aptCacheEntry);
    }

    private ErrorDirectiveImpl createError(APTError error) {
        APTToken token = error.getToken();
        SimpleOffsetableImpl pos = this.getOffsetable(token);
        this.setEndPosition(pos, token);
        return ErrorDirectiveImpl.create(this.getFile(), token.getTextID(), pos, this.getPreprocHandler().getState());
    }

    private CsmMacro createMacro(APTDefine define) {
        List<Object> params = null;
        Collection paramTokens = define.getParams();
        APTToken lastParam = null;
        if (paramTokens != null) {
            params = new ArrayList<CharSequence>(paramTokens.size());
            for (APTToken elem : paramTokens) {
                if (APTUtils.isID((Token)elem)) {
                    params.add(NameCache.getManager().getString(elem.getTextID()));
                }
                if (APTUtils.isVaArgsToken((APTToken)elem)) continue;
                lastParam = elem;
            }
            if (params.isEmpty()) {
                params = Collections.emptyList();
            }
        }
        int[] offsets = APTParseFileWalker.getDefineOffsets(define, lastParam);
        String body = "";
        CsmMacro.Kind kind = define.isValid() ? CsmMacro.Kind.DEFINED : CsmMacro.Kind.INVALID;
        return MacroImpl.create(define.getName().getTextID(), params, body, this.getFile(), offsets[0], offsets[1], kind);
    }

    private IncludeImpl createInclude(APTInclude apt, FileImpl included, boolean recursive, int includedDirectiveIndex) {
        int startOffset = apt.getToken().getOffset();
        APTToken lastToken = this.getLastToken(apt.getInclude());
        if (lastToken == null || APTUtils.isEOF((Token)lastToken)) {
            lastToken = apt.getToken();
        }
        int endOffset = lastToken != null && !APTUtils.isEOF((Token)lastToken) ? lastToken.getEndOffset() : startOffset;
        IncludeImpl incImpl = IncludeImpl.create(apt.getFileName((APTMacroCallback)this.getMacroMap()), apt.isSystem((APTMacroCallback)this.getMacroMap()), recursive, included, this.getFile(), startOffset, endOffset, includedDirectiveIndex);
        return incImpl;
    }

    private SimpleOffsetableImpl getOffsetable(APTToken token) {
        return new SimpleOffsetableImpl(token.getLine(), token.getColumn(), token.getOffset());
    }

    private void setEndPosition(SimpleOffsetableImpl offsetable, APTToken token) {
        if (token != null && !APTUtils.isEOF((Token)token)) {
            offsetable.setEndPosition(token.getEndLine(), token.getEndColumn(), token.getEndOffset());
        } else {
            assert (offsetable.getStartPosition() != null);
            offsetable.setEndPosition(offsetable.getStartPosition());
        }
    }

    private APTToken getLastToken(TokenStream ts) {
        try {
            Token last = ts.nextToken();
            Token curr = null;
            while (!APTUtils.isEOF((Token)(curr = ts.nextToken()))) {
                last = curr;
            }
            return (APTToken)last;
        }
        catch (TokenStreamException e) {
            DiagnosticExceptoins.register(e);
            return null;
        }
    }

    protected void onEval(APT apt, boolean result) {
        this.evalCallback.onEval(apt, result);
    }

    private final class LdScopeFilter
    implements TokenStream {
        private final TokenStream orig;

        public LdScopeFilter(TokenStream orig) {
            this.orig = orig;
        }

        public Token nextToken() throws TokenStreamException {
            Token nextToken = this.orig.nextToken();
            if (!APTParseFileWalker.this.ldScopeEnabled && nextToken.getType() == 215) {
                nextToken = new APTBaseLanguageFilter.FilterToken((APTToken)nextToken, 91);
            }
            return nextToken;
        }
    }

    private static final class FileIncludeOutParams {
        private final FileIncludeInParams inParams;
        private final PreprocHandler.State ppState;
        private final FilePreprocessorConditionState pcState;
        private final APTBasedPCStateBuilder pcBuilder;
        private final APTFileCacheEntry aptCacheEntry;

        public FileIncludeOutParams(FileIncludeInParams inParams, PreprocHandler.State ppState, FilePreprocessorConditionState pcState, APTFileCacheEntry aptCacheEntry) {
            this(inParams, ppState, pcState, null, aptCacheEntry);
            assert (pcState != null);
        }

        public FileIncludeOutParams(FileIncludeInParams inParams, PreprocHandler.State ppState, APTBasedPCStateBuilder pcBuilder, APTFileCacheEntry aptCacheEntry) {
            this(inParams, ppState, null, pcBuilder, aptCacheEntry);
            assert (pcBuilder != null);
        }

        private FileIncludeOutParams(FileIncludeInParams inParams, PreprocHandler.State ppState, FilePreprocessorConditionState pcState, APTBasedPCStateBuilder pcBuilder, APTFileCacheEntry aptCacheEntry) {
            this.inParams = inParams;
            this.ppState = ppState;
            this.pcState = pcState;
            this.pcBuilder = pcBuilder;
            this.aptCacheEntry = aptCacheEntry;
        }

        private PreprocessorStatePair getStatePair() {
            if (this.pcState != null) {
                return new PreprocessorStatePair(this.ppState, this.pcState);
            }
            assert (this.pcBuilder != null);
            return new PreprocessorStatePair(this.ppState, this.pcBuilder.build());
        }
    }

    private static final class FileIncludeInParams {
        private final ProjectBase inclFileOwner;
        private final ProjectBase startProject;
        private final FileImpl includedFile;
        private final CharSequence includedPath;
        private final PreprocHandler preprocHandler;
        private final PostIncludeData postIncludeState;
        private final int mode;
        private final boolean triggerParsingActivity;

        public FileIncludeInParams(ProjectBase inclFileOwner, ProjectBase startProject, FileImpl includedFile, CharSequence includedFileName, PreprocHandler preprocHandler, PostIncludeData postIncludeState, int mode, boolean triggerParsingActivity) {
            this.inclFileOwner = inclFileOwner;
            this.startProject = startProject;
            this.includedFile = includedFile;
            this.includedPath = includedFileName;
            this.preprocHandler = preprocHandler;
            this.postIncludeState = postIncludeState;
            this.mode = mode;
            this.triggerParsingActivity = triggerParsingActivity;
        }
    }

    public static interface EvalCallback {
        public void onEval(APT var1, boolean var2);

        public void onErrorDirective(APT var1);

        public void onPragmaOnceDirective(APT var1);
    }
}

