/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class JBossJaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String JAXWS_TOOLS_JAR = "client/jaxws-tools.jar";
    private File root;
    private String version;
    private JaxWs jaxWs;

    public JBossJaxWsStack(File root) {
        this.root = root;
        try {
            this.version = this.resolveImplementationVersion();
            if (this.version == null) {
                this.version = "2.1.3";
            }
        }
        catch (IOException ex) {
            this.version = "2.1.3";
        }
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return WSStackFactory.createWSStackVersion((String)this.version);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (toolId == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            public String getServiceUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return applicationRoot + "/" + serviceName;
            }

            public String getDescriptorUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return this.getServiceUri(applicationRoot, serviceName, portName, isEjb) + "?wsdl";
            }

            public String getTesterPageUri(String host, String port, String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return "";
            }
        };
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.JSR109) {
            return true;
        }
        return feature == JaxWs.Feature.WSIT && new File(this.root, "client/jbossws-metro-wsit-tools.jar").exists();
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry entry;
        File wsToolsJar = new File(this.root, JAXWS_TOOLS_JAR);
        if (wsToolsJar.exists() && (entry = (jarFile = new JarFile(wsToolsJar)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream is = jarFile.getInputStream(entry);
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            String ln = null;
            String ver = null;
            while ((ln = r.readLine()) != null) {
                String line = ln.trim();
                if (!line.startsWith("major-version=")) continue;
                ver = line.substring(14);
            }
            r.close();
            return ver;
        }
        return null;
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            File clientRoot = new File(JBossJaxWsStack.this.root, "client");
            try {
                File jaxWsAPILib;
                File loggingJar = new File(clientRoot, "jboss-common-client.jar");
                if (!loggingJar.exists()) {
                    loggingJar = new File(clientRoot, "jboss-logging-spi.jar");
                }
                if ((jaxWsAPILib = new File(clientRoot, "jboss-jaxws.jar")).exists()) {
                    return new URL[]{new File(clientRoot, "wstx.jar").toURI().toURL(), new File(clientRoot, "jaxws-tools.jar").toURI().toURL(), loggingJar.toURI().toURL(), new File(clientRoot, "stax-api.jar").toURI().toURL(), jaxWsAPILib.toURI().toURL(), new File(clientRoot, "jbossws-client.jar").toURI().toURL(), new File(clientRoot, "jboss-jaxws-ext.jar").toURI().toURL(), new File(clientRoot, "jboss-saaj.jar").toURI().toURL()};
                }
                jaxWsAPILib = new File(clientRoot, "jbossws-native-jaxws.jar");
                if (jaxWsAPILib.exists()) {
                    return new URL[]{new File(clientRoot, "wstx.jar").toURI().toURL(), new File(clientRoot, "jaxws-tools.jar").toURI().toURL(), loggingJar.toURI().toURL(), new File(clientRoot, "stax-api.jar").toURI().toURL(), jaxWsAPILib.toURI().toURL(), new File(clientRoot, "jbossws-native-client.jar").toURI().toURL(), new File(clientRoot, "jbossws-native-jaxws-ext.jar").toURI().toURL(), new File(clientRoot, "jbossws-native-saaj.jar").toURI().toURL()};
                }
                jaxWsAPILib = new File(clientRoot, "jaxws-api.jar");
                if (jaxWsAPILib.exists()) {
                    return new URL[]{new File(clientRoot, "wstx.jar").toURI().toURL(), new File(clientRoot, "jaxws-tools.jar").toURI().toURL(), loggingJar.toURI().toURL(), new File(clientRoot, "stax-api.jar").toURI().toURL(), jaxWsAPILib.toURI().toURL(), new File(clientRoot, "jbossws-metro-client.jar").toURI().toURL(), new File(clientRoot, "saaj-api.jar").toURI().toURL()};
                }
            }
            catch (MalformedURLException ex) {
                return new URL[0];
            }
            return new URL[0];
        }
    }
}

