/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes.actions;

import java.io.File;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.nodes.JBAbilitiesSupport;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.UndeployModuleCookie;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UndeployModuleCookieImpl
implements UndeployModuleCookie {
    private static final int TIMEOUT = 30000;
    private static final int POLLING_INTERVAL = 2000;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("JBoss undeploy", 1);
    private String fileName;
    private Lookup lookup;
    private ModuleType type;
    private final boolean isEJB3;
    private boolean isRunning;
    private final JBAbilitiesSupport abilitiesSupport;

    public UndeployModuleCookieImpl(String fileName, ModuleType type, Lookup lookup) {
        this(fileName, type, false, lookup);
    }

    public UndeployModuleCookieImpl(String fileName, Lookup lookup) {
        this(fileName, ModuleType.EJB, true, lookup);
    }

    private UndeployModuleCookieImpl(String fileName, ModuleType type, boolean isEJB3, Lookup lookup) {
        this.lookup = lookup;
        this.fileName = fileName;
        this.type = type;
        this.isEJB3 = isEJB3;
        this.isRunning = false;
        this.abilitiesSupport = new JBAbilitiesSupport(lookup);
    }

    @Override
    public RequestProcessor.Task undeploy() {
        final JBDeploymentManager dm = (JBDeploymentManager)this.lookup.lookup(JBDeploymentManager.class);
        final String nameWoExt = this.fileName.substring(0, this.fileName.lastIndexOf(46));
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(UndeployModuleCookieImpl.class, (String)"LBL_UndeployProgress", (Object)nameWoExt));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UndeployModuleCookieImpl.this.isRunning = true;
                String deployDir = dm.getInstanceProperties().getProperty("deploy-dir");
                File file = new File(deployDir, UndeployModuleCookieImpl.this.fileName);
                if (file.exists() && file.canWrite()) {
                    long start = System.currentTimeMillis();
                    file.delete();
                    if (UndeployModuleCookieImpl.this.abilitiesSupport.isJB7x()) {
                        File statusFile = new File(file.getAbsolutePath() + ".undeployed");
                        int time = 0;
                        do {
                            try {
                                Thread.sleep(2000L);
                                time += 2000;
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                        } while ((!statusFile.exists() || statusFile.lastModified() < start) && time < 30000);
                        boolean wait = true;
                        while (wait && time < 30000) {
                            block26: {
                                try {
                                    wait = false;
                                    TargetModuleID[] ids = dm.getAvailableModules(UndeployModuleCookieImpl.this.type, dm.getTargets());
                                    if (ids == null) break block26;
                                    for (TargetModuleID id : ids) {
                                        if (!UndeployModuleCookieImpl.this.fileName.equals(id.getModuleID())) continue;
                                        wait = true;
                                        break;
                                    }
                                }
                                catch (TargetException ex) {
                                }
                                catch (IllegalStateException ex) {
                                    // empty catch block
                                }
                            }
                            if (!wait) continue;
                            try {
                                Thread.sleep(2000L);
                                time += 2000;
                            }
                            catch (InterruptedException ex) {}
                        }
                    } else {
                        try {
                            ObjectName searchPattern = null;
                            if (Util.isRemoteManagementSupported(UndeployModuleCookieImpl.this.lookup) && !UndeployModuleCookieImpl.this.isEJB3) {
                                searchPattern = new ObjectName("jboss.management.local:" + (!UndeployModuleCookieImpl.this.type.equals(ModuleType.EAR) ? "J2EEApplication=null," : "") + "j2eeType=" + Util.getModuleTypeString(UndeployModuleCookieImpl.this.type) + ",name=" + UndeployModuleCookieImpl.this.fileName + ",*");
                            } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.EAR)) {
                                searchPattern = new ObjectName("jboss.j2ee:service=EARDeployment,url='" + UndeployModuleCookieImpl.this.fileName + "'");
                            } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.WAR)) {
                                searchPattern = new ObjectName("jboss.web:j2eeType=WebModule,J2EEApplication=none,name=//localhost/" + nameWoExt + ",*");
                            } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.EJB)) {
                                searchPattern = new ObjectName("jboss.j2ee:service=" + (UndeployModuleCookieImpl.this.isEJB3 ? "EJB3" : "EjbModule") + ",module=" + UndeployModuleCookieImpl.this.fileName);
                            }
                            int time = 0;
                            while (Util.isObjectDeployed(dm, searchPattern) && time < 30000) {
                                try {
                                    Thread.sleep(2000L);
                                    time += 2000;
                                }
                                catch (InterruptedException ex) {}
                            }
                        }
                        catch (MalformedObjectNameException ex) {
                        }
                        catch (NullPointerException ex) {
                            // empty catch block
                        }
                    }
                }
                handle.finish();
                UndeployModuleCookieImpl.this.isRunning = false;
            }
        };
        handle.start();
        return PROCESSOR.post(r);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }
}

