/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.project.ui.groups.DirectoryGroupEditPanel;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class DirectoryGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(DirectoryGroup.class.getName());
    static final String KIND = "directory";

    public static DirectoryGroup create(String name, FileObject dir) {
        String path = dir.toURL().toExternalForm();
        String id = DirectoryGroup.sanitizeNameAndUniquifyForId(name);
        LOG.log(Level.FINE, "Creating: {0}", id);
        Preferences p = NODE.node(id);
        p.put("name", name);
        p.put("kind", KIND);
        p.put("path", path);
        return new DirectoryGroup(id);
    }

    DirectoryGroup(String id) {
        super(id);
    }

    @Override
    protected void findProjects(Set<Project> projects, ProgressHandle h, int start, int end) {
        assert (!SwingUtilities.isEventDispatchThread());
        String dir = this.prefs().get("path", null);
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)new URL(dir));
        }
        catch (MalformedURLException x) {
            LOG.log(Level.WARNING, "MalformedURLException: {0}", dir);
        }
        if (fo != null && fo.isFolder()) {
            try {
                Project p = ProjectManager.getDefault().findProject(fo);
                if (p != null) {
                    projects.add(p);
                    if (h != null) {
                        h.progress(DirectoryGroup.progressMessage(p), Math.min(++start, end));
                    }
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
            Counter counter = new Counter();
            counter.start = start;
            counter.end = end;
            this.processFolderChildren(fo, projects, h, counter, true);
        }
    }

    public FileObject getDirectory() {
        String p = this.prefs().get("path", null);
        if (p != null && p.length() > 0) {
            try {
                return URLMapper.findFileObject((URL)new URL(p));
            }
            catch (MalformedURLException x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        return null;
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return new DirectoryGroupEditPanel(this);
    }

    private void processFolderChildren(FileObject fo, Set<Project> projects, ProgressHandle h, Counter counter, boolean checkShare) throws IllegalArgumentException {
        Enumeration e = fo.getFolders(false);
        while (e.hasMoreElements()) {
            try {
                FileObject em = (FileObject)e.nextElement();
                SharabilityQuery.Sharability share = SharabilityQuery.Sharability.UNKNOWN;
                if (checkShare && (share = SharabilityQuery.getSharability((FileObject)fo)) == SharabilityQuery.Sharability.NOT_SHARABLE) continue;
                Project p = ProjectManager.getDefault().findProject(em);
                if (p != null && !ProjectConvertors.isConvertorProject((Project)p)) {
                    projects.add(p);
                    if (h != null) {
                        h.progress(DirectoryGroup.progressMessage(p), Math.min(++counter.start, counter.end));
                    }
                }
                checkShare = share != SharabilityQuery.Sharability.SHARABLE;
                this.processFolderChildren(em, projects, h, counter, checkShare);
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    private static class Counter {
        int start;
        int end;

        private Counter() {
        }
    }
}

