/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.callgraph.FunctionImpl;
import org.netbeans.modules.cnd.navigation.callgraph.VariableImpl;

public class CallImpl
implements Call {
    private final Function owner;
    private final Function callee;
    private final boolean nameOrder;
    private final CsmReference firstOccurrence;
    private final ArrayList<Call.Occurrence> occurrences;
    private final CharSequence description;
    private final CharSequence htmlName;

    public CallImpl(CsmOffsetableDeclaration owner, ArrayList<CsmReference> references, CsmOffsetableDeclaration callee, boolean nameOrder) {
        this.nameOrder = nameOrder;
        this.owner = CallImpl.implementationResolver(owner);
        this.callee = CallImpl.implementationResolver(callee);
        this.occurrences = this.initOccurrences(references);
        this.firstOccurrence = !references.isEmpty() ? references.get(0) : null;
        this.description = this.initDescription(this.firstOccurrence);
        this.htmlName = this.initHtmlDisplayName(this.firstOccurrence);
    }

    public Object getReferencedCall() {
        return this.firstOccurrence;
    }

    public void open() {
        String taskName = "Open function call";
        Runnable run = new Runnable(){

            @Override
            public void run() {
                CsmUtilities.openSource((CsmObject)CallImpl.this.firstOccurrence);
            }
        };
        CsmModelAccessor.getModel().enqueue(run, (CharSequence)"Open function call");
    }

    public Function getCallee() {
        return this.callee;
    }

    public Function getCaller() {
        return this.owner;
    }

    public Collection<Call.Occurrence> getOccurrences() {
        return this.occurrences;
    }

    public String getHtmlDisplayName() {
        if (this.htmlName != null) {
            return this.htmlName.toString();
        }
        return null;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description.toString();
        }
        return null;
    }

    public String toString() {
        if (this.nameOrder) {
            return this.getCallee().getName() + "<-" + this.getCaller().getName();
        }
        return this.getCaller().getName() + "->" + this.getCallee().getName();
    }

    public int compareTo(Call o) {
        if (this.nameOrder) {
            return this.getCaller().getName().compareTo(o.getCaller().getName());
        }
        int diff = this.firstOccurrence.getStartOffset() - ((CallImpl)o).firstOccurrence.getStartOffset();
        if (diff == 0) {
            return this.getCallee().getName().compareTo(o.getCallee().getName());
        }
        return diff;
    }

    private CharSequence initHtmlDisplayName(CsmReference reference) {
        return CsmReferenceSupport.getContextLineHtml((CsmReference)reference, (boolean)true);
    }

    private CharSequence initDescription(CsmReference reference) {
        return CsmReferenceSupport.getContextLine((CsmReference)reference);
    }

    private ArrayList<Call.Occurrence> initOccurrences(ArrayList<CsmReference> references) {
        ArrayList<Call.Occurrence> result = new ArrayList<Call.Occurrence>(references.size());
        for (CsmReference ref : references) {
            result.add(new OccurrenceImpl(ref));
        }
        return result;
    }

    private static Function implementationResolver(CsmOffsetableDeclaration entity) {
        if (CsmKindUtilities.isFunction((CsmObject)entity)) {
            return new FunctionImpl((CsmFunction)entity);
        }
        if (CsmKindUtilities.isVariable((CsmObject)entity)) {
            return new VariableImpl((CsmVariable)entity);
        }
        return null;
    }

    private static class OccurrenceImpl
    implements Call.Occurrence {
        private final CsmReference reference;
        private final CharSequence description;
        private final CharSequence htmlName;

        private OccurrenceImpl(CsmReference reference) {
            this.reference = reference;
            this.description = this.initDescription(reference);
            this.htmlName = this.initHtmlDisplayName(reference);
        }

        public void open() {
            String taskName = "Open function call";
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    CsmUtilities.openSource((CsmObject)OccurrenceImpl.this.reference);
                }
            };
            CsmModelAccessor.getModel().enqueue(run, (CharSequence)"Open function call");
        }

        public String getHtmlDisplayName() {
            if (this.htmlName != null) {
                return this.htmlName.toString();
            }
            return null;
        }

        public String getDescription() {
            if (this.description != null) {
                return this.description.toString();
            }
            return null;
        }

        private CharSequence initHtmlDisplayName(CsmReference ref) {
            return CsmReferenceSupport.getContextLineHtml((CsmReference)ref, (boolean)true);
        }

        private CharSequence initDescription(CsmReference ref) {
            return CsmReferenceSupport.getContextLine((CsmReference)ref);
        }
    }
}

