/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend;

import org.clang.basic.CharSourceRange;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.spi.PreprocessorImplementation;
import org.clang.frontend.TextDiagnostic;
import org.clang.frontend.impl.TextDiagnosticPrinterStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.SmallString;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;

public class TextDiagnosticPrinter
extends DiagnosticConsumer
implements Destructors.ClassWithDestructor {
    private raw_ostream OS;
    private IntrusiveRefCntPtr<DiagnosticOptions> DiagOpts;
    private std_ptr.unique_ptr<TextDiagnostic> TextDiag;
    private std.string Prefix;
    private boolean OwnsOutputStream;

    public TextDiagnosticPrinter(raw_ostream os, DiagnosticOptions diags) {
        this(os, diags, false);
    }

    public TextDiagnosticPrinter(raw_ostream os, DiagnosticOptions diags, boolean _OwnsOutputStream) {
        this.OS = os;
        this.DiagOpts = new IntrusiveRefCntPtr((Object)diags);
        this.TextDiag = new std_ptr.unique_ptr();
        this.Prefix = new std.string();
        this.OwnsOutputStream = _OwnsOutputStream;
    }

    public void $destroy() {
        if (this.OwnsOutputStream && this.OS != null) {
            this.OS.$destroy();
        }
        super.$destroy();
    }

    public void setPrefix(std.string Value) {
        this.Prefix.$assign(Value);
    }

    public void BeginSourceFile(LangOptions LO, PreprocessorImplementation PP) {
        this.TextDiag.reset((Object)new TextDiagnostic(this.OS, LO, (DiagnosticOptions)this.DiagOpts.$star()));
    }

    public void EndSourceFile() {
        this.TextDiag.reset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void HandleDiagnostic(DiagnosticsEngine.Level Level2, Diagnostic Info) {
        SmallString OutStr = null;
        raw_svector_ostream DiagMessageStream = null;
        try {
            super.HandleDiagnostic(Level2, Info);
            OutStr = new SmallString(100);
            Info.FormatDiagnostic(OutStr);
            DiagMessageStream = new raw_svector_ostream(OutStr);
            TextDiagnosticPrinterStatics.printDiagnosticOptions((raw_ostream)DiagMessageStream, Level2, Info, (DiagnosticOptions)this.DiagOpts.$star());
            long StartOfLocationInfo = this.OS.tell();
            if (!this.Prefix.empty()) {
                this.OS.$out(this.Prefix).$out(NativePointer.$((String)": "));
            }
            if (!Info.getLocation().isValid()) {
                TextDiagnostic.printDiagnosticLevel(this.OS, Level2, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors, ((DiagnosticOptions)this.DiagOpts.$arrow()).CLFallbackMode);
                TextDiagnostic.printDiagnosticMessage(this.OS, Level2.getValue() != 0, DiagMessageStream.str(), this.OS.tell() - StartOfLocationInfo, ((DiagnosticOptions)this.DiagOpts.$arrow()).MessageLength, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors);
                this.OS.flush();
                return;
            }
            assert (this.DiagOpts.$boolean()) : "Unexpected diagnostic without options set";
            assert (Info.hasSourceManager()) : "Unexpected diagnostic with no source manager";
            assert (this.TextDiag.$boolean()) : "Unexpected diagnostic outside source file processing";
            ((TextDiagnostic)this.TextDiag.$arrow()).emitDiagnostic(new SourceLocation(Info.getLocation()), Level2, DiagMessageStream.str(), (ArrayRef<CharSourceRange>)Info.getRanges(), (ArrayRef<FixItHint>)Info.getFixItHints(), Info.getSourceManager());
            this.OS.flush();
        }
        finally {
            if (DiagMessageStream != null) {
                DiagMessageStream.$destroy();
            }
            if (OutStr != null) {
                OutStr.$destroy();
            }
        }
    }
}

