/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.CharSourceRange;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.FileEntry;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.SetVector;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.DOT;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;

public class DependencyGraphCallback
extends PPCallbacks
implements Destructors.ClassWithDestructor {
    private Preprocessor PP;
    private std.string OutputFile;
    private std.string SysRoot;
    private SetVector<FileEntry> AllFiles;
    private DenseMap<FileEntry, SmallVector<FileEntry>> Dependencies;

    private raw_ostream writeNodeReference(raw_ostream OS, FileEntry Node) {
        OS.$out(NativePointer.$((String)"header_")).$out_uint((long)Node.getUID());
        return OS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OutputGraphFile() {
        raw_fd_ostream OS = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            std_errors.error_code EC = new std_errors.error_code();
            OS = new raw_fd_ostream(new StringRef(this.OutputFile), EC, fs.OpenFlags.F_Text);
            if (EC.$boolean()) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.PP.getDiagnostics().Report(409L))), (StringRef)new StringRef(this.OutputFile)), (StringRef)new StringRef((std.string)$c.track((Object)EC.message()))));
                return;
            }
            OS.$out(NativePointer.$((String)"digraph \"dependencies\" {\n"));
            long N = this.AllFiles.size();
            for (long I = 0L; I != N; ++I) {
                OS.indent(2L);
                this.writeNodeReference((raw_ostream)OS, (FileEntry)this.AllFiles.$at(I));
                OS.$out(NativePointer.$((String)" [ shape=\"box\", label=\""));
                StringRef FileName = new StringRef(((FileEntry)this.AllFiles.$at(I)).getName());
                if (FileName.startswith(this.SysRoot)) {
                    FileName.$assignMove(FileName.substr(this.SysRoot.size()));
                }
                $c.clean((Object)OS.$out((std.string)$c.track((Object)DOT.EscapeString((std.string)((std.string)$c.track((Object)FileName.$basic_string()))))).$out(NativePointer.$((String)"\"];\n")));
            }
            DenseMapIterator F = this.Dependencies.begin();
            DenseMapIterator FEnd = this.Dependencies.end();
            while (F.$noteq(FEnd)) {
                long N2 = ((SmallVector)((std.pair)F.$arrow().$star()).second).size();
                for (long I = 0L; I != N2; ++I) {
                    OS.indent(2L);
                    this.writeNodeReference((raw_ostream)OS, (FileEntry)((std.pair)F.$arrow().$star()).first);
                    OS.$out(NativePointer.$((String)" -> "));
                    this.writeNodeReference((raw_ostream)OS, (FileEntry)((SmallVector)((std.pair)F.$arrow().$star()).second).$at(I));
                    OS.$out(NativePointer.$((String)";\n"));
                }
                F.$preInc();
            }
            OS.$out(NativePointer.$((String)"}\n"));
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
            $c.$destroy();
        }
    }

    public DependencyGraphCallback(Preprocessor _PP, StringRef OutputFile2, StringRef SysRoot) {
        this.PP = _PP;
        this.OutputFile = OutputFile2.str();
        this.SysRoot = SysRoot.str();
        this.AllFiles = new SetVector((Object)new FileEntry());
        this.Dependencies = new DenseMap(FileEntry.DenseMapInfo, null);
    }

    public void InclusionDirective(SourceLocation HashLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File, StringRef SearchPath, StringRef RelativePath, Module Imported) {
        if (File == null) {
            return;
        }
        SourceManager SM = this.PP.getSourceManager();
        FileEntry FromFile = SM.getFileEntryForID(SM.getFileID(SM.getExpansionLoc(new SourceLocation(HashLoc))));
        if (FromFile == null) {
            return;
        }
        ((SmallVector)this.Dependencies.$at((Object)FromFile)).push_back((Object)File);
        this.AllFiles.insert((Object)File);
        this.AllFiles.insert((Object)FromFile);
    }

    public void EndOfMainFile() {
        this.OutputGraphFile();
    }

    public void $destroy() {
        this.Dependencies.$destroy();
        this.AllFiles.$destroy();
        this.SysRoot.$destroy();
        this.OutputFile.$destroy();
        super.$destroy();
    }

    public String toString() {
        return "PP=" + this.PP + ", OutputFile=" + this.OutputFile + ", SysRoot=" + this.SysRoot + ", AllFiles=" + this.AllFiles + ", Dependencies=" + this.Dependencies + super.toString();
    }
}

