/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.frontend.impl.TextDiagnosticStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImplInt;
import org.llvm.adt.aliases.SmallVectorInt;

public class SourceColumnMap
implements Destructors.ClassWithDestructor {
    private std.string m_SourceLine;
    private SmallVectorInt m_byteToColumn;
    private SmallVectorInt m_columnToByte;

    public SourceColumnMap(StringRef SourceLine, int TabStop) {
        this.m_SourceLine = new std.string(SourceLine.$basic_string());
        this.m_byteToColumn = new SmallVectorInt(200);
        this.m_columnToByte = new SmallVectorInt(200);
        TextDiagnosticStatics.byteToColumn(SourceLine, TabStop, (SmallVectorImplInt)this.m_byteToColumn);
        TextDiagnosticStatics.columnToByte(SourceLine, TabStop, (SmallVectorImplInt)this.m_columnToByte);
        assert (this.m_byteToColumn.size() == SourceLine.size() + 1);
        assert (0 < this.m_byteToColumn.size() && 0 < this.m_columnToByte.size());
        assert ((long)this.m_byteToColumn.size() == (long)(this.m_columnToByte.back() + 1));
        assert ((long)(this.m_byteToColumn.back() + 1) == (long)this.m_columnToByte.size());
    }

    public int columns() {
        return this.m_byteToColumn.back();
    }

    public int bytes() {
        return this.m_columnToByte.back();
    }

    public int byteToColumn(int n) {
        assert (0 <= n && n < this.m_byteToColumn.size());
        return this.m_byteToColumn.$at(n);
    }

    public int byteToContainingColumn(int N) {
        assert (0 <= N && N < this.m_byteToColumn.size()) : "" + N + " is out of range " + this.m_byteToColumn.size();
        while (this.m_byteToColumn.$at(N) == -1) {
            --N;
        }
        return this.m_byteToColumn.$at(N);
    }

    public int columnToByte(int n) {
        assert (0 <= n && n < this.m_columnToByte.size());
        return this.m_columnToByte.$at(n);
    }

    public int startOfNextColumn(int N) {
        assert (0 <= N && N < this.m_columnToByte.size() - 1);
        while (this.byteToColumn(++N) == -1) {
        }
        return N;
    }

    public int startOfPreviousColumn(int N) {
        assert (0 < N && N < this.m_columnToByte.size());
        while (this.byteToColumn(--N) == -1) {
        }
        return N;
    }

    public StringRef getSourceLine() {
        return new StringRef(this.m_SourceLine);
    }

    public void $destroy() {
    }

    public String toString() {
        return "SourceColumnMap{m_SourceLine=" + this.m_SourceLine + "\n, m_byteToColumn=" + this.m_byteToColumn + "\n, m_columnToByte=" + this.m_columnToByte + '}';
    }
}

