/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.util;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.dlight.sendto.api.OutputMode;
import org.netbeans.modules.dlight.sendto.config.ConfigureAction;
import org.netbeans.modules.dlight.sendto.util.CachedIOProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.IOColorLines;
import org.openide.windows.InputOutput;

public final class ScriptExecutor {
    private final ExecutionEnvironment env;
    private final ArrayList<String> argslist;
    private String stringToWrite;

    public ScriptExecutor(List<String> cmd) {
        this(null, cmd);
    }

    public ScriptExecutor(ExecutionEnvironment env, List<String> cmd) {
        this.argslist = new ArrayList<String>(cmd);
        this.env = env;
    }

    public ScriptExecutor writeToProcessOnRun(String string) {
        this.stringToWrite = string;
        return this;
    }

    private void outHeader(InputOutput io, String tabName) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss");
        String msg = formatter.format((Object)date) + " - " + tabName + "\r";
        try {
            if (IOColorLines.isSupported((InputOutput)io)) {
                IOColorLines.println((InputOutput)io, (CharSequence)msg, null, (boolean)true, (Color)Color.BLUE);
            } else {
                io.getOut().println(msg, null, true);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void execute(String name, OutputMode outputMode) {
        this.execute(name, outputMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String name, OutputMode outputMode, ExecutionDescriptor.LineConvertorFactory lineConvertorFactory) {
        if (this.argslist.isEmpty()) {
            return;
        }
        final AtomicReference<Process> procRef = new AtomicReference<Process>();
        AtomicReference<Throwable> xRef = new AtomicReference<Throwable>();
        final String tabName = NbBundle.getMessage(ScriptExecutor.class, (String)"OutputWindow.SendTo.name", (Object)name);
        final StopAction stopAction = new StopAction(tabName, procRef);
        final InputOutput io = CachedIOProvider.getIO(tabName, new Action[]{stopAction, ConfigureAction.getInstance()}, procRef, outputMode);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)tabName, (Cancellable)new Cancellable(){

            public boolean cancel() {
                stopAction.actionPerformed(null);
                return true;
            }
        }, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                io.select();
            }
        });
        try {
            progressHandle.start();
            PostExecution postExecution = new PostExecution(io, tabName, procRef, xRef);
            if (OutputMode.INTERNAL_TERMINAL == outputMode || this.env != null && !this.env.isLocal()) {
                String exec = this.argslist.get(0);
                String[] args = Arrays.copyOfRange(this.argslist.toArray(new String[0]), 1, this.argslist.size());
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
                npb.setExecutable(exec).setArguments(args);
                npb.addNativeProcessListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        Object src;
                        Object object = src = e == null ? null : e.getSource();
                        if (src instanceof Process && procRef.compareAndSet(null, (Process)src)) {
                            stopAction.setEnabled(true);
                        }
                    }
                });
                NativeExecutionDescriptor descr = new NativeExecutionDescriptor();
                descr = descr.frontWindow(true).controllable(true).noReset(true).inputOutput(io).inputVisible(true).postExecution((Runnable)postExecution);
                NativeExecutionService es = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)tabName);
                this.outHeader(io, tabName);
                es.run().get();
            } else {
                ProcessBuilder pb = new ProcessBuilder(this.argslist);
                Runnable preExecution = new Runnable(){

                    @Override
                    public void run() {
                        ScriptExecutor.this.outHeader(io, tabName);
                    }
                };
                ExecutionDescriptor descr = new ExecutionDescriptor();
                descr = descr.frontWindow(true).controllable(true).noReset(true).inputOutput(io).inputVisible(this.stringToWrite == null).preExecution(preExecution).postExecution((Runnable)postExecution).outConvertorFactory(lineConvertorFactory).errConvertorFactory(lineConvertorFactory);
                ExecutionService es = ExecutionService.newService((Callable)new ProcessCreator(pb, procRef, xRef, this.stringToWrite), (ExecutionDescriptor)descr, (String)name);
                es.run().get();
            }
        }
        catch (Throwable th) {
            xRef.set(th);
        }
        finally {
            stopAction.setEnabled(false);
            progressHandle.finish();
        }
    }

    private static class PostExecution
    implements Runnable {
        private final InputOutput io;
        private final AtomicReference<Process> procRef;
        private final AtomicReference<Throwable> xRef;
        private final String scriptName;

        private PostExecution(InputOutput io, String scriptName, AtomicReference<Process> procRef, AtomicReference<Throwable> xRef) {
            this.io = io;
            this.scriptName = scriptName;
            this.procRef = procRef;
            this.xRef = xRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Process p = this.procRef.get();
                this.io.getOut().println('\r');
                if (p != null) {
                    IOColorLines.println((InputOutput)this.io, (CharSequence)NbBundle.getMessage(ScriptExecutor.class, (String)"Execution.ExitStatus.text", (Object)p.waitFor()), (Color)Color.BLUE);
                } else {
                    if (this.xRef.get() != null) {
                        IOColorLines.println((InputOutput)this.io, (CharSequence)this.xRef.get().getLocalizedMessage(), (Color)Color.RED);
                    }
                    IOColorLines.println((InputOutput)this.io, (CharSequence)NbBundle.getMessage(ScriptExecutor.class, (String)"Execution.StartFailed.text", (Object)this.scriptName), (Color)Color.RED);
                }
                this.io.getOut().println('\r');
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.io.getOut().close();
            }
        }
    }

    private static class StopAction
    extends AbstractAction {
        private final AtomicReference<Process> procRef;

        private StopAction(String tabName, AtomicReference<Process> procRef) {
            super(NbBundle.getMessage(ScriptExecutor.class, (String)"Execution.StopAction.name", (Object)tabName), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dlight/sendto/resources/stop.png", (boolean)false));
            this.procRef = procRef;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Process proc = this.procRef.get();
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    private static class ProcessCreator
    implements Callable<Process> {
        private final ProcessBuilder pb;
        private final AtomicReference<Process> pref;
        private final AtomicReference<Throwable> xref;
        private final String selection;

        public ProcessCreator(ProcessBuilder pb, AtomicReference<Process> pref, AtomicReference<Throwable> xref, String selection) {
            this.pb = pb;
            this.pref = pref;
            this.xref = xref;
            this.selection = selection;
        }

        @Override
        public Process call() throws Exception {
            Process p = null;
            try {
                p = this.pb.start();
                if (this.selection != null) {
                    p.getOutputStream().write(this.selection.getBytes(Charset.forName("UTF-8")));
                    p.getOutputStream().close();
                }
            }
            catch (Exception ex) {
                this.xref.set(ex);
                throw ex;
            }
            this.pref.set(p);
            return p;
        }
    }
}

