/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.NbCatalogManager;
import org.apache.xml.resolver.helpers.Debug;
import org.apache.xml.resolver.tools.NbCatalogResolver;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.retriever.XMLCatalogProvider;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapperDOMImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelFactoryImpl;
import org.netbeans.modules.xml.retriever.impl.ResourceRetriever;
import org.netbeans.modules.xml.retriever.impl.ResourceRetrieverFactory;
import org.netbeans.modules.xml.retriever.impl.Util;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CatalogModelImpl
implements CatalogModel {
    private static Logger logger = Logger.getLogger(CatalogModelImpl.class.getName());
    protected FileObject catalogFileObject = null;
    NbCatalogResolver catalogResolver;
    Catalog apacheCatalogResolverObj;
    private boolean doFetch = true;
    private boolean fetchSynchronous = false;
    private boolean registerInCatalog = true;
    private static Map<URI, CatalogModelException> failedURIs = new HashMap<URI, CatalogModelException>();

    public CatalogModelImpl(Project myProject) throws IOException {
        assert (myProject != null);
        this.catalogFileObject = Util.getProjectCatalogFileObject(myProject, false);
    }

    public CatalogModelImpl(FileObject catalogFileObject) throws IOException {
        assert (catalogFileObject != null);
        this.catalogFileObject = catalogFileObject;
    }

    public CatalogModelImpl() {
    }

    public CatalogModelImpl(File tempFolder) throws IOException {
        tempFolder = FileUtil.normalizeFile((File)tempFolder);
        FileObject fo = FileUtil.toFileObject((File)tempFolder);
        String fileName = "catalog.xml";
        this.catalogFileObject = FileUtil.createData((FileObject)fo, (String)fileName);
    }

    private URI extractRealURI(URI locationURI) throws URISyntaxException {
        URI realURI = locationURI;
        String queryString = locationURI.getQuery();
        if (queryString != null && queryString.indexOf("fetch=") != -1 && queryString.indexOf("sync=") != -1) {
            int index = queryString.indexOf("fetch=");
            String temp = queryString.substring(index);
            String[] queries = temp.split("&");
            this.doFetch = Boolean.valueOf(queries[0].split("=")[1]);
            this.fetchSynchronous = Boolean.valueOf(queries[1].split("=")[1]);
            realURI = new URI(locationURI.toString().substring(0, locationURI.toString().lastIndexOf("fetch=") - 1));
            this.registerInCatalog = false;
        }
        return realURI;
    }

    public synchronized ModelSource getModelSource(URI locationURI, ModelSource modelSourceOfSourceDocument) throws CatalogModelException {
        ModelSource ms = null;
        try {
            this.checkFailedURI(locationURI);
            ms = this.doGetModelSource(this.extractRealURI(locationURI), modelSourceOfSourceDocument);
        }
        catch (URISyntaxException ex) {
            CatalogModelException e = new CatalogModelException((Throwable)ex);
            CatalogModelImpl.addFailedURI(locationURI, e);
            throw e;
        }
        catch (CatalogModelException ex) {
            CatalogModelImpl.addFailedURI(locationURI, ex);
            throw ex;
        }
        finally {
            this.resetFlags();
        }
        return ms;
    }

    private static void addFailedURI(URI locationURI, CatalogModelException t) {
        failedURIs.put(locationURI, t);
    }

    private void resetFlags() {
        this.doFetch = true;
        this.fetchSynchronous = false;
        this.registerInCatalog = true;
    }

    private synchronized ModelSource doGetModelSource(URI locationURI, ModelSource modelSourceOfSourceDocument) throws CatalogModelException {
        logger.entering("CatalogModelImpl", "getModelSource", locationURI);
        Throwable exn = null;
        this.useSuitableCatalogFile(modelSourceOfSourceDocument);
        if (this.isOrphan() && this.isLocalFile(locationURI)) {
            return this.tryOrphanResolution(locationURI, modelSourceOfSourceDocument);
        }
        File absResourceFile = null;
        FileObject fob = null;
        if (modelSourceOfSourceDocument != null) {
            fob = (FileObject)modelSourceOfSourceDocument.getLookup().lookup(FileObject.class);
        }
        try {
            absResourceFile = this.resolveUsingCatalog(locationURI, fob);
        }
        catch (IOException ex) {
            exn = ex;
        }
        catch (CatalogModelException ex) {
            exn = ex;
        }
        if (absResourceFile == null || exn != null) {
            ModelSource rms = this.getModelSourceFromSystemWideCatalog(locationURI, modelSourceOfSourceDocument);
            if (rms != null) {
                return rms;
            }
            try {
                if (this.doFetch) {
                    absResourceFile = this.retrieveCacheAndLookup(locationURI, fob);
                }
            }
            catch (IOException ex) {
                throw new CatalogModelException((Throwable)ex);
            }
        }
        ModelSource result = null;
        if (absResourceFile != null) {
            logger.finer("Found  abs file res:" + absResourceFile);
            File normalizedFile = FileUtil.normalizeFile((File)absResourceFile);
            FileObject thisFileObj = FileUtil.toFileObject((File)normalizedFile);
            boolean editable = this.isEditable(absResourceFile);
            result = this.createModelSource(thisFileObj, editable);
        }
        if (result == null) {
            String strURI = locationURI.toASCIIString();
            result = this.getModelSource(strURI);
        }
        if (result == null && exn != null) {
            throw new CatalogModelException(exn);
        }
        logger.exiting("CatalogModelImpl", "getModelSource", result);
        return result;
    }

    private ModelSource getModelSource(String strURL) {
        try {
            ResourceRetriever urlRetriever = ResourceRetrieverFactory.getResourceRetriever(null, strURL);
            if (urlRetriever == null) {
                return null;
            }
            HashMap<String, InputStream> mapInputSources = urlRetriever.retrieveDocument(null, strURL);
            InputStream inputStream = null;
            for (Map.Entry entry : mapInputSources.entrySet()) {
                if (!strURL.equals(entry.getKey()) || entry.getValue() == null) continue;
                inputStream = (InputStream)entry.getValue();
                break;
            }
            if (inputStream != null) {
                ModelSource modelSource = this.createModelSource(inputStream);
                return modelSource;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
        }
        return null;
    }

    private ModelSource createModelSource(InputStream inputStream) throws CatalogModelException {
        try {
            Document doc = AbstractDocumentModel.getAccessProvider().loadSwingDocument(inputStream);
            if (doc != null) {
                ModelSource modelSource = new ModelSource(Lookups.fixed((Object[])new Object[]{this, doc}), false);
                return modelSource;
            }
        }
        catch (Exception ex) {
            throw new CatalogModelException((Throwable)ex);
        }
        return null;
    }

    private void useSuitableCatalogFile(ModelSource modelSourceOfSourceDocument) {
        if (modelSourceOfSourceDocument != null) {
            FileObject catFO;
            FileObject msfo = (FileObject)modelSourceOfSourceDocument.getLookup().lookup(FileObject.class);
            if (msfo == null) {
                return;
            }
            Project prj = FileOwnerQuery.getOwner((FileObject)msfo);
            if (prj == null) {
                return;
            }
            XMLCatalogProvider catPovider = (XMLCatalogProvider)prj.getLookup().lookup(XMLCatalogProvider.class);
            if (catPovider == null) {
                return;
            }
            URI caturi = catPovider.getCatalog(msfo);
            if (caturi == null) {
                return;
            }
            URI prjuri = FileUtil.toFile((FileObject)prj.getProjectDirectory()).toURI();
            URI catFileURI = prjuri.resolve(caturi);
            if (catFileURI == null) {
                return;
            }
            File catFile = new File(catFileURI);
            if (!catFile.isFile()) {
                try {
                    catFile.createNewFile();
                }
                catch (IOException ex) {
                    return;
                }
            }
            if ((catFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)catFile))) == null) {
                return;
            }
            this.catalogFileObject = catFO;
        }
    }

    public ModelSource getModelSource(URI locationURI) throws CatalogModelException {
        if (this.isOrphan()) {
            return this.tryOrphanResolution(locationURI, null);
        }
        return this.getModelSource(locationURI, null);
    }

    private Document getDocument(FileObject modelSourceFileObject) throws CatalogModelException {
        StyledDocument result = null;
        try {
            DataObject dObject = DataObject.find((FileObject)modelSourceFileObject);
            EditorCookie ec = (EditorCookie)dObject.getCookie(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            assert (doc instanceof BaseDocument);
            result = doc;
        }
        catch (Exception dObjEx) {
            throw new CatalogModelException((Throwable)dObjEx);
        }
        return result;
    }

    protected ModelSource createModelSource(FileObject thisFileObj, boolean editable) throws CatalogModelException {
        ModelSource ms = Utilities.getModelSource(thisFileObj, editable);
        return ms;
    }

    protected CatalogModel createCatalogModel(FileObject fo) throws CatalogModelException {
        return new CatalogModelFactoryImpl().getCatalogModel(fo);
    }

    private ModelSource tryOrphanResolution(URI locationURI, ModelSource modelSource) {
        logger.entering("CatalogModelImpl", "getModelSource", locationURI);
        if (this.catalogFileObject == null) {
            try {
                FileObject fo;
                File file;
                if (locationURI.isAbsolute()) {
                    File file2 = new File(locationURI);
                    if (file2.isFile()) {
                        file2 = FileUtil.normalizeFile((File)file2);
                        FileObject fo2 = FileUtil.toFileObject((File)file2);
                        return this.createModelSource(fo2, this.isEditable(file2));
                    }
                } else if (modelSource != null && (file = this.resolveRelativeURI(locationURI, fo = (FileObject)modelSource.getLookup().lookup(FileObject.class))) != null) {
                    file = FileUtil.normalizeFile((File)file);
                    FileObject fobj = FileUtil.toFileObject((File)file);
                    return this.createModelSource(fobj, this.isEditable(file));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private boolean isOrphan() {
        return this.catalogFileObject == null;
    }

    private boolean isLocalFile(URI locationURI) {
        return locationURI.isAbsolute() && locationURI.getScheme() != null && "file".equals(locationURI.getScheme());
    }

    private void checkFailedURI(URI locationURI) throws CatalogModelException {
        CatalogModelException t = failedURIs.get(locationURI);
        if (t != null) {
            throw t;
        }
    }

    protected File resolveUsingCatalog(URI locationURI, FileObject sourceFileObject) throws CatalogModelException, IOException {
        logger.entering("CatalogModelImpl", "resolveUsingCatalog", locationURI);
        if (locationURI == null) {
            return null;
        }
        File result = null;
        result = this.resolveUsingPublicCatalog(locationURI);
        if (result != null) {
            return result;
        }
        result = this.resolveUsingPrivateCatalog(locationURI, sourceFileObject);
        if (result != null) {
            return result;
        }
        if (sourceFileObject != null) {
            result = this.resolveRelativeURI(locationURI, sourceFileObject);
        }
        if (result != null) {
            return result;
        }
        if (locationURI.isAbsolute() && locationURI.getScheme().equalsIgnoreCase("file")) {
            result = new File(locationURI);
            if (result.isFile()) {
                logger.exiting("CatalogModelImpl", "resolveUsingCatalog", result);
                return result;
            }
            throw new FileNotFoundException(locationURI.toString() + ": is absolute but " + result.getAbsolutePath() + " Not Found.");
        }
        throw new CatalogModelException(locationURI.toString() + " : Entry is not a relative or absolute and catalog entry not found");
    }

    private File retrieveCacheAndLookup(URI locationURI, FileObject sourceFileObject) throws IOException, CatalogModelException {
        File result = null;
        if (locationURI.isAbsolute() && locationURI.getScheme().toLowerCase().startsWith("http") && !CatalogFileWrapperDOMImpl.TEST_ENVIRONMENT) {
            boolean res = false;
            try {
                res = Util.retrieveAndCache(locationURI, sourceFileObject, !this.fetchSynchronous, this.registerInCatalog);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (res && (result = this.resolveUsingPublicCatalog(locationURI)) != null) {
                return result;
            }
        }
        return result;
    }

    private File resolveUsingPrivateCatalog(URI locationURI, FileObject sourceFileObject) throws IOException, CatalogModelException {
        FileObject catalogFile = null;
        File resource = null;
        if (sourceFileObject != null && (catalogFile = Util.findCacheCatalog(sourceFileObject)) != null) {
            resource = this.resolveUsingCatalog(catalogFile, locationURI);
        }
        if (resource == null && (catalogFile = Util.findSystemCatalog()) != null) {
            resource = this.resolveUsingCatalog(catalogFile, locationURI);
        }
        return resource;
    }

    private File resolveUsingCatalog(FileObject catalogFile, URI locationURI) throws IOException, CatalogModelException {
        File result = null;
        File publicCatalogFile = FileUtil.toFile((FileObject)catalogFile);
        if (publicCatalogFile.isFile()) {
            if (publicCatalogFile.length() < 20L) {
                return null;
            }
            URI strRes = this.resolveUsingApacheCatalog(publicCatalogFile, locationURI.toString());
            if (strRes != null && strRes.isAbsolute()) {
                if (strRes.getScheme().equalsIgnoreCase("file")) {
                    result = new File(strRes);
                    if (result.isFile()) {
                        logger.exiting("CatalogModelImpl", "resolveUsingCatalog", result);
                        return result;
                    }
                    throw new FileNotFoundException(result.getAbsolutePath() + " Not Found.");
                }
                File res = this.resolveProjectProtocol(strRes);
                if (res != null) {
                    return res;
                }
                throw new CatalogModelException("Catalog contains non-file URI. Catalog Maps URI to a local file only.");
            }
        }
        return null;
    }

    protected File resolveUsingPublicCatalog(URI locationURI) throws IOException, CatalogModelException {
        File publicCatalogFile;
        File result = null;
        if (this.catalogFileObject != null && (publicCatalogFile = FileUtil.toFile((FileObject)this.catalogFileObject)).isFile()) {
            if (publicCatalogFile.length() < 20L) {
                return null;
            }
            URI strRes = this.resolveUsingApacheCatalog(publicCatalogFile, locationURI.toString());
            if (strRes != null && strRes.isAbsolute()) {
                if (strRes.getScheme().equalsIgnoreCase("file")) {
                    result = new File(strRes);
                    if (result.isFile()) {
                        logger.exiting("CatalogModelImpl", "resolveUsingCatalog", result);
                        return result;
                    }
                    throw new FileNotFoundException(result.getAbsolutePath() + " Not Found.");
                }
                File res = this.resolveProjectProtocol(strRes);
                if (res != null) {
                    return res;
                }
                throw new CatalogModelException("Catalog contains non-file URI. Catalog Maps URI to a local file only.");
            }
        }
        return null;
    }

    protected File resolveRelativeURI(URI locationURI, FileObject sourceFileObject) throws CatalogModelException, FileNotFoundException {
        File result = null;
        if (!locationURI.isAbsolute()) {
            if (sourceFileObject == null) {
                throw new CatalogModelException(locationURI.toString() + " : Entry is relative but base file now known. Pass base file to the factory");
            }
            File sourceFile = FileUtil.toFile((FileObject)sourceFileObject);
            if (sourceFile != null) {
                URI sourceFileObjectURI = sourceFile.toURI();
                URI resultURI = sourceFileObjectURI.resolve(locationURI);
                try {
                    result = new File(resultURI);
                }
                catch (Exception e) {
                    throw new CatalogModelException(locationURI.toString() + " : Entry is relative but resolved entry is not absolute");
                }
                if (result.isFile()) {
                    logger.exiting("CatalogModelImpl", "resolveUsingCatalog", result);
                    return result;
                }
                throw new FileNotFoundException(result.getAbsolutePath() + " Not Found.");
            }
        }
        return null;
    }

    protected URI resolveUsingApacheCatalog(File catalogFile, String locationURI) throws IOException, CatalogModelException {
        ArrayList<File> catalogFileList = new ArrayList<File>();
        catalogFileList.add(catalogFile);
        return this.resolveUsingApacheCatalog(catalogFileList, locationURI);
    }

    protected URI resolveUsingApacheCatalog(List<File> catalogFileList, String locationURI) throws CatalogModelException, IOException {
        if (logger.getLevel() != null && logger.getLevel().intValue() <= Level.FINER.intValue()) {
            Debug debug = NbCatalogManager.getStaticManager().debug;
            debug.setDebug(logger.getLevel().intValue());
        }
        NbCatalogManager manager = new NbCatalogManager(null);
        manager.setUseStaticCatalog(false);
        manager.setPreferPublic(false);
        this.catalogResolver = new NbCatalogResolver(manager);
        this.apacheCatalogResolverObj = this.catalogResolver.getCatalog();
        for (File catFile : catalogFileList) {
            this.apacheCatalogResolverObj.parseCatalog(catFile.toURL());
        }
        String result = null;
        try {
            result = this.apacheCatalogResolverObj.resolveSystem(locationURI);
        }
        catch (Exception ex) {
            result = "";
        }
        if (result == null) {
            result = "";
        } else {
            try {
                result = Utilities.normalizeURI(result);
                URI uri = new URI(result);
                if (uri.isOpaque() && uri.getScheme().equalsIgnoreCase("file")) {
                    StringBuffer resBuff = new StringBuffer(result);
                    result = resBuff.insert("file:".length(), "/").toString();
                }
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        if (result.length() > 0) {
            try {
                URI res = new URI(result);
                return res;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
        return null;
    }

    boolean isEditable(File absResourceFile) {
        return true;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        try {
            return this.getInputSource(new URI(systemId));
        }
        catch (CatalogModelException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (URISyntaxException e) {
            throw new IOException("SystemID not a URL");
        }
    }

    private InputSource getInputSource(URI locationURI) throws CatalogModelException, IOException {
        logger.entering("CatalogModelImpl", "getInputSource", locationURI);
        File absResourceFile = this.resolveUsingCatalog(locationURI, null);
        logger.finer("Found  abs file res:" + absResourceFile);
        InputSource result = new InputSource(new FileInputStream(absResourceFile));
        result.setSystemId(locationURI.toString());
        logger.exiting("CatalogModelImpl", "getInputSource", result);
        return result;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURIStr) {
        if (systemId == null || systemId.trim().length() <= 0) {
            return null;
        }
        URI systemIdURI = null;
        try {
            systemIdURI = new URI(systemId);
        }
        catch (URISyntaxException ex) {
            return null;
        }
        FileObject baseFO = null;
        CatalogModel depRez = null;
        try {
            baseFO = this.getFileObject(baseURIStr);
            depRez = this.getResolver(baseFO);
        }
        catch (CatalogModelException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        if (depRez == null) {
            return null;
        }
        ModelSource baseMS = null;
        if (baseFO != null) {
            try {
                baseMS = this.createModelSource(baseFO, false);
            }
            catch (CatalogModelException ex) {
                // empty catch block
            }
        }
        ModelSource resultMS = null;
        try {
            resultMS = depRez.getModelSource(systemIdURI, baseMS);
        }
        catch (CatalogModelException ex) {
            return null;
        }
        if (resultMS == null) {
            return null;
        }
        FileObject resultFob = (FileObject)resultMS.getLookup().lookup(FileObject.class);
        if (resultFob == null) {
            return null;
        }
        File resultFile = FileUtil.toFile((FileObject)resultFob);
        if (resultFile == null) {
            return null;
        }
        URI resultURI = resultFile.toURI();
        DOMImplementation domImpl = null;
        try {
            domImpl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
        DOMImplementationLS dols = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
        LSInput lsi = dols.createLSInput();
        Reader is = this.getFileStreamFromDocument(resultFile);
        if (is != null) {
            lsi.setCharacterStream(is);
        }
        lsi.setSystemId(resultURI.toString());
        return lsi;
    }

    private FileObject getFileObject(String baseURIStr) throws IOException {
        if (baseURIStr == null) {
            return null;
        }
        URI baseURI = null;
        try {
            baseURI = new URI(baseURIStr);
        }
        catch (URISyntaxException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
        if (baseURI.isAbsolute() && baseURI.getScheme().equalsIgnoreCase("file")) {
            File baseFile = null;
            try {
                baseFile = new File(baseURI);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            baseFile = FileUtil.normalizeFile((File)baseFile);
            FileObject baseFileObject = null;
            try {
                baseFileObject = FileUtil.toFileObject((File)baseFile);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            return baseFileObject;
        }
        return null;
    }

    private CatalogModel getResolver(FileObject baseFileObject) throws CatalogModelException {
        if (baseFileObject != null && FileOwnerQuery.getOwner((FileObject)baseFileObject) != null) {
            return CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(baseFileObject);
        }
        return this;
    }

    private Reader getFileStreamFromDocument(File resultFile) {
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)resultFile));
        if (fo != null) {
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                return null;
            }
            if (dobj.isValid() && dobj.isModified()) {
                return DataObjectAdapters.inputSource((DataObject)dobj).getCharacterStream();
            }
            return null;
        }
        return null;
    }

    protected File resolveProjectProtocol(URI strRes) {
        FileObject resFO;
        ProjectCatalogSupport pcs;
        File result = null;
        Project prj = FileOwnerQuery.getOwner((FileObject)this.catalogFileObject);
        if (prj != null && (pcs = (ProjectCatalogSupport)prj.getLookup().lookup(ProjectCatalogSupport.class)).isProjectProtocol(strRes) && (resFO = pcs.resolveProjectProtocol(strRes)) != null) {
            return FileUtil.toFile((FileObject)resFO);
        }
        return result;
    }

    private ModelSource getModelSourceFromSystemWideCatalog(URI locationURI, ModelSource modelSourceOfSourceDocument) {
        if (locationURI == null) {
            return null;
        }
        try {
            Lookup.Template templ = new Lookup.Template(CatalogModel.class);
            Lookup.Result res = Lookup.getDefault().lookup(templ);
            Collection impls = res.allInstances();
            Iterator i$ = impls.iterator();
            if (i$.hasNext()) {
                Object obj = i$.next();
                CatalogModel cm = (CatalogModel)obj;
                return cm.getModelSource(locationURI, modelSourceOfSourceDocument);
            }
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
        return null;
    }
}

