/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.apigen.annotations.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

class SeeLineParser
implements AnnotationLineParser {
    static String ANNOTATION_NAME = "see";
    private static final String HTTP_PREFIX = "http://";
    private static final String DELIMITER = " ";
    private static final char SCOPE_OPERATOR_PART = ':';
    private String line;
    private String[] tokens;

    SeeLineParser() {
    }

    public AnnotationParsedLine parse(String line) {
        this.line = line;
        AnnotationParsedLine result = null;
        this.tokens = line.split("[ \t]+");
        if (this.tokens.length > 0 && ANNOTATION_NAME.equals(this.tokens[0])) {
            result = this.handleAnnotation();
        }
        return result;
    }

    private AnnotationParsedLine handleAnnotation() {
        String description = "";
        Map<Object, Object> types = new HashMap();
        if (this.tokens.length > 1) {
            description = this.createDescription();
            types = this.fetchTypes(description);
        }
        return new AnnotationParsedLine.ParsedLine(ANNOTATION_NAME, types, description, true);
    }

    private String createDescription() {
        LinkedList<String> descriptionTokens = new LinkedList<String>();
        for (int i = 1; i < this.tokens.length; ++i) {
            descriptionTokens.add(this.tokens[i]);
        }
        return StringUtils.implode(descriptionTokens, (String)DELIMITER);
    }

    private Map<OffsetRange, String> fetchTypes(String description) {
        HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
        if (!description.startsWith(HTTP_PREFIX)) {
            int start = ANNOTATION_NAME.length() + SeeLineParser.countSpacesToFirstNonWhitespace(this.line.substring(ANNOTATION_NAME.length()));
            int end = start + SeeLineParser.countTypeLength(description);
            types.put(new OffsetRange(start, end), this.line.substring(start, end));
        }
        return types;
    }

    private static int countSpacesToFirstNonWhitespace(String line) {
        int result = 0;
        for (int i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
            ++result;
        }
        return result;
    }

    private static int countTypeLength(String line) {
        char ch;
        int result = 0;
        for (int i = 0; i < line.length() && !Character.isWhitespace(ch = line.charAt(i)) && ch != ':'; ++i) {
            ++result;
        }
        return result;
    }
}

