/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.apigen.annotations.parser;

import java.util.HashMap;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

class ThrowsLineParser
implements AnnotationLineParser {
    static final String ANNOTATION_NAME = "throws";
    private String line;
    private String[] tokens;

    ThrowsLineParser() {
    }

    public AnnotationParsedLine parse(String line) {
        this.line = line;
        AnnotationParsedLine result = null;
        this.tokens = line.split("[ \t]+");
        if (this.tokens.length > 0 && ANNOTATION_NAME.equals(this.tokens[0])) {
            result = this.handleAnnotation();
        }
        return result;
    }

    private AnnotationParsedLine handleAnnotation() {
        String description = "";
        HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
        if (this.tokens.length > 1) {
            description = this.tokens[1];
            int start = ANNOTATION_NAME.length() + ThrowsLineParser.countSpacesToFirstNonWhitespace(this.line.substring(ANNOTATION_NAME.length()));
            int end = start + description.length();
            types.put(new OffsetRange(start, end), this.line.substring(start, end));
        }
        return new AnnotationParsedLine.ParsedLine(ANNOTATION_NAME, types, description, true);
    }

    private static int countSpacesToFirstNonWhitespace(String line) {
        int result = 0;
        for (int i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
            ++result;
        }
        return result;
    }
}

