/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.option.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.aliases.StringMapConstIteratorChar;
import org.llvm.adt.aliases.StringMapIteratorChar;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.option.Option;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public final class OptTableStatics {
    public static boolean isInput(StringSet Prefixes, StringRef Arg2) {
        if (llvm.$eq_StringRef((StringRef)Arg2, (StringRef)StringRef.MINUS)) {
            return true;
        }
        StringMapIteratorChar I = (StringMapIteratorChar)Native.$tryClone((NativeCloneable)Prefixes.begin());
        StringMapIteratorChar E = (StringMapIteratorChar)Native.$tryClone((NativeCloneable)Prefixes.end());
        while (I.$noteq((StringMapConstIteratorChar)E)) {
            if (Arg2.startswith(I.$arrow().getKey())) {
                return false;
            }
            I.$preInc();
        }
        return true;
    }

    public static long matchOption(type.ptr<OptTable.Info> I, StringRef Str, boolean IgnoreCase) {
        type.ptr Pre = (type.ptr)Native.$tryClone(((OptTable.Info)I.$star()).Prefixes);
        while (Pre.$star() != null) {
            StringRef Prefix = new StringRef((char.ptr)Pre.$star());
            if (Str.startswith(Prefix)) {
                boolean Matched;
                StringRef Rest = Str.substr(Prefix.size());
                boolean bl = Matched = IgnoreCase ? Rest.startswith_lower(new StringRef(((OptTable.Info)I.$star()).Name)) : Rest.startswith(((OptTable.Info)I.$star()).Name);
                if (Matched) {
                    return Prefix.size() + std.strlen((char.ptr)((OptTable.Info)I.$star()).Name);
                }
            }
            Pre.$preInc();
        }
        return 0L;
    }

    public static std.string getOptionHelpName(OptTable Opts, OptSpecifier Id) {
        Option O = Opts.getOption(Id);
        std.string Name = O.getPrefixedName();
        switch (O.getKind()) {
            case GroupClass: 
            case InputClass: 
            case UnknownClass: {
                throw new llvm_unreachable((CharSequence)"Invalid option with help text.");
            }
            case MultiArgClass: {
                throw new llvm_unreachable((CharSequence)"Cannot print metavar for this kind of option.");
            }
            case FlagClass: {
                break;
            }
            case SeparateClass: 
            case JoinedOrSeparateClass: 
            case RemainingArgsClass: {
                Name.$addassign(' ');
            }
            case JoinedClass: 
            case CommaJoinedClass: 
            case JoinedAndSeparateClass: {
                char.ptr MetaVarName = Native.$tryClone((char.ptr)Opts.getOptionMetaVar(Id));
                if (MetaVarName != null) {
                    Name.$addassign(NativePointer.$((char)' '));
                    Name.$addassign(MetaVarName);
                    break;
                }
                long e = O.getNumArgs();
                for (long i = 0L; i < e; ++i) {
                    Name.$addassign(NativePointer.$((String)" <value>"));
                }
                break;
            }
        }
        return Name;
    }

    public static void PrintHelpOptionList(raw_ostream OS, StringRef Title, std.vector<std.pair<std.string, char.ptr>> OptionHelp) {
        OS.$out(Title).$out((CharSequence)":\n");
        long OptionFieldWidth = 0L;
        long e = OptionHelp.size();
        for (long i = 0L; i != e; ++i) {
            long Length;
            if (((std.pair)OptionHelp.$at((long)i)).second == null || (Length = (long)((std.string)((std.pair)OptionHelp.$at((long)i)).first).size()) > 23L) continue;
            OptionFieldWidth = std.max((long)OptionFieldWidth, (long)Length);
        }
        long InitialPad = 2L;
        long e2 = OptionHelp.size();
        for (long i = 0L; i != e2; ++i) {
            std.string Option2 = (std.string)((std.pair)OptionHelp.$at((long)i)).first;
            long Pad = OptionFieldWidth - (long)Option2.size();
            OS.indent(InitialPad).$out(Option2);
            if (Pad < 0L) {
                OS.$out((CharSequence)"\n");
                Pad = OptionFieldWidth + InitialPad;
            }
            OS.indent(Pad + 1L).$out((char.ptr)((std.pair)OptionHelp.$at((long)i)).second).$out('\n');
        }
    }

    public static char.ptr getOptionHelpGroup(OptTable Opts, OptSpecifier Id) {
        long GroupID = Opts.getOptionGroupID(Id);
        if (GroupID == 0L) {
            return NativePointer.$((String)"OPTIONS");
        }
        char.ptr GroupHelp = Native.$tryClone((char.ptr)Opts.getOptionHelpText(new OptSpecifier(GroupID)));
        if (GroupHelp != null) {
            return GroupHelp;
        }
        return OptTableStatics.getOptionHelpGroup(Opts, new OptSpecifier(GroupID));
    }
}

