/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class StartServer
extends Task
implements Deployment.Logger {
    private static final long DEFAULT_TIMEOUT = 300000L;
    private boolean debugmode = false;
    private boolean profilemode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader originalLoader = null;
        try {
            ClassLoader current = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (current == null) {
                current = ClassLoader.getSystemClassLoader();
            }
            if (current != null) {
                originalLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(current);
            }
            J2eeModuleProvider jmp = null;
            try {
                FileObject fob = FileUtil.toFileObject((File)this.getProject().getBaseDir());
                fob.refresh();
                jmp = (J2eeModuleProvider)FileOwnerQuery.getOwner((FileObject)fob).getLookup().lookup(J2eeModuleProvider.class);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            ServerInstance si = ServerRegistry.getInstance().getServerInstance(jmp.getServerInstanceID());
            String title = NbBundle.getMessage((Class)ServerInstance.class, (String)"LBL_StartServerProgressMonitor", (Object)si.getDisplayName());
            ProgressUI ui = new ProgressUI(title, false, (Deployment.Logger)this);
            ui.start();
            ServerDebugInfo sdi = null;
            try {
                if (this.debugmode) {
                    si.startDebug(ui);
                } else if (this.profilemode) {
                    si.startProfile(false, ui);
                    long start = System.nanoTime();
                    while (!si.isReallyRunning() && 300000L > (System.nanoTime() - start) / 1000000L) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                } else {
                    si.start(ui);
                }
                sdi = jmp.getServerDebugInfo();
                if (sdi != null) {
                    String h = sdi.getHost();
                    String transport = sdi.getTransport();
                    String address = "";
                    address = transport.equals("dt_shmem") ? sdi.getShmemName() : Integer.toString(sdi.getPort());
                    this.getProject().setProperty("name", jmp.getDeploymentName());
                    this.getProject().setProperty("jpda.transport", transport);
                    this.getProject().setProperty("jpda.host", h);
                    this.getProject().setProperty("jpda.address", address);
                }
            }
            catch (ServerException ex) {
                if (null != ex.getCause()) {
                    throw new BuildException(ex.getMessage(), (Throwable)ex);
                }
                throw new BuildException(ex.getMessage());
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
            finally {
                ui.finish();
            }
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
        catch (Throwable throwable) {
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
            throw throwable;
        }
    }

    public boolean getDebugmode() {
        return this.debugmode;
    }

    public boolean getProfilemode() {
        return this.profilemode;
    }

    public void setDebugmode(boolean debugmode) {
        this.debugmode = debugmode;
    }

    public void setProfilemode(boolean profilemode) {
        this.profilemode = profilemode;
    }
}

