/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.prep.editor.CPCssIndexModel;
import org.netbeans.modules.css.prep.editor.model.CPElementHandle;
import org.netbeans.modules.css.prep.editor.model.CPElementType;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.DependencyType;
import org.openide.filesystems.FileObject;

public class CPUtils {
    public static String SCSS_FILE_EXTENSION = "scss";
    public static String SASS_FILE_EXTENSION = "sass";
    public static String LESS_FILE_EXTENSION = "less";
    public static String SCSS_FILE_MIMETYPE = "text/scss";
    public static String LESS_FILE_MIMETYPE = "text/less";

    public static boolean isCPFile(FileObject file) {
        String mt = file.getMIMEType();
        return SCSS_FILE_MIMETYPE.equals(mt) || LESS_FILE_MIMETYPE.equals(mt);
    }

    public static Map<FileObject, CPCssIndexModel> getIndexModels(FileObject file, DependencyType dependencyType, boolean excludeTheBaseFile) throws IOException {
        LinkedHashMap<FileObject, CPCssIndexModel> models = new LinkedHashMap<FileObject, CPCssIndexModel>();
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project != null) {
            CssIndex index = CssIndex.get((Project)project);
            DependenciesGraph dependencies = index.getDependencies(file);
            Collection referred = dependencies.getFiles(dependencyType);
            for (FileObject reff : referred) {
                CPCssIndexModel cpIndexModel;
                if (excludeTheBaseFile && reff.equals(file) || file.isSymbolicLink() && reff.getPath().equals(file.readSymbolicLinkPath()) || (cpIndexModel = (CPCssIndexModel)index.getIndexModel(CPCssIndexModel.Factory.class, reff)) == null) continue;
                models.put(reff, cpIndexModel);
            }
        }
        return models;
    }

    public static Collection<CPElementHandle> filter(Collection<CPElementHandle> handles, CPElementType ... types) {
        EnumSet<CPElementType> typesSet = EnumSet.copyOf(Arrays.asList(types));
        ArrayList<CPElementHandle> filtered = new ArrayList<CPElementHandle>();
        for (CPElementHandle handle : handles) {
            if (!typesSet.contains((Object)handle.getType())) continue;
            filtered.add(handle);
        }
        return filtered;
    }
}

