package org.clank.support.aliases;

import org.clank.support.Converted;
import org.clank.support.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.NativeMemory.*;
import static org.clank.support.NativePointer.*;


/**
 * Pointer to ${TYPE}
 */
//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/support/aliases/templates/pointer.tpl")
//</editor-fold>
public interface ${FILE_NAME}${CLASS_SUFFIX} extends abstract_pointer<${FILE_NAME}${CLASS_SUFFIX}>, ${ITERATOR} {
    /**
      * Accessors for performance critical paths
      */
    int $index();
    ${TYPE}[] $array();

    /**
     * Gets value from pointer ('*x' in C++)
     * 
     * @return value
     */
    ${TYPE} $star();

    /**
     * Gets reference from pointer ('*x' passed to '&T')
     * 
     * @return reference to memory
     */
    ${REFERENCE} star$ref();
    
    /**
     * Replaces value in pointer ('*x = value' in C++)
     * 
     * @param value - new value
     * @return value
     */
    ${TYPE} $set(${TYPE} value);

    /**
     * Gets value from pointer at the given index ('x[10]' in C++)
     * 
     * @return value
     */        
    ${TYPE} $at(int index);
    ${TYPE} $at(long index);
    
    /**
     * Replaces value in pointer at the given index ('x[10] = value' in C++)
     * 
     * @param value - new value
     * @return value
     */
    ${TYPE} $set(int index, ${TYPE} value);
    ${TYPE} $set(long index, ${TYPE} value);

    /**
     * modify value at the given index (i.e. 'x[10] += value' in C++)
     * 
     * @param value - value
     * @return value
     */${BUILTIN_TYPE_MODIFY_VALUE_SECTION_START}
    ${TYPE} $set$andassign(int index, ${TYPE} value); // "&="
    ${TYPE} $set$andassign(long index, ${TYPE} value); // "&="
    ${TYPE} $set$xorassign(int index, ${TYPE} value); // "^="
    ${TYPE} $set$xorassign(long index, ${TYPE} value); // "^="
    ${TYPE} $set$orassign(int index, ${TYPE} value); // "|=" 
    ${TYPE} $set$orassign(long index, ${TYPE} value); // "|=" 
    ${BUILTIN_TYPE_MODIFY_VALUE_SECTION_END}${ADDITIONAL_MODIFY_VALUE_SECTION_START}
    ${TYPE} $set$addassign(int index, ${TYPE} value); // "+=" 
    ${TYPE} $set$addassign(long index, ${TYPE} value); // "+=" 
    ${TYPE} $set$minusassign(int index, ${TYPE} value); // "-="
    ${TYPE} $set$minusassign(long index, ${TYPE} value); // "-="
    ${TYPE} $set$starassign(int index, ${TYPE} value); // "*="    
    ${TYPE} $set$starassign(long index, ${TYPE} value); // "*="    
    ${TYPE} $set$slashassign(int index, ${TYPE} value); // "/="
    ${TYPE} $set$slashassign(long index, ${TYPE} value); // "/="
    ${TYPE} $set$modassign(int index, ${TYPE} value); // "%=" 
    ${TYPE} $set$modassign(long index, ${TYPE} value); // "%=" 
    ${TYPE} $set$lshiftassign(int index, ${TYPE} value); // "<<="
    ${TYPE} $set$lshiftassign(long index, ${TYPE} value); // "<<="
    ${TYPE} $set$rshiftassign(int index, ${TYPE} value); // ">>="
    ${TYPE} $set$rshiftassign(long index, ${TYPE} value); // ">>="
    ${TYPE} $set$postInc(int index); // "x++"    
    ${TYPE} $set$postInc(long index); // "x++"    
    ${TYPE} $set$postDec(int index); // "x--"    
    ${TYPE} $set$postDec(long index); // "x--"    
    ${TYPE} $set$preInc(int index); // "++x"    
    ${TYPE} $set$preInc(long index); // "++x"    
    ${TYPE} $set$preDec(int index); // "--x"  
    ${TYPE} $set$preDec(long index); // "--x"  
    ${ADDITIONAL_MODIFY_VALUE_SECTION_END}
}        