package org.clank.support.aliases;

import org.clank.support.Converted;
import org.clank.support.*;
import org.clank.java.std;
import static org.clank.support.NativeType.*;
import static org.clank.support.NativeMemory.*;
import static org.clank.support.NativePointer.*;

/**
 * Array based implementation of pointer to ${TYPE}
 */
//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/support/aliases/templates/pointerarrayimpl.tpl")
//</editor-fold>
public final class ${FILE_NAME}${CLASS_SUFFIX} extends AbstractArrayPointerType<${POINTER_NAME}> implements ${POINTER_NAME} {
    
    protected ${TYPE}[] array;

    protected ${FILE_NAME}(${FILE_NAME}${CLASS_SUFFIX} other, boolean makeConst) {
      super(other, makeConst);
      this.array = other.array;
      trackInstance();
    }
  
    public ${FILE_NAME}() {
        this(null, 0, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr) {
        this(arr, 0, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr, long idx) {
        this(arr, Unsigned.long2uint(idx), false);
    }
    public ${FILE_NAME}(${TYPE}[] arr, int idx) {
        this(arr, idx, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr, boolean makeConst) {
        this(arr, 0, makeConst);
    }

    public ${FILE_NAME}(${TYPE}[] arr, long idx, boolean makeConst) {
        this(arr, Unsigned.long2uint(idx), makeConst);
    }
    public ${FILE_NAME}(${TYPE}[] arr, int idx, boolean makeConst) {
        super(makeConst);
        this.array = arr;
        assert idx >= 0 : "can not be negative " + idx;
        this.index = idx;
        trackInstance();
    }

    ///////////////////////////////////////////////////////////////////////////
    // common operations

    @Override
    public boolean $isNull() {
        return array == null;
    }

    @Override
    public ${TYPE} $star() {
        return array[index];
    }

    @Override
    public ${TYPE} $set(${TYPE} value) {
        return $set(0, value);
    }

    @Override
    public ${TYPE} $at(int index) {
        return array[(this.index + index)];
    }

    @Override
    public ${TYPE} $at(long index) {
        return array[(int)(this.index + index)];
    }

    @Override
    public int $sub(${POINTER_NAME} other) {
      assert other instanceof ${FILE_NAME} : "unexpected object " + other;
      return (index - ((${FILE_NAME})other).index);
    }
    
    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} $add(int amount) {
      ${FILE_NAME}${CLASS_SUFFIX} cloned = new ${FILE_NAME}${CLASS_SUFFIX}(this, false);
      cloned.index += amount;
      return cloned;
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} $add(long amount) {
      ${FILE_NAME}${CLASS_SUFFIX} cloned = new ${FILE_NAME}${CLASS_SUFFIX}(this, false);
      cloned.index += amount;
      return cloned;
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} $sub(int amount) {
      ${FILE_NAME}${CLASS_SUFFIX} cloned = new ${FILE_NAME}${CLASS_SUFFIX}(this, false);
      cloned.index -= amount;
      return cloned;
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} $sub(long amount) {
      ${FILE_NAME}${CLASS_SUFFIX} cloned = new ${FILE_NAME}${CLASS_SUFFIX}(this, false);
      cloned.index -= amount;
      return cloned;
    }
  
    @Override
    public ${TYPE} $set(int index, ${TYPE} value) {
      ${SET_IMPL}
    }   
    @Override
    public ${TYPE} $set(long index, ${TYPE} value) {
      ${SET_IMPL}
    }   
    ${BUILTIN_TYPE_MODIFY_VALUE_SECTION_START}
    @Override
    public ${TYPE} $set$andassign(int index, ${TYPE} value) {
        return array[(this.index + index)] &= value;
    }
    @Override
    public ${TYPE} $set$andassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] &= value;
    }

    @Override
    public ${TYPE} $set$xorassign(int index, ${TYPE} value) {
        return array[(this.index + index)] ^= value;
    }
    @Override
    public ${TYPE} $set$xorassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] ^= value;
    }

    @Override
    public ${TYPE} $set$orassign(int index, ${TYPE} value) {
        return array[(this.index + index)] |= value;
    }
    @Override
    public ${TYPE} $set$orassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] |= value;
    }

    ${BUILTIN_TYPE_MODIFY_VALUE_SECTION_END}${ADDITIONAL_MODIFY_VALUE_SECTION_START}

    @Override
    public ${TYPE} $set$addassign(int index, ${TYPE} value) {
        return array[(this.index + index)] += value;
    }
    @Override
    public ${TYPE} $set$addassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] += value;
    }

    @Override
    public ${TYPE} $set$minusassign(int index, ${TYPE} value) {
        return array[(this.index + index)] -= value;
    }
    @Override
    public ${TYPE} $set$minusassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] -= value;
    }

    @Override
    public ${TYPE} $set$starassign(int index, ${TYPE} value) {
        return array[(this.index + index)] *= value;
    }
    @Override
    public ${TYPE} $set$starassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] *= value;
    }

    @Override
    public ${TYPE} $set$slashassign(int index, ${TYPE} value) {
        return array[(this.index + index)] /= value;
    }
    @Override
    public ${TYPE} $set$slashassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] /= value;
    }

    @Override
    public ${TYPE} $set$modassign(int index, ${TYPE} value) {
        return array[(this.index + index)] %= value;
    }
    @Override
    public ${TYPE} $set$modassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] %= value;
    }

    @Override
    public ${TYPE} $set$lshiftassign(int index, ${TYPE} value) {
        return array[(this.index + index)] <<= value;
    }
    @Override
    public ${TYPE} $set$lshiftassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] <<= value;
    }

    @Override
    public ${TYPE} $set$rshiftassign(int index, ${TYPE} value) {
        return array[(this.index + index)] >>= value;
    }
    @Override
    public ${TYPE} $set$rshiftassign(long index, ${TYPE} value) {
        return array[(int)(this.index + index)] >>= value;
    }

    @Override
    public ${TYPE} $set$postInc(int index) {
        return array[(this.index + index)]++;
    }
    @Override
    public ${TYPE} $set$postInc(long index) {
        return array[(int)(this.index + index)]++;
    }

    @Override
    public ${TYPE} $set$postDec(int index) {
        return array[(this.index + index)]--;
    }
    @Override
    public ${TYPE} $set$postDec(long index) {
        return array[(int)(this.index + index)]--;
    }

    @Override
    public ${TYPE} $set$preInc(int index) {
        return ++array[(this.index + index)];
    }
    @Override
    public ${TYPE} $set$preInc(long index) {
        return ++array[(int)(this.index + index)];
    }

    @Override
    public ${TYPE} $set$preDec(int index) {
        return --array[(this.index + index)];
    }
    @Override
    public ${TYPE} $set$preDec(long index) {
        return --array[(int)(this.index + index)];
    }

    ${ADDITIONAL_MODIFY_VALUE_SECTION_END}

    @Override
    public ${POINTER_NAME} $assign(${POINTER_NAME} value) {
        assert !_isConst() : "Cannot modify const object!";
        if (value instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} val = (${FILE_NAME}${CLASS_SUFFIX})value;
            array = val.array;
            index = val.index;
            return this;
        } ${ADDITIONAL_ASSIGNMENTS}
        throw new IllegalArgumentException(
                "Different pointer types: expected '" + getClass().getName() + "'" 
                + ", but found '" + (value != null ? value.getClass() : "null") + "'"
        );            
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
      return other instanceof ${FILE_NAME} && ((${FILE_NAME}) other).array == this.array;
    }
    
    @Override
    public boolean $less(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) < 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) <= 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) > 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());          
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) >= 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());          
    }
    
    @Override
    public boolean $eq(Object p) {
        if (p instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) p;
            return other.array == this.array && index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !$eq(p);
    }        

    @Override
    public ${REFERENCE_NAME} star$ref() {
      return new ${REFERENCE_NAME}() {

            // use outer instance if only $set/$deref is needed
            ${FILE_NAME}${CLASS_SUFFIX} localPtr = ${FILE_NAME}.this;

            @Override
            public ${TYPE} $deref() {
                return localPtr.$star();
            }

            @Override
            public ${TYPE} $set(${TYPE} value) {
                return localPtr.$set(value);
            }

            @Override
            public ${POINTER_NAME} deref$ptr() {
                // we have to make a copy,
                // otherwise ++/-- will change outer instance
                if (localPtr == ${FILE_NAME}.this) {
                  localPtr = localPtr.clone();
                }
                return localPtr;
            }
        };
    }

    @Override
    public long $hashcode() {
        return ((long) System.identityHashCode(this.array)) ^ index;
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} clone() {
      return new ${FILE_NAME}(this, false);
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} const_clone() {
      return super._isConst() ? this : new ${FILE_NAME}(this, true);
    }

    @Override
    public String toString() {
      if (array == null || array.length == 0) {
        return "<EMPTY>";
      }
      StringBuilder sb = new StringBuilder("\n" + ${FILE_NAME}.class.getSimpleName() + "{range=[" + this.index + "-" + array.length + "]\n");
      String fmt = "%" + (int) Math.ceil(Math.log10(array.length + 1)) + "d";
      for (int i = (int) this.index; i < array.length; i++) {
        ${TYPE} b = array[i];
        ${SB_APPEND_ELEMENT_I};
        if ((i - this.index) > NativeTrace.TO_STRING_LIMIT) {
          sb.append("...."); break;
        }
      }
      sb.append("}").append(${FILE_NAME}.class.getSimpleName()).append("\n");
      return sb.toString();
    }  

    ////////////////////////////////////////////////////////////////////////////
    // statistics
    private static long instances = 0;

    public static void trackInstance() {
        if (NativeTrace.STATISTICS) instances++;
    }

    public static void clearStatistics() {
        instances = 0;
    }

    public static void printStatistics(java.io.PrintWriter out) {
        out.printf("%22s created:\t%s%n", ${FILE_NAME}.class.getSimpleName(), NativeTrace.formatNumber(instances));
    }
    ///////////////////////////////////////////////////////////////////////////
    // performance access operations
    public final ${TYPE}[] $array() {
      return this.array;
    }
}