package org.llvm.adt.aliases;

import java.util.Arrays;
import java.util.Iterator;
import org.clank.java.*;
import org.clank.support.Converted;
import org.clank.support.Destructors.ClassWithDestructor;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import static org.clank.support.NativePointer.*;
import static org.clank.java.std.string.npos;

/**
 * SmallVectorImpl for ${TYPE}
 */
//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.llvm.adtsupport/src/org/llvm/adt/aliases/templates/SmallVectorImpl.tpl")
//</editor-fold>
public ${CLASS_SPECIFIER} class ${FILE_NAME}${CLASS_SUFFIX} implements assignable<${FILE_NAME}${CLASS_SUFFIX}>, 
  Native.NativeComparable<${FILE_NAME}${CLASS_SUFFIX}>, Native.ComparableLower, NativeType.SizeofCapable,
  Iterable<${BOXED_TYPE}> {  

  protected final ${TYPE} defaultValue;
  
  private ${TYPE}[] array;
  private static final ${ARRAY_TYPE}[] EMPTY = ${NEW_ZERO_ARRAY};

  private int end;

  ${INNER_METHOD_VISIBILITY} final ${TYPE}[] $array() {
    return this.array;
  }

  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(int capacity, ${TYPE} defaultValue) {
    this.array = (${TYPE}[]) (capacity == 0 ? EMPTY : ${NEW_CAPACITY_ARRAY});
    this.end = 0;
    this.defaultValue = defaultValue;
  }
  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(long capacity, ${TYPE} defaultValue) {
    this.array = (${TYPE}[]) (capacity == 0 ? EMPTY : ${NEW_CAPACITY_ARRAY});
    this.end = 0;
    this.defaultValue = defaultValue;
  }
  
  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(int capacity, int initialSize, ${TYPE} defaultValue) {
    this(capacity, defaultValue);
    this.assign(initialSize, defaultValue);
  }
  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(long capacity, long initialSize, ${TYPE} defaultValue) {
    this(capacity, defaultValue);
    this.assign(initialSize, defaultValue);
  }

  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(int capacity, int initialSize, ${TYPE} value, ${TYPE} defaultValue) {
    this(capacity, defaultValue);
    this.assign(initialSize, value);
  }
  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(long capacity, long initialSize, ${TYPE} value, ${TYPE} defaultValue) {
    this(capacity, defaultValue);
    this.assign(initialSize, value);
  }

  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(${TYPE} array[], int length, ${TYPE} defaultValue) {
    this.array = array;
    this.end = (int) length;
    this.defaultValue = defaultValue;
  }
  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(${TYPE} array[], long length, ${TYPE} defaultValue) {
    this.array = array;
    this.end = (int) length;
    this.defaultValue = defaultValue;
  }

  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(int capacity, ${GENERIC_ITERATOR} iter, int length, ${TYPE} defaultValue) {
    this(capacity, iter, iter.$add(length), defaultValue);
  }
  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(long capacity, ${GENERIC_ITERATOR} iter, long length, ${TYPE} defaultValue) {
    this(capacity, iter, iter.$add(length), defaultValue);
  }

  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(int capacity, ${GENERIC_ITERATOR} begin, ${GENERIC_ITERATOR} end, ${TYPE} defaultValue) {
    this(capacity, defaultValue);
    append(begin, end);
  }
  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(long capacity, ${GENERIC_ITERATOR} begin, ${GENERIC_ITERATOR} end, ${TYPE} defaultValue) {
    this(capacity, defaultValue);
    append(begin, end);
  }

  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(${FILE_NAME}${CLASS_SUFFIX} other) {
    this.defaultValue = other.defaultValue;
    this.array = other.array.clone();
    this.end = other.end;
  }

  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(JavaDifferentiators.Move _dparam, ${FILE_NAME}${CLASS_SUFFIX} other) {
    this.defaultValue = other.defaultValue;
    this.array = other.array;
    this.end = other.end;
    
    other.array = null;
  }
  
//  ${CONSTRUCTOR_VISIBILITY} ${FILE_NAME}(${TYPE}... arr) {
//      // TODO: think over: this uses passed array as a backing store, 
//      // which is effective, but probably error prone; consider copynig
//      array = arr;
//      end = arr.length;
//  }

  @Override
  public final ${FILE_NAME}${CLASS_SUFFIX} $assign(${FILE_NAME}${CLASS_SUFFIX} other) {
      this.array = other.array;
      this.end = other.end;
      return this;
  }    

  public final void clear() {
    this.destroy_range(0, this.size());
    this.setEnd(0);
  }

  public final boolean resize(int newSize) {
    return resize(newSize, defaultValue);
  }
  public final boolean resize(long newSize) {
    return resize(newSize, defaultValue);
  }
  
  public final boolean resize(long newSize, ${TYPE} defaultValue) {
    return resize(Unsigned.long2uint(newSize), defaultValue);
  }
  public final boolean resize(int newSize, ${TYPE} defaultValue) {
    assert newSize >= 0 : "can not be negative " + newSize;
    boolean grown = false;
    if (newSize < array.length) {
      destroy_range(newSize, end);
    } else if (newSize > array.length) {
      if (this.capacity() < newSize) {
        this.grow(newSize);
        grown = true;
      }
      for (int i = end; i < newSize; i++) {
        array[i] = $tryClone(defaultValue);
      }
    }
    this.setEnd(newSize);
    return grown;
  }  

  public final void reserve(long N) {
    reserve(Unsigned.long2uint(N));
  }
  public final void reserve(int N) {
    assert N >= 0 : "can not be negative " + N;
    if (this.capacity() < N)
      this.grow(N);
  }

  public final void assign(long NumElts, ${TYPE} Elt) {
    assign(Unsigned.long2uint(NumElts), Elt);
  }
  public final void assign(int NumElts, ${TYPE} Elt) {
    assert NumElts >= 0 : "can not be negative " + NumElts;
    clear();
    if (this.capacity() < NumElts)
      this.grow(NumElts);    
    this.setEnd(NumElts);
    
    for (int i = 0; i < this.size(); i++) {
      $set(i, Elt);
    }
  }  

  /**
   *  @brief  Assigns a range to a %vector.
   *  @param  __first  An input iterator.
   *  @param  __last   An input iterator.
   *
   *  This function fills a %vector with copies of the elements in the
   *  range [__first,__last).
   *
   *  Note that the assignment completely changes the %vector and
   *  that the resulting %vector's size is the same as the number
   *  of elements assigned.  Old data may be lost.
   */
  public final void assign(${GENERIC_ITERATOR} __first, ${GENERIC_ITERATOR} __last) {
    clear();
    append(__first, __last);
  }
  
  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line = 440)
  //</editor-fold>  
  public final void swap(${FILE_NAME}${CLASS_SUFFIX} RHS) {
    ${TYPE}[] arrTmp = this.array;
    this.array = (${TYPE}[])RHS.array;
    RHS.array = arrTmp;
    int endTmp = this.end;
    this.end = RHS.end;
    RHS.end = endTmp;
  }
  
  public final long/*size_t*/ find(${ARRAY_TYPE} elem) {
    return find(elem, 0);
  }

  public final long/*size_t*/ find(${ARRAY_TYPE} elem, long/*size_t*/ from/*=0*/) {
    boolean isDataPointerLike = isDataPointerLike();
    for (int i = Unsigned.long2uint(from); i < this.end; i++) {
      if (Native.$eq(array[i], elem, isDataPointerLike)) {
        return i;
      }
    }
    return npos;
  }
  
  public final boolean contains(${ARRAY_TYPE} elem) {
    return find(elem) != npos;
  }

  public final boolean erase(${ARRAY_TYPE} elem) {
    long _index = find(elem);
    if (_index == npos) {
      return false;
    }
    int index = Unsigned.long2uint(_index);
    // destroy element
    destroy_range(index, index+1);
    // shift leftward if not the last
    --end;
    if (index < end) {
      std.copy(this.array, index+1, end-index, this.array, index);
    }
    // clean up after shift
    $set(end, defaultValue);
    return true;
  }
  
  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=478)
  //</editor-fold>
  public final iterator erase(iterator I) {
    assert(I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
    assert(I.$less(this.end())) : "Erasing at past-the-end iterator.";

    iterator N = I;
    // Shift all elts down one.
    std.copy(I.$add(1), this.end(), I);
    // Drop the last elt.
    this.pop_back();
    return(N);
  } 
  
  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=490)
  //</editor-fold>
  public final iterator erase(iterator S, iterator E) {
    assert(S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
    assert(S.$lesseq(E)) : "Trying to erase invalid range.";
    assert(E.$lesseq(this.end())) : "Trying to erase past the end.";

    iterator N = S;
    // Shift all elts down.
    iterator I = std.copy(E, this.end(), S);
    // Drop the last elts.
    this.destroy_range(I, this.end());
    this.setEnd(I);
    return(N);
  }

  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=537)
  //</editor-fold>
  public final iterator insert(iterator I, ${TYPE} Elt) {
    if (I.$eq(this.end())) {  // Important special case for empty vector.
      this.push_back(Elt);
      return this.end().$sub(1);
    }

    assert(I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
    assert(I.$lesseq(this.end())) : "Inserting past the end of the vector.";
    
    if (this.size() >= this.capacity()) {
      int EltNo = I.$sub(this.begin());
      this.grow();
      I = this.begin().$add(EltNo);
    }
    
    assert(this.size() < this.capacity());
    
    this.setEnd(this.size() + 1);
    // Push everything else over.
    std.copy_backward(I, this.end().$sub(1), this.end());   
    
//  // If we just moved the element we're inserting, be sure to update
//  // the reference.
//  const T *EltPtr = &Elt;
//  if (I <= EltPtr && EltPtr < this->EndX)
//    ++EltPtr;    
    
    I.star$ref().$set(Elt);
    return I;    
  }  

  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=568)
  //</editor-fold>  
  public final iterator insert(iterator I, long NumToInsert, ${TYPE} Elt) {
    return insert(I, Unsigned.long2uint(NumToInsert), Elt);
  }
  public final iterator insert(iterator I, int NumToInsert, ${TYPE} Elt) {
    assert NumToInsert >= 0 : "can not be negative " + NumToInsert;
    // Convert iterator to elt# to avoid invalidating iterator when we reserve()
    int InsertElt = I.$sub(this.begin());

    if (I.$eq(this.end())) {  // Important special case for empty vector.
      append(NumToInsert, Elt);
      return this.begin().$add(InsertElt);
    }

    assert(I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
    assert(I.$lesseq(this.end())) : "Inserting past the end of the vector.";

    // Ensure there is enough space.
    reserve(this.size() + NumToInsert);

    // Uninvalidate the iterator.
    I = this.begin().$add(InsertElt);

    // If there are more elements between the insertion point and the end of the
    // range than there are being inserted, we can use a simple approach to
    // insertion.  Since we already reserved space, we know that this won't
    // reallocate the vector.
    if (this.end().$sub(I) >= NumToInsert) {
      iterator OldEnd = this.end();
      append(this.end().$sub(NumToInsert), this.end());

      // Copy the existing elements that get replaced.
      std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);

      std.fill_n(I, NumToInsert, Elt);
      return I;
    }

    // Otherwise, we're inserting more elements than exist already, and we're
    // not inserting at the end.

    // Move over the elements that we're about to overwrite.
    iterator OldEnd = this.end();
    this.setEnd(this.size() + NumToInsert);
    int NumOverwritten = OldEnd.$sub(I);
    std.copy(I, OldEnd, this.end().$sub(NumOverwritten));

    // Replace the overwritten part.
    std.fill_n(I, NumOverwritten, Elt);

    // Insert the non-overwritten middle part.
    std.fill_n(OldEnd, NumToInsert-NumOverwritten, Elt);
    return I;  
  }

  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=618)
  //</editor-fold>
  public final iterator insert(iterator I, ${GENERIC_ITERATOR} From, ${GENERIC_ITERATOR} To) {
    // Convert iterator to elt# to avoid invalidating iterator when we reserve()
    int InsertElt = I.$sub(this.begin());

    if (I.$eq(this.end())) {  // Important special case for empty vector.
      append(From, To);
      return this.begin().$add(InsertElt);
    }

    assert(I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
    assert(I.$lesseq(this.end())) : "Inserting past the end of the vector.";

    int NumToInsert = std.distance(From, To);

    // Ensure there is enough space.
    reserve(this.size() + NumToInsert);

    // Uninvalidate the iterator.
    I = this.begin().$add(InsertElt);

    // If there are more elements between the insertion point and the end of the
    // range than there are being inserted, we can use a simple approach to
    // insertion.  Since we already reserved space, we know that this won't
    // reallocate the vector.
    if (this.end().$sub(I) >= NumToInsert) {
      iterator OldEnd = this.end();
      append(this.end().$sub(NumToInsert), this.end());

      // Copy the existing elements that get replaced.
      std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);

      std.copy(From, To, I);
      return I;
    }

    // Otherwise, we're inserting more elements than exist already, and we're
    // not inserting at the end.

    // Move over the elements that we're about to overwrite.
    iterator OldEnd = this.end();
    this.setEnd(this.size() + NumToInsert);
    int NumOverwritten = OldEnd.$sub(I);
    std.copy(I, OldEnd, this.end().$sub(NumOverwritten));

    // Replace the overwritten part.
    for (iterator J = I.clone(); NumOverwritten > 0; --NumOverwritten) {
      J.star$ref().$set(From.$star());
      J.$preInc(); From.$preInc();
    }

    // Insert the non-overwritten middle part.
    std.copy(From, To, OldEnd);
    return I;
  }

  /// append - Add the specified range to the end of the SmallVector.
  ///  
  public final void append(${GENERIC_ITERATOR} in_start, ${GENERIC_ITERATOR} in_end) {
    int NumInputs = std.distance(in_start, in_end);
    // Grow allocated space if needed.
    if (NumInputs > (this.capacity() - this.size()))
      this.grow(this.size()+NumInputs);
    
    ${GENERIC_ITERATOR} iter = (${GENERIC_ITERATOR}) in_start.clone();
    while (!iter.$eq(in_end)) {
      $set(end, iter.$star());
      ++end;
      iter.$preInc();
    }
  }

  public final void append(${TYPE}[] a) {
    append(a, 0, a.length);
  }

  public final void append(${TYPE}[] a, int fromIndex, int count) {
    if (count > (this.capacity() - this.size()))
      this.grow(this.size()+count);
    while (count-- > 0) {
      ${TYPE} el = a[fromIndex++];
      $set(end, el);
      ++end;
    }
  } 
  
  public final void append(long NumInputs, ${TYPE} Elt) {
    append(Unsigned.long2uint(NumInputs), Elt);
  }
  public final void append(int NumInputs, ${TYPE} Elt) {
    assert NumInputs >= 0 : "can not be negative " + NumInputs;
    // Grow allocated space if needed.
    if (NumInputs > (this.capacity() - this.size()))
      this.grow(this.size()+NumInputs);

    // Copy the new elements over.
    for (int i = 0; i < NumInputs; i++) {
      $set(end, Elt);
      ++end;
    }
  }  

  @Override
  public final boolean $eq(${FILE_NAME}${CLASS_SUFFIX} RHS) {
    int size = this.size();
    if (size != RHS.size()) return false;
    for (int i = 0; i < size; i++) {
      //if (this.array[i] != RHS.array[i]) {
      if (Native.$noteq(this.array[i], RHS.array[i])) {
        return false;
      }
    }
    return true;
  }

  @Override
  public final boolean $noteq(${FILE_NAME}${CLASS_SUFFIX} RHS) {
    return !$eq(RHS);
  }

  @Override
  public final boolean $less(Object obj) {
    return std.lexicographical_compare(
        this.begin(), 
        this.end(), 
        ((${FILE_NAME}) obj).begin(), 
        ((${FILE_NAME}) obj).end()
    );
  }

  @Override
  public final boolean $lesseq(Object obj) {
    return $less(obj) || $eq((${FILE_NAME}${CLASS_SUFFIX})obj);
  }

  public final ${REFERENCE_TYPE} ref$at(int idx) {
    return NativePointer.${REFERENCE_FACTORY_MTD}(array, idx);
  }
  public final ${REFERENCE_TYPE} ref$at(long idx) {
    return NativePointer.${REFERENCE_FACTORY_MTD}(array, idx);
  }
  
  public final ${TYPE} $at(int idx) {
    return array[(int) idx];
  }
  public final ${TYPE} $at(long idx) {
    return array[(int) idx];
  }

  public final ${TYPE} $set(int idx, ${TYPE} value) {
    ${SET_IMPL}
  }
  public final ${TYPE} $set(long idx, ${TYPE} value) {
    ${SET_IMPL}
  }
  
  public final boolean empty() {
    return this.size() == 0;
  }
  
  public final void $destroy() {
    //destroy_range(0, this.size());
  }
  
  public final void push_back(${TYPE} val) {
    if (this.size() >= this.capacity()) {
      this.grow();
    }
    $set(this.size(), val);
    this.setEnd(this.size() + 1);
  }    

  public final void pop_back() {
    destroy_range(this.size() - 1, this.size());
    this.setEnd(this.size() - 1);
  }

  public final ${TYPE} pop_back_val() {
    ${TYPE} val = this.back();
    this.setEnd(end - 1);
    return val;
  }  

  public final ${ITERATOR_TYPE} begin() {
    return new ${ITERATOR_TYPE}(this, 0, false);
  }

  public final ${ITERATOR_TYPE} end() {
    return new ${ITERATOR_TYPE}(this, end, false);
  }
  
  public final ${REV_ITERATOR_TYPE} rbegin() {
    return new ${REV_ITERATOR_TYPE}(NativePointer.${POINTER_FACTORY_MTD}(array, end));
  }

  public final ${REV_ITERATOR_TYPE} rend() {
    return new ${REV_ITERATOR_TYPE}(NativePointer.${POINTER_FACTORY_MTD}(array));
  }
  
  public final ${POINTER_TYPE} data() {
    return NativePointer.${POINTER_FACTORY_MTD}(array);
  }
  
  public final ${TYPE} front() {
    return array[0];
  }    
  
  public final ${TYPE} back() {
    return array[end - 1];
  }    
  
  public final ${REFERENCE_TYPE} ref$front() {
    return new ${REFERENCE_TYPE}() {
      
      private final ${TYPE} stored = array[0];
      
      private final int index = 0;

      @Override
      public ${TYPE} $deref() {
        return stored;
      }

      @Override
      public ${TYPE} $set(${TYPE} value) {
        ${REF_SET_IMPL}
      }
      
      @Override
      public ${POINTER_TYPE} deref$ptr() {
        return data().$add(index);
      }
    };
  }

  public final ${REFERENCE_TYPE} ref$back() {
    return  new ${REFERENCE_TYPE}() {
      
      private final ${TYPE} stored = array[end - 1];
      
      private final int index = end - 1;

      @Override
      public ${TYPE} $deref() {
        return stored;
      }

      @Override
      public ${TYPE} $set(${TYPE} value) {
        ${REF_SET_IMPL}
      }
      
      @Override
      public ${POINTER_TYPE} deref$ptr() {
        return data().$add(index);
      }   
    };
  }
  
  public final int/*size_t*/ size() /*const*/ {
    return end;
  }

  public final int/*size_t*/ max_size() /*const*/ {
    return Integer.MAX_VALUE; // TODO 
  }

  /// capacity - Return the total number of elements in the currently allocated
  /// buffer.
  public final int/*size_t*/ capacity() /*const*/ {
    return array.length;
  }

  @Override public final long/*size_t*/ $sizeof() {
    return capacity_in_bytes();
  }

  public final long/*size_t*/ capacity_in_bytes() {
    int oneElemSize = NativeType.sizeof(defaultValue);; 
    for (${TYPE} elem : array) {
      if (elem != defaultValue) {
        oneElemSize = NativeType.sizeof(elem);
        break;
      }
    }
    return array.length * oneElemSize;
  }

  public final ${POINTER_TYPE} ptr$at(int idx) {
    return ${POINTER_FACTORY_MTD}(array, idx);
  }
  public final ${POINTER_TYPE} ptr$at(long idx) {
    return ${POINTER_FACTORY_MTD}(array, idx);
  }

  /// Set the array size to \p N, which the current array must have enough
  /// capacity for.
  ///
  /// This does not construct or destroy any elements in the vector.
  ///
  /// Clients can use this in conjunction with capacity() to write past the end
  /// of the buffer when they know that more elements are available, and only
  /// update the size later. This avoids the cost of value initializing elements
  /// which will only be overwritten.
  public final void set_size(long N) {
    set_size(Unsigned.long2uint(N));
  }
  public final void set_size(int N) {
    assert N >= 0 : "can not be negative " + N;
    assert(N <= this.capacity());
    this.setEnd(N);
  }  
  
  private void destroy_range(int from, int to) {
    ${DESTROY_RANGE_IMPL}
  }
  private void destroy_range(long from, long to) {
    ${DESTROY_RANGE_IMPL}
  }

  private void destroy_range(iterator _from, iterator _to) {
    destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
  } 
  
  private void grow(int capacity) {
    ${TYPE}[] oldArray = array;
    array = (${TYPE}[])${NEW_CAPACITY_ARRAY};
    copy$Object(oldArray, 0, array, 0, oldArray.length);
  }

  private void grow() {
    int capacity = capacity();
    this.grow(capacity == 0 ? 1 : ((capacity < 1024) ? capacity * 2 : (capacity + 1024)));
  }
  
  private void setEnd(int to) {
    end = to;
  }  

  private void setEnd(iterator to) {
    setEnd(to.$sub(this.begin()));
  } 

  @Override
  public Iterator<${BOXED_TYPE}> iterator() {
    return new JavaIterator(begin(), end());
  }

  // Only Java! 
  // Means that in native code vector contained pointers but in Java they were converted as Java references
  public boolean isDataPointerLike() {
    ${IS_DATA_POINTER_LIKE_IMPL}
  }
  
  /*
   * *************************************************************************
   *  Iterators
   * *************************************************************************
   */
    
  public final static class ${ITERATOR_TYPE} implements ${ITERATOR_INTERFACE}, Native.assignable<${ITERATOR_TYPE}>, Native.ComparableLowerGreater {
    
    private final boolean _const;
    private final ${FILE_NAME}${CLASS_SUFFIX} delegate;
    private int index;

    private iterator(${FILE_NAME}${CLASS_SUFFIX} delegate, int index, boolean makeConst) {
      this.delegate = delegate;
      this.index = index;
      this._const = makeConst;
    }

    @Override
    public ${ITERATOR_TYPE} $assign(${ITERATOR_TYPE} other) {
      assert this.delegate == other.delegate;
      this.index = other.index;
      return this;
    }

    public ${TYPE} $arrow() {
      return $at(0);
    }

    @Override
    public ${TYPE} $star() {
      return $at(0);
    }
    
    @Override
    public ${REFERENCE_TYPE} star$ref() {
      return ref$at(0);
    }       

    @Override
    public int $sub(${ITERATOR_TYPE} iter) {
      assert this.delegate == iter.delegate;
      return this.index - iter.index;
    }

    @Override
    public ${ITERATOR_TYPE} $preInc() {
      assert !_const;
      ++this.index;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $preDec() {
      assert !_const;
      --this.index;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $postInc() {
      assert !_const;
      ${ITERATOR_TYPE} cloned = new ${ITERATOR_TYPE}(delegate, index, false);
      index++;
      return cloned;
    }

    @Override
    public ${ITERATOR_TYPE} $postDec() {
      assert !_const;
      ${ITERATOR_TYPE} cloned = new ${ITERATOR_TYPE}(delegate, index, false);
      index--;
      return cloned;
    }

    @Override
    public ${ITERATOR_TYPE} $inc(int amount) {
      assert !_const;
      index+=amount;
      return this;
    }
    @Override
    public ${ITERATOR_TYPE} $inc(long amount) {
      assert !_const;
      index+=amount;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $dec(int amount) {
      assert !_const;
      index-=amount;
      return this;
    }
    @Override
    public ${ITERATOR_TYPE} $dec(long amount) {
      assert !_const;
      index-=amount;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $add(int amount) {
      return new ${ITERATOR_TYPE}(this.delegate, (this.index + amount), false);
    }
    @Override
    public ${ITERATOR_TYPE} $add(long amount) {
      return new ${ITERATOR_TYPE}(this.delegate, (int) (this.index + amount), false);
    }

    @Override
    public ${ITERATOR_TYPE} $sub(int amount) {
      return new ${ITERATOR_TYPE}(this.delegate, (this.index - amount), false);
    }
    @Override
    public ${ITERATOR_TYPE} $sub(long amount) {
      return new ${ITERATOR_TYPE}(this.delegate, (int) (this.index - amount), false);
    }

    @Override
    public boolean $noteq(Object other) {
      assert this.delegate == ((iterator) other).delegate;
      return this.index != ((iterator) other).index;
    }

    @Override
    public boolean $eq(Object other) {
      assert this.delegate == ((iterator) other).delegate;
      return this.index == ((iterator) other).index;
    }

    @Override
    public ${ITERATOR_TYPE} clone() {
      return new ${ITERATOR_TYPE}(delegate, index, false);
    }

    @Override
    public ${ITERATOR_TYPE} const_clone() {
      return new ${ITERATOR_TYPE}(delegate, index, true);
    }

    @Override
    public boolean $less(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index < ((iterator) obj).index;
    }

    @Override
    public boolean $lesseq(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index <= ((iterator) obj).index;
    }

    @Override
    public boolean $greater(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index > ((iterator) obj).index;
    }

    @Override
    public boolean $greatereq(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index >= ((iterator) obj).index;
    }

    public ${TYPE} $at(int index) {
      return delegate.$at(this.index + index);
    }
    public ${TYPE} $at(long index) {
      return delegate.$at(this.index + index);
    }
    
    public ${REFERENCE_TYPE} ref$at(final int index) {
      return delegate.ref$at(this.index + index);
    }
    public ${REFERENCE_TYPE} ref$at(final long index) {
      return delegate.ref$at(this.index + index);
    }

    public ${POINTER_TYPE} toPointer() {
      return ${POINTER_FACTORY_MTD}(delegate.array, this.index);
    }

    @Override
    public String toString() {
      return "[" + this.index + "] from\n" + delegate.toString();
    }
  } 

  private final static class JavaIterator${CLASS_SUFFIX} implements Iterator<${BOXED_TYPE}> {
    
    private final ${ITERATOR_TYPE} begin;
    
    private final ${ITERATOR_TYPE} end;

    public JavaIterator(${ITERATOR_TYPE} begin, ${ITERATOR_TYPE} end) {
      this.begin = $tryClone(begin);
      this.end = end;
    }

    @Override
    public boolean hasNext() {
      return begin.$noteq(end);
    }

    @Override
    public ${BOXED_TYPE} next() {
      ${BOXED_TYPE} val = begin.$star();
      begin.$preInc();
      return val;
    }

    @Override
    public void remove() {
      throw new UnsupportedOperationException("Not supported.");
    }
  }

  @Override
  public String toString() {
    if (this.end == 0) {
      return "<EMPTY>";
    }
    StringBuilder out = new StringBuilder("\n${FILE_NAME}{\nend = " + this.end + '\n');
    String fmt = "%" + (int)Math.ceil(Math.log10(this.end+1)) + "d";
    for (int i = 0; i < this.end; i++) {
      ${TYPE} element = array[i];
      out.append("[").append(String.format(fmt, i)).append("]");
      ${SB_APPEND_ELEMENT_I};
    }
    out.append("}${FILE_NAME}}\n");
    return out.toString();
  }
}
