// Generated by psc-bundle 0.8.5.0
var PS = {};
(function(exports) {
  /* global exports */
  "use strict";

  // module Prelude

  //- Functor --------------------------------------------------------------------

  exports.arrayMap = function (f) {
    return function (arr) {
      var l = arr.length;
      var result = new Array(l);
      for (var i = 0; i < l; i++) {
        result[i] = f(arr[i]);
      }
      return result;
    };
  };

  //- Bind -----------------------------------------------------------------------

  exports.arrayBind = function (arr) {
    return function (f) {
      var result = [];
      for (var i = 0, l = arr.length; i < l; i++) {
        Array.prototype.push.apply(result, f(arr[i]));
      }
      return result;
    };
  };

  //- Monoid ---------------------------------------------------------------------

  exports.concatString = function (s1) {
    return function (s2) {
      return s1 + s2;
    };
  };

  exports.concatArray = function (xs) {
    return function (ys) {
      return xs.concat(ys);
    };
  };

  //- Semiring -------------------------------------------------------------------

  exports.intAdd = function (x) {
    return function (y) {
      /* jshint bitwise: false */
      return x + y | 0;
    };
  };

  exports.intMul = function (x) {
    return function (y) {
      /* jshint bitwise: false */
      return x * y | 0;
    };
  };

  //- Ring -----------------------------------------------------------------------

  exports.intSub = function (x) {
    return function (y) {
      /* jshint bitwise: false */
      return x - y | 0;
    };
  };

  //- Eq -------------------------------------------------------------------------

  exports.refEq = function (r1) {
    return function (r2) {
      return r1 === r2;
    };
  };

  exports.eqArrayImpl = function (f) {
    return function (xs) {
      return function (ys) {
        if (xs.length !== ys.length) return false;
        for (var i = 0; i < xs.length; i++) {
          if (!f(xs[i])(ys[i])) return false;
        }
        return true;
      };
    };
  };

  exports.ordArrayImpl = function (f) {
    return function (xs) {
      return function (ys) {
        var i = 0;
        var xlen = xs.length;
        var ylen = ys.length;
        while (i < xlen && i < ylen) {
          var x = xs[i];
          var y = ys[i];
          var o = f(x)(y);
          if (o !== 0) {
            return o;
          }
          i++;
        }
        if (xlen === ylen) {
          return 0;
        } else if (xlen > ylen) {
          return -1;
        } else {
          return 1;
        }
      };
    };
  };

  //- Ord ------------------------------------------------------------------------

  exports.unsafeCompareImpl = function (lt) {
    return function (eq) {
      return function (gt) {
        return function (x) {
          return function (y) {
            return x < y ? lt : x > y ? gt : eq;
          };
        };
      };
    };
  };                                          

  //- BooleanAlgebra -------------------------------------------------------------

  exports.boolOr = function (b1) {
    return function (b2) {
      return b1 || b2;
    };
  };

  exports.boolAnd = function (b1) {
    return function (b2) {
      return b1 && b2;
    };
  };

  exports.boolNot = function (b) {
    return !b;
  };

  //- Show -----------------------------------------------------------------------

  exports.showIntImpl = function (n) {
    return n.toString();
  };

  exports.showStringImpl = function (s) {
    var l = s.length;
    return "\"" + s.replace(
      /[\0-\x1F\x7F"\\]/g,
      function (c, i) { // jshint ignore:line
        switch (c) {
          case "\"":
          case "\\":
            return "\\" + c;
          case "\x07": return "\\a";
          case "\b": return "\\b";
          case "\f": return "\\f";
          case "\n": return "\\n";
          case "\r": return "\\r";
          case "\t": return "\\t";
          case "\v": return "\\v";
        }
        var k = i + 1;
        var empty = k < l && s[k] >= "0" && s[k] <= "9" ? "\\&" : "";
        return "\\" + c.charCodeAt(0).toString(10) + empty;
      }
    ) + "\"";
  };

  exports.showArrayImpl = function (f) {
    return function (xs) {
      var ss = [];
      for (var i = 0, l = xs.length; i < l; i++) {
        ss[i] = f(xs[i]);
      }
      return "[" + ss.join(",") + "]";
    };
  };
})(PS["Prelude"] = PS["Prelude"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Prelude"];

  /**
 *  | The `Ordering` data type represents the three possible outcomes of
 *  | comparing two values:
 *  |
 *  | `LT` - The first value is _less than_ the second.
 *  | `GT` - The first value is _greater than_ the second.
 *  | `EQ` - The first value is _equal to_ the second.
 */  
  var LT = (function () {
      function LT() {

      };
      LT.value = new LT();
      return LT;
  })();

  /**
 *  | The `Ordering` data type represents the three possible outcomes of
 *  | comparing two values:
 *  |
 *  | `LT` - The first value is _less than_ the second.
 *  | `GT` - The first value is _greater than_ the second.
 *  | `EQ` - The first value is _equal to_ the second.
 */  
  var GT = (function () {
      function GT() {

      };
      GT.value = new GT();
      return GT;
  })();

  /**
 *  | The `Ordering` data type represents the three possible outcomes of
 *  | comparing two values:
 *  |
 *  | `LT` - The first value is _less than_ the second.
 *  | `GT` - The first value is _greater than_ the second.
 *  | `EQ` - The first value is _equal to_ the second.
 */  
  var EQ = (function () {
      function EQ() {

      };
      EQ.value = new EQ();
      return EQ;
  })();

  /**
 *  | A `Semigroupoid` is similar to a [`Category`](#category) but does not
 *  | require an identity element `id`, just composable morphisms.
 *  |
 *  | `Semigroupoid`s must satisfy the following law:
 *  |
 *  | - Associativity: `p <<< (q <<< r) = (p <<< q) <<< r`
 *  |
 *  | One example of a `Semigroupoid` is the function type constructor `(->)`,
 *  | with `(<<<)` defined as function composition.
 */  
  var Semigroupoid = function (compose) {
      this.compose = compose;
  };

  /**
 *  | `Category`s consist of objects and composable morphisms between them, and
 *  | as such are [`Semigroupoids`](#semigroupoid), but unlike `semigroupoids`
 *  | must have an identity element.
 *  |
 *  | Instances must satisfy the following law in addition to the
 *  | `Semigroupoid` law:
 *  |
 *  | - Identity: `id <<< p = p <<< id = p`
 */  
  var Category = function (__superclass_Prelude$dotSemigroupoid_0, id) {
      this["__superclass_Prelude.Semigroupoid_0"] = __superclass_Prelude$dotSemigroupoid_0;
      this.id = id;
  };

  /**
 *  | A `Functor` is a type constructor which supports a mapping operation
 *  | `(<$>)`.
 *  |
 *  | `(<$>)` can be used to turn functions `a -> b` into functions
 *  | `f a -> f b` whose argument and return types use the type constructor `f`
 *  | to represent some computational context.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Identity: `(<$>) id = id`
 *  | - Composition: `(<$>) (f <<< g) = (f <$>) <<< (g <$>)`
 */  
  var Functor = function (map) {
      this.map = map;
  };

  /**
 *  | The `Apply` class provides the `(<*>)` which is used to apply a function
 *  | to an argument under a type constructor.
 *  |
 *  | `Apply` can be used to lift functions of two or more arguments to work on
 *  | values wrapped with the type constructor `f`. It might also be understood
 *  | in terms of the `lift2` function:
 *  |
 *  | ```purescript
 *  | lift2 :: forall f a b c. (Apply f) => (a -> b -> c) -> f a -> f b -> f c
 *  | lift2 f a b = f <$> a <*> b
 *  | ```
 *  |
 *  | `(<*>)` is recovered from `lift2` as `lift2 ($)`. That is, `(<*>)` lifts
 *  | the function application operator `($)` to arguments wrapped with the
 *  | type constructor `f`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Functor`
 *  | laws:
 *  |
 *  | - Associative composition: `(<<<) <$> f <*> g <*> h = f <*> (g <*> h)`
 *  |
 *  | Formally, `Apply` represents a strong lax semi-monoidal endofunctor.
 */  
  var Apply = function (__superclass_Prelude$dotFunctor_0, apply) {
      this["__superclass_Prelude.Functor_0"] = __superclass_Prelude$dotFunctor_0;
      this.apply = apply;
  };

  /**
 *  | The `Applicative` type class extends the [`Apply`](#apply) type class
 *  | with a `pure` function, which can be used to create values of type `f a`
 *  | from values of type `a`.
 *  |
 *  | Where [`Apply`](#apply) provides the ability to lift functions of two or
 *  | more arguments to functions whose arguments are wrapped using `f`, and
 *  | [`Functor`](#functor) provides the ability to lift functions of one
 *  | argument, `pure` can be seen as the function which lifts functions of
 *  | _zero_ arguments. That is, `Applicative` functors support a lifting
 *  | operation for any number of function arguments.
 *  |
 *  | Instances must satisfy the following laws in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Identity: `(pure id) <*> v = v`
 *  | - Composition: `(pure <<<) <*> f <*> g <*> h = f <*> (g <*> h)`
 *  | - Homomorphism: `(pure f) <*> (pure x) = pure (f x)`
 *  | - Interchange: `u <*> (pure y) = (pure ($ y)) <*> u`
 */  
  var Applicative = function (__superclass_Prelude$dotApply_0, pure) {
      this["__superclass_Prelude.Apply_0"] = __superclass_Prelude$dotApply_0;
      this.pure = pure;
  };

  /**
 *  | The `Bind` type class extends the [`Apply`](#apply) type class with a
 *  | "bind" operation `(>>=)` which composes computations in sequence, using
 *  | the return value of one computation to determine the next computation.
 *  |
 *  | The `>>=` operator can also be expressed using `do` notation, as follows:
 *  |
 *  | ```purescript
 *  | x >>= f = do y <- x
 *  |              f y
 *  | ```
 *  |
 *  | where the function argument of `f` is given the name `y`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Associativity: `(x >>= f) >>= g = x >>= (\k => f k >>= g)`
 *  |
 *  | Associativity tells us that we can regroup operations which use `do`
 *  | notation so that we can unambiguously write, for example:
 *  |
 *  | ```purescript
 *  | do x <- m1
 *  |    y <- m2 x
 *  |    m3 x y
 *  | ```
 */  
  var Bind = function (__superclass_Prelude$dotApply_0, bind) {
      this["__superclass_Prelude.Apply_0"] = __superclass_Prelude$dotApply_0;
      this.bind = bind;
  };

  /**
 *  | The `Monad` type class combines the operations of the `Bind` and
 *  | `Applicative` type classes. Therefore, `Monad` instances represent type
 *  | constructors which support sequential composition, and also lifting of
 *  | functions of arbitrary arity.
 *  |
 *  | Instances must satisfy the following laws in addition to the
 *  | `Applicative` and `Bind` laws:
 *  |
 *  | - Left Identity: `pure x >>= f = f x`
 *  | - Right Identity: `x >>= pure = x`
 */  
  var Monad = function (__superclass_Prelude$dotApplicative_0, __superclass_Prelude$dotBind_1) {
      this["__superclass_Prelude.Applicative_0"] = __superclass_Prelude$dotApplicative_0;
      this["__superclass_Prelude.Bind_1"] = __superclass_Prelude$dotBind_1;
  };

  /**
 *  | The `Semigroup` type class identifies an associative operation on a type.
 *  |
 *  | Instances are required to satisfy the following law:
 *  |
 *  | - Associativity: `(x <> y) <> z = x <> (y <> z)`
 *  |
 *  | One example of a `Semigroup` is `String`, with `(<>)` defined as string
 *  | concatenation.
 */  
  var Semigroup = function (append) {
      this.append = append;
  };

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihiliation: `zero * a = a * zero = zero`
 */  
  var Semiring = function (add, mul, one, zero) {
      this.add = add;
      this.mul = mul;
      this.one = one;
      this.zero = zero;
  };

  /**
 *  | The `Ring` class is for types that support addition, multiplication,
 *  | and subtraction operations.
 *  |
 *  | Instances must satisfy the following law in addition to the `Semiring`
 *  | laws:
 *  |
 *  | - Additive inverse: `a - a = (zero - a) + a = zero`
 */  
  var Ring = function (__superclass_Prelude$dotSemiring_0, sub) {
      this["__superclass_Prelude.Semiring_0"] = __superclass_Prelude$dotSemiring_0;
      this.sub = sub;
  };

  /**
 *  | The `Eq` type class represents types which support decidable equality.
 *  |
 *  | `Eq` instances should satisfy the following laws:
 *  |
 *  | - Reflexivity: `x == x = true`
 *  | - Symmetry: `x == y = y == x`
 *  | - Transitivity: if `x == y` and `y == z` then `x == z`
 */  
  var Eq = function (eq) {
      this.eq = eq;
  };

  /**
 *  | The `Ord` type class represents types which support comparisons with a
 *  | _total order_.
 *  |
 *  | `Ord` instances should satisfy the laws of total orderings:
 *  |
 *  | - Reflexivity: `a <= a`
 *  | - Antisymmetry: if `a <= b` and `b <= a` then `a = b`
 *  | - Transitivity: if `a <= b` and `b <= c` then `a <= c`
 */  
  var Ord = function (__superclass_Prelude$dotEq_0, compare) {
      this["__superclass_Prelude.Eq_0"] = __superclass_Prelude$dotEq_0;
      this.compare = compare;
  };

  /**
 *  | The `Bounded` type class represents types that are finite.
 *  |
 *  | Although there are no "internal" laws for `Bounded`, every value of `a`
 *  | should be considered less than or equal to `top` by some means, and greater
 *  | than or equal to `bottom`.
 *  |
 *  | The lack of explicit `Ord` constraint allows flexibility in the use of
 *  | `Bounded` so it can apply to total and partially ordered sets, boolean
 *  | algebras, etc.
 */  
  var Bounded = function (bottom, top) {
      this.bottom = bottom;
      this.top = top;
  };

  /**
 *  | The `BooleanAlgebra` type class represents types that behave like boolean
 *  | values.
 *  |
 *  | Instances should satisfy the following laws in addition to the `Bounded`
 *  | laws:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Distributivity:
 *  |   - `a && (b || c) = (a && b) || (a && c)`
 *  |   - `a || (b && c) = (a || b) && (a || c)`
 *  | - Identity:
 *  |   - `a || bottom = a`
 *  |   - `a && top = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Annhiliation:
 *  |   - `a || top = top`
 *  | - Complementation:
 *  |   - `a && not a = bottom`
 *  |   - `a || not a = top`
 */  
  var BooleanAlgebra = function (__superclass_Prelude$dotBounded_0, conj, disj, not) {
      this["__superclass_Prelude.Bounded_0"] = __superclass_Prelude$dotBounded_0;
      this.conj = conj;
      this.disj = disj;
      this.not = not;
  };

  /**
 *  | The `Show` type class represents those types which can be converted into
 *  | a human-readable `String` representation.
 *  |
 *  | While not required, it is recommended that for any expression `x`, the
 *  | string `show x` be executable PureScript code which evaluates to the same
 *  | value as the expression `x`.
 */  
  var Show = function (show) {
      this.show = show;
  };

  /**
 *  | Applies a function to its argument.
 *  |
 *  | ```purescript
 *  | length $ groupBy productCategory $ filter isInStock $ products
 *  | ```
 *  |
 *  | is equivalent to:
 *  |
 *  | ```purescript
 *  | length (groupBy productCategory (filter isInStock products))
 *  | ```
 *  |
 *  | `($)` is different from [`(#)`](#-2) because it is right-infix instead of
 *  | left: `a $ b $ c $ d x = a $ (b $ (c $ (d $ x))) = a (b (c (d x)))`
 */  
  var $dollar = function (f) {
      return function (x) {
          return f(x);
      };
  };

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihiliation: `zero * a = a * zero = zero`
 */  
  var zero = function (dict) {
      return dict.zero;
  };
  var unsafeCompare = $foreign.unsafeCompareImpl(LT.value)(EQ.value)(GT.value);

  /**
 *  | `unit` is the sole inhabitant of the `Unit` type.
 */  
  var unit = {};

  /**
 *  | The `Bounded` type class represents types that are finite.
 *  |
 *  | Although there are no "internal" laws for `Bounded`, every value of `a`
 *  | should be considered less than or equal to `top` by some means, and greater
 *  | than or equal to `bottom`.
 *  |
 *  | The lack of explicit `Ord` constraint allows flexibility in the use of
 *  | `Bounded` so it can apply to total and partially ordered sets, boolean
 *  | algebras, etc.
 */  
  var top = function (dict) {
      return dict.top;
  };

  /**
 *  | The `Ring` class is for types that support addition, multiplication,
 *  | and subtraction operations.
 *  |
 *  | Instances must satisfy the following law in addition to the `Semiring`
 *  | laws:
 *  |
 *  | - Additive inverse: `a - a = (zero - a) + a = zero`
 */  
  var sub = function (dict) {
      return dict.sub;
  };

  /**
 *  | `(-)` is an alias for `sub`.
 */  
  var $minus = function (dictRing) {
      return sub(dictRing);
  }; 
  var showString = new Show($foreign.showStringImpl);
  var showInt = new Show($foreign.showIntImpl);

  /**
 *  | The `Show` type class represents those types which can be converted into
 *  | a human-readable `String` representation.
 *  |
 *  | While not required, it is recommended that for any expression `x`, the
 *  | string `show x` be executable PureScript code which evaluates to the same
 *  | value as the expression `x`.
 */  
  var show = function (dict) {
      return dict.show;
  };
  var showArray = function (dictShow) {
      return new Show($foreign.showArrayImpl(show(dictShow)));
  };                                                                            
  var semiringInt = new Semiring($foreign.intAdd, $foreign.intMul, 1, 0);
  var semigroupoidFn = new Semigroupoid(function (f) {
      return function (g) {
          return function (x) {
              return f(g(x));
          };
      };
  });
  var semigroupString = new Semigroup($foreign.concatString);
  var semigroupOrdering = new Semigroup(function (v) {
      return function (v1) {
          if (v instanceof LT) {
              return LT.value;
          };
          if (v instanceof GT) {
              return GT.value;
          };
          if (v instanceof EQ) {
              return v1;
          };
          throw new Error("Failed pattern match at Prelude line 414, column 3 - line 415, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var semigroupArray = new Semigroup($foreign.concatArray);
  var ringInt = new Ring(function () {
      return semiringInt;
  }, $foreign.intSub);

  /**
 *  | The `Applicative` type class extends the [`Apply`](#apply) type class
 *  | with a `pure` function, which can be used to create values of type `f a`
 *  | from values of type `a`.
 *  |
 *  | Where [`Apply`](#apply) provides the ability to lift functions of two or
 *  | more arguments to functions whose arguments are wrapped using `f`, and
 *  | [`Functor`](#functor) provides the ability to lift functions of one
 *  | argument, `pure` can be seen as the function which lifts functions of
 *  | _zero_ arguments. That is, `Applicative` functors support a lifting
 *  | operation for any number of function arguments.
 *  |
 *  | Instances must satisfy the following laws in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Identity: `(pure id) <*> v = v`
 *  | - Composition: `(pure <<<) <*> f <*> g <*> h = f <*> (g <*> h)`
 *  | - Homomorphism: `(pure f) <*> (pure x) = pure (f x)`
 *  | - Interchange: `u <*> (pure y) = (pure ($ y)) <*> u`
 */  
  var pure = function (dict) {
      return dict.pure;
  };

  /**
 *  | `return` is an alias for `pure`.
 */  
  var $$return = function (dictApplicative) {
      return pure(dictApplicative);
  };

  /**
 *  | An alias for `true`, which can be useful in guard clauses:
 *  |
 *  | ```purescript
 *  | max x y | x >= y    = x
 *  |         | otherwise = y
 *  | ```
 */  
  var otherwise = true;

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihiliation: `zero * a = a * zero = zero`
 */  
  var one = function (dict) {
      return dict.one;
  };

  /**
 *  | The `BooleanAlgebra` type class represents types that behave like boolean
 *  | values.
 *  |
 *  | Instances should satisfy the following laws in addition to the `Bounded`
 *  | laws:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Distributivity:
 *  |   - `a && (b || c) = (a && b) || (a && c)`
 *  |   - `a || (b && c) = (a || b) && (a || c)`
 *  | - Identity:
 *  |   - `a || bottom = a`
 *  |   - `a && top = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Annhiliation:
 *  |   - `a || top = top`
 *  | - Complementation:
 *  |   - `a && not a = bottom`
 *  |   - `a || not a = top`
 */  
  var not = function (dict) {
      return dict.not;
  };

  /**
 *  | `negate x` can be used as a shorthand for `zero - x`.
 */  
  var negate = function (dictRing) {
      return function (a) {
          return $minus(dictRing)(zero(dictRing["__superclass_Prelude.Semiring_0"]()))(a);
      };
  };

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihiliation: `zero * a = a * zero = zero`
 */  
  var mul = function (dict) {
      return dict.mul;
  };

  /**
 *  | A `Functor` is a type constructor which supports a mapping operation
 *  | `(<$>)`.
 *  |
 *  | `(<$>)` can be used to turn functions `a -> b` into functions
 *  | `f a -> f b` whose argument and return types use the type constructor `f`
 *  | to represent some computational context.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Identity: `(<$>) id = id`
 *  | - Composition: `(<$>) (f <<< g) = (f <$>) <<< (g <$>)`
 */  
  var map = function (dict) {
      return dict.map;
  };

  /**
 *  | `(<$>)` is an alias for `map`
 */  
  var $less$dollar$greater = function (dictFunctor) {
      return map(dictFunctor);
  };

  /**
 *  | `(<#>)` is `(<$>)` with its arguments reversed. For example:
 *  |
 *  | ```purescript
 *  | [1, 2, 3] <#> \n -> n * n
 *  | ```
 */  
  var $less$hash$greater = function (dictFunctor) {
      return function (fa) {
          return function (f) {
              return $less$dollar$greater(dictFunctor)(f)(fa);
          };
      };
  };

  /**
 *  | `Category`s consist of objects and composable morphisms between them, and
 *  | as such are [`Semigroupoids`](#semigroupoid), but unlike `semigroupoids`
 *  | must have an identity element.
 *  |
 *  | Instances must satisfy the following law in addition to the
 *  | `Semigroupoid` law:
 *  |
 *  | - Identity: `id <<< p = p <<< id = p`
 */  
  var id = function (dict) {
      return dict.id;
  };
  var functorArray = new Functor($foreign.arrayMap);

  /**
 *  | Flips the order of the arguments to a function of two arguments.
 *  |
 *  | ```purescript
 *  | flip const 1 2 = const 2 1 = 2
 *  | ```
 */  
  var flip = function (f) {
      return function (b) {
          return function (a) {
              return f(a)(b);
          };
      };
  }; 
  var eqString = new Eq($foreign.refEq);
  var ordString = new Ord(function () {
      return eqString;
  }, unsafeCompare);
  var eqOrdering = new Eq(function (v) {
      return function (v1) {
          if (v instanceof LT && v1 instanceof LT) {
              return true;
          };
          if (v instanceof GT && v1 instanceof GT) {
              return true;
          };
          if (v instanceof EQ && v1 instanceof EQ) {
              return true;
          };
          return false;
      };
  });               
  var eqInt = new Eq($foreign.refEq);
  var ordInt = new Ord(function () {
      return eqInt;
  }, unsafeCompare);
  var eqChar = new Eq($foreign.refEq);
  var ordChar = new Ord(function () {
      return eqChar;
  }, unsafeCompare);

  /**
 *  | The `Eq` type class represents types which support decidable equality.
 *  |
 *  | `Eq` instances should satisfy the following laws:
 *  |
 *  | - Reflexivity: `x == x = true`
 *  | - Symmetry: `x == y = y == x`
 *  | - Transitivity: if `x == y` and `y == z` then `x == z`
 */  
  var eq = function (dict) {
      return dict.eq;
  };

  /**
 *  | `(==)` is an alias for `eq`. Tests whether one value is equal to another.
 */  
  var $eq$eq = function (dictEq) {
      return eq(dictEq);
  };
  var eqArray = function (dictEq) {
      return new Eq($foreign.eqArrayImpl($eq$eq(dictEq)));
  };

  /**
 *  | The `BooleanAlgebra` type class represents types that behave like boolean
 *  | values.
 *  |
 *  | Instances should satisfy the following laws in addition to the `Bounded`
 *  | laws:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Distributivity:
 *  |   - `a && (b || c) = (a && b) || (a && c)`
 *  |   - `a || (b && c) = (a || b) && (a || c)`
 *  | - Identity:
 *  |   - `a || bottom = a`
 *  |   - `a && top = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Annhiliation:
 *  |   - `a || top = top`
 *  | - Complementation:
 *  |   - `a && not a = bottom`
 *  |   - `a || not a = top`
 */  
  var disj = function (dict) {
      return dict.disj;
  };

  /**
 *  | `(||)` is an alias for `disj`.
 */  
  var $bar$bar = function (dictBooleanAlgebra) {
      return disj(dictBooleanAlgebra);
  };

  /**
 *  | Returns its first argument and ignores its second.
 *  |
 *  | ```purescript
 *  | const 1 "hello" = 1
 *  | ```
 */  
  var $$const = function (a) {
      return function (v) {
          return a;
      };
  };

  /**
 *  | The `void` function is used to ignore the type wrapped by a
 *  | [`Functor`](#functor), replacing it with `Unit` and keeping only the type
 *  | information provided by the type constructor itself.
 *  |
 *  | `void` is often useful when using `do` notation to change the return type
 *  | of a monadic computation:
 *  |
 *  | ```purescript
 *  | main = forE 1 10 \n -> void do
 *  |   print n
 *  |   print (n * n)
 *  | ```
 */  
  var $$void = function (dictFunctor) {
      return function (fa) {
          return $less$dollar$greater(dictFunctor)($$const(unit))(fa);
      };
  };

  /**
 *  | The `BooleanAlgebra` type class represents types that behave like boolean
 *  | values.
 *  |
 *  | Instances should satisfy the following laws in addition to the `Bounded`
 *  | laws:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Distributivity:
 *  |   - `a && (b || c) = (a && b) || (a && c)`
 *  |   - `a || (b && c) = (a || b) && (a || c)`
 *  | - Identity:
 *  |   - `a || bottom = a`
 *  |   - `a && top = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Annhiliation:
 *  |   - `a || top = top`
 *  | - Complementation:
 *  |   - `a && not a = bottom`
 *  |   - `a || not a = top`
 */  
  var conj = function (dict) {
      return dict.conj;
  };

  /**
 *  | A `Semigroupoid` is similar to a [`Category`](#category) but does not
 *  | require an identity element `id`, just composable morphisms.
 *  |
 *  | `Semigroupoid`s must satisfy the following law:
 *  |
 *  | - Associativity: `p <<< (q <<< r) = (p <<< q) <<< r`
 *  |
 *  | One example of a `Semigroupoid` is the function type constructor `(->)`,
 *  | with `(<<<)` defined as function composition.
 */  
  var compose = function (dict) {
      return dict.compose;
  };

  /**
 *  | The `Ord` type class represents types which support comparisons with a
 *  | _total order_.
 *  |
 *  | `Ord` instances should satisfy the laws of total orderings:
 *  |
 *  | - Reflexivity: `a <= a`
 *  | - Antisymmetry: if `a <= b` and `b <= a` then `a = b`
 *  | - Transitivity: if `a <= b` and `b <= c` then `a <= c`
 */  
  var compare = function (dict) {
      return dict.compare;
  };
  var ordArray = function (dictOrd) {
      return new Ord(function () {
          return eqArray(dictOrd["__superclass_Prelude.Eq_0"]());
      }, function (xs) {
          return function (ys) {
              return $dollar(compare(ordInt)(0))($foreign.ordArrayImpl(function (x) {
                  return function (y) {
                      var $79 = compare(dictOrd)(x)(y);
                      if ($79 instanceof EQ) {
                          return 0;
                      };
                      if ($79 instanceof LT) {
                          return 1;
                      };
                      if ($79 instanceof GT) {
                          return negate(ringInt)(1);
                      };
                      throw new Error("Failed pattern match at Prelude line 661, column 53 - line 664, column 57: " + [ $79.constructor.name ]);
                  };
              })(xs)(ys));
          };
      });
  };

  /**
 *  | Test whether one value is _strictly less than_ another.
 */  
  var $less = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var $80 = compare(dictOrd)(a1)(a2);
              if ($80 instanceof LT) {
                  return true;
              };
              return false;
          };
      };
  };

  /**
 *  | Test whether one value is _non-strictly less than_ another.
 */  
  var $less$eq = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var $81 = compare(dictOrd)(a1)(a2);
              if ($81 instanceof GT) {
                  return false;
              };
              return true;
          };
      };
  };
  var categoryFn = new Category(function () {
      return semigroupoidFn;
  }, function (x) {
      return x;
  });
  var boundedBoolean = new Bounded(false, true);

  /**
 *  | The `Bounded` type class represents types that are finite.
 *  |
 *  | Although there are no "internal" laws for `Bounded`, every value of `a`
 *  | should be considered less than or equal to `top` by some means, and greater
 *  | than or equal to `bottom`.
 *  |
 *  | The lack of explicit `Ord` constraint allows flexibility in the use of
 *  | `Bounded` so it can apply to total and partially ordered sets, boolean
 *  | algebras, etc.
 */  
  var bottom = function (dict) {
      return dict.bottom;
  };
  var booleanAlgebraBoolean = new BooleanAlgebra(function () {
      return boundedBoolean;
  }, $foreign.boolAnd, $foreign.boolOr, $foreign.boolNot);

  /**
 *  | The `Bind` type class extends the [`Apply`](#apply) type class with a
 *  | "bind" operation `(>>=)` which composes computations in sequence, using
 *  | the return value of one computation to determine the next computation.
 *  |
 *  | The `>>=` operator can also be expressed using `do` notation, as follows:
 *  |
 *  | ```purescript
 *  | x >>= f = do y <- x
 *  |              f y
 *  | ```
 *  |
 *  | where the function argument of `f` is given the name `y`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Associativity: `(x >>= f) >>= g = x >>= (\k => f k >>= g)`
 *  |
 *  | Associativity tells us that we can regroup operations which use `do`
 *  | notation so that we can unambiguously write, for example:
 *  |
 *  | ```purescript
 *  | do x <- m1
 *  |    y <- m2 x
 *  |    m3 x y
 *  | ```
 */  
  var bind = function (dict) {
      return dict.bind;
  };

  /**
 *  | `(>>=)` is an alias for `bind`.
 */  
  var $greater$greater$eq = function (dictBind) {
      return bind(dictBind);
  }; 

  /**
 *  | The `Apply` class provides the `(<*>)` which is used to apply a function
 *  | to an argument under a type constructor.
 *  |
 *  | `Apply` can be used to lift functions of two or more arguments to work on
 *  | values wrapped with the type constructor `f`. It might also be understood
 *  | in terms of the `lift2` function:
 *  |
 *  | ```purescript
 *  | lift2 :: forall f a b c. (Apply f) => (a -> b -> c) -> f a -> f b -> f c
 *  | lift2 f a b = f <$> a <*> b
 *  | ```
 *  |
 *  | `(<*>)` is recovered from `lift2` as `lift2 ($)`. That is, `(<*>)` lifts
 *  | the function application operator `($)` to arguments wrapped with the
 *  | type constructor `f`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Functor`
 *  | laws:
 *  |
 *  | - Associative composition: `(<<<) <$> f <*> g <*> h = f <*> (g <*> h)`
 *  |
 *  | Formally, `Apply` represents a strong lax semi-monoidal endofunctor.
 */  
  var apply = function (dict) {
      return dict.apply;
  };

  /**
 *  | `(<*>)` is an alias for `apply`.
 */  
  var $less$times$greater = function (dictApply) {
      return apply(dictApply);
  };

  /**
 *  | `liftA1` provides a default implementation of `(<$>)` for any
 *  | [`Applicative`](#applicative) functor, without using `(<$>)` as provided
 *  | by the [`Functor`](#functor)-[`Applicative`](#applicative) superclass
 *  | relationship.
 *  |
 *  | `liftA1` can therefore be used to write [`Functor`](#functor) instances
 *  | as follows:
 *  |
 *  | ```purescript
 *  | instance functorF :: Functor F where
 *  |   map = liftA1
 *  | ```
 */  
  var liftA1 = function (dictApplicative) {
      return function (f) {
          return function (a) {
              return $less$times$greater(dictApplicative["__superclass_Prelude.Apply_0"]())(pure(dictApplicative)(f))(a);
          };
      };
  }; 

  /**
 *  | The `Semigroup` type class identifies an associative operation on a type.
 *  |
 *  | Instances are required to satisfy the following law:
 *  |
 *  | - Associativity: `(x <> y) <> z = x <> (y <> z)`
 *  |
 *  | One example of a `Semigroup` is `String`, with `(<>)` defined as string
 *  | concatenation.
 */  
  var append = function (dict) {
      return dict.append;
  };

  /**
 *  | `(++)` is an alternative alias for `append`.
 */  
  var $plus$plus = function (dictSemigroup) {
      return append(dictSemigroup);
  };

  /**
 *  | `(<>)` is an alias for `append`.
 */  
  var $less$greater = function (dictSemigroup) {
      return append(dictSemigroup);
  };

  /**
 *  | `ap` provides a default implementation of `(<*>)` for any
 *  | [`Monad`](#monad), without using `(<*>)` as provided by the
 *  | [`Apply`](#apply)-[`Monad`](#monad) superclass relationship.
 *  |
 *  | `ap` can therefore be used to write [`Apply`](#apply) instances as
 *  | follows:
 *  |
 *  | ```purescript
 *  | instance applyF :: Apply F where
 *  |   apply = ap
 *  | ```
 */  
  var ap = function (dictMonad) {
      return function (f) {
          return function (a) {
              return bind(dictMonad["__superclass_Prelude.Bind_1"]())(f)(function (v) {
                  return bind(dictMonad["__superclass_Prelude.Bind_1"]())(a)(function (v1) {
                      return $$return(dictMonad["__superclass_Prelude.Applicative_0"]())(v(v1));
                  });
              });
          };
      };
  };
  var monadArray = new Monad(function () {
      return applicativeArray;
  }, function () {
      return bindArray;
  });
  var bindArray = new Bind(function () {
      return applyArray;
  }, $foreign.arrayBind);
  var applyArray = new Apply(function () {
      return functorArray;
  }, ap(monadArray));
  var applicativeArray = new Applicative(function () {
      return applyArray;
  }, function (x) {
      return [ x ];
  });

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihiliation: `zero * a = a * zero = zero`
 */  
  var add = function (dict) {
      return dict.add;
  };

  /**
 *  | `(+)` is an alias for `add`.
 */  
  var $plus = function (dictSemiring) {
      return add(dictSemiring);
  };
  exports["LT"] = LT;
  exports["GT"] = GT;
  exports["EQ"] = EQ;
  exports["Show"] = Show;
  exports["BooleanAlgebra"] = BooleanAlgebra;
  exports["Bounded"] = Bounded;
  exports["Ord"] = Ord;
  exports["Eq"] = Eq;
  exports["Ring"] = Ring;
  exports["Semiring"] = Semiring;
  exports["Semigroup"] = Semigroup;
  exports["Monad"] = Monad;
  exports["Bind"] = Bind;
  exports["Applicative"] = Applicative;
  exports["Apply"] = Apply;
  exports["Functor"] = Functor;
  exports["Category"] = Category;
  exports["Semigroupoid"] = Semigroupoid;
  exports["show"] = show;
  exports["||"] = $bar$bar;
  exports["not"] = not;
  exports["disj"] = disj;
  exports["conj"] = conj;
  exports["bottom"] = bottom;
  exports["top"] = top;
  exports["unsafeCompare"] = unsafeCompare;
  exports["<="] = $less$eq;
  exports["<"] = $less;
  exports["compare"] = compare;
  exports["=="] = $eq$eq;
  exports["eq"] = eq;
  exports["negate"] = negate;
  exports["sub"] = sub;
  exports["+"] = $plus;
  exports["one"] = one;
  exports["mul"] = mul;
  exports["zero"] = zero;
  exports["add"] = add;
  exports["++"] = $plus$plus;
  exports["<>"] = $less$greater;
  exports["append"] = append;
  exports["ap"] = ap;
  exports["return"] = $$return;
  exports[">>="] = $greater$greater$eq;
  exports["bind"] = bind;
  exports["liftA1"] = liftA1;
  exports["pure"] = pure;
  exports["<*>"] = $less$times$greater;
  exports["apply"] = apply;
  exports["void"] = $$void;
  exports["<#>"] = $less$hash$greater;
  exports["<$>"] = $less$dollar$greater;
  exports["map"] = map;
  exports["id"] = id;
  exports["compose"] = compose;
  exports["otherwise"] = otherwise;
  exports["const"] = $$const;
  exports["flip"] = flip;
  exports["unit"] = unit;
  exports["semigroupoidFn"] = semigroupoidFn;
  exports["categoryFn"] = categoryFn;
  exports["functorArray"] = functorArray;
  exports["applyArray"] = applyArray;
  exports["applicativeArray"] = applicativeArray;
  exports["bindArray"] = bindArray;
  exports["monadArray"] = monadArray;
  exports["semigroupString"] = semigroupString;
  exports["semigroupOrdering"] = semigroupOrdering;
  exports["semigroupArray"] = semigroupArray;
  exports["semiringInt"] = semiringInt;
  exports["ringInt"] = ringInt;
  exports["eqInt"] = eqInt;
  exports["eqChar"] = eqChar;
  exports["eqString"] = eqString;
  exports["eqArray"] = eqArray;
  exports["eqOrdering"] = eqOrdering;
  exports["ordInt"] = ordInt;
  exports["ordString"] = ordString;
  exports["ordChar"] = ordChar;
  exports["ordArray"] = ordArray;
  exports["boundedBoolean"] = boundedBoolean;
  exports["booleanAlgebraBoolean"] = booleanAlgebraBoolean;
  exports["showInt"] = showInt;
  exports["showString"] = showString;
  exports["showArray"] = showArray;
})(PS["Prelude"] = PS["Prelude"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports.fromCharArray = function (a) {
    return a.join("");
  };

  exports._indexOf = function (just) {
    return function (nothing) {
      return function (x) {
        return function (s) {
          var i = s.indexOf(x);
          return i === -1 ? nothing : just(i);
        };
      };
    };
  };

  exports._lastIndexOf = function (just) {
    return function (nothing) {
      return function (x) {
        return function (s) {
          var i = s.lastIndexOf(x);
          return i === -1 ? nothing : just(i);
        };
      };
    };
  };

  exports.length = function (s) {
    return s.length;
  };

  exports.replace = function (s1) {
    return function (s2) {
      return function (s3) {
        return s3.replace(s1, s2);
      };
    };
  };

  exports.take = function (n) {
    return function (s) {
      return s.substr(0, n);
    };
  };

  exports.drop = function (n) {
    return function (s) {
      return s.substr(n);
    };
  };

  exports.count = function (p) {
    return function (s) {
      for (var i = 0; i < s.length && p(s.charAt(i)); i++); {}
      return i;
    };
  };

  exports.split = function (sep) {
    return function (s) {
      return s.split(sep);
    };
  };

  exports.toCharArray = function (s) {
    return s.split("");
  };

  exports.toLower = function (s) {
    return s.toLowerCase();
  };

  exports.toUpper = function (s) {
    return s.toUpperCase();
  };

  exports.trim = function (s) {
    return s.trim();
  };

  exports.joinWith = function (s) {
    return function (xs) {
      return xs.join(s);
    };
  };
})(PS["Data.String"] = PS["Data.String"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports.toLower = function (c) {
    return c.toLowerCase();
  };
})(PS["Data.Char"] = PS["Data.Char"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | A type and functions for single characters.
 */  
  "use strict";
  var $foreign = PS["Data.Char"];
  var Prelude = PS["Prelude"];
  exports["toLower"] = $foreign.toLower;
})(PS["Data.Char"] = PS["Data.Char"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `Alt` type class.
 */  
  "use strict";
  var Prelude = PS["Prelude"];        

  /**
 *  | The `Alt` type class identifies an associative operation on a type
 *  | constructor.  It is similar to `Semigroup`, except that it applies to
 *  | types of kind `* -> *`, like `Array` or `List`, rather than concrete types
 *  | `String` or `Number`.
 *  |
 *  | `Alt` instances are required to satisfy the following laws:
 *  |
 *  | - Associativity: `(x <|> y) <|> z == x <|> (y <|> z)`
 *  | - Distributivity: `f <$> (x <|> y) == (f <$> x) <|> (f <$> y)`
 *  |
 *  | For example, the `Array` (`[]`) type is an instance of `Alt`, where
 *  | `(<|>)` is defined to be concatenation.
 */  
  var Alt = function (__superclass_Prelude$dotFunctor_0, alt) {
      this["__superclass_Prelude.Functor_0"] = __superclass_Prelude$dotFunctor_0;
      this.alt = alt;
  };                                         

  /**
 *  | The `Alt` type class identifies an associative operation on a type
 *  | constructor.  It is similar to `Semigroup`, except that it applies to
 *  | types of kind `* -> *`, like `Array` or `List`, rather than concrete types
 *  | `String` or `Number`.
 *  |
 *  | `Alt` instances are required to satisfy the following laws:
 *  |
 *  | - Associativity: `(x <|> y) <|> z == x <|> (y <|> z)`
 *  | - Distributivity: `f <$> (x <|> y) == (f <$> x) <|> (f <$> y)`
 *  |
 *  | For example, the `Array` (`[]`) type is an instance of `Alt`, where
 *  | `(<|>)` is defined to be concatenation.
 */  
  var alt = function (dict) {
      return dict.alt;
  };

  /**
 *  | An infix version of `alt`.
 */  
  var $less$bar$greater = function (dictAlt) {
      return alt(dictAlt);
  };
  exports["Alt"] = Alt;
  exports["<|>"] = $less$bar$greater;
  exports["alt"] = alt;
})(PS["Control.Alt"] = PS["Control.Alt"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `Plus` type class.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];        

  /**
 *  | The `Plus` type class extends the `Alt` type class with a value that
 *  | should be the left and right identity for `(<|>)`.
 *  |
 *  | It is similar to `Monoid`, except that it applies to types of
 *  | kind `* -> *`, like `Array` or `List`, rather than concrete types like
 *  | `String` or `Number`.
 *  |
 *  | `Plus` instances should satisfy the following laws:
 *  |
 *  | - Left identity: `empty <|> x == x`
 *  | - Right identity: `x <|> empty == x`
 *  | - Annihilation: `f <$> empty == empty`
 */  
  var Plus = function (__superclass_Control$dotAlt$dotAlt_0, empty) {
      this["__superclass_Control.Alt.Alt_0"] = __superclass_Control$dotAlt$dotAlt_0;
      this.empty = empty;
  };       

  /**
 *  | The `Plus` type class extends the `Alt` type class with a value that
 *  | should be the left and right identity for `(<|>)`.
 *  |
 *  | It is similar to `Monoid`, except that it applies to types of
 *  | kind `* -> *`, like `Array` or `List`, rather than concrete types like
 *  | `String` or `Number`.
 *  |
 *  | `Plus` instances should satisfy the following laws:
 *  |
 *  | - Left identity: `empty <|> x == x`
 *  | - Right identity: `x <|> empty == x`
 *  | - Annihilation: `f <$> empty == empty`
 */  
  var empty = function (dict) {
      return dict.empty;
  };
  exports["Plus"] = Plus;
  exports["empty"] = empty;
})(PS["Control.Plus"] = PS["Control.Plus"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `Alternative` type class and associated
 *  | helper functions.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Plus = PS["Control.Plus"];        

  /**
 *  | The `Alternative` type class has no members of its own; it just specifies
 *  | that the type constructor has both `Applicative` and `Plus` instances.
 *  |
 *  | Types which have `Alternative` instances should also satisfy the following
 *  | laws:
 *  |
 *  | - Distributivity: `(f <|> g) <*> x == (f <*> x) <|> (g <*> x)`
 *  | - Annihilation: `empty <*> f = empty`
 */  
  var Alternative = function (__superclass_Control$dotPlus$dotPlus_1, __superclass_Prelude$dotApplicative_0) {
      this["__superclass_Control.Plus.Plus_1"] = __superclass_Control$dotPlus$dotPlus_1;
      this["__superclass_Prelude.Applicative_0"] = __superclass_Prelude$dotApplicative_0;
  };
  exports["Alternative"] = Alternative;
})(PS["Control.Alternative"] = PS["Control.Alternative"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `MonadPlus` type class.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Plus = PS["Control.Plus"];        

  /**
 *  | The `MonadPlus` type class has no members of its own; it just specifies
 *  | that the type has both `Monad` and `Alternative` instances.
 *  |
 *  | Types which have `MonadPlus` instances should also satisfy the following
 *  | laws:
 *  |
 *  | - Distributivity: `(x <|> y) >>= f == (x >>= f) <|> (y >>= f)`
 *  | - Annihilation: `empty >>= f = empty`
 */  
  var MonadPlus = function (__superclass_Control$dotAlternative$dotAlternative_1, __superclass_Prelude$dotMonad_0) {
      this["__superclass_Control.Alternative.Alternative_1"] = __superclass_Control$dotAlternative$dotAlternative_1;
      this["__superclass_Prelude.Monad_0"] = __superclass_Prelude$dotMonad_0;
  }; 

  /**
 *  | Fail using `Plus` if a condition does not hold, or
 *  | succeed using `Monad` if it does.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | import Data.Array
 *  |
 *  | factors :: Number -> Array Number
 *  | factors n = do
 *  |   a <- 1 .. n
 *  |   b <- 1 .. a
 *  |   guard $ a * b == n
 *  |   return a
 *  | ```
 */  
  var guard = function (dictMonadPlus) {
      return function (v) {
          if (v) {
              return Prelude["return"]((dictMonadPlus["__superclass_Control.Alternative.Alternative_1"]())["__superclass_Prelude.Applicative_0"]())(Prelude.unit);
          };
          if (!v) {
              return Control_Plus.empty((dictMonadPlus["__superclass_Control.Alternative.Alternative_1"]())["__superclass_Control.Plus.Plus_1"]());
          };
          throw new Error("Failed pattern match at Control.MonadPlus line 36, column 1 - line 37, column 1: " + [ v.constructor.name ]);
      };
  };
  exports["MonadPlus"] = MonadPlus;
  exports["guard"] = guard;
})(PS["Control.MonadPlus"] = PS["Control.MonadPlus"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];        

  /**
 *  | A `Monoid` is a `Semigroup` with a value `mempty`, which is both a
 *  | left and right unit for the associative operation `<>`:
 *  |
 *  | ```text
 *  | forall x. mempty <> x = x <> mempty = x
 *  | ```
 *  |
 *  | `Monoid`s are commonly used as the result of fold operations, where
 *  | `<>` is used to combine individual results, and `mempty` gives the result
 *  | of folding an empty collection of elements.
 */  
  var Monoid = function (__superclass_Prelude$dotSemigroup_0, mempty) {
      this["__superclass_Prelude.Semigroup_0"] = __superclass_Prelude$dotSemigroup_0;
      this.mempty = mempty;
  };     
  var monoidArray = new Monoid(function () {
      return Prelude.semigroupArray;
  }, [  ]);

  /**
 *  | A `Monoid` is a `Semigroup` with a value `mempty`, which is both a
 *  | left and right unit for the associative operation `<>`:
 *  |
 *  | ```text
 *  | forall x. mempty <> x = x <> mempty = x
 *  | ```
 *  |
 *  | `Monoid`s are commonly used as the result of fold operations, where
 *  | `<>` is used to combine individual results, and `mempty` gives the result
 *  | of folding an empty collection of elements.
 */  
  var mempty = function (dict) {
      return dict.mempty;
  };
  exports["Monoid"] = Monoid;
  exports["mempty"] = mempty;
  exports["monoidArray"] = monoidArray;
})(PS["Data.Monoid"] = PS["Data.Monoid"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Extend = PS["Control.Extend"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Monoid = PS["Data.Monoid"];        

  /**
 *  | The `Maybe` type is used to represent optional values and can be seen as
 *  | something like a type-safe `null`, where `Nothing` is `null` and `Just x`
 *  | is the non-null value `x`.
 */  
  var Nothing = (function () {
      function Nothing() {

      };
      Nothing.value = new Nothing();
      return Nothing;
  })();

  /**
 *  | The `Maybe` type is used to represent optional values and can be seen as
 *  | something like a type-safe `null`, where `Nothing` is `null` and `Just x`
 *  | is the non-null value `x`.
 */  
  var Just = (function () {
      function Just(value0) {
          this.value0 = value0;
      };
      Just.create = function (value0) {
          return new Just(value0);
      };
      return Just;
  })();

  /**
 *  | The `Show` instance allows `Maybe` values to be rendered as a string with
 *  | `show` whenever there is an `Show` instance for the type the `Maybe`
 *  | contains.
 */  
  var showMaybe = function (dictShow) {
      return new Prelude.Show(function (v) {
          if (v instanceof Just) {
              return "Just (" + (Prelude.show(dictShow)(v.value0) + ")");
          };
          if (v instanceof Nothing) {
              return "Nothing";
          };
          throw new Error("Failed pattern match at Data.Maybe line 290, column 3 - line 291, column 3: " + [ v.constructor.name ]);
      });
  };

  /**
 *  | Takes a default value, a function, and a `Maybe` value. If the `Maybe`
 *  | value is `Nothing` the default value is returned, otherwise the function
 *  | is applied to the value inside the `Just` and the result is returned.
 *  |
 *  | ``` purescript
 *  | maybe x f Nothing == x
 *  | maybe x f (Just y) == f y
 *  | ```
 */  
  var maybe = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Nothing) {
                  return v;
              };
              if (v2 instanceof Just) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Maybe line 27, column 1 - line 28, column 1: " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };

  /**
 *  | Returns `true` when the `Maybe` value is `Nothing`.
 */  
  var isNothing = maybe(true)(Prelude["const"](false));

  /**
 *  | Returns `true` when the `Maybe` value was constructed with `Just`.
 */  
  var isJust = maybe(false)(Prelude["const"](true));

  /**
 *  | The `Functor` instance allows functions to transform the contents of a
 *  | `Just` with the `<$>` operator:
 *  |
 *  | ``` purescript
 *  | f <$> Just x == Just (f x)
 *  | ```
 *  |
 *  | `Nothing` values are left untouched:
 *  |
 *  | ``` purescript
 *  | f <$> Nothing == Nothing
 *  | ```
 */  
  var functorMaybe = new Prelude.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Just) {
              return new Just(v(v1.value0));
          };
          return Nothing.value;
      };
  });

  /**
 *  | Takes a default value, and a `Maybe` value. If the `Maybe` value is
 *  | `Nothing` the default value is returned, otherwise the value inside the
 *  | `Just` is returned.
 *  |
 *  | ``` purescript
 *  | fromMaybe x Nothing == x
 *  | fromMaybe x (Just y) == y
 *  | ```
 */  
  var fromMaybe = function (a) {
      return maybe(a)(Prelude.id(Prelude.categoryFn));
  };

  /**
 *  | The `Apply` instance allows functions contained within a `Just` to
 *  | transform a value contained within a `Just` using the `apply` operator:
 *  |
 *  | ``` purescript
 *  | Just f <*> Just x == Just (f x)
 *  | ```
 *  |
 *  | `Nothing` values are left untouched:
 *  |
 *  | ``` purescript
 *  | Just f <*> Nothing == Nothing
 *  | Nothing <*> Just x == Nothing
 *  | ```
 *  |
 *  | Combining `Functor`'s `<$>` with `Apply`'s `<*>` can be used transform a
 *  | pure function to take `Maybe`-typed arguments so `f :: a -> b -> c`
 *  | becomes `f :: Maybe a -> Maybe b -> Maybe c`:
 *  |
 *  | ``` purescript
 *  | f <$> Just x <*> Just y == Just (f x y)
 *  | ```
 *  |
 *  | The `Nothing`-preserving behaviour of both operators means the result of
 *  | an expression like the above but where any one of the values is `Nothing`
 *  | means the whole result becomes `Nothing` also:
 *  |
 *  | ``` purescript
 *  | f <$> Nothing <*> Just y == Nothing
 *  | f <$> Just x <*> Nothing == Nothing
 *  | f <$> Nothing <*> Nothing == Nothing
 *  | ```
 */  
  var applyMaybe = new Prelude.Apply(function () {
      return functorMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Just) {
              return Prelude["<$>"](functorMaybe)(v.value0)(v1);
          };
          if (v instanceof Nothing) {
              return Nothing.value;
          };
          throw new Error("Failed pattern match at Data.Maybe line 122, column 3 - line 123, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | The `Bind` instance allows sequencing of `Maybe` values and functions that
 *  | return a `Maybe` by using the `>>=` operator:
 *  |
 *  | ``` purescript
 *  | Just x >>= f = f x
 *  | Nothing >>= f = Nothing
 *  | ```
 */  
  var bindMaybe = new Prelude.Bind(function () {
      return applyMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Just) {
              return v1(v.value0);
          };
          if (v instanceof Nothing) {
              return Nothing.value;
          };
          throw new Error("Failed pattern match at Data.Maybe line 181, column 3 - line 182, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | The `Alt` instance allows for a choice to be made between two `Maybe`
 *  | values with the `<|>` operator, where the first `Just` encountered
 *  | is taken.
 *  |
 *  | ``` purescript
 *  | Just x <|> Just y == Just x
 *  | Nothing <|> Just y == Just y
 *  | Nothing <|> Nothing == Nothing
 *  | ```
 */  
  var altMaybe = new Control_Alt.Alt(function () {
      return functorMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Nothing) {
              return v1;
          };
          return v;
      };
  });
  exports["Nothing"] = Nothing;
  exports["Just"] = Just;
  exports["isNothing"] = isNothing;
  exports["isJust"] = isJust;
  exports["fromMaybe"] = fromMaybe;
  exports["maybe"] = maybe;
  exports["functorMaybe"] = functorMaybe;
  exports["applyMaybe"] = applyMaybe;
  exports["altMaybe"] = altMaybe;
  exports["bindMaybe"] = bindMaybe;
  exports["showMaybe"] = showMaybe;
})(PS["Data.Maybe"] = PS["Data.Maybe"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Wraps the functions of Javascript's `String` object.
 *  | A String represents a sequence of characters.
 *  | For details of the underlying implementation, see [String Reference at MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String).
 */  
  "use strict";
  var $foreign = PS["Data.String"];
  var Prelude = PS["Prelude"];
  var Data_Char = PS["Data.Char"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_String_Unsafe = PS["Data.String.Unsafe"];                              

  /**
 *  | Returns the longest prefix (possibly empty) of characters that satisfy
 *  | the predicate:
 */  
  var takeWhile = function (p) {
      return function (s) {
          return $foreign.take($foreign.count(p)(s))(s);
      };
  };

  /**
 *  | Returns `true` if the given string is empty.
 */  
  var $$null = function (s) {
      return $foreign.length(s) === 0;
  };                                                                                                  

  /**
 *  | Returns the index of the last occurrence of the first string in the
 *  | second string. Returns `Nothing` if there is no match.
 */  
  var lastIndexOf = $foreign._lastIndexOf(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 *  | If the string ends with the given suffix, return the portion of the
 *  | string left after removing it, as a Just value. Otherwise, return Nothing.
 *  | * `stripSuffix ".exe" "psc.exe" == Just "psc"`
 *  | * `stripSuffix ".exe" "psc" == Nothing`
 */  
  var stripSuffix = function (suffix) {
      return function (str) {
          var $2 = lastIndexOf(suffix)(str);
          if ($2 instanceof Data_Maybe.Just && $2.value0 === $foreign.length(str) - $foreign.length(suffix)) {
              return Data_Maybe.Just.create($foreign.take($2.value0)(str));
          };
          return Data_Maybe.Nothing.value;
      };
  };                                                                                          

  /**
 *  | Returns the index of the first occurrence of the first string in the
 *  | second string. Returns `Nothing` if there is no match.
 */  
  var indexOf = $foreign._indexOf(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 *  | If the string starts with the given prefix, return the portion of the
 *  | string left after removing it, as a Just value. Otherwise, return Nothing.
 *  | * `stripPrefix "http:" "http://purescript.org" == Just "//purescript.org"`
 *  | * `stripPrefix "http:" "https://purescript.org" == Nothing`
 */  
  var stripPrefix = function (prefix) {
      return function (str) {
          var $4 = indexOf(prefix)(str);
          if ($4 instanceof Data_Maybe.Just && $4.value0 === 0) {
              return Data_Maybe.Just.create($foreign.drop($foreign.length(prefix))(str));
          };
          return Data_Maybe.Nothing.value;
      };
  };
  exports["stripSuffix"] = stripSuffix;
  exports["stripPrefix"] = stripPrefix;
  exports["takeWhile"] = takeWhile;
  exports["null"] = $$null;
  exports["lastIndexOf"] = lastIndexOf;
  exports["indexOf"] = indexOf;
  exports["joinWith"] = $foreign.joinWith;
  exports["trim"] = $foreign.trim;
  exports["toUpper"] = $foreign.toUpper;
  exports["toLower"] = $foreign.toLower;
  exports["toCharArray"] = $foreign.toCharArray;
  exports["split"] = $foreign.split;
  exports["replace"] = $foreign.replace;
  exports["length"] = $foreign.length;
  exports["fromCharArray"] = $foreign.fromCharArray;
})(PS["Data.String"] = PS["Data.String"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a data type representing ANSI escape codes, as well as
 *  | functions for serialising them as Strings.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_String = PS["Data.String"];        
  var Bold = (function () {
      function Bold() {

      };
      Bold.value = new Bold();
      return Bold;
  })();
  var Dim = (function () {
      function Dim() {

      };
      Dim.value = new Dim();
      return Dim;
  })();
  var Italic = (function () {
      function Italic() {

      };
      Italic.value = new Italic();
      return Italic;
  })();
  var Underline = (function () {
      function Underline() {

      };
      Underline.value = new Underline();
      return Underline;
  })();
  var Inverse = (function () {
      function Inverse() {

      };
      Inverse.value = new Inverse();
      return Inverse;
  })();
  var Strikethrough = (function () {
      function Strikethrough() {

      };
      Strikethrough.value = new Strikethrough();
      return Strikethrough;
  })();

  /**
 *  | Specifies how much text to erase.
 *  |
 *  | * ToEnd: erase from the cursor to the end of the line or screen.
 *  | * FromBeginning: erase to the cursor from the beginning of the line or
 *  |    screen.
 *  | * Entire: erase the entire line or screen.
 */  
  var ToEnd = (function () {
      function ToEnd() {

      };
      ToEnd.value = new ToEnd();
      return ToEnd;
  })();

  /**
 *  | Specifies how much text to erase.
 *  |
 *  | * ToEnd: erase from the cursor to the end of the line or screen.
 *  | * FromBeginning: erase to the cursor from the beginning of the line or
 *  |    screen.
 *  | * Entire: erase the entire line or screen.
 */  
  var FromBeginning = (function () {
      function FromBeginning() {

      };
      FromBeginning.value = new FromBeginning();
      return FromBeginning;
  })();

  /**
 *  | Specifies how much text to erase.
 *  |
 *  | * ToEnd: erase from the cursor to the end of the line or screen.
 *  | * FromBeginning: erase to the cursor from the beginning of the line or
 *  |    screen.
 *  | * Entire: erase the entire line or screen.
 */  
  var Entire = (function () {
      function Entire() {

      };
      Entire.value = new Entire();
      return Entire;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var White = (function () {
      function White() {

      };
      White.value = new White();
      return White;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Black = (function () {
      function Black() {

      };
      Black.value = new Black();
      return Black;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Blue = (function () {
      function Blue() {

      };
      Blue.value = new Blue();
      return Blue;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Cyan = (function () {
      function Cyan() {

      };
      Cyan.value = new Cyan();
      return Cyan;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Green = (function () {
      function Green() {

      };
      Green.value = new Green();
      return Green;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Magenta = (function () {
      function Magenta() {

      };
      Magenta.value = new Magenta();
      return Magenta;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Red = (function () {
      function Red() {

      };
      Red.value = new Red();
      return Red;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Yellow = (function () {
      function Yellow() {

      };
      Yellow.value = new Yellow();
      return Yellow;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Grey = (function () {
      function Grey() {

      };
      Grey.value = new Grey();
      return Grey;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightBlack = (function () {
      function BrightBlack() {

      };
      BrightBlack.value = new BrightBlack();
      return BrightBlack;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightRed = (function () {
      function BrightRed() {

      };
      BrightRed.value = new BrightRed();
      return BrightRed;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightGreen = (function () {
      function BrightGreen() {

      };
      BrightGreen.value = new BrightGreen();
      return BrightGreen;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightYellow = (function () {
      function BrightYellow() {

      };
      BrightYellow.value = new BrightYellow();
      return BrightYellow;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightBlue = (function () {
      function BrightBlue() {

      };
      BrightBlue.value = new BrightBlue();
      return BrightBlue;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightMagenta = (function () {
      function BrightMagenta() {

      };
      BrightMagenta.value = new BrightMagenta();
      return BrightMagenta;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightCyan = (function () {
      function BrightCyan() {

      };
      BrightCyan.value = new BrightCyan();
      return BrightCyan;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightWhite = (function () {
      function BrightWhite() {

      };
      BrightWhite.value = new BrightWhite();
      return BrightWhite;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var Reset = (function () {
      function Reset() {

      };
      Reset.value = new Reset();
      return Reset;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var PMode = (function () {
      function PMode(value0) {
          this.value0 = value0;
      };
      PMode.create = function (value0) {
          return new PMode(value0);
      };
      return PMode;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var PForeground = (function () {
      function PForeground(value0) {
          this.value0 = value0;
      };
      PForeground.create = function (value0) {
          return new PForeground(value0);
      };
      return PForeground;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var PBackground = (function () {
      function PBackground(value0) {
          this.value0 = value0;
      };
      PBackground.create = function (value0) {
          return new PBackground(value0);
      };
      return PBackground;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Up = (function () {
      function Up(value0) {
          this.value0 = value0;
      };
      Up.create = function (value0) {
          return new Up(value0);
      };
      return Up;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Down = (function () {
      function Down(value0) {
          this.value0 = value0;
      };
      Down.create = function (value0) {
          return new Down(value0);
      };
      return Down;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Forward = (function () {
      function Forward(value0) {
          this.value0 = value0;
      };
      Forward.create = function (value0) {
          return new Forward(value0);
      };
      return Forward;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Back = (function () {
      function Back(value0) {
          this.value0 = value0;
      };
      Back.create = function (value0) {
          return new Back(value0);
      };
      return Back;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var NextLine = (function () {
      function NextLine(value0) {
          this.value0 = value0;
      };
      NextLine.create = function (value0) {
          return new NextLine(value0);
      };
      return NextLine;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var PreviousLine = (function () {
      function PreviousLine(value0) {
          this.value0 = value0;
      };
      PreviousLine.create = function (value0) {
          return new PreviousLine(value0);
      };
      return PreviousLine;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var HorizontalAbsolute = (function () {
      function HorizontalAbsolute(value0) {
          this.value0 = value0;
      };
      HorizontalAbsolute.create = function (value0) {
          return new HorizontalAbsolute(value0);
      };
      return HorizontalAbsolute;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Position = (function () {
      function Position(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Position.create = function (value0) {
          return function (value1) {
              return new Position(value0, value1);
          };
      };
      return Position;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var EraseData = (function () {
      function EraseData(value0) {
          this.value0 = value0;
      };
      EraseData.create = function (value0) {
          return new EraseData(value0);
      };
      return EraseData;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var EraseLine = (function () {
      function EraseLine(value0) {
          this.value0 = value0;
      };
      EraseLine.create = function (value0) {
          return new EraseLine(value0);
      };
      return EraseLine;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var ScrollUp = (function () {
      function ScrollUp(value0) {
          this.value0 = value0;
      };
      ScrollUp.create = function (value0) {
          return new ScrollUp(value0);
      };
      return ScrollUp;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var ScrollDown = (function () {
      function ScrollDown(value0) {
          this.value0 = value0;
      };
      ScrollDown.create = function (value0) {
          return new ScrollDown(value0);
      };
      return ScrollDown;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Graphics = (function () {
      function Graphics(value0) {
          this.value0 = value0;
      };
      Graphics.create = function (value0) {
          return new Graphics(value0);
      };
      return Graphics;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var SavePosition = (function () {
      function SavePosition() {

      };
      SavePosition.value = new SavePosition();
      return SavePosition;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var RestorePosition = (function () {
      function RestorePosition() {

      };
      RestorePosition.value = new RestorePosition();
      return RestorePosition;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var QueryPosition = (function () {
      function QueryPosition() {

      };
      QueryPosition.value = new QueryPosition();
      return QueryPosition;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var HideCursor = (function () {
      function HideCursor() {

      };
      HideCursor.value = new HideCursor();
      return HideCursor;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var ShowCursor = (function () {
      function ShowCursor() {

      };
      ShowCursor.value = new ShowCursor();
      return ShowCursor;
  })();

  /**
 *  | The prefix for all escape codes.
 */  
  var prefix = "\x1b[";
  var eraseParamToString = function (ep) {
      if (ep instanceof ToEnd) {
          return "0";
      };
      if (ep instanceof FromBeginning) {
          return "1";
      };
      if (ep instanceof Entire) {
          return "2";
      };
      throw new Error("Failed pattern match at Ansi.Codes line 79, column 3 - line 86, column 1: " + [ ep.constructor.name ]);
  };

  /**
 *  | The suffix for escape codes; note that this is only required for colors.
 */  
  var colorSuffix = "m";
  var colorCode = function (c) {
      if (c instanceof White) {
          return 37;
      };
      if (c instanceof Black) {
          return 30;
      };
      if (c instanceof Blue) {
          return 34;
      };
      if (c instanceof Cyan) {
          return 36;
      };
      if (c instanceof Green) {
          return 32;
      };
      if (c instanceof Magenta) {
          return 35;
      };
      if (c instanceof Red) {
          return 31;
      };
      if (c instanceof Yellow) {
          return 33;
      };
      if (c instanceof Grey) {
          return 90;
      };
      if (c instanceof BrightBlack) {
          return 90;
      };
      if (c instanceof BrightRed) {
          return 91;
      };
      if (c instanceof BrightGreen) {
          return 92;
      };
      if (c instanceof BrightYellow) {
          return 93;
      };
      if (c instanceof BrightBlue) {
          return 94;
      };
      if (c instanceof BrightMagenta) {
          return 95;
      };
      if (c instanceof BrightCyan) {
          return 96;
      };
      if (c instanceof BrightWhite) {
          return 97;
      };
      throw new Error("Failed pattern match at Ansi.Codes line 140, column 3 - line 157, column 20: " + [ c.constructor.name ]);
  };
  var codeForRenderingMode = function (m) {
      if (m instanceof Bold) {
          return 1;
      };
      if (m instanceof Dim) {
          return 2;
      };
      if (m instanceof Italic) {
          return 3;
      };
      if (m instanceof Underline) {
          return 4;
      };
      if (m instanceof Inverse) {
          return 7;
      };
      if (m instanceof Strikethrough) {
          return 9;
      };
      throw new Error("Failed pattern match at Ansi.Codes line 110, column 3 - line 119, column 1: " + [ m.constructor.name ]);
  };
  var graphicsParamToString = function (gp) {
      if (gp instanceof Reset) {
          return "0";
      };
      if (gp instanceof PMode) {
          return Prelude.show(Prelude.showInt)(codeForRenderingMode(gp.value0));
      };
      if (gp instanceof PForeground) {
          return Prelude.show(Prelude.showInt)(colorCode(gp.value0));
      };
      if (gp instanceof PBackground) {
          return Prelude.show(Prelude.showInt)(colorCode(gp.value0) + 10 | 0);
      };
      throw new Error("Failed pattern match at Ansi.Codes line 94, column 3 - line 100, column 1: " + [ gp.constructor.name ]);
  };

  /**
 *  | Convert an escape code to the form recognised by terminals.
 */  
  var escapeCodeToString = (function () {
      var go = function (c) {
          if (c instanceof Up) {
              return Prelude.show(Prelude.showInt)(c.value0) + "A";
          };
          if (c instanceof Down) {
              return Prelude.show(Prelude.showInt)(c.value0) + "B";
          };
          if (c instanceof Forward) {
              return Prelude.show(Prelude.showInt)(c.value0) + "C";
          };
          if (c instanceof Back) {
              return Prelude.show(Prelude.showInt)(c.value0) + "D";
          };
          if (c instanceof NextLine) {
              return Prelude.show(Prelude.showInt)(c.value0) + "E";
          };
          if (c instanceof PreviousLine) {
              return Prelude.show(Prelude.showInt)(c.value0) + "F";
          };
          if (c instanceof HorizontalAbsolute) {
              return Prelude.show(Prelude.showInt)(c.value0) + "G";
          };
          if (c instanceof Position) {
              return Prelude.show(Prelude.showInt)(c.value0) + (";" + (Prelude.show(Prelude.showInt)(c.value1) + "H"));
          };
          if (c instanceof EraseData) {
              return eraseParamToString(c.value0) + "J";
          };
          if (c instanceof EraseLine) {
              return eraseParamToString(c.value0) + "K";
          };
          if (c instanceof ScrollUp) {
              return Prelude.show(Prelude.showInt)(c.value0) + "S";
          };
          if (c instanceof ScrollDown) {
              return Prelude.show(Prelude.showInt)(c.value0) + "T";
          };
          if (c instanceof Graphics) {
              return Data_String.joinWith(";")(Prelude.map(Prelude.functorArray)(graphicsParamToString)(c.value0)) + colorSuffix;
          };
          if (c instanceof SavePosition) {
              return "s";
          };
          if (c instanceof RestorePosition) {
              return "u";
          };
          if (c instanceof QueryPosition) {
              return "6n";
          };
          if (c instanceof HideCursor) {
              return "?25l";
          };
          if (c instanceof ShowCursor) {
              return "?25h";
          };
          throw new Error("Failed pattern match at Ansi.Codes line 43, column 5 - line 63, column 3: " + [ c.constructor.name ]);
      };
      return function ($23) {
          return (function (v) {
              return prefix + v;
          })(go($23));
      };
  })();
  exports["White"] = White;
  exports["Black"] = Black;
  exports["Blue"] = Blue;
  exports["Cyan"] = Cyan;
  exports["Green"] = Green;
  exports["Magenta"] = Magenta;
  exports["Red"] = Red;
  exports["Yellow"] = Yellow;
  exports["Grey"] = Grey;
  exports["BrightBlack"] = BrightBlack;
  exports["BrightRed"] = BrightRed;
  exports["BrightGreen"] = BrightGreen;
  exports["BrightYellow"] = BrightYellow;
  exports["BrightBlue"] = BrightBlue;
  exports["BrightMagenta"] = BrightMagenta;
  exports["BrightCyan"] = BrightCyan;
  exports["BrightWhite"] = BrightWhite;
  exports["Bold"] = Bold;
  exports["Dim"] = Dim;
  exports["Italic"] = Italic;
  exports["Underline"] = Underline;
  exports["Inverse"] = Inverse;
  exports["Strikethrough"] = Strikethrough;
  exports["Reset"] = Reset;
  exports["PMode"] = PMode;
  exports["PForeground"] = PForeground;
  exports["PBackground"] = PBackground;
  exports["ToEnd"] = ToEnd;
  exports["FromBeginning"] = FromBeginning;
  exports["Entire"] = Entire;
  exports["Up"] = Up;
  exports["Down"] = Down;
  exports["Forward"] = Forward;
  exports["Back"] = Back;
  exports["NextLine"] = NextLine;
  exports["PreviousLine"] = PreviousLine;
  exports["HorizontalAbsolute"] = HorizontalAbsolute;
  exports["Position"] = Position;
  exports["EraseData"] = EraseData;
  exports["EraseLine"] = EraseLine;
  exports["ScrollUp"] = ScrollUp;
  exports["ScrollDown"] = ScrollDown;
  exports["Graphics"] = Graphics;
  exports["SavePosition"] = SavePosition;
  exports["RestorePosition"] = RestorePosition;
  exports["QueryPosition"] = QueryPosition;
  exports["HideCursor"] = HideCursor;
  exports["ShowCursor"] = ShowCursor;
  exports["colorCode"] = colorCode;
  exports["codeForRenderingMode"] = codeForRenderingMode;
  exports["graphicsParamToString"] = graphicsParamToString;
  exports["eraseParamToString"] = eraseParamToString;
  exports["escapeCodeToString"] = escapeCodeToString;
  exports["colorSuffix"] = colorSuffix;
  exports["prefix"] = prefix;
})(PS["Ansi.Codes"] = PS["Ansi.Codes"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Convenience functions to simplify outputting ANSI escape codes to
 *  | terminals.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Ansi_Codes = PS["Ansi.Codes"];        

  /**
 *  | Using the given output function, write the given text with the given set
 *  | of graphics parameters. For example:
 *  |
 *  | ```purescript
 *  | withGraphics Console.log (bold <> underline <> foreground BrightRed) "hello world"
 *  | ```
 *  |
 *  | would print "hello world" to the terminal, bold, underlined, and in bright
 *  | red, and then reset (so that further logging to the console uses the
 *  | normal color and style).
 *  |
 *  | This function works by first printing the escape code corresponding to the
 *  | supplied graphics parameters, then printing the text, and then printing a
 *  | reset escape code.
 *  |
 *  | The first argument should take a string, and write it to some output stream
 *  | such as a terminal. In most cases, you will want to use either
 *  | `Console.log` or `Console.error`.
 */  
  var withGraphics = function (dictMonad) {
      return function (write) {
          return function (params) {
              return function (text) {
                  return Prelude.bind(dictMonad["__superclass_Prelude.Bind_1"]())(write(Ansi_Codes.escapeCodeToString(new Ansi_Codes.Graphics(params))))(function () {
                      return Prelude.bind(dictMonad["__superclass_Prelude.Bind_1"]())(write(text))(function () {
                          return write(Ansi_Codes.escapeCodeToString(new Ansi_Codes.Graphics([ Ansi_Codes.Reset.value ])));
                      });
                  });
              };
          };
      };
  };                                                               
  var foreground = function (c) {
      return [ new Ansi_Codes.PForeground(c) ];
  };                                                       
  var bold = [ new Ansi_Codes.PMode(Ansi_Codes.Bold.value) ];
  exports["foreground"] = foreground;
  exports["bold"] = bold;
  exports["withGraphics"] = withGraphics;
})(PS["Ansi.Output"] = PS["Ansi.Output"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines helper functions for working with `Apply` instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];

  /**
 *  | Combine two effectful actions, keeping only the result of the second.
 */  
  var $times$greater = function (dictApply) {
      return function (a) {
          return function (b) {
              return Prelude["<*>"](dictApply)(Prelude["<$>"](dictApply["__superclass_Prelude.Functor_0"]())(Prelude["const"](Prelude.id(Prelude.categoryFn)))(a))(b);
          };
      };
  };
  exports["*>"] = $times$greater;
})(PS["Control.Apply"] = PS["Control.Apply"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines helper functions for working with `Bind` instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];        

  /**
 *  | Forwards Kleisli composition.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | import Data.Array (head, tail)
 *  |
 *  | third = tail >=> tail >=> head
 *  | ```
 */  
  var $greater$eq$greater = function (dictBind) {
      return function (f) {
          return function (g) {
              return function (a) {
                  return Prelude[">>="](dictBind)(f(a))(g);
              };
          };
      };
  };

  /**
 *  | A version of `(>>=)` with its arguments flipped.
 */  
  var $eq$less$less = function (dictBind) {
      return function (f) {
          return function (m) {
              return Prelude[">>="](dictBind)(m)(f);
          };
      };
  };
  exports[">=>"] = $greater$eq$greater;
  exports["=<<"] = $eq$less$less;
})(PS["Control.Bind"] = PS["Control.Bind"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `Lazy` type class and associated
 *  | helper functions.
 */  
  "use strict";
  var Prelude = PS["Prelude"];        

  /**
 *  | The `Lazy` class represents types which allow evaluation of values
 *  | to be _deferred_.
 *  |
 *  | Usually, this means that a type contains a function arrow which can
 *  | be used to delay evaluation.
 */  
  var Lazy = function (defer) {
      this.defer = defer;
  };

  /**
 *  | The `Lazy` class represents types which allow evaluation of values
 *  | to be _deferred_.
 *  |
 *  | Usually, this means that a type contains a function arrow which can
 *  | be used to delay evaluation.
 */  
  var defer = function (dict) {
      return dict.defer;
  };
  exports["Lazy"] = Lazy;
  exports["defer"] = defer;
})(PS["Control.Lazy"] = PS["Control.Lazy"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines helper functions for working with `Monad` instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];        

  /**
 *  | Perform a monadic action when a condition is true.
 */  
  var when = function (dictMonad) {
      return function (v) {
          return function (v1) {
              if (v) {
                  return v1;
              };
              if (!v) {
                  return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())(Prelude.unit);
              };
              throw new Error("Failed pattern match at Control.Monad line 9, column 1 - line 10, column 1: " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };

  /**
 *  | Perform a monadic action unless a condition is true.
 */  
  var unless = function (dictMonad) {
      return function (v) {
          return function (v1) {
              if (!v) {
                  return v1;
              };
              if (v) {
                  return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())(Prelude.unit);
              };
              throw new Error("Failed pattern match at Control.Monad line 14, column 1 - line 15, column 1: " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };
  exports["unless"] = unless;
  exports["when"] = when;
})(PS["Control.Monad"] = PS["Control.Monad"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports._unsafeInterleaveAff = function (aff) {
    return aff;
  }

  exports._forkAff = function (nonCanceler, aff) {
    var voidF = function(){};

    return function(success, error) {
      var canceler = aff(voidF, voidF);

      try {
        success(canceler);
      } catch (err) {
        error(err);
      }

      return nonCanceler;
    };
  }

  exports._makeAff = function (cb) {
    return function(success, error) {
      return cb(function(e) {
        return function() {
          error(e);
        };
      })(function(v) {
        return function() {
          try {
            success(v);
          } catch (err) {
            error(err);
          }
        };
      })();
    }
  }

  exports._pure = function (nonCanceler, v) {
    return function(success, error) {
      try {
        success(v);
      } catch (err) {
        error(err);
      }

      return nonCanceler;
    };
  }

  exports._throwError = function (nonCanceler, e) {
    return function(success, error) {
      error(e);

      return nonCanceler;
    };
  }

  exports._fmap = function (f, aff) {
    return function(success, error) {
      return aff(function(v) {
        try {
          success(f(v));
        } catch (err) {
          error(err);
        }
      }, error);
    };
  }

  exports._bind = function (alwaysCanceler, aff, f) {
    return function(success, error) {
      var canceler1, canceler2;

      var isCanceled    = false;
      var requestCancel = false;

      var onCanceler = function(){};

      canceler1 = aff(function(v) {
        if (requestCancel) {
          isCanceled = true;

          return alwaysCanceler;
        } else {
          canceler2 = f(v)(success, error);

          onCanceler(canceler2);

          return canceler2;
        }
      }, error);

      return function(e) {
        return function(s, f) {
          requestCancel = true;

          if (canceler2 !== undefined) {
            return canceler2(e)(s, f);
          } else {
            return canceler1(e)(function(bool) {
              if (bool || isCanceled) {
                try {
                  s(true);
                } catch (err) {
                  f(err);
                }
              } else {
                onCanceler = function(canceler) {
                  canceler(e)(s, f);
                };
              }
            }, f);
          }
        };
      };
    };
  }

  exports._attempt = function (Left, Right, aff) {
    return function(success, error) {
      return aff(function(v) {
        try {
          success(Right(v));
        } catch (err) {
          error(err);
        }
      }, function(e) {
        try {
          success(Left(e));
        } catch (err) {
          error(err);
        }
      });
    };
  }

  exports._runAff = function (errorT, successT, aff) {
    return function() {
      return aff(function(v) {
        try {
          successT(v)();
        } catch (err) {
          errorT(err)();
        }
      }, function(e) {
        errorT(e)();
      });
    };
  }

  exports._liftEff = function (nonCanceler, e) {
    return function(success, error) {
      try {
        success(e());
      } catch (err) {
        error(err);
      }

      return nonCanceler;
    };
  }
})(PS["Control.Monad.Aff"] = PS["Control.Monad.Aff"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Control.Monad.Eff

  exports.returnE = function (a) {
    return function () {
      return a;
    };
  };

  exports.bindE = function (a) {
    return function (f) {
      return function () {
        return f(a())();
      };
    };
  };

  exports.runPure = function (f) {
    return f();
  };
})(PS["Control.Monad.Eff"] = PS["Control.Monad.Eff"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Control.Monad.Eff"];
  var Prelude = PS["Prelude"];        
  var monadEff = new Prelude.Monad(function () {
      return applicativeEff;
  }, function () {
      return bindEff;
  });
  var bindEff = new Prelude.Bind(function () {
      return applyEff;
  }, $foreign.bindE);
  var applyEff = new Prelude.Apply(function () {
      return functorEff;
  }, Prelude.ap(monadEff));
  var applicativeEff = new Prelude.Applicative(function () {
      return applyEff;
  }, $foreign.returnE);
  var functorEff = new Prelude.Functor(Prelude.liftA1(applicativeEff));
  exports["functorEff"] = functorEff;
  exports["applyEff"] = applyEff;
  exports["applicativeEff"] = applicativeEff;
  exports["bindEff"] = bindEff;
  exports["monadEff"] = monadEff;
  exports["runPure"] = $foreign.runPure;
})(PS["Control.Monad.Eff"] = PS["Control.Monad.Eff"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];        

  /**
 *  | The `MonadEff` class captures those monads which support native effects.
 *  |
 *  | Instances are provided for `Eff` itself, and the standard monad transformers.
 *  |
 *  | `liftEff` can be used in any appropriate monad transformer stack to lift an action
 *  | of type `Eff eff a` into the monad.
 *  |
 *  | Note that `MonadEff` is parameterized by the row of effects, so type inference can be
 *  | tricky. It is generally recommended to either work with a polymorphic row of effects,
 *  | or a concrete, closed row of effects such as `(trace :: Trace)`.
 */  
  var MonadEff = function (__superclass_Prelude$dotMonad_0, liftEff) {
      this["__superclass_Prelude.Monad_0"] = __superclass_Prelude$dotMonad_0;
      this.liftEff = liftEff;
  };
  var monadEffEff = new MonadEff(function () {
      return Control_Monad_Eff.monadEff;
  }, Prelude.id(Prelude.categoryFn));

  /**
 *  | The `MonadEff` class captures those monads which support native effects.
 *  |
 *  | Instances are provided for `Eff` itself, and the standard monad transformers.
 *  |
 *  | `liftEff` can be used in any appropriate monad transformer stack to lift an action
 *  | of type `Eff eff a` into the monad.
 *  |
 *  | Note that `MonadEff` is parameterized by the row of effects, so type inference can be
 *  | tricky. It is generally recommended to either work with a polymorphic row of effects,
 *  | or a concrete, closed row of effects such as `(trace :: Trace)`.
 */  
  var liftEff = function (dict) {
      return dict.liftEff;
  };
  exports["MonadEff"] = MonadEff;
  exports["liftEff"] = liftEff;
  exports["monadEffEff"] = monadEffEff;
})(PS["Control.Monad.Eff.Class"] = PS["Control.Monad.Eff.Class"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports.error = function (msg) {
    return new Error(msg);
  };

  exports.message = function (e) {
    return e.message;
  };

  exports.throwException = function (e) {
    return function () {
      throw e;
    };
  };

  exports.catchException = function (c) {
    return function (t) {
      return function () {
        try {
          return t();
        } catch (e) {
          if (e instanceof Error || Object.prototype.toString.call(e) === "[object Error]") {
            return c(e)();
          } else {
            return c(new Error(e.toString()))();
          }
        }
      };
    };
  };
})(PS["Control.Monad.Eff.Exception"] = PS["Control.Monad.Eff.Exception"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines an effect, actions and handlers for working
 *  | with JavaScript exceptions.
 */  
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Exception"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  exports["catchException"] = $foreign.catchException;
  exports["throwException"] = $foreign.throwException;
  exports["message"] = $foreign.message;
  exports["error"] = $foreign.error;
})(PS["Control.Monad.Eff.Exception"] = PS["Control.Monad.Eff.Exception"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Foldable

  exports.foldrArray = function (f) {
    return function (init) {
      return function (xs) {
        var acc = init;
        var len = xs.length;
        for (var i = len - 1; i >= 0; i--) {
          acc = f(xs[i])(acc);
        }
        return acc;
      };
    };
  };

  exports.foldlArray = function (f) {
    return function (init) {
      return function (xs) {
        var acc = init;
        var len = xs.length;
        for (var i = 0; i < len; i++) {
          acc = f(acc)(xs[i]);
        }
        return acc;
      };
    };
  };
})(PS["Data.Foldable"] = PS["Data.Foldable"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var semigroupFirst = new Prelude.Semigroup(function (v) {
      return function (v1) {
          if (v instanceof Data_Maybe.Just) {
              return v;
          };
          return v1;
      };
  });
  var runFirst = function (v) {
      return v;
  };
  var monoidFirst = new Data_Monoid.Monoid(function () {
      return semigroupFirst;
  }, Data_Maybe.Nothing.value);
  exports["runFirst"] = runFirst;
  exports["semigroupFirst"] = semigroupFirst;
  exports["monoidFirst"] = monoidFirst;
})(PS["Data.Maybe.First"] = PS["Data.Maybe.First"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Monoid = PS["Data.Monoid"];        

  /**
 *  | Monoid under conjuntion.
 *  |
 *  | ``` purescript
 *  | Conj x <> Conj y == Conj (x && y)
 *  | mempty :: Conj _ == Conj top
 *  | ```
 */  
  var Conj = function (x) {
      return x;
  };
  var semigroupConj = function (dictBooleanAlgebra) {
      return new Prelude.Semigroup(function (v) {
          return function (v1) {
              return Prelude.conj(dictBooleanAlgebra)(v)(v1);
          };
      });
  };
  var runConj = function (v) {
      return v;
  };
  var monoidConj = function (dictBooleanAlgebra) {
      return new Data_Monoid.Monoid(function () {
          return semigroupConj(dictBooleanAlgebra);
      }, Prelude.top(dictBooleanAlgebra["__superclass_Prelude.Bounded_0"]()));
  };
  exports["Conj"] = Conj;
  exports["runConj"] = runConj;
  exports["semigroupConj"] = semigroupConj;
  exports["monoidConj"] = monoidConj;
})(PS["Data.Monoid.Conj"] = PS["Data.Monoid.Conj"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Monoid = PS["Data.Monoid"];        

  /**
 *  | Monoid under disjuntion.
 *  |
 *  | ``` purescript
 *  | Disj x <> Disj y == Disj (x || y)
 *  | mempty :: Disj _ == Disj bottom
 *  | ```
 */  
  var Disj = function (x) {
      return x;
  };
  var semigroupDisj = function (dictBooleanAlgebra) {
      return new Prelude.Semigroup(function (v) {
          return function (v1) {
              return Prelude.disj(dictBooleanAlgebra)(v)(v1);
          };
      });
  };
  var runDisj = function (v) {
      return v;
  };
  var monoidDisj = function (dictBooleanAlgebra) {
      return new Data_Monoid.Monoid(function () {
          return semigroupDisj(dictBooleanAlgebra);
      }, Prelude.bottom(dictBooleanAlgebra["__superclass_Prelude.Bounded_0"]()));
  };
  exports["Disj"] = Disj;
  exports["runDisj"] = runDisj;
  exports["semigroupDisj"] = semigroupDisj;
  exports["monoidDisj"] = monoidDisj;
})(PS["Data.Monoid.Disj"] = PS["Data.Monoid.Disj"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Data.Foldable"];
  var Prelude = PS["Prelude"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_First = PS["Data.Maybe.First"];
  var Data_Maybe_Last = PS["Data.Maybe.Last"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Monoid_Additive = PS["Data.Monoid.Additive"];
  var Data_Monoid_Conj = PS["Data.Monoid.Conj"];
  var Data_Monoid_Disj = PS["Data.Monoid.Disj"];
  var Data_Monoid_Dual = PS["Data.Monoid.Dual"];
  var Data_Monoid_Endo = PS["Data.Monoid.Endo"];
  var Data_Monoid_Multiplicative = PS["Data.Monoid.Multiplicative"];        

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var Foldable = function (foldMap, foldl, foldr) {
      this.foldMap = foldMap;
      this.foldl = foldl;
      this.foldr = foldr;
  };

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var foldr = function (dict) {
      return dict.foldr;
  };

  /**
 *  | Traverse a data structure, performing some effects encoded by an
 *  | `Applicative` functor at each value, ignoring the final result.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | traverse_ print [1, 2, 3]
 *  | ```
 */  
  var traverse_ = function (dictApplicative) {
      return function (dictFoldable) {
          return function (f) {
              return foldr(dictFoldable)(function ($161) {
                  return Control_Apply["*>"](dictApplicative["__superclass_Prelude.Apply_0"]())(f($161));
              })(Prelude.pure(dictApplicative)(Prelude.unit));
          };
      };
  };

  /**
 *  | A version of `traverse_` with its arguments flipped.
 *  |
 *  | This can be useful when running an action written using do notation
 *  | for every element in a data structure:
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | for_ [1, 2, 3] \n -> do
 *  |   print n
 *  |   trace "squared is"
 *  |   print (n * n)
 *  | ```
 */  
  var for_ = function (dictApplicative) {
      return function (dictFoldable) {
          return Prelude.flip(traverse_(dictApplicative)(dictFoldable));
      };
  };

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var foldl = function (dict) {
      return dict.foldl;
  };

  /**
 *  | Find the largest element of a structure, according to a given comparison
 *  | function. The comparison function should represent a total ordering (see
 *  | the `Ord` type class laws); if it does not, the behaviour is undefined.
 */  
  var maximumBy = function (dictFoldable) {
      return function (cmp) {
          var max$prime = function (v) {
              return function (v1) {
                  if (v instanceof Data_Maybe.Nothing) {
                      return new Data_Maybe.Just(v1);
                  };
                  if (v instanceof Data_Maybe.Just) {
                      return new Data_Maybe.Just((function () {
                          var $87 = cmp(v.value0)(v1);
                          if ($87 instanceof Prelude.GT) {
                              return v.value0;
                          };
                          return v1;
                      })());
                  };
                  throw new Error("Failed pattern match at Data.Foldable line 246, column 3 - line 247, column 3: " + [ v.constructor.name, v1.constructor.name ]);
              };
          };
          return foldl(dictFoldable)(max$prime)(Data_Maybe.Nothing.value);
      };
  };

  /**
 *  | Find the largest element of a structure, according to its `Ord` instance.
 */  
  var maximum = function (dictOrd) {
      return function (dictFoldable) {
          return maximumBy(dictFoldable)(Prelude.compare(dictOrd));
      };
  };

  /**
 *  | Fold a data structure, accumulating values in some `Monoid`.
 */  
  var mconcat = function (dictFoldable) {
      return function (dictMonoid) {
          return foldl(dictFoldable)(Prelude["<>"](dictMonoid["__superclass_Prelude.Semigroup_0"]()))(Data_Monoid.mempty(dictMonoid));
      };
  }; 

  /**
 *  | A default implementation of `foldMap` using `foldr`.
 *  |
 *  | Note: when defining a `Foldable` instance, this function is unsafe to use
 *  | in combination with `foldrDefault`.
 */  
  var foldMapDefaultR = function (dictFoldable) {
      return function (dictMonoid) {
          return function (f) {
              return function (xs) {
                  return foldr(dictFoldable)(function (x) {
                      return function (acc) {
                          return Prelude["<>"](dictMonoid["__superclass_Prelude.Semigroup_0"]())(f(x))(acc);
                      };
                  })(Data_Monoid.mempty(dictMonoid))(xs);
              };
          };
      };
  };
  var foldableArray = new Foldable(function (dictMonoid) {
      return foldMapDefaultR(foldableArray)(dictMonoid);
  }, $foreign.foldlArray, $foreign.foldrArray);

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var foldMap = function (dict) {
      return dict.foldMap;
  };

  /**
 *  | Fold a data structure, accumulating values in some `Monoid`.
 */  
  var fold = function (dictFoldable) {
      return function (dictMonoid) {
          return foldMap(dictFoldable)(dictMonoid)(Prelude.id(Prelude.categoryFn));
      };
  };

  /**
 *  | Try to find an element in a data structure which satisfies a predicate.
 */  
  var find = function (dictFoldable) {
      return function (p) {
          return foldl(dictFoldable)(function (r) {
              return function (x) {
                  var $160 = p(x);
                  if ($160) {
                      return new Data_Maybe.Just(x);
                  };
                  if (!$160) {
                      return r;
                  };
                  throw new Error("Failed pattern match at Data.Foldable line 234, column 25 - line 234, column 50: " + [ $160.constructor.name ]);
              };
          })(Data_Maybe.Nothing.value);
      };
  };

  /**
 *  | Test whether a predicate holds for any element in a data structure.
 */  
  var any = function (dictFoldable) {
      return function (dictBooleanAlgebra) {
          return function (p) {
              return function ($164) {
                  return Data_Monoid_Disj.runDisj(foldMap(dictFoldable)(Data_Monoid_Disj.monoidDisj(dictBooleanAlgebra))(function ($165) {
                      return Data_Monoid_Disj.Disj(p($165));
                  })($164));
              };
          };
      };
  };

  /**
 *  | Test whether a value is an element of a data structure.
 */  
  var elem = function (dictFoldable) {
      return function (dictEq) {
          return function ($166) {
              return any(dictFoldable)(Prelude.booleanAlgebraBoolean)(Prelude["=="](dictEq)($166));
          };
      };
  };

  /**
 *  | Test whether a value is not an element of a data structure.
 */  
  var notElem = function (dictFoldable) {
      return function (dictEq) {
          return function (x) {
              return function ($167) {
                  return !elem(dictFoldable)(dictEq)(x)($167);
              };
          };
      };
  };

  /**
 *  | Test whether a predicate holds for all elements in a data structure.
 */  
  var all = function (dictFoldable) {
      return function (dictBooleanAlgebra) {
          return function (p) {
              return function ($168) {
                  return Data_Monoid_Conj.runConj(foldMap(dictFoldable)(Data_Monoid_Conj.monoidConj(dictBooleanAlgebra))(function ($169) {
                      return Data_Monoid_Conj.Conj(p($169));
                  })($168));
              };
          };
      };
  };
  exports["Foldable"] = Foldable;
  exports["maximumBy"] = maximumBy;
  exports["maximum"] = maximum;
  exports["find"] = find;
  exports["notElem"] = notElem;
  exports["elem"] = elem;
  exports["all"] = all;
  exports["any"] = any;
  exports["mconcat"] = mconcat;
  exports["for_"] = for_;
  exports["traverse_"] = traverse_;
  exports["fold"] = fold;
  exports["foldMapDefaultR"] = foldMapDefaultR;
  exports["foldMap"] = foldMap;
  exports["foldl"] = foldl;
  exports["foldr"] = foldr;
  exports["foldableArray"] = foldableArray;
})(PS["Data.Foldable"] = PS["Data.Foldable"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Traversable

  // jshint maxparams: 3

  exports.traverseArrayImpl = function () {
    function Cont (fn) {
      this.fn = fn;
    }

    var emptyList = {};

    var ConsCell = function (head, tail) {
      this.head = head;
      this.tail = tail;
    };

    function consList (x) {
      return function (xs) {
        return new ConsCell(x, xs);
      };
    }

    function listToArray (list) {
      var arr = [];
      while (list !== emptyList) {
        arr.push(list.head);
        list = list.tail;
      }
      return arr;
    }

    return function (apply) {
      return function (map) {
        return function (pure) {
          return function (f) {
            var buildFrom = function (x, ys) {
              return apply(map(consList)(f(x)))(ys);
            };

            var go = function (acc, currentLen, xs) {
              if (currentLen === 0) {
                return acc;
              } else {
                var last = xs[currentLen - 1];
                return new Cont(function () {
                  return go(buildFrom(last, acc), currentLen - 1, xs);
                });
              }
            };

            return function (array) {
              var result = go(pure(emptyList), array.length, array);
              while (result instanceof Cont) {
                result = result.fn();
              }

              return map(listToArray)(result);
            };
          };
        };
      };
    };
  }();
})(PS["Data.Traversable"] = PS["Data.Traversable"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Data.Traversable"];
  var Prelude = PS["Prelude"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_First = PS["Data.Maybe.First"];
  var Data_Maybe_Last = PS["Data.Maybe.Last"];
  var Data_Monoid_Additive = PS["Data.Monoid.Additive"];
  var Data_Monoid_Conj = PS["Data.Monoid.Conj"];
  var Data_Monoid_Disj = PS["Data.Monoid.Disj"];
  var Data_Monoid_Dual = PS["Data.Monoid.Dual"];
  var Data_Monoid_Multiplicative = PS["Data.Monoid.Multiplicative"];

  /**
 *  | `Traversable` represents data structures which can be _traversed_,
 *  | accumulating results and effects in some `Applicative` functor.
 *  |
 *  | - `traverse` runs an action for every element in a data structure,
 *  |   and accumulates the results.
 *  | - `sequence` runs the actions _contained_ in a data structure,
 *  |   and accumulates the results.
 *  |
 *  | The `traverse` and `sequence` functions should be compatible in the
 *  | following sense:
 *  |
 *  | - `traverse f xs = sequence (f <$> xs)`
 *  | - `sequence = traverse id`
 *  |
 *  | `Traversable` instances should also be compatible with the corresponding
 *  | `Foldable` instances, in the following sense:
 *  |
 *  | - `foldMap f = runConst <<< traverse (Const <<< f)`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `traverseDefault`
 *  | - `sequenceDefault`
 */  
  var Traversable = function (__superclass_Data$dotFoldable$dotFoldable_1, __superclass_Prelude$dotFunctor_0, sequence, traverse) {
      this["__superclass_Data.Foldable.Foldable_1"] = __superclass_Data$dotFoldable$dotFoldable_1;
      this["__superclass_Prelude.Functor_0"] = __superclass_Prelude$dotFunctor_0;
      this.sequence = sequence;
      this.traverse = traverse;
  };

  /**
 *  | `Traversable` represents data structures which can be _traversed_,
 *  | accumulating results and effects in some `Applicative` functor.
 *  |
 *  | - `traverse` runs an action for every element in a data structure,
 *  |   and accumulates the results.
 *  | - `sequence` runs the actions _contained_ in a data structure,
 *  |   and accumulates the results.
 *  |
 *  | The `traverse` and `sequence` functions should be compatible in the
 *  | following sense:
 *  |
 *  | - `traverse f xs = sequence (f <$> xs)`
 *  | - `sequence = traverse id`
 *  |
 *  | `Traversable` instances should also be compatible with the corresponding
 *  | `Foldable` instances, in the following sense:
 *  |
 *  | - `foldMap f = runConst <<< traverse (Const <<< f)`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `traverseDefault`
 *  | - `sequenceDefault`
 */  
  var traverse = function (dict) {
      return dict.traverse;
  };

  /**
 *  | A default implementation of `sequence` using `traverse`.
 */  
  var sequenceDefault = function (dictTraversable) {
      return function (dictApplicative) {
          return function (tma) {
              return traverse(dictTraversable)(dictApplicative)(Prelude.id(Prelude.categoryFn))(tma);
          };
      };
  };
  var traversableArray = new Traversable(function () {
      return Data_Foldable.foldableArray;
  }, function () {
      return Prelude.functorArray;
  }, function (dictApplicative) {
      return sequenceDefault(traversableArray)(dictApplicative);
  }, function (dictApplicative) {
      return $foreign.traverseArrayImpl(Prelude.apply(dictApplicative["__superclass_Prelude.Apply_0"]()))(Prelude.map((dictApplicative["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]()))(Prelude.pure(dictApplicative));
  });

  /**
 *  | `Traversable` represents data structures which can be _traversed_,
 *  | accumulating results and effects in some `Applicative` functor.
 *  |
 *  | - `traverse` runs an action for every element in a data structure,
 *  |   and accumulates the results.
 *  | - `sequence` runs the actions _contained_ in a data structure,
 *  |   and accumulates the results.
 *  |
 *  | The `traverse` and `sequence` functions should be compatible in the
 *  | following sense:
 *  |
 *  | - `traverse f xs = sequence (f <$> xs)`
 *  | - `sequence = traverse id`
 *  |
 *  | `Traversable` instances should also be compatible with the corresponding
 *  | `Foldable` instances, in the following sense:
 *  |
 *  | - `foldMap f = runConst <<< traverse (Const <<< f)`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `traverseDefault`
 *  | - `sequenceDefault`
 */  
  var sequence = function (dict) {
      return dict.sequence;
  }; 

  /**
 *  | A version of `traverse` with its arguments flipped.
 *  |
 *  |
 *  | This can be useful when running an action written using do notation
 *  | for every element in a data structure:
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | for [1, 2, 3] \n -> do
 *  |   print n
 *  |   return (n * n)
 *  | ```
 */  
  var $$for = function (dictApplicative) {
      return function (dictTraversable) {
          return function (x) {
              return function (f) {
                  return traverse(dictTraversable)(dictApplicative)(f)(x);
              };
          };
      };
  };
  exports["Traversable"] = Traversable;
  exports["for"] = $$for;
  exports["sequenceDefault"] = sequenceDefault;
  exports["sequence"] = sequence;
  exports["traverse"] = traverse;
  exports["traversableArray"] = traversableArray;
})(PS["Data.Traversable"] = PS["Data.Traversable"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Bifoldable = PS["Data.Bifoldable"];
  var Data_Bifunctor = PS["Data.Bifunctor"];
  var Data_Bitraversable = PS["Data.Bitraversable"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];        

  /**
 *  | The `Either` type is used to represent a choice between two types of value.
 *  |
 *  | A common use case for `Either` is error handling, where `Left` is used to
 *  | carry an error value and `Right` is used to carry a success value.
 */  
  var Left = (function () {
      function Left(value0) {
          this.value0 = value0;
      };
      Left.create = function (value0) {
          return new Left(value0);
      };
      return Left;
  })();

  /**
 *  | The `Either` type is used to represent a choice between two types of value.
 *  |
 *  | A common use case for `Either` is error handling, where `Left` is used to
 *  | carry an error value and `Right` is used to carry a success value.
 */  
  var Right = (function () {
      function Right(value0) {
          this.value0 = value0;
      };
      Right.create = function (value0) {
          return new Right(value0);
      };
      return Right;
  })();

  /**
 *  | The `Functor` instance allows functions to transform the contents of a
 *  | `Right` with the `<$>` operator:
 *  |
 *  | ``` purescript
 *  | f <$> Right x == Right (f x)
 *  | ```
 *  |
 *  | `Left` values are untouched:
 *  |
 *  | ``` purescript
 *  | f <$> Left y == Left y
 *  | ```
 */  
  var functorEither = new Prelude.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Left) {
              return new Left(v1.value0);
          };
          if (v1 instanceof Right) {
              return new Right(v(v1.value0));
          };
          throw new Error("Failed pattern match at Data.Either line 53, column 3 - line 54, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | Takes two functions and an `Either` value, if the value is a `Left` the
 *  | inner value is applied to the first function, if the value is a `Right`
 *  | the inner value is applied to the second function.
 *  |
 *  | ``` purescript
 *  | either f g (Left x) == f x
 *  | either f g (Right y) == g y
 *  | ```
 */  
  var either = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Left) {
                  return v(v2.value0);
              };
              if (v2 instanceof Right) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Either line 29, column 1 - line 30, column 1: " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  }; 

  /**
 *  | The `Apply` instance allows functions contained within a `Right` to
 *  | transform a value contained within a `Right` using the `(<*>)` operator:
 *  |
 *  | ``` purescript
 *  | Right f <*> Right x == Right (f x)
 *  | ```
 *  |
 *  | `Left` values are left untouched:
 *  |
 *  | ``` purescript
 *  | Left f <*> Right x == Left x
 *  | Right f <*> Left y == Left y
 *  | ```
 *  |
 *  | Combining `Functor`'s `<$>` with `Apply`'s `<*>` can be used transform a
 *  | pure function to take `Either`-typed arguments so `f :: a -> b -> c`
 *  | becomes `f :: Either l a -> Either l b -> Either l c`:
 *  |
 *  | ``` purescript
 *  | f <$> Right x <*> Right y == Right (f x y)
 *  | ```
 *  |
 *  | The `Left`-preserving behaviour of both operators means the result of
 *  | an expression like the above but where any one of the values is `Left`
 *  | means the whole result becomes `Left` also, taking the first `Left` value
 *  | found:
 *  |
 *  | ``` purescript
 *  | f <$> Left x <*> Right y == Left x
 *  | f <$> Right x <*> Left y == Left y
 *  | f <$> Left x <*> Left y == Left x
 *  | ```
 */  
  var applyEither = new Prelude.Apply(function () {
      return functorEither;
  }, function (v) {
      return function (v1) {
          if (v instanceof Left) {
              return new Left(v.value0);
          };
          if (v instanceof Right) {
              return Prelude["<$>"](functorEither)(v.value0)(v1);
          };
          throw new Error("Failed pattern match at Data.Either line 93, column 3 - line 94, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | The `Bind` instance allows sequencing of `Either` values and functions that
 *  | return an `Either` by using the `>>=` operator:
 *  |
 *  | ``` purescript
 *  | Left x >>= f = Left x
 *  | Right x >>= f = f x
 *  | ```
 */  
  var bindEither = new Prelude.Bind(function () {
      return applyEither;
  }, either(function (e) {
      return function (v) {
          return new Left(e);
      };
  })(function (a) {
      return function (f) {
          return f(a);
      };
  }));

  /**
 *  | The `Applicative` instance enables lifting of values into `Either` with the
 *  | `pure` or `return` function (`return` is an alias for `pure`):
 *  |
 *  | ``` purescript
 *  | pure x :: Either _ _ == Right x
 *  | return x :: Either _ _ == Right x
 *  | ```
 *  |
 *  | Combining `Functor`'s `<$>` with `Apply`'s `<*>` and `Applicative`'s
 *  | `pure` can be used to pass a mixture of `Either` and non-`Either` typed
 *  | values to a function that does not usually expect them, by using `pure`
 *  | for any value that is not already `Either` typed:
 *  |
 *  | ``` purescript
 *  | f <$> Right x <*> pure y == Right (f x y)
 *  | ```
 *  |
 *  | Even though `pure = Right` it is recommended to use `pure` in situations
 *  | like this as it allows the choice of `Applicative` to be changed later
 *  | without having to go through and replace `Right` with a new constructor.
 */  
  var applicativeEither = new Prelude.Applicative(function () {
      return applyEither;
  }, Right.create);
  exports["Left"] = Left;
  exports["Right"] = Right;
  exports["either"] = either;
  exports["functorEither"] = functorEither;
  exports["applyEither"] = applyEither;
  exports["applicativeEither"] = applicativeEither;
  exports["bindEither"] = bindEither;
})(PS["Data.Either"] = PS["Data.Either"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `MonadError` type class and its instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];        

  /**
 *  | The `MonadError` type class represents those monads which support errors via
 *  | `throwError` and `catchError`.
 *  |
 *  | - `throwError e` throws the error `e`
 *  | - `catchError x f` calls the error handler `f` if an error is thrown during the
 *  |   evaluation of `x`.
 *  |
 *  | An implementation is provided for `ErrorT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - Left zero: `throwError e >>= f = throwError e`
 *  | - Catch: `catchError (throwError e) f = f e`
 *  | - Pure: `catchError (pure a) f = pure a`
 *  |
 */  
  var MonadError = function (__superclass_Prelude$dotMonad_0, catchError, throwError) {
      this["__superclass_Prelude.Monad_0"] = __superclass_Prelude$dotMonad_0;
      this.catchError = catchError;
      this.throwError = throwError;
  };

  /**
 *  | The `MonadError` type class represents those monads which support errors via
 *  | `throwError` and `catchError`.
 *  |
 *  | - `throwError e` throws the error `e`
 *  | - `catchError x f` calls the error handler `f` if an error is thrown during the
 *  |   evaluation of `x`.
 *  |
 *  | An implementation is provided for `ErrorT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - Left zero: `throwError e >>= f = throwError e`
 *  | - Catch: `catchError (throwError e) f = f e`
 *  | - Pure: `catchError (pure a) f = pure a`
 *  |
 */  
  var throwError = function (dict) {
      return dict.throwError;
  };                          

  /**
 *  | The `MonadError` type class represents those monads which support errors via
 *  | `throwError` and `catchError`.
 *  |
 *  | - `throwError e` throws the error `e`
 *  | - `catchError x f` calls the error handler `f` if an error is thrown during the
 *  |   evaluation of `x`.
 *  |
 *  | An implementation is provided for `ErrorT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - Left zero: `throwError e >>= f = throwError e`
 *  | - Catch: `catchError (throwError e) f = f e`
 *  | - Pure: `catchError (pure a) f = pure a`
 *  |
 */  
  var catchError = function (dict) {
      return dict.catchError;
  };

  /**
 *  | This function allows you to provide a predicate for selecting the
 *  | exceptions that you're interested in, and handle only those exceptons.
 *  | If the inner computation throws an exception, and the predicate returns
 *  | Nothing, then the whole computation will still fail with that exception.
 */  
  var catchJust = function (dictMonadError) {
      return function (p) {
          return function (act) {
              return function (handler) {
                  var handle = function (e) {
                      var $12 = p(e);
                      if ($12 instanceof Data_Maybe.Nothing) {
                          return throwError(dictMonadError)(e);
                      };
                      if ($12 instanceof Data_Maybe.Just) {
                          return handler($12.value0);
                      };
                      throw new Error("Failed pattern match at Control.Monad.Error.Class line 42, column 5 - line 46, column 1: " + [ $12.constructor.name ]);
                  };
                  return catchError(dictMonadError)(act)(handle);
              };
          };
      };
  };
  exports["MonadError"] = MonadError;
  exports["catchJust"] = catchJust;
  exports["catchError"] = catchError;
  exports["throwError"] = throwError;
})(PS["Control.Monad.Error.Class"] = PS["Control.Monad.Error.Class"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports.runFn2 = function (fn) {
    return function (a) {
      return function (b) {
        return fn(a, b);
      };
    };
  };

  exports.runFn4 = function (fn) {
    return function (a) {
      return function (b) {
        return function (c) {
          return function (d) {
            return fn(a, b, c, d);
          };
        };
      };
    };
  };
})(PS["Data.Function"] = PS["Data.Function"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Data.Function"];
  var Prelude = PS["Prelude"];        

  /**
 *  | The `on` function is used to change the domain of a binary operator.
 *  |
 *  | For example, we can create a function which compares two records based on the values of their `x` properties:
 *  |
 *  | ```purescript
 *  | compareX :: forall r. { x :: Number | r } -> { x :: Number | r } -> Ordering
 *  | compareX = compare `on` _.x
 *  | ```
 */  
  var on = function (f) {
      return function (g) {
          return function (x) {
              return function (y) {
                  return f(g(x))(g(y));
              };
          };
      };
  };
  exports["on"] = on;
  exports["runFn4"] = $foreign.runFn4;
  exports["runFn2"] = $foreign.runFn2;
})(PS["Data.Function"] = PS["Data.Function"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Control.Monad.Aff"];
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Monad_Cont_Class = PS["Control.Monad.Cont.Class"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Function = PS["Data.Function"];
  var Data_Monoid = PS["Data.Monoid"];

  /**
 *  | Runs the asynchronous computation. You must supply an error callback and a
 *  | success callback.
 */  
  var runAff = function (ex) {
      return function (f) {
          return function (aff) {
              return $foreign._runAff(ex, f, aff);
          };
      };
  };

  /**
 *  | Creates an asynchronous effect from a function that accepts error and
 *  | success callbacks, and returns a canceler for the computation. This
 *  | function can be used for asynchronous computations that can be canceled.
 */  
  var makeAff$prime = function (h) {
      return $foreign._makeAff(h);
  };

  /**
 *  | Converts the asynchronous computation into a synchronous one. All values
 *  | are ignored, and if the computation produces an error, it is thrown.
 *  |
 *  | Catching exceptions by using `catchException` with the resulting Eff
 *  | computation is not recommended, as exceptions may end up being thrown
 *  | asynchronously, in which case they cannot be caught.
 *  |
 *  | If you do need to handle exceptions, you can use `runAff` instead, or
 *  | you can handle the exception within the Aff computation, using
 *  | `catchError` (or any of the other mechanisms).
 */  
  var launchAff = function ($20) {
      return runAff(Control_Monad_Eff_Exception.throwException)(Prelude["const"](Prelude.pure(Control_Monad_Eff.applicativeEff)(Prelude.unit)))($foreign._unsafeInterleaveAff($20));
  };
  var functorAff = new Prelude.Functor(function (f) {
      return function (fa) {
          return $foreign._fmap(f, fa);
      };
  });

  /**
 *  | Promotes any error to the value level of the asynchronous monad.
 */  
  var attempt = function (aff) {
      return $foreign._attempt(Data_Either.Left.create, Data_Either.Right.create, aff);
  };

  /**
 *  | Ignores any errors.
 */  
  var apathize = function (a) {
      return Prelude["<$>"](functorAff)(Prelude["const"](Prelude.unit))(attempt(a));
  };
  var applyAff = new Prelude.Apply(function () {
      return functorAff;
  }, function (ff) {
      return function (fa) {
          return $foreign._bind(alwaysCanceler, ff, function (f) {
              return Prelude["<$>"](functorAff)(f)(fa);
          });
      };
  });
  var applicativeAff = new Prelude.Applicative(function () {
      return applyAff;
  }, function (v) {
      return $foreign._pure(nonCanceler, v);
  });
  var nonCanceler = Prelude["const"](Prelude.pure(applicativeAff)(false));
  var alwaysCanceler = Prelude["const"](Prelude.pure(applicativeAff)(true));

  /**
 *  | Forks the specified asynchronous computation so subsequent computations
 *  | will not block on the result of the computation.
 *  |
 *  | Returns a canceler that can be used to attempt cancellation of the
 *  | forked computation.
 */  
  var forkAff = function (aff) {
      return $foreign._forkAff(nonCanceler, aff);
  };

  /**
 *  | Creates an asynchronous effect from a function that accepts error and
 *  | success callbacks. This function can be used for asynchronous computations
 *  | that cannot be canceled.
 */  
  var makeAff = function (h) {
      return makeAff$prime(function (e) {
          return function (a) {
              return Prelude["<$>"](Control_Monad_Eff.functorEff)(Prelude["const"](nonCanceler))(h(e)(a));
          };
      });
  };                                                       
  var bindAff = new Prelude.Bind(function () {
      return applyAff;
  }, function (fa) {
      return function (f) {
          return $foreign._bind(alwaysCanceler, fa, f);
      };
  });
  var monadAff = new Prelude.Monad(function () {
      return applicativeAff;
  }, function () {
      return bindAff;
  });
  var monadEffAff = new Control_Monad_Eff_Class.MonadEff(function () {
      return monadAff;
  }, function (eff) {
      return $foreign._liftEff(nonCanceler, eff);
  });

  /**
 *  | Allows users to catch and throw errors on the error channel of the
 *  | asynchronous computation. See documentation in `purescript-transformers`.
 */  
  var monadErrorAff = new Control_Monad_Error_Class.MonadError(function () {
      return monadAff;
  }, function (aff) {
      return function (ex) {
          return Prelude[">>="](bindAff)(attempt(aff))(Data_Either.either(ex)(Prelude.pure(applicativeAff)));
      };
  }, function (e) {
      return $foreign._throwError(nonCanceler, e);
  });
  exports["runAff"] = runAff;
  exports["nonCanceler"] = nonCanceler;
  exports["makeAff"] = makeAff;
  exports["launchAff"] = launchAff;
  exports["forkAff"] = forkAff;
  exports["attempt"] = attempt;
  exports["apathize"] = apathize;
  exports["functorAff"] = functorAff;
  exports["applyAff"] = applyAff;
  exports["applicativeAff"] = applicativeAff;
  exports["bindAff"] = bindAff;
  exports["monadAff"] = monadAff;
  exports["monadEffAff"] = monadEffAff;
  exports["monadErrorAff"] = monadErrorAff;
})(PS["Control.Monad.Aff"] = PS["Control.Monad.Aff"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Control.Monad.Aff.AVar

  exports._makeVar = function (nonCanceler) {
    return function(success, error) {
      try {
        success({
          consumers: [],
          producers: [],
          error: undefined
        });
      } catch (err) {
        error(err);
      }

      return nonCanceler;
    }
  }

  exports._takeVar = function (nonCanceler, avar) {
    return function(success, error) {
      if (avar.error !== undefined) {
        error(avar.error);
      } else if (avar.producers.length > 0) {
        var producer = avar.producers.shift();

        producer(success, error);
      } else {
        avar.consumers.push({success: success, error: error});
      }

      return nonCanceler;
    }
  }

  exports._putVar = function (nonCanceler, avar, a) {
    return function(success, error) {
      if (avar.error !== undefined) {
        error(avar.error);
      } else if (avar.consumers.length === 0) {
        avar.producers.push(function(success, error) {
          try {
            success(a);
          } catch (err) {
            error(err);
          }
        });

        success({});
      } else {
        var consumer = avar.consumers.shift();

        try {
          consumer.success(a);
        } catch (err) {
          error(err);

          return;
        }

        success({});
      }

      return nonCanceler;
    }
  }
})(PS["Control.Monad.Aff.AVar"] = PS["Control.Monad.Aff.AVar"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | A low-level primitive for building asynchronous code.
 */  
  "use strict";
  var $foreign = PS["Control.Monad.Aff.AVar"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_Function = PS["Data.Function"];        

  /**
 *  | Takes the next value from the asynchronous avar.
 */  
  var takeVar = function (q) {
      return $foreign._takeVar(Control_Monad_Aff.nonCanceler, q);
  };

  /**
 *  | Puts a new value into the asynchronous avar. If the avar has
 *  | been killed, this will result in an error.
 */  
  var putVar = function (q) {
      return function (a) {
          return $foreign._putVar(Control_Monad_Aff.nonCanceler, q, a);
      };
  };

  /**
 *  | Makes a new asynchronous avar.
 */  
  var makeVar = $foreign._makeVar(Control_Monad_Aff.nonCanceler);
  exports["takeVar"] = takeVar;
  exports["putVar"] = putVar;
  exports["makeVar"] = makeVar;
})(PS["Control.Monad.Aff.AVar"] = PS["Control.Monad.Aff.AVar"] || {});
(function(exports) {
  /* global exports, console */
  "use strict";

  // module Control.Monad.Eff.Console

  exports.log = function (s) {
    return function () {
      console.log(s);
      return {};
    };
  };

  exports.error = function (s) {
    return function () {
      console.error(s);
      return {};
    };
  };
})(PS["Control.Monad.Eff.Console"] = PS["Control.Monad.Eff.Console"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Console-related functions and effect type.
 */  
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Console"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  exports["error"] = $foreign.error;
  exports["log"] = $foreign.log;
})(PS["Control.Monad.Eff.Console"] = PS["Control.Monad.Eff.Console"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Control.Monad.Eff.Unsafe

  exports.unsafeInterleaveEff = function (f) {
    return f;
  };
})(PS["Control.Monad.Eff.Unsafe"] = PS["Control.Monad.Eff.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Unsafe"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];        

  /**
 *  | Run an effectful computation. Note: use of this function can result in
 *  | arbitrary side-effects.
 */  
  var unsafePerformEff = function ($0) {
      return Control_Monad_Eff.runPure($foreign.unsafeInterleaveEff($0));
  };
  exports["unsafePerformEff"] = unsafePerformEff;
  exports["unsafeInterleaveEff"] = $foreign.unsafeInterleaveEff;
})(PS["Control.Monad.Eff.Unsafe"] = PS["Control.Monad.Eff.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];        

  /**
 *  | Throw an exception in pure code. This function should be used very
 *  | sparingly, as it can cause unexpected crashes at runtime.
 */  
  var unsafeThrowException = function ($0) {
      return Control_Monad_Eff_Unsafe.unsafePerformEff(Control_Monad_Eff_Exception.throwException($0));
  };

  /**
 *  | Defined as `unsafeThrowException <<< error`.
 */  
  var unsafeThrow = function ($1) {
      return unsafeThrowException(Control_Monad_Eff_Exception.error($1));
  };
  exports["unsafeThrow"] = unsafeThrow;
  exports["unsafeThrowException"] = unsafeThrowException;
})(PS["Control.Monad.Eff.Exception.Unsafe"] = PS["Control.Monad.Eff.Exception.Unsafe"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Control.Monad.ST

  exports.newSTRef = function (val) {
    return function () {
      return { value: val };
    };
  };

  exports.readSTRef = function (ref) {
    return function () {
      return ref.value;
    };
  };

  exports.writeSTRef = function (ref) {
    return function (a) {
      return function () {
        /* jshint boss: true */
        return ref.value = a;
      };
    };
  };
})(PS["Control.Monad.ST"] = PS["Control.Monad.ST"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Control.Monad.ST"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  exports["writeSTRef"] = $foreign.writeSTRef;
  exports["readSTRef"] = $foreign.readSTRef;
  exports["newSTRef"] = $foreign.newSTRef;
})(PS["Control.Monad.ST"] = PS["Control.Monad.ST"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | A data type and functions for working with ordered pairs.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Biapplicative = PS["Control.Biapplicative"];
  var Control_Biapply = PS["Control.Biapply"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Control_Lazy = PS["Control.Lazy"];
  var Data_Bifoldable = PS["Data.Bifoldable"];
  var Data_Bifunctor = PS["Data.Bifunctor"];
  var Data_Bitraversable = PS["Data.Bitraversable"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_First = PS["Data.Maybe.First"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];        

  /**
 *  | A simple product type for wrapping a pair of component values.
 */  
  var Tuple = (function () {
      function Tuple(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Tuple.create = function (value0) {
          return function (value1) {
              return new Tuple(value0, value1);
          };
      };
      return Tuple;
  })();

  /**
 *  | Returns the second component of a tuple.
 */  
  var snd = function (v) {
      return v.value1;
  };

  /**
 *  | Allows `Tuple`s to be rendered as a string with `show` whenever there are
 *  | `Show` instances for both component types.
 */  
  var showTuple = function (dictShow) {
      return function (dictShow1) {
          return new Prelude.Show(function (v) {
              return "Tuple (" + (Prelude.show(dictShow)(v.value0) + (") (" + (Prelude.show(dictShow1)(v.value1) + ")")));
          });
      };
  }; 

  /**
 *  | The `Semigroup` instance enables use of the associative operator `<>` on
 *  | `Tuple`s whenever there are `Semigroup` instances for the component
 *  | types. The `<>` operator is applied pairwise, so:
 *  | ```purescript
 *  | (Tuple a1 b1) <> (Tuple a2 b2) = Tuple (a1 <> a2) (b1 <> b2)
 *  | ```
 */  
  var semigroupTuple = function (dictSemigroup) {
      return function (dictSemigroup1) {
          return new Prelude.Semigroup(function (v) {
              return function (v1) {
                  return new Tuple(Prelude["<>"](dictSemigroup)(v.value0)(v1.value0), Prelude["<>"](dictSemigroup1)(v.value1)(v1.value1));
              };
          });
      };
  };
  var monoidTuple = function (dictMonoid) {
      return function (dictMonoid1) {
          return new Data_Monoid.Monoid(function () {
              return semigroupTuple(dictMonoid["__superclass_Prelude.Semigroup_0"]())(dictMonoid1["__superclass_Prelude.Semigroup_0"]());
          }, new Tuple(Data_Monoid.mempty(dictMonoid), Data_Monoid.mempty(dictMonoid1)));
      };
  };

  /**
 *  | Lookup a value in a data structure of `Tuple`s, generalizing association lists.
 */  
  var lookup = function (dictFoldable) {
      return function (dictEq) {
          return function (a) {
              return function (f) {
                  return Data_Maybe_First.runFirst(Data_Foldable.foldMap(dictFoldable)(Data_Maybe_First.monoidFirst)(function (v) {
                      var $145 = Prelude["=="](dictEq)(a)(v.value0);
                      if ($145) {
                          return new Data_Maybe.Just(v.value1);
                      };
                      if (!$145) {
                          return Data_Maybe.Nothing.value;
                      };
                      throw new Error("Failed pattern match at Data.Tuple line 174, column 58 - line 174, column 93: " + [ $145.constructor.name ]);
                  })(f));
              };
          };
      };
  };
  exports["Tuple"] = Tuple;
  exports["lookup"] = lookup;
  exports["snd"] = snd;
  exports["showTuple"] = showTuple;
  exports["semigroupTuple"] = semigroupTuple;
  exports["monoidTuple"] = monoidTuple;
})(PS["Data.Tuple"] = PS["Data.Tuple"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `MonadState` type class and its instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Tuple = PS["Data.Tuple"];        

  /**
 *  | The `MonadState s` type class represents those monads which support a single piece of mutable
 *  | state of type `s`.
 *  |
 *  | - `state f` updates the state using the function `f`.
 *  |
 *  | An implementation is provided for `StateT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - `do { get ; get } = get`
 *  | - `do { put x ; put y } = put y`
 *  | - `do { put x ; get } = put x $> x`
 *  | - `do { s <- get ; put s } = pure unit`
 *  |
 */  
  var MonadState = function (__superclass_Prelude$dotMonad_0, state) {
      this["__superclass_Prelude.Monad_0"] = __superclass_Prelude$dotMonad_0;
      this.state = state;
  };

  /**
 *  | The `MonadState s` type class represents those monads which support a single piece of mutable
 *  | state of type `s`.
 *  |
 *  | - `state f` updates the state using the function `f`.
 *  |
 *  | An implementation is provided for `StateT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - `do { get ; get } = get`
 *  | - `do { put x ; put y } = put y`
 *  | - `do { put x ; get } = put x $> x`
 *  | - `do { s <- get ; put s } = pure unit`
 *  |
 */  
  var state = function (dict) {
      return dict.state;
  };

  /**
 *  | Get the current state.
 */  
  var get = function (dictMonadState) {
      return state(dictMonadState)(function (s) {
          return new Data_Tuple.Tuple(s, s);
      });
  };
  exports["MonadState"] = MonadState;
  exports["get"] = get;
  exports["state"] = state;
})(PS["Control.Monad.State.Class"] = PS["Control.Monad.State.Class"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the `MonadTrans` type class of _monad transformers_.
 */  
  "use strict";
  var Prelude = PS["Prelude"];        

  /**
 *  | The `MonadTrans` type class represents _monad transformers_.
 *  |
 *  | A monad transformer is a type constructor of kind `(* -> *) -> * -> *`, which
 *  | takes a `Monad` as its first argument, and returns another `Monad`.
 *  |
 *  | This allows us to add additional effects to an existing monad. By iterating this
 *  | process, we create monad transformer _stacks_, which contain all of the effects
 *  | required for a particular computation.
 *  | 
 *  | The laws state that `lift` is a `Monad` morphism.
 *  |
 *  | Laws:
 *  |
 *  | - `lift (pure a) = pure a`
 *  | - `lift (do { x <- m ; y }) = do { x <- lift m ; lift y }`
 */  
  var MonadTrans = function (lift) {
      this.lift = lift;
  };

  /**
 *  | The `MonadTrans` type class represents _monad transformers_.
 *  |
 *  | A monad transformer is a type constructor of kind `(* -> *) -> * -> *`, which
 *  | takes a `Monad` as its first argument, and returns another `Monad`.
 *  |
 *  | This allows us to add additional effects to an existing monad. By iterating this
 *  | process, we create monad transformer _stacks_, which contain all of the effects
 *  | required for a particular computation.
 *  | 
 *  | The laws state that `lift` is a `Monad` morphism.
 *  |
 *  | Laws:
 *  |
 *  | - `lift (pure a) = pure a`
 *  | - `lift (do { x <- m ; y }) = do { x <- lift m ; lift y }`
 */  
  var lift = function (dict) {
      return dict.lift;
  };
  exports["MonadTrans"] = MonadTrans;
  exports["lift"] = lift;
})(PS["Control.Monad.Trans"] = PS["Control.Monad.Trans"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Array

  //------------------------------------------------------------------------------
  // Array creation --------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.range = function (start) {
    return function (end) {
      var step = start > end ? -1 : 1;
      var result = [];
      for (var i = start, n = 0; i !== end; i += step) {
        result[n++] = i;
      }
      result[n] = i;
      return result;
    };
  };

  //------------------------------------------------------------------------------
  // Array size ------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.length = function (xs) {
    return xs.length;
  };

  //------------------------------------------------------------------------------
  // Extending arrays ------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.cons = function (e) {
    return function (l) {
      return [e].concat(l);
    };
  };

  //------------------------------------------------------------------------------
  // Non-indexed reads -----------------------------------------------------------
  //------------------------------------------------------------------------------

  exports["uncons'"] = function (empty) {
    return function (next) {
      return function (xs) {
        return xs.length === 0 ? empty({}) : next(xs[0])(xs.slice(1));
      };
    };
  };

  //------------------------------------------------------------------------------
  // Indexed operations ----------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.indexImpl = function (just) {
    return function (nothing) {
      return function (xs) {
        return function (i) {
          return i < 0 || i >= xs.length ? nothing :  just(xs[i]);
        };
      };
    };
  };

  exports.concat = function (xss) {
    var result = [];
    for (var i = 0, l = xss.length; i < l; i++) {
      var xs = xss[i];
      for (var j = 0, m = xs.length; j < m; j++) {
        result.push(xs[j]);
      }
    }
    return result;
  };

  exports.filter = function (f) {
    return function (xs) {
      return xs.filter(f);
    };
  };

  //------------------------------------------------------------------------------
  // Sorting ---------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.sortImpl = function (f) {
    return function (l) {
      /* jshint maxparams: 2 */
      return l.slice().sort(function (x, y) {
        return f(x)(y);
      });
    };
  };

  //------------------------------------------------------------------------------
  // Subarrays -------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.slice = function (s) {
    return function (e) {
      return function (l) {
        return l.slice(s, e);
      };
    };
  };

  exports.drop = function (n) {
    return function (l) {
      return n < 1 ? l : l.slice(n);
    };
  };

  //------------------------------------------------------------------------------
  // Zipping ---------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.zipWith = function (f) {
    return function (xs) {
      return function (ys) {
        var l = xs.length < ys.length ? xs.length : ys.length;
        var result = new Array(l);
        for (var i = 0; i < l; i++) {
          result[i] = f(xs[i])(ys[i]);
        }
        return result;
      };
    };
  };
})(PS["Data.Array"] = PS["Data.Array"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Maybe.Unsafe

  exports.unsafeThrow = function (msg) {
    throw new Error(msg);
  };
})(PS["Data.Maybe.Unsafe"] = PS["Data.Maybe.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Data.Maybe.Unsafe"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];        

  /**
 *  | A partial function that extracts the value from the `Just` data
 *  | constructor. Passing `Nothing` to `fromJust` will throw an error at
 *  | runtime.
 */  
  var fromJust = function (v) {
      if (v instanceof Data_Maybe.Just) {
          return v.value0;
      };
      if (v instanceof Data_Maybe.Nothing) {
          return $foreign.unsafeThrow("Data.Maybe.Unsafe.fromJust called on Nothing");
      };
      throw new Error("Failed pattern match at Data.Maybe.Unsafe line 11, column 1 - line 12, column 1: " + [ v.constructor.name ]);
  };
  exports["fromJust"] = fromJust;
  exports["unsafeThrow"] = $foreign.unsafeThrow;
})(PS["Data.Maybe.Unsafe"] = PS["Data.Maybe.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Helper functions for working with immutable Javascript arrays.
 *  |
 *  | _Note_: Depending on your use-case, you may prefer to use `Data.List` or
 *  | `Data.Sequence` instead, which might give better performance for certain
 *  | use cases. This module is useful when integrating with JavaScript libraries
 *  | which use arrays, but immutable arrays are not a practical data structure
 *  | for many use cases due to their poor asymptotics.
 *  |
 *  | In addition to the functions in this module, Arrays have a number of
 *  | useful instances:
 *  |
 *  | * `Functor`, which provides `map :: forall a b. (a -> b) -> Array a ->
 *  |   Array b`
 *  | * `Apply`, which provides `(<*>) :: forall a b. Array (a -> b) -> Array a
 *  |   -> Array b`. This function works a bit like a Cartesian product; the
 *  |   result array is constructed by applying each function in the first
 *  |   array to each value in the second, so that the result array ends up with
 *  |   a length equal to the product of the two arguments' lengths.
 *  | * `Bind`, which provides `(>>=) :: forall a b. (a -> Array b) -> Array a
 *  |   -> Array b` (this is the same as `concatMap`).
 *  | * `Semigroup`, which provides `(<>) :: forall a. Array a -> Array a ->
 *  |   Array a`, for concatenating arrays.
 *  | * `Foldable`, which provides a slew of functions for *folding* (also known
 *  |   as *reducing*) arrays down to one value. For example,
 *  |   `Data.Foldable.or` tests whether an array of `Boolean` values contains
 *  |   at least one `true` value.
 *  | * `Traversable`, which provides the PureScript version of a for-loop,
 *  |   allowing you to iterate over an array and accumulate effects.
 *  |
 */  
  "use strict";
  var $foreign = PS["Data.Array"];
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];        

  /**
 *  | An infix alias for `cons`.
 *  |
 *  | Note, the running time of this function is `O(n)`.
 */  
  var $colon = $foreign.cons;

  /**
 *  | Sort the elements of an array in increasing order, where elements are compared using
 *  | the specified partial ordering, creating a new array.
 */  
  var sortBy = function (comp) {
      return function (xs) {
          var comp$prime = function (x) {
              return function (y) {
                  var $46 = comp(x)(y);
                  if ($46 instanceof Prelude.GT) {
                      return 1;
                  };
                  if ($46 instanceof Prelude.EQ) {
                      return 0;
                  };
                  if ($46 instanceof Prelude.LT) {
                      return -1;
                  };
                  throw new Error("Failed pattern match at Data.Array line 417, column 15 - line 422, column 1: " + [ $46.constructor.name ]);
              };
          };
          return $foreign.sortImpl(comp$prime)(xs);
      };
  };

  /**
 * ------------------------------------------------------------------------------
 *  Sorting ---------------------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Sort the elements of an array in increasing order, creating a new array.
 */  
  var sort = function (dictOrd) {
      return function (xs) {
          return sortBy(Prelude.compare(dictOrd))(xs);
      };
  };

  /**
 *  | Create an array of one element
 */  
  var singleton = function (a) {
      return [ a ];
  };

  /**
 * ------------------------------------------------------------------------------
 *  Array size ------------------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Test whether an array is empty.
 */  
  var $$null = function (xs) {
      return $foreign.length(xs) === 0;
  };
  var some = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Prelude["<*>"]((dictAlternative["__superclass_Prelude.Applicative_0"]())["__superclass_Prelude.Apply_0"]())(Prelude["<$>"](((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())["__superclass_Prelude.Functor_0"]())($colon)(v))(Control_Lazy.defer(dictLazy)(function (v1) {
                  return many(dictAlternative)(dictLazy)(v);
              }));
          };
      };
  };
  var many = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Alt["<|>"]((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())(some(dictAlternative)(dictLazy)(v))(Prelude.pure(dictAlternative["__superclass_Prelude.Applicative_0"]())([  ]));
          };
      };
  };

  /**
 * ------------------------------------------------------------------------------
 *  Indexed operations ----------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | This function provides a safe way to read a value at a particular index
 *  | from an array.
 */  
  var index = $foreign.indexImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 *  | An infix version of `index`.
 */  
  var $bang$bang = index;

  /**
 * ------------------------------------------------------------------------------
 *  Non-indexed reads -----------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Get the first element in an array, or `Nothing` if the array is empty
 *  |
 *  | Running time: `O(1)`.
 */  
  var head = $foreign["uncons'"](Prelude["const"](Data_Maybe.Nothing.value))(function (x) {
      return function (v) {
          return new Data_Maybe.Just(x);
      };
  });

  /**
 *  | Apply a function to each element in an array, and flatten the results
 *  | into a single, new array.
 */  
  var concatMap = Prelude.flip(Prelude.bind(Prelude.bindArray));

  /**
 *  | Apply a function to each element in an array, keeping only the results
 *  | which contain a value, creating a new array.
 */  
  var mapMaybe = function (f) {
      return concatMap(function ($69) {
          return Data_Maybe.maybe([  ])(singleton)(f($69));
      });
  };

  /**
 *  | Filter an array of optional values, keeping only the elements which contain
 *  | a value, creating a new array.
 */  
  var catMaybes = mapMaybe(Prelude.id(Prelude.categoryFn));
  exports["sortBy"] = sortBy;
  exports["sort"] = sort;
  exports["catMaybes"] = catMaybes;
  exports["mapMaybe"] = mapMaybe;
  exports["concatMap"] = concatMap;
  exports["index"] = index;
  exports["!!"] = $bang$bang;
  exports["head"] = head;
  exports["null"] = $$null;
  exports["many"] = many;
  exports["some"] = some;
  exports["singleton"] = singleton;
  exports["zipWith"] = $foreign.zipWith;
  exports["drop"] = $foreign.drop;
  exports["filter"] = $foreign.filter;
  exports["concat"] = $foreign.concat;
  exports["length"] = $foreign.length;
  exports["range"] = $foreign.range;
})(PS["Data.Array"] = PS["Data.Array"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Array.ST

  exports.runSTArray = function (f) {
    return f;
  };

  exports.emptySTArray = function () {
    return [];
  };

  exports.pushAllSTArray = function (xs) {
    return function (as) {
      return function () {
        return xs.push.apply(xs, as);
      };
    };
  };
})(PS["Data.Array.ST"] = PS["Data.Array.ST"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Helper functions for working with mutable arrays using the `ST` effect.
 *  |
 *  | This module can be used when performance is important and mutation is a local effect.
 */  
  "use strict";
  var $foreign = PS["Data.Array.ST"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_ST = PS["Control.Monad.ST"];
  var Data_Maybe = PS["Data.Maybe"];

  /**
 *  | Append an element to the end of a mutable array.
 */  
  var pushSTArray = function (arr) {
      return function (a) {
          return $foreign.pushAllSTArray(arr)([ a ]);
      };
  };
  exports["pushSTArray"] = pushSTArray;
  exports["emptySTArray"] = $foreign.emptySTArray;
  exports["runSTArray"] = $foreign.runSTArray;
})(PS["Data.Array.ST"] = PS["Data.Array.ST"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Foreign

  // jshint maxparams: 3
  exports.parseJSONImpl = function (left, right, str) {
    try {
      return right(JSON.parse(str));
    } catch (e) {
      return left(e.toString());
    }
  };

  // jshint maxparams: 1
  exports.toForeign = function (value) {
    return value;
  };

  exports.unsafeFromForeign = function (value) {
    return value;
  };

  exports.typeOf = function (value) {
    return typeof value;
  };

  exports.tagOf = function (value) {
    return Object.prototype.toString.call(value).slice(8, -1);
  };

  exports.isNull = function (value) {
    return value === null;
  };

  exports.isUndefined = function (value) {
    return value === undefined;
  };

  exports.isArray = Array.isArray || function (value) {
    return Object.prototype.toString.call(value) === "[object Array]";
  };
})(PS["Data.Foreign"] = PS["Data.Foreign"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Int

  exports.fromNumberImpl = function (just) {
    return function (nothing) {
      return function (n) {
        /* jshint bitwise: false */
        return (n | 0) === n ? just(n) : nothing;
      };
    };
  };

  exports.fromStringImpl = function (just) {
    return function (nothing) {
      return function (s) {
        /* jshint bitwise: false */
        var i = parseFloat(s);
        return (i | 0) === i ? just(i) : nothing;
      };
    };
  };
})(PS["Data.Int"] = PS["Data.Int"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Data.Int"];
  var Prelude = PS["Prelude"];
  var Data_Int_Bits = PS["Data.Int.Bits"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];
  var $$Math = PS["Math"];

  /**
 *  | Reads an `Int` from a `String` value. The number must parse as an integer
 *  | and fall within the valid range of values for the `Int` type, otherwise
 *  | `Nothing` is returned.
 */  
  var fromString = $foreign.fromStringImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 *  | Creates an `Int` from a `Number` value. The number must already be an
 *  | integer and fall within the valid range of values for the `Int` type
 *  | otherwise `Nothing` is returned.
 */  
  var fromNumber = $foreign.fromNumberImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  exports["fromString"] = fromString;
  exports["fromNumber"] = fromNumber;
})(PS["Data.Int"] = PS["Data.Int"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines types and functions for working with _foreign_
 *  | data.
 */  
  "use strict";
  var $foreign = PS["Data.Foreign"];
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Function = PS["Data.Function"];
  var Data_Int_1 = PS["Data.Int"];
  var Data_Int_1 = PS["Data.Int"];
  var Data_String = PS["Data.String"];        

  /**
 *  | A type for runtime type errors
 */  
  var TypeMismatch = (function () {
      function TypeMismatch(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      TypeMismatch.create = function (value0) {
          return function (value1) {
              return new TypeMismatch(value0, value1);
          };
      };
      return TypeMismatch;
  })();

  /**
 *  | A type for runtime type errors
 */  
  var ErrorAtIndex = (function () {
      function ErrorAtIndex(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ErrorAtIndex.create = function (value0) {
          return function (value1) {
              return new ErrorAtIndex(value0, value1);
          };
      };
      return ErrorAtIndex;
  })();

  /**
 *  | A type for runtime type errors
 */  
  var ErrorAtProperty = (function () {
      function ErrorAtProperty(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ErrorAtProperty.create = function (value0) {
          return function (value1) {
              return new ErrorAtProperty(value0, value1);
          };
      };
      return ErrorAtProperty;
  })();

  /**
 *  | A type for runtime type errors
 */  
  var JSONError = (function () {
      function JSONError(value0) {
          this.value0 = value0;
      };
      JSONError.create = function (value0) {
          return new JSONError(value0);
      };
      return JSONError;
  })();

  /**
 *  | Unsafely coerce a `Foreign` value when the value has a particular `tagOf`
 *  | value.
 */  
  var unsafeReadTagged = function (tag) {
      return function (value) {
          if ($foreign.tagOf(value) === tag) {
              return Prelude.pure(Data_Either.applicativeEither)($foreign.unsafeFromForeign(value));
          };
          return new Data_Either.Left(new TypeMismatch(tag, $foreign.tagOf(value)));
      };
  };
  var showForeignError = new Prelude.Show(function (v) {
      if (v instanceof TypeMismatch) {
          return "Type mismatch: expected " + (v.value0 + (", found " + v.value1));
      };
      if (v instanceof ErrorAtIndex) {
          return "Error at array index " + (Prelude.show(Prelude.showInt)(v.value0) + (": " + Prelude.show(showForeignError)(v.value1)));
      };
      if (v instanceof ErrorAtProperty) {
          return "Error at property " + (Prelude.show(Prelude.showString)(v.value0) + (": " + Prelude.show(showForeignError)(v.value1)));
      };
      if (v instanceof JSONError) {
          return "JSON error: " + v.value0;
      };
      throw new Error("Failed pattern match at Data.Foreign line 54, column 3 - line 55, column 3: " + [ v.constructor.name ]);
  });

  /**
 *  | Attempt to coerce a foreign value to a `String`.
 */  
  var readString = unsafeReadTagged("String");

  /**
 *  | Attempt to coerce a foreign value to a `Number`.
 */  
  var readNumber = unsafeReadTagged("Number");

  /**
 *  | Attempt to coerce a foreign value to an `Int`.
 */  
  var readInt = function (value) {
      var error = Data_Either.Left.create(new TypeMismatch("Int", $foreign.tagOf(value)));
      var fromNumber = function ($30) {
          return Data_Maybe.maybe(error)(Prelude.pure(Data_Either.applicativeEither))(Data_Int_1.fromNumber($30));
      };
      return Data_Either.either(Prelude["const"](error))(fromNumber)(readNumber(value));
  };                                            

  /**
 *  | Attempt to coerce a foreign value to an array.
 */  
  var readArray = function (value) {
      if ($foreign.isArray(value)) {
          return Prelude.pure(Data_Either.applicativeEither)($foreign.unsafeFromForeign(value));
      };
      return new Data_Either.Left(new TypeMismatch("array", $foreign.tagOf(value)));
  };

  /**
 *  | Attempt to parse a JSON string, returning the result as foreign data.
 */  
  var parseJSON = function (json) {
      return $foreign.parseJSONImpl(function ($32) {
          return Data_Either.Left.create(JSONError.create($32));
      }, Data_Either.Right.create, json);
  };
  exports["TypeMismatch"] = TypeMismatch;
  exports["ErrorAtIndex"] = ErrorAtIndex;
  exports["ErrorAtProperty"] = ErrorAtProperty;
  exports["JSONError"] = JSONError;
  exports["readArray"] = readArray;
  exports["readInt"] = readInt;
  exports["readNumber"] = readNumber;
  exports["readString"] = readString;
  exports["unsafeReadTagged"] = unsafeReadTagged;
  exports["parseJSON"] = parseJSON;
  exports["showForeignError"] = showForeignError;
  exports["isUndefined"] = $foreign.isUndefined;
  exports["isNull"] = $foreign.isNull;
  exports["typeOf"] = $foreign.typeOf;
  exports["toForeign"] = $foreign.toForeign;
})(PS["Data.Foreign"] = PS["Data.Foreign"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Foreign.Index

  // jshint maxparams: 4
  exports.unsafeReadPropImpl = function (f, s, key, value) {
    return value == null ? f : s(value[key]);
  };

  // jshint maxparams: 2
  exports.unsafeHasOwnProperty = function (prop, value) {
    return Object.prototype.hasOwnProperty.call(value, prop);
  };

  exports.unsafeHasProperty = function (prop, value) {
    return prop in value;
  };
})(PS["Data.Foreign.Index"] = PS["Data.Foreign.Index"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a type class for types which act like
 *  | _property indices_.
 */  
  "use strict";
  var $foreign = PS["Data.Foreign.Index"];
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Function = PS["Data.Function"];
  var Data_Int = PS["Data.Int"];        

  /**
 *  | This type class identifies types wich act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Number`s.
 */  
  var Index = function (errorAt, hasOwnProperty, hasProperty, ix) {
      this.errorAt = errorAt;
      this.hasOwnProperty = hasOwnProperty;
      this.hasProperty = hasProperty;
      this.ix = ix;
  };
  var unsafeReadProp = function (k) {
      return function (value) {
          return $foreign.unsafeReadPropImpl(new Data_Either.Left(new Data_Foreign.TypeMismatch("object", Data_Foreign.typeOf(value))), Prelude.pure(Data_Either.applicativeEither), k, value);
      };
  };

  /**
 *  | Attempt to read a value from a foreign value property
 */  
  var prop = unsafeReadProp;

  /**
 *  | This type class identifies types wich act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Number`s.
 */  
  var ix = function (dict) {
      return dict.ix;
  };

  /**
 *  | An infix alias for `ix`.
 */  
  var $bang = function (dictIndex) {
      return ix(dictIndex);
  };                         
  var hasPropertyImpl = function (v) {
      return function (value) {
          if (Data_Foreign.isNull(value)) {
              return false;
          };
          if (Data_Foreign.isUndefined(value)) {
              return false;
          };
          if (Data_Foreign.typeOf(value) === "object" || Data_Foreign.typeOf(value) === "function") {
              return $foreign.unsafeHasProperty(v, value);
          };
          return false;
      };
  };

  /**
 *  | This type class identifies types wich act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Number`s.
 */  
  var hasProperty = function (dict) {
      return dict.hasProperty;
  };
  var hasOwnPropertyImpl = function (v) {
      return function (value) {
          if (Data_Foreign.isNull(value)) {
              return false;
          };
          if (Data_Foreign.isUndefined(value)) {
              return false;
          };
          if (Data_Foreign.typeOf(value) === "object" || Data_Foreign.typeOf(value) === "function") {
              return $foreign.unsafeHasOwnProperty(v, value);
          };
          return false;
      };
  };                                                                                                                   
  var indexString = new Index(Data_Foreign.ErrorAtProperty.create, hasOwnPropertyImpl, hasPropertyImpl, Prelude.flip(prop));

  /**
 *  | This type class identifies types wich act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Number`s.
 */  
  var hasOwnProperty = function (dict) {
      return dict.hasOwnProperty;
  };

  /**
 *  | This type class identifies types wich act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Number`s.
 */  
  var errorAt = function (dict) {
      return dict.errorAt;
  };
  exports["Index"] = Index;
  exports["errorAt"] = errorAt;
  exports["hasOwnProperty"] = hasOwnProperty;
  exports["hasProperty"] = hasProperty;
  exports["!"] = $bang;
  exports["ix"] = ix;
  exports["prop"] = prop;
  exports["indexString"] = indexString;
})(PS["Data.Foreign.Index"] = PS["Data.Foreign.Index"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a type class for reading foreign values.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Array = PS["Data.Array"];
  var Data_Either = PS["Data.Either"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var Data_Foreign_Null = PS["Data.Foreign.Null"];
  var Data_Foreign_NullOrUndefined = PS["Data.Foreign.NullOrUndefined"];
  var Data_Foreign_Undefined = PS["Data.Foreign.Undefined"];
  var Data_Int = PS["Data.Int"];
  var Data_Traversable = PS["Data.Traversable"];        

  /**
 *  | A type class instance for this class can be written for a type if it
 *  | is possible to attempt to _safely_ coerce a `Foreign` value to that
 *  | type.
 *  |
 *  | Instances are provided for standard data structures, and the `F` monad
 *  | can be used to construct instances for new data structures.
 */  
  var IsForeign = function (read) {
      this.read = read;
  };
  var stringIsForeign = new IsForeign(Data_Foreign.readString);

  /**
 *  | A type class instance for this class can be written for a type if it
 *  | is possible to attempt to _safely_ coerce a `Foreign` value to that
 *  | type.
 *  |
 *  | Instances are provided for standard data structures, and the `F` monad
 *  | can be used to construct instances for new data structures.
 */  
  var read = function (dict) {
      return dict.read;
  };

  /**
 *  | Attempt to read a foreign value, handling errors using the specified function
 */  
  var readWith = function (dictIsForeign) {
      return function (f) {
          return function (value) {
              return Data_Either.either(function ($8) {
                  return Data_Either.Left.create(f($8));
              })(Data_Either.Right.create)(read(dictIsForeign)(value));
          };
      };
  };

  /**
 *  | Attempt to read a property of a foreign value at the specified index
 */  
  var readProp = function (dictIsForeign) {
      return function (dictIndex) {
          return function (prop) {
              return function (value) {
                  return Prelude[">>="](Data_Either.bindEither)(Data_Foreign_Index["!"](dictIndex)(value)(prop))(readWith(dictIsForeign)(Data_Foreign_Index.errorAt(dictIndex)(prop)));
              };
          };
      };
  };
  var intIsForeign = new IsForeign(Data_Foreign.readInt);
  var foreignIsForeign = new IsForeign(function (f) {
      return Prelude["return"](Data_Either.applicativeEither)(f);
  });                                                            
  var arrayIsForeign = function (dictIsForeign) {
      return new IsForeign(function (value) {
          var readElement = function (i) {
              return function (value1) {
                  return readWith(dictIsForeign)(Data_Foreign.ErrorAtIndex.create(i))(value1);
              };
          };
          var readElements = function (arr) {
              return Data_Traversable.sequence(Data_Traversable.traversableArray)(Data_Either.applicativeEither)(Data_Array.zipWith(readElement)(Data_Array.range(0)(Data_Array.length(arr)))(arr));
          };
          return Prelude[">>="](Data_Either.bindEither)(Data_Foreign.readArray(value))(readElements);
      });
  };
  exports["IsForeign"] = IsForeign;
  exports["readProp"] = readProp;
  exports["readWith"] = readWith;
  exports["read"] = read;
  exports["foreignIsForeign"] = foreignIsForeign;
  exports["stringIsForeign"] = stringIsForeign;
  exports["intIsForeign"] = intIsForeign;
  exports["arrayIsForeign"] = arrayIsForeign;
})(PS["Data.Foreign.Class"] = PS["Data.Foreign.Class"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];        
  var Identity = function (x) {
      return x;
  };
  var runIdentity = function (v) {
      return v;
  };
  var functorIdentity = new Prelude.Functor(function (f) {
      return function (v) {
          return f(v);
      };
  });
  var applyIdentity = new Prelude.Apply(function () {
      return functorIdentity;
  }, function (v) {
      return function (v1) {
          return v(v1);
      };
  });
  var bindIdentity = new Prelude.Bind(function () {
      return applyIdentity;
  }, function (v) {
      return function (f) {
          return f(v);
      };
  });
  var applicativeIdentity = new Prelude.Applicative(function () {
      return applyIdentity;
  }, Identity);
  var monadIdentity = new Prelude.Monad(function () {
      return applicativeIdentity;
  }, function () {
      return bindIdentity;
  });
  exports["Identity"] = Identity;
  exports["runIdentity"] = runIdentity;
  exports["functorIdentity"] = functorIdentity;
  exports["applyIdentity"] = applyIdentity;
  exports["applicativeIdentity"] = applicativeIdentity;
  exports["bindIdentity"] = bindIdentity;
  exports["monadIdentity"] = monadIdentity;
})(PS["Data.Identity"] = PS["Data.Identity"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module provides a type class for _unfoldable functors_, i.e.
 *  | functors which support an `unfoldr` operation.
 *  |
 *  | This allows us to unify various operations on arrays, lists,
 *  | sequences, etc.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Array_ST = PS["Data.Array.ST"];
  var Data_Traversable = PS["Data.Traversable"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_ST = PS["Control.Monad.ST"];        

  /**
 *  | This class identifies data structures which can be _unfolded_,
 *  | generalizing `unfoldr` on arrays.
 *  |
 *  | The generating function `f` in `unfoldr f` in understood as follows:
 *  |
 *  | - If `f b` is `Nothing`, then `unfoldr f b` should be empty.
 *  | - If `f b` is `Just (Tuple a b1)`, then `unfoldr f b` should consist of `a`
 *  |   appended to the result of `unfoldr f b1`.
 */  
  var Unfoldable = function (unfoldr) {
      this.unfoldr = unfoldr;
  };

  /**
 *  | This class identifies data structures which can be _unfolded_,
 *  | generalizing `unfoldr` on arrays.
 *  |
 *  | The generating function `f` in `unfoldr f` in understood as follows:
 *  |
 *  | - If `f b` is `Nothing`, then `unfoldr f b` should be empty.
 *  | - If `f b` is `Just (Tuple a b1)`, then `unfoldr f b` should consist of `a`
 *  |   appended to the result of `unfoldr f b1`.
 */  
  var unfoldr = function (dict) {
      return dict.unfoldr;
  };
  var unfoldableArray = new Unfoldable(function (f) {
      return function (b) {
          return Control_Monad_Eff.runPure(Data_Array_ST.runSTArray(function __do() {
              var v = Data_Array_ST.emptySTArray();
              var v1 = Control_Monad_ST.newSTRef(b)();
              (function () {
                  while (!(function __do() {
                      var v2 = Control_Monad_ST.readSTRef(v1)();
                      var $12 = f(v2);
                      if ($12 instanceof Data_Maybe.Nothing) {
                          return true;
                      };
                      if ($12 instanceof Data_Maybe.Just) {
                          Data_Array_ST.pushSTArray(v)($12.value0.value0)();
                          Control_Monad_ST.writeSTRef(v1)($12.value0.value1)();
                          return false;
                      };
                      throw new Error("Failed pattern match at Data.Unfoldable line 35, column 7 - line 41, column 5: " + [ $12.constructor.name ]);
                  })()) {

                  };
                  return {};
              })();
              return v;
          }));
      };
  });
  exports["Unfoldable"] = Unfoldable;
  exports["unfoldr"] = unfoldr;
  exports["unfoldableArray"] = unfoldableArray;
})(PS["Data.Unfoldable"] = PS["Data.Unfoldable"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a type of _strict_ linked lists, and associated helper
 *  | functions and type class instances.
 *  |
 *  | _Note_: Depending on your use-case, you may prefer to use
 *  | `Data.Sequence` instead, which might give better performance for certain
 *  | use cases. This module is an improvement over `Data.Array` when working with
 *  | immutable lists of data in a purely-functional setting, but does not have
 *  | good random-access performance.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];        

  /**
 *  | A strict linked list.
 *  |
 *  | A list is either empty (represented by the `Nil` constructor) or non-empty, in
 *  | which case it consists of a head element, and another list (represented by the
 *  | `Cons` constructor).
 */  
  var Nil = (function () {
      function Nil() {

      };
      Nil.value = new Nil();
      return Nil;
  })();

  /**
 *  | A strict linked list.
 *  |
 *  | A list is either empty (represented by the `Nil` constructor) or non-empty, in
 *  | which case it consists of a head element, and another list (represented by the
 *  | `Cons` constructor).
 */  
  var Cons = (function () {
      function Cons(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Cons.create = function (value0) {
          return function (value1) {
              return new Cons(value0, value1);
          };
      };
      return Cons;
  })();

  /**
 *  | An infix alias for `Cons`; attaches an element to the front of
 *  | a list.
 *  |
 *  | Running time: `O(1)`
 */  
  var $colon = Cons.create;

  /**
 *  | Break a list into its first element, and the remaining elements,
 *  | or `Nothing` if the list is empty.
 *  |
 *  | Running time: `O(1)`
 */  
  var uncons = function (v) {
      if (v instanceof Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Cons) {
          return new Data_Maybe.Just({
              head: v.value0, 
              tail: v.value1
          });
      };
      throw new Error("Failed pattern match at Data.List line 273, column 1 - line 274, column 1: " + [ v.constructor.name ]);
  };

  /**
 *  | Convert a list into any unfoldable structure.
 *  |
 *  | Running time: `O(n)`
 */  
  var toUnfoldable = function (dictUnfoldable) {
      return Data_Unfoldable.unfoldr(dictUnfoldable)(function (xs) {
          return Prelude["<$>"](Data_Maybe.functorMaybe)(function (rec) {
              return new Data_Tuple.Tuple(rec.head, rec.tail);
          })(uncons(xs));
      });
  };

  /**
 *  | Get all but the first element of a list, or `Nothing` if the list is empty.
 *  |
 *  | Running time: `O(1)`
 */  
  var tail = function (v) {
      if (v instanceof Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Cons) {
          return new Data_Maybe.Just(v.value1);
      };
      throw new Error("Failed pattern match at Data.List line 254, column 1 - line 255, column 1: " + [ v.constructor.name ]);
  };
  var showList = function (dictShow) {
      return new Prelude.Show(function (v) {
          if (v instanceof Nil) {
              return "Nil";
          };
          if (v instanceof Cons) {
              return "Cons (" + (Prelude.show(dictShow)(v.value0) + (") (" + (Prelude.show(showList(dictShow))(v.value1) + ")")));
          };
          throw new Error("Failed pattern match at Data.List line 727, column 3 - line 728, column 3: " + [ v.constructor.name ]);
      });
  };
  var semigroupList = new Prelude.Semigroup(function (v) {
      return function (ys) {
          if (v instanceof Nil) {
              return ys;
          };
          if (v instanceof Cons) {
              return new Cons(v.value0, Prelude["<>"](semigroupList)(v.value1)(ys));
          };
          throw new Error("Failed pattern match at Data.List line 751, column 3 - line 752, column 3: " + [ v.constructor.name, ys.constructor.name ]);
      };
  });

  /**
 * ------------------------------------------------------------------------------
 *  Transformations -------------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Reverse a list.
 *  |
 *  | Running time: `O(n)`
 */  
  var reverse = (function () {
      var go = function (__copy_acc) {
          return function (__copy_v) {
              var acc = __copy_acc;
              var v = __copy_v;
              tco: while (true) {
                  if (v instanceof Nil) {
                      return acc;
                  };
                  if (v instanceof Cons) {
                      var __tco_acc = new Cons(v.value0, acc);
                      var __tco_v = v.value1;
                      acc = __tco_acc;
                      v = __tco_v;
                      continue tco;
                  };
                  throw new Error("Failed pattern match at Data.List line 371, column 1 - line 379, column 1: " + [ acc.constructor.name, v.constructor.name ]);
              };
          };
      };
      return go(Nil.value);
  })();                

  /**
 * ------------------------------------------------------------------------------
 *  List size -------------------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Test whether a list is empty.
 *  |
 *  | Running time: `O(1)`
 */  
  var $$null = function (v) {
      if (v instanceof Nil) {
          return true;
      };
      return false;
  };
  var some = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Prelude["<*>"]((dictAlternative["__superclass_Prelude.Applicative_0"]())["__superclass_Prelude.Apply_0"]())(Prelude["<$>"](((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())["__superclass_Prelude.Functor_0"]())(Cons.create)(v))(Control_Lazy.defer(dictLazy)(function (v1) {
                  return many(dictAlternative)(dictLazy)(v);
              }));
          };
      };
  };
  var many = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Alt["<|>"]((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())(some(dictAlternative)(dictLazy)(v))(Prelude.pure(dictAlternative["__superclass_Prelude.Applicative_0"]())(Nil.value));
          };
      };
  };                     

  /**
 * ------------------------------------------------------------------------------
 *  Non-indexed reads -----------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Get the first element in a list, or `Nothing` if the list is empty.
 *  |
 *  | Running time: `O(1)`.
 */  
  var head = function (v) {
      if (v instanceof Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Cons) {
          return new Data_Maybe.Just(v.value0);
      };
      throw new Error("Failed pattern match at Data.List line 239, column 1 - line 240, column 1: " + [ v.constructor.name ]);
  };
  var functorList = new Prelude.Functor(function (f) {
      return function (lst) {
          var go = function (__copy_v) {
              return function (__copy_acc) {
                  var v = __copy_v;
                  var acc = __copy_acc;
                  tco: while (true) {
                      if (v instanceof Nil) {
                          return acc;
                      };
                      if (v instanceof Cons) {
                          var __tco_v = v.value1;
                          var __tco_acc = new Cons(f(v.value0), acc);
                          v = __tco_v;
                          acc = __tco_acc;
                          continue tco;
                      };
                      throw new Error("Failed pattern match at Data.List line 758, column 3 - line 764, column 1: " + [ v.constructor.name, acc.constructor.name ]);
                  };
              };
          };
          return reverse(go(lst)(Nil.value));
      };
  });

  /**
 *  | *Deprecated.* Use `toUnfoldable` instead. `fromList` will be removed in a
 *  | later version.
 */  
  var fromList = function (dictUnfoldable) {
      return toUnfoldable(dictUnfoldable);
  };

  /**
 *  | Construct a list from a foldable structure.
 *  |
 *  | Running time: `O(n)`
 */  
  var fromFoldable = function (dictFoldable) {
      return Data_Foldable.foldr(dictFoldable)(Cons.create)(Nil.value);
  };

  /**
 * ------------------------------------------------------------------------------
 *  Deprecated functions --------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | *Deprecated.* Use `fromFoldable` instead. `toList` will be removed in a
 *  | later version.
 */  
  var toList = function (dictFoldable) {
      return fromFoldable(dictFoldable);
  };
  var foldableList = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return Data_Foldable.foldl(foldableList)(function (acc) {
              return function ($374) {
                  return Prelude.append(dictMonoid["__superclass_Prelude.Semigroup_0"]())(acc)(f($374));
              };
          })(Data_Monoid.mempty(dictMonoid));
      };
  }, (function () {
      var go = function (__copy_v) {
          return function (__copy_b) {
              return function (__copy_v1) {
                  var v = __copy_v;
                  var b = __copy_b;
                  var v1 = __copy_v1;
                  tco: while (true) {
                      if (v1 instanceof Nil) {
                          return b;
                      };
                      if (v1 instanceof Cons) {
                          var __tco_v = v;
                          var __tco_b = v(b)(v1.value0);
                          var __tco_v1 = v1.value1;
                          v = __tco_v;
                          b = __tco_b;
                          v1 = __tco_v1;
                          continue tco;
                      };
                      throw new Error("Failed pattern match at Data.List line 767, column 3 - line 771, column 3: " + [ v.constructor.name, b.constructor.name, v1.constructor.name ]);
                  };
              };
          };
      };
      return go;
  })(), function (v) {
      return function (b) {
          return function (v1) {
              if (v1 instanceof Nil) {
                  return b;
              };
              if (v1 instanceof Cons) {
                  return v(v1.value0)(Data_Foldable.foldr(foldableList)(v)(b)(v1.value1));
              };
              throw new Error("Failed pattern match at Data.List line 765, column 3 - line 766, column 3: " + [ v.constructor.name, b.constructor.name, v1.constructor.name ]);
          };
      };
  });   
  var traversableList = new Data_Traversable.Traversable(function () {
      return foldableList;
  }, function () {
      return functorList;
  }, function (dictApplicative) {
      return function (v) {
          if (v instanceof Nil) {
              return Prelude.pure(dictApplicative)(Nil.value);
          };
          if (v instanceof Cons) {
              return Prelude["<*>"](dictApplicative["__superclass_Prelude.Apply_0"]())(Prelude["<$>"]((dictApplicative["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]())(Cons.create)(v.value0))(Data_Traversable.sequence(traversableList)(dictApplicative)(v.value1));
          };
          throw new Error("Failed pattern match at Data.List line 784, column 3 - line 785, column 3: " + [ v.constructor.name ]);
      };
  }, function (dictApplicative) {
      return function (v) {
          return function (v1) {
              if (v1 instanceof Nil) {
                  return Prelude.pure(dictApplicative)(Nil.value);
              };
              if (v1 instanceof Cons) {
                  return Prelude["<*>"](dictApplicative["__superclass_Prelude.Apply_0"]())(Prelude["<$>"]((dictApplicative["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]())(Cons.create)(v(v1.value0)))(Data_Traversable.traverse(traversableList)(dictApplicative)(v)(v1.value1));
              };
              throw new Error("Failed pattern match at Data.List line 782, column 3 - line 783, column 3: " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  });
  var eqList = function (dictEq) {
      return new Prelude.Eq(function (xs) {
          return function (ys) {
              var go = function (__copy_v) {
                  return function (__copy_v1) {
                      return function (__copy_v2) {
                          var v = __copy_v;
                          var v1 = __copy_v1;
                          var v2 = __copy_v2;
                          tco: while (true) {
                              if (!v2) {
                                  return false;
                              };
                              if (v instanceof Nil && v1 instanceof Nil) {
                                  return v2;
                              };
                              if (v instanceof Cons && v1 instanceof Cons) {
                                  var __tco_v = v.value1;
                                  var __tco_v1 = v1.value1;
                                  var __tco_v2 = v2 && Prelude["=="](dictEq)(v1.value0)(v.value0);
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  v2 = __tco_v2;
                                  continue tco;
                              };
                              return false;
                          };
                      };
                  };
              };
              return go(xs)(ys)(true);
          };
      });
  };
  var ordList = function (dictOrd) {
      return new Prelude.Ord(function () {
          return eqList(dictOrd["__superclass_Prelude.Eq_0"]());
      }, function (xs) {
          return function (ys) {
              var go = function (__copy_v) {
                  return function (__copy_v1) {
                      var v = __copy_v;
                      var v1 = __copy_v1;
                      tco: while (true) {
                          if (v instanceof Nil && v1 instanceof Nil) {
                              return Prelude.EQ.value;
                          };
                          if (v instanceof Nil) {
                              return Prelude.LT.value;
                          };
                          if (v1 instanceof Nil) {
                              return Prelude.GT.value;
                          };
                          if (v instanceof Cons && v1 instanceof Cons) {
                              var $330 = Prelude.compare(dictOrd)(v.value0)(v1.value0);
                              if ($330 instanceof Prelude.EQ) {
                                  var __tco_v = v.value1;
                                  var __tco_v1 = v1.value1;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              return $330;
                          };
                          throw new Error("Failed pattern match at Data.List line 740, column 3 - line 750, column 1: " + [ v.constructor.name, v1.constructor.name ]);
                      };
                  };
              };
              return go(xs)(ys);
          };
      });
  };                                                       
  var applyList = new Prelude.Apply(function () {
      return functorList;
  }, function (v) {
      return function (v1) {
          if (v instanceof Nil) {
              return Nil.value;
          };
          if (v instanceof Cons) {
              return Prelude["<>"](semigroupList)(Prelude["<$>"](functorList)(v.value0)(v1))(Prelude["<*>"](applyList)(v.value1)(v1));
          };
          throw new Error("Failed pattern match at Data.List line 788, column 3 - line 789, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var applicativeList = new Prelude.Applicative(function () {
      return applyList;
  }, function (a) {
      return new Cons(a, Nil.value);
  });
  exports["Nil"] = Nil;
  exports["Cons"] = Cons;
  exports["fromList"] = fromList;
  exports["toList"] = toList;
  exports["reverse"] = reverse;
  exports["uncons"] = uncons;
  exports["tail"] = tail;
  exports["head"] = head;
  exports[":"] = $colon;
  exports["null"] = $$null;
  exports["many"] = many;
  exports["some"] = some;
  exports["fromFoldable"] = fromFoldable;
  exports["toUnfoldable"] = toUnfoldable;
  exports["showList"] = showList;
  exports["eqList"] = eqList;
  exports["ordList"] = ordList;
  exports["semigroupList"] = semigroupList;
  exports["functorList"] = functorList;
  exports["foldableList"] = foldableList;
  exports["traversableList"] = traversableList;
  exports["applyList"] = applyList;
  exports["applicativeList"] = applicativeList;
})(PS["Data.List"] = PS["Data.List"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a type of maps as balanced 2-3 trees, based on
 *  | <http://www.cs.princeton.edu/~dpw/courses/cos326-12/ass/2-3-trees.pdf>
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List = PS["Data.List"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];        

  /**
 *  | `Map k v` represents maps from keys of type `k` to values of type `v`.
 */  
  var Leaf = (function () {
      function Leaf() {

      };
      Leaf.value = new Leaf();
      return Leaf;
  })();

  /**
 *  | `Map k v` represents maps from keys of type `k` to values of type `v`.
 */  
  var Two = (function () {
      function Two(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      Two.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new Two(value0, value1, value2, value3);
                  };
              };
          };
      };
      return Two;
  })();

  /**
 *  | `Map k v` represents maps from keys of type `k` to values of type `v`.
 */  
  var Three = (function () {
      function Three(value0, value1, value2, value3, value4, value5, value6) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
          this.value6 = value6;
      };
      Three.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return function (value6) {
                                  return new Three(value0, value1, value2, value3, value4, value5, value6);
                              };
                          };
                      };
                  };
              };
          };
      };
      return Three;
  })();
  var TwoLeft = (function () {
      function TwoLeft(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      TwoLeft.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new TwoLeft(value0, value1, value2);
              };
          };
      };
      return TwoLeft;
  })();
  var TwoRight = (function () {
      function TwoRight(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      TwoRight.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new TwoRight(value0, value1, value2);
              };
          };
      };
      return TwoRight;
  })();
  var ThreeLeft = (function () {
      function ThreeLeft(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeLeft.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeLeft(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeLeft;
  })();
  var ThreeMiddle = (function () {
      function ThreeMiddle(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeMiddle.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeMiddle(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeMiddle;
  })();
  var ThreeRight = (function () {
      function ThreeRight(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeRight.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeRight(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeRight;
  })();
  var KickUp = (function () {
      function KickUp(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      KickUp.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new KickUp(value0, value1, value2, value3);
                  };
              };
          };
      };
      return KickUp;
  })();
  var toList = function (v) {
      if (v instanceof Leaf) {
          return Data_List.Nil.value;
      };
      if (v instanceof Two) {
          return Prelude["++"](Data_List.semigroupList)(toList(v.value0))(Prelude["++"](Data_List.semigroupList)(Prelude.pure(Data_List.applicativeList)(new Data_Tuple.Tuple(v.value1, v.value2)))(toList(v.value3)));
      };
      if (v instanceof Three) {
          return Prelude["++"](Data_List.semigroupList)(toList(v.value0))(Prelude["++"](Data_List.semigroupList)(Prelude.pure(Data_List.applicativeList)(new Data_Tuple.Tuple(v.value1, v.value2)))(Prelude["++"](Data_List.semigroupList)(toList(v.value3))(Prelude["++"](Data_List.semigroupList)(Prelude.pure(Data_List.applicativeList)(new Data_Tuple.Tuple(v.value4, v.value5)))(toList(v.value6)))));
      };
      throw new Error("Failed pattern match at Data.Map line 290, column 1 - line 291, column 1: " + [ v.constructor.name ]);
  };

  /**
 *  | Create a map with one key/value pair
 */  
  var singleton = function (k) {
      return function (v) {
          return new Two(Leaf.value, k, v, Leaf.value);
      };
  };
  var showMap = function (dictShow) {
      return function (dictShow1) {
          return new Prelude.Show(function (m) {
              return "fromList " + Prelude.show(Data_List.showList(Data_Tuple.showTuple(dictShow)(dictShow1)))(toList(m));
          });
      };
  };
  var lookup = function (__copy_dictOrd) {
      return function (__copy_k) {
          return function (__copy_tree) {
              var dictOrd = __copy_dictOrd;
              var k = __copy_k;
              var tree = __copy_tree;
              tco: while (true) {
                  var comp = Prelude.compare(dictOrd);
                  if (tree instanceof Leaf) {
                      return Data_Maybe.Nothing.value;
                  };
                  if (tree instanceof Two) {
                      var $91 = comp(k)(tree.value1);
                      if ($91 instanceof Prelude.EQ) {
                          return new Data_Maybe.Just(tree.value2);
                      };
                      if ($91 instanceof Prelude.LT) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_k = k;
                          var __tco_tree = tree.value0;
                          dictOrd = __tco_dictOrd;
                          k = __tco_k;
                          tree = __tco_tree;
                          continue tco;
                      };
                      var __tco_dictOrd = dictOrd;
                      var __tco_k = k;
                      var __tco_tree = tree.value3;
                      dictOrd = __tco_dictOrd;
                      k = __tco_k;
                      tree = __tco_tree;
                      continue tco;
                  };
                  if (tree instanceof Three) {
                      var $96 = comp(k)(tree.value1);
                      if ($96 instanceof Prelude.EQ) {
                          return new Data_Maybe.Just(tree.value2);
                      };
                      var $97 = comp(k)(tree.value4);
                      if ($97 instanceof Prelude.EQ) {
                          return new Data_Maybe.Just(tree.value5);
                      };
                      if ($96 instanceof Prelude.LT) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_k = k;
                          var __tco_tree = tree.value0;
                          dictOrd = __tco_dictOrd;
                          k = __tco_k;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if ($97 instanceof Prelude.GT) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_k = k;
                          var __tco_tree = tree.value6;
                          dictOrd = __tco_dictOrd;
                          k = __tco_k;
                          tree = __tco_tree;
                          continue tco;
                      };
                      var __tco_dictOrd = dictOrd;
                      var __tco_k = k;
                      var __tco_tree = tree.value3;
                      dictOrd = __tco_dictOrd;
                      k = __tco_k;
                      tree = __tco_tree;
                      continue tco;
                  };
                  throw new Error("Failed pattern match at Data.Map line 121, column 6 - line 143, column 1: " + [ tree.constructor.name ]);
              };
          };
      };
  };
  var keys = function (v) {
      if (v instanceof Leaf) {
          return Data_List.Nil.value;
      };
      if (v instanceof Two) {
          return Prelude["++"](Data_List.semigroupList)(keys(v.value0))(Prelude["++"](Data_List.semigroupList)(Prelude.pure(Data_List.applicativeList)(v.value1))(keys(v.value3)));
      };
      if (v instanceof Three) {
          return Prelude["++"](Data_List.semigroupList)(keys(v.value0))(Prelude["++"](Data_List.semigroupList)(Prelude.pure(Data_List.applicativeList)(v.value1))(Prelude["++"](Data_List.semigroupList)(keys(v.value3))(Prelude["++"](Data_List.semigroupList)(Prelude.pure(Data_List.applicativeList)(v.value4))(keys(v.value6)))));
      };
      throw new Error("Failed pattern match at Data.Map line 305, column 1 - line 306, column 1: " + [ v.constructor.name ]);
  };
  var functorMap = new Prelude.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Leaf) {
              return Leaf.value;
          };
          if (v1 instanceof Two) {
              return new Two(Prelude.map(functorMap)(v)(v1.value0), v1.value1, v(v1.value2), Prelude.map(functorMap)(v)(v1.value3));
          };
          if (v1 instanceof Three) {
              return new Three(Prelude.map(functorMap)(v)(v1.value0), v1.value1, v(v1.value2), Prelude.map(functorMap)(v)(v1.value3), v1.value4, v(v1.value5), Prelude.map(functorMap)(v)(v1.value6));
          };
          throw new Error("Failed pattern match at Data.Map line 62, column 3 - line 63, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var fromZipper = function (__copy_dictOrd) {
      return function (__copy_v) {
          return function (__copy_tree) {
              var dictOrd = __copy_dictOrd;
              var v = __copy_v;
              var tree = __copy_tree;
              tco: while (true) {
                  if (v instanceof Data_List.Nil) {
                      return tree;
                  };
                  if (v instanceof Data_List.Cons) {
                      if (v.value0 instanceof TwoLeft) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Two(tree, v.value0.value0, v.value0.value1, v.value0.value2);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof TwoRight) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Two(v.value0.value0, v.value0.value1, v.value0.value2, tree);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeLeft) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Three(tree, v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeMiddle) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Three(v.value0.value0, v.value0.value1, v.value0.value2, tree, v.value0.value3, v.value0.value4, v.value0.value5);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeRight) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Three(v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5, tree);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      throw new Error("Failed pattern match at Data.Map line 156, column 3 - line 163, column 1: " + [ v.value0.constructor.name ]);
                  };
                  throw new Error("Failed pattern match at Data.Map line 154, column 1 - line 155, column 1: " + [ v.constructor.name, tree.constructor.name ]);
              };
          };
      };
  };

  /**
 *  | Insert a key/value pair into a map
 */  
  var insert = function (dictOrd) {
      var up = function (__copy_v) {
          return function (__copy_v1) {
              var v = __copy_v;
              var v1 = __copy_v1;
              tco: while (true) {
                  if (v instanceof Data_List.Nil) {
                      return new Two(v1.value0, v1.value1, v1.value2, v1.value3);
                  };
                  if (v instanceof Data_List.Cons) {
                      if (v.value0 instanceof TwoLeft) {
                          return fromZipper(dictOrd)(v.value1)(new Three(v1.value0, v1.value1, v1.value2, v1.value3, v.value0.value0, v.value0.value1, v.value0.value2));
                      };
                      if (v.value0 instanceof TwoRight) {
                          return fromZipper(dictOrd)(v.value1)(new Three(v.value0.value0, v.value0.value1, v.value0.value2, v1.value0, v1.value1, v1.value2, v1.value3));
                      };
                      if (v.value0 instanceof ThreeLeft) {
                          var __tco_v = v.value1;
                          var __tco_v1 = new KickUp(new Two(v1.value0, v1.value1, v1.value2, v1.value3), v.value0.value0, v.value0.value1, new Two(v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5));
                          v = __tco_v;
                          v1 = __tco_v1;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeMiddle) {
                          var __tco_v = v.value1;
                          var __tco_v1 = new KickUp(new Two(v.value0.value0, v.value0.value1, v.value0.value2, v1.value0), v1.value1, v1.value2, new Two(v1.value3, v.value0.value3, v.value0.value4, v.value0.value5));
                          v = __tco_v;
                          v1 = __tco_v1;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeRight) {
                          var __tco_v = v.value1;
                          var __tco_v1 = new KickUp(new Two(v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3), v.value0.value4, v.value0.value5, new Two(v1.value0, v1.value1, v1.value2, v1.value3));
                          v = __tco_v;
                          v1 = __tco_v1;
                          continue tco;
                      };
                      throw new Error("Failed pattern match at Data.Map line 197, column 5 - line 205, column 1: " + [ v.value0.constructor.name ]);
                  };
                  throw new Error("Failed pattern match at Data.Map line 195, column 3 - line 196, column 3: " + [ v.constructor.name, v1.constructor.name ]);
              };
          };
      };
      var comp = Prelude.compare(dictOrd);
      var down = function (__copy_ctx) {
          return function (__copy_k) {
              return function (__copy_v) {
                  return function (__copy_v1) {
                      var ctx = __copy_ctx;
                      var k = __copy_k;
                      var v = __copy_v;
                      var v1 = __copy_v1;
                      tco: while (true) {
                          if (v1 instanceof Leaf) {
                              return up(ctx)(new KickUp(Leaf.value, k, v, Leaf.value));
                          };
                          if (v1 instanceof Two) {
                              var $203 = comp(k)(v1.value1);
                              if ($203 instanceof Prelude.EQ) {
                                  return fromZipper(dictOrd)(ctx)(new Two(v1.value0, k, v, v1.value3));
                              };
                              if ($203 instanceof Prelude.LT) {
                                  var __tco_ctx = new Data_List.Cons(new TwoLeft(v1.value1, v1.value2, v1.value3), ctx);
                                  var __tco_k = k;
                                  var __tco_v = v;
                                  var __tco_v1 = v1.value0;
                                  ctx = __tco_ctx;
                                  k = __tco_k;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              var __tco_ctx = new Data_List.Cons(new TwoRight(v1.value0, v1.value1, v1.value2), ctx);
                              var __tco_k = k;
                              var __tco_v = v;
                              var __tco_v1 = v1.value3;
                              ctx = __tco_ctx;
                              k = __tco_k;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                          if (v1 instanceof Three) {
                              var $208 = comp(k)(v1.value1);
                              if ($208 instanceof Prelude.EQ) {
                                  return fromZipper(dictOrd)(ctx)(new Three(v1.value0, k, v, v1.value3, v1.value4, v1.value5, v1.value6));
                              };
                              var $209 = comp(k)(v1.value4);
                              if ($209 instanceof Prelude.EQ) {
                                  return fromZipper(dictOrd)(ctx)(new Three(v1.value0, v1.value1, v1.value2, v1.value3, k, v, v1.value6));
                              };
                              if ($208 instanceof Prelude.LT) {
                                  var __tco_ctx = new Data_List.Cons(new ThreeLeft(v1.value1, v1.value2, v1.value3, v1.value4, v1.value5, v1.value6), ctx);
                                  var __tco_k = k;
                                  var __tco_v = v;
                                  var __tco_v1 = v1.value0;
                                  ctx = __tco_ctx;
                                  k = __tco_k;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              if ($208 instanceof Prelude.GT) {
                                  if ($209 instanceof Prelude.LT) {
                                      var __tco_ctx = new Data_List.Cons(new ThreeMiddle(v1.value0, v1.value1, v1.value2, v1.value4, v1.value5, v1.value6), ctx);
                                      var __tco_k = k;
                                      var __tco_v = v;
                                      var __tco_v1 = v1.value3;
                                      ctx = __tco_ctx;
                                      k = __tco_k;
                                      v = __tco_v;
                                      v1 = __tco_v1;
                                      continue tco;
                                  };
                                  var __tco_ctx = new Data_List.Cons(new ThreeRight(v1.value0, v1.value1, v1.value2, v1.value3, v1.value4, v1.value5), ctx);
                                  var __tco_k = k;
                                  var __tco_v = v;
                                  var __tco_v1 = v1.value6;
                                  ctx = __tco_ctx;
                                  k = __tco_k;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              var __tco_ctx = new Data_List.Cons(new ThreeRight(v1.value0, v1.value1, v1.value2, v1.value3, v1.value4, v1.value5), ctx);
                              var __tco_k = k;
                              var __tco_v = v;
                              var __tco_v1 = v1.value6;
                              ctx = __tco_ctx;
                              k = __tco_k;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                          throw new Error("Failed pattern match at Data.Map line 173, column 3 - line 174, column 3: " + [ ctx.constructor.name, k.constructor.name, v.constructor.name, v1.constructor.name ]);
                      };
                  };
              };
          };
      };
      return down(Data_List.Nil.value);
  };

  /**
 *  | An empty map
 */  
  var empty = Leaf.value;

  /**
 *  | Delete a key and its corresponding value from a map
 */  
  var $$delete = function (dictOrd) {
      var up = function (__copy_v) {
          return function (__copy_v1) {
              var v = __copy_v;
              var v1 = __copy_v1;
              tco: while (true) {
                  if (v instanceof Data_List.Nil) {
                      return v1;
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof TwoLeft && (v.value0.value2 instanceof Leaf && v1 instanceof Leaf))) {
                      return fromZipper(dictOrd)(v.value1)(new Two(Leaf.value, v.value0.value0, v.value0.value1, Leaf.value));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof TwoRight && (v.value0.value0 instanceof Leaf && v1 instanceof Leaf))) {
                      return fromZipper(dictOrd)(v.value1)(new Two(Leaf.value, v.value0.value1, v.value0.value2, Leaf.value));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof TwoLeft && v.value0.value2 instanceof Two)) {
                      var __tco_v = v.value1;
                      var __tco_v1 = new Three(v1, v.value0.value0, v.value0.value1, v.value0.value2.value0, v.value0.value2.value1, v.value0.value2.value2, v.value0.value2.value3);
                      v = __tco_v;
                      v1 = __tco_v1;
                      continue tco;
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof TwoRight && v.value0.value0 instanceof Two)) {
                      var __tco_v = v.value1;
                      var __tco_v1 = new Three(v.value0.value0.value0, v.value0.value0.value1, v.value0.value0.value2, v.value0.value0.value3, v.value0.value1, v.value0.value2, v1);
                      v = __tco_v;
                      v1 = __tco_v1;
                      continue tco;
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof TwoLeft && v.value0.value2 instanceof Three)) {
                      return fromZipper(dictOrd)(v.value1)(new Two(new Two(v1, v.value0.value0, v.value0.value1, v.value0.value2.value0), v.value0.value2.value1, v.value0.value2.value2, new Two(v.value0.value2.value3, v.value0.value2.value4, v.value0.value2.value5, v.value0.value2.value6)));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof TwoRight && v.value0.value0 instanceof Three)) {
                      return fromZipper(dictOrd)(v.value1)(new Two(new Two(v.value0.value0.value0, v.value0.value0.value1, v.value0.value0.value2, v.value0.value0.value3), v.value0.value0.value4, v.value0.value0.value5, new Two(v.value0.value0.value6, v.value0.value1, v.value0.value2, v1)));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeLeft && (v.value0.value2 instanceof Leaf && (v.value0.value5 instanceof Leaf && v1 instanceof Leaf)))) {
                      return fromZipper(dictOrd)(v.value1)(new Three(Leaf.value, v.value0.value0, v.value0.value1, Leaf.value, v.value0.value3, v.value0.value4, Leaf.value));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeMiddle && (v.value0.value0 instanceof Leaf && (v.value0.value5 instanceof Leaf && v1 instanceof Leaf)))) {
                      return fromZipper(dictOrd)(v.value1)(new Three(Leaf.value, v.value0.value1, v.value0.value2, Leaf.value, v.value0.value3, v.value0.value4, Leaf.value));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeRight && (v.value0.value0 instanceof Leaf && (v.value0.value3 instanceof Leaf && v1 instanceof Leaf)))) {
                      return fromZipper(dictOrd)(v.value1)(new Three(Leaf.value, v.value0.value1, v.value0.value2, Leaf.value, v.value0.value4, v.value0.value5, Leaf.value));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeLeft && v.value0.value2 instanceof Two)) {
                      return fromZipper(dictOrd)(v.value1)(new Two(new Three(v1, v.value0.value0, v.value0.value1, v.value0.value2.value0, v.value0.value2.value1, v.value0.value2.value2, v.value0.value2.value3), v.value0.value3, v.value0.value4, v.value0.value5));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeMiddle && v.value0.value0 instanceof Two)) {
                      return fromZipper(dictOrd)(v.value1)(new Two(new Three(v.value0.value0.value0, v.value0.value0.value1, v.value0.value0.value2, v.value0.value0.value3, v.value0.value1, v.value0.value2, v1), v.value0.value3, v.value0.value4, v.value0.value5));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeMiddle && v.value0.value5 instanceof Two)) {
                      return fromZipper(dictOrd)(v.value1)(new Two(v.value0.value0, v.value0.value1, v.value0.value2, new Three(v1, v.value0.value3, v.value0.value4, v.value0.value5.value0, v.value0.value5.value1, v.value0.value5.value2, v.value0.value5.value3)));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeRight && v.value0.value3 instanceof Two)) {
                      return fromZipper(dictOrd)(v.value1)(new Two(v.value0.value0, v.value0.value1, v.value0.value2, new Three(v.value0.value3.value0, v.value0.value3.value1, v.value0.value3.value2, v.value0.value3.value3, v.value0.value4, v.value0.value5, v1)));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeLeft && v.value0.value2 instanceof Three)) {
                      return fromZipper(dictOrd)(v.value1)(new Three(new Two(v1, v.value0.value0, v.value0.value1, v.value0.value2.value0), v.value0.value2.value1, v.value0.value2.value2, new Two(v.value0.value2.value3, v.value0.value2.value4, v.value0.value2.value5, v.value0.value2.value6), v.value0.value3, v.value0.value4, v.value0.value5));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeMiddle && v.value0.value0 instanceof Three)) {
                      return fromZipper(dictOrd)(v.value1)(new Three(new Two(v.value0.value0.value0, v.value0.value0.value1, v.value0.value0.value2, v.value0.value0.value3), v.value0.value0.value4, v.value0.value0.value5, new Two(v.value0.value0.value6, v.value0.value1, v.value0.value2, v1), v.value0.value3, v.value0.value4, v.value0.value5));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeMiddle && v.value0.value5 instanceof Three)) {
                      return fromZipper(dictOrd)(v.value1)(new Three(v.value0.value0, v.value0.value1, v.value0.value2, new Two(v1, v.value0.value3, v.value0.value4, v.value0.value5.value0), v.value0.value5.value1, v.value0.value5.value2, new Two(v.value0.value5.value3, v.value0.value5.value4, v.value0.value5.value5, v.value0.value5.value6)));
                  };
                  if (v instanceof Data_List.Cons && (v.value0 instanceof ThreeRight && v.value0.value3 instanceof Three)) {
                      return fromZipper(dictOrd)(v.value1)(new Three(v.value0.value0, v.value0.value1, v.value0.value2, new Two(v.value0.value3.value0, v.value0.value3.value1, v.value0.value3.value2, v.value0.value3.value3), v.value0.value3.value4, v.value0.value3.value5, new Two(v.value0.value3.value6, v.value0.value4, v.value0.value5, v1)));
                  };
                  return Data_Maybe_Unsafe.unsafeThrow("Impossible case in 'up'");
              };
          };
      };
      var removeMaxNode = function (__copy_v) {
          return function (__copy_v1) {
              var v = __copy_v;
              var v1 = __copy_v1;
              tco: while (true) {
                  if (v1 instanceof Two && (v1.value0 instanceof Leaf && v1.value3 instanceof Leaf)) {
                      return up(v)(Leaf.value);
                  };
                  if (v1 instanceof Two) {
                      var __tco_v = new Data_List.Cons(new TwoRight(v1.value0, v1.value1, v1.value2), v);
                      var __tco_v1 = v1.value3;
                      v = __tco_v;
                      v1 = __tco_v1;
                      continue tco;
                  };
                  if (v1 instanceof Three && (v1.value0 instanceof Leaf && (v1.value3 instanceof Leaf && v1.value6 instanceof Leaf))) {
                      return up(new Data_List.Cons(new TwoRight(Leaf.value, v1.value1, v1.value2), v))(Leaf.value);
                  };
                  if (v1 instanceof Three) {
                      var __tco_v = new Data_List.Cons(new ThreeRight(v1.value0, v1.value1, v1.value2, v1.value3, v1.value4, v1.value5), v);
                      var __tco_v1 = v1.value6;
                      v = __tco_v;
                      v1 = __tco_v1;
                      continue tco;
                  };
                  if (v1 instanceof Leaf) {
                      return Data_Maybe_Unsafe.unsafeThrow("Impossible case in 'removeMaxNode'");
                  };
                  throw new Error("Failed pattern match at Data.Map line 259, column 3 - line 260, column 3: " + [ v.constructor.name, v1.constructor.name ]);
              };
          };
      };
      var maxNode = function (__copy_v) {
          var v = __copy_v;
          tco: while (true) {
              if (v instanceof Two && v.value3 instanceof Leaf) {
                  return {
                      key: v.value1, 
                      value: v.value2
                  };
              };
              if (v instanceof Two) {
                  var __tco_v = v.value3;
                  v = __tco_v;
                  continue tco;
              };
              if (v instanceof Three && v.value6 instanceof Leaf) {
                  return {
                      key: v.value4, 
                      value: v.value5
                  };
              };
              if (v instanceof Three) {
                  var __tco_v = v.value6;
                  v = __tco_v;
                  continue tco;
              };
              if (v instanceof Leaf) {
                  return Data_Maybe_Unsafe.unsafeThrow("Impossible case in 'maxNode'");
              };
              throw new Error("Failed pattern match at Data.Map line 251, column 3 - line 252, column 3: " + [ v.constructor.name ]);
          };
      };
      var down = function (__copy_ctx) {
          return function (__copy_v) {
              return function (__copy_v1) {
                  var ctx = __copy_ctx;
                  var v = __copy_v;
                  var v1 = __copy_v1;
                  tco: while (true) {
                      if (v1 instanceof Leaf) {
                          return fromZipper(dictOrd)(ctx)(Leaf.value);
                      };
                      if (v1 instanceof Two && (v1.value0 instanceof Leaf && (v1.value3 instanceof Leaf && Prelude["=="](dictOrd["__superclass_Prelude.Eq_0"]())(v)(v1.value1)))) {
                          return up(ctx)(Leaf.value);
                      };
                      if (v1 instanceof Two) {
                          if (Prelude["=="](dictOrd["__superclass_Prelude.Eq_0"]())(v)(v1.value1)) {
                              var max = maxNode(v1.value0);
                              return removeMaxNode(new Data_List.Cons(new TwoLeft(max.key, max.value, v1.value3), ctx))(v1.value0);
                          };
                          if (Prelude["<"](dictOrd)(v)(v1.value1)) {
                              var __tco_ctx = new Data_List.Cons(new TwoLeft(v1.value1, v1.value2, v1.value3), ctx);
                              var __tco_v = v;
                              var __tco_v1 = v1.value0;
                              ctx = __tco_ctx;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                          if (Prelude.otherwise) {
                              var __tco_ctx = new Data_List.Cons(new TwoRight(v1.value0, v1.value1, v1.value2), ctx);
                              var __tco_v = v;
                              var __tco_v1 = v1.value3;
                              ctx = __tco_ctx;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                      };
                      if (v1 instanceof Three && (v1.value0 instanceof Leaf && (v1.value3 instanceof Leaf && v1.value6 instanceof Leaf))) {
                          if (Prelude["=="](dictOrd["__superclass_Prelude.Eq_0"]())(v)(v1.value1)) {
                              return fromZipper(dictOrd)(ctx)(new Two(Leaf.value, v1.value4, v1.value5, Leaf.value));
                          };
                          if (Prelude["=="](dictOrd["__superclass_Prelude.Eq_0"]())(v)(v1.value4)) {
                              return fromZipper(dictOrd)(ctx)(new Two(Leaf.value, v1.value1, v1.value2, Leaf.value));
                          };
                      };
                      if (v1 instanceof Three) {
                          if (Prelude["=="](dictOrd["__superclass_Prelude.Eq_0"]())(v)(v1.value1)) {
                              var max = maxNode(v1.value0);
                              return removeMaxNode(new Data_List.Cons(new ThreeLeft(max.key, max.value, v1.value3, v1.value4, v1.value5, v1.value6), ctx))(v1.value0);
                          };
                          if (Prelude["=="](dictOrd["__superclass_Prelude.Eq_0"]())(v)(v1.value4)) {
                              var max = maxNode(v1.value3);
                              return removeMaxNode(new Data_List.Cons(new ThreeMiddle(v1.value0, v1.value1, v1.value2, max.key, max.value, v1.value6), ctx))(v1.value3);
                          };
                          if (Prelude["<"](dictOrd)(v)(v1.value1)) {
                              var __tco_ctx = new Data_List.Cons(new ThreeLeft(v1.value1, v1.value2, v1.value3, v1.value4, v1.value5, v1.value6), ctx);
                              var __tco_v = v;
                              var __tco_v1 = v1.value0;
                              ctx = __tco_ctx;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                          if (Prelude["<"](dictOrd)(v1.value1)(v) && Prelude["<"](dictOrd)(v)(v1.value4)) {
                              var __tco_ctx = new Data_List.Cons(new ThreeMiddle(v1.value0, v1.value1, v1.value2, v1.value4, v1.value5, v1.value6), ctx);
                              var __tco_v = v;
                              var __tco_v1 = v1.value3;
                              ctx = __tco_ctx;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                          if (Prelude.otherwise) {
                              var __tco_ctx = new Data_List.Cons(new ThreeRight(v1.value0, v1.value1, v1.value2, v1.value3, v1.value4, v1.value5), ctx);
                              var __tco_v = v;
                              var __tco_v1 = v1.value6;
                              ctx = __tco_ctx;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                      };
                      throw new Error("Failed pattern match at Data.Map line 209, column 3 - line 210, column 3: " + [ ctx.constructor.name, v.constructor.name, v1.constructor.name ]);
                  };
              };
          };
      };
      return down(Data_List.Nil.value);
  };

  /**
 *  | Insert the value, delete a value, or update a value for a key in a map
 */  
  var alter = function (dictOrd) {
      return function (f) {
          return function (k) {
              return function (m) {
                  var $492 = f(lookup(dictOrd)(k)(m));
                  if ($492 instanceof Data_Maybe.Nothing) {
                      return $$delete(dictOrd)(k)(m);
                  };
                  if ($492 instanceof Data_Maybe.Just) {
                      return insert(dictOrd)(k)($492.value0)(m);
                  };
                  throw new Error("Failed pattern match at Data.Map line 268, column 15 - line 273, column 1: " + [ $492.constructor.name ]);
              };
          };
      };
  };

  /**
 *  | Compute the union of two maps, using the specified function
 *  | to combine values for duplicate keys.
 */  
  var unionWith = function (dictOrd) {
      return function (f) {
          return function (m1) {
              return function (m2) {
                  var go = function (m) {
                      return function (v) {
                          return alter(dictOrd)(function ($505) {
                              return Data_Maybe.Just.create(Data_Maybe.maybe(v.value1)(f(v.value1))($505));
                          })(v.value0)(m);
                      };
                  };
                  return Data_Foldable.foldl(Data_List.foldableList)(go)(m2)(toList(m1));
              };
          };
      };
  };

  /**
 *  | Compute the union of two maps, preferring values from the first map in the case
 *  | of duplicate keys
 */  
  var union = function (dictOrd) {
      return unionWith(dictOrd)(Prelude["const"]);
  };

  /**
 *  | Compute the union of a collection of maps
 */  
  var unions = function (dictOrd) {
      return function (dictFoldable) {
          return Data_Foldable.foldl(dictFoldable)(union(dictOrd))(empty);
      };
  };
  exports["unions"] = unions;
  exports["unionWith"] = unionWith;
  exports["union"] = union;
  exports["keys"] = keys;
  exports["alter"] = alter;
  exports["delete"] = $$delete;
  exports["toList"] = toList;
  exports["lookup"] = lookup;
  exports["insert"] = insert;
  exports["singleton"] = singleton;
  exports["empty"] = empty;
  exports["showMap"] = showMap;
  exports["functorMap"] = functorMap;
})(PS["Data.Map"] = PS["Data.Map"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.Nullable

  exports["null"] = null;

  exports.nullable = function(a, r, f) {
      return a == null ? r : f(a);
  };

  exports.notNull = function(x) {
      return x;
  };
})(PS["Data.Nullable"] = PS["Data.Nullable"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines types and functions for working with nullable types
 *  | using the FFI.
 */  
  "use strict";
  var $foreign = PS["Data.Nullable"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Function = PS["Data.Function"];        

  /**
 *  | Takes `Nothing` to `null`, and `Just a` to `a`.
 */  
  var toNullable = Data_Maybe.maybe($foreign["null"])($foreign.notNull);

  /**
 *  | Represent `null` using `Maybe a` as `Nothing`. 
 */  
  var toMaybe = function (n) {
      return $foreign.nullable(n, Data_Maybe.Nothing.value, Data_Maybe.Just.create);
  };
  exports["toNullable"] = toNullable;
  exports["toMaybe"] = toMaybe;
})(PS["Data.Nullable"] = PS["Data.Nullable"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines the opposite of the function category, `Op` and its instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Functor_Contravariant = PS["Data.Functor.Contravariant"];        

  /**
 *  | The opposite of the function category.
 */  
  var Op = function (x) {
      return x;
  };

  /**
 *  | Unpack a value of type `Op a b`, revealing a function.
 */  
  var runOp = function (v) {
      return v;
  };
  exports["Op"] = Op;
  exports["runOp"] = runOp;
})(PS["Data.Op"] = PS["Data.Op"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports._copyEff = function (m) {
    return function () {
      var r = {};
      for (var k in m) {
        if (m.hasOwnProperty(k)) {
          r[k] = m[k];
        }
      }
      return r;
    };
  };

  exports.empty = {};

  exports.runST = function (f) {
    return f;
  };

  // jshint maxparams: 4
  exports._lookup = function (no, yes, k, m) {
    return k in m ? yes(m[k]) : no;
  };

  function _collect (f) {
    return function (m) {
      var r = [];
      for (var k in m) {
        if (m.hasOwnProperty(k)) {
          r.push(f(k)(m[k]));
        }
      }
      return r;
    };
  }

  exports._collect = _collect;

  exports.keys = Object.keys || _collect(function (k) {
    return function () { return k; };
  });
})(PS["Data.StrMap"] = PS["Data.StrMap"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.StrMap.ST

  exports["new"] = function () {
    return {};
  };

  exports.poke = function (m) {
    return function (k) {
      return function (v) {
        return function () {
          m[k] = v;
          return m;
        };
      };
    };
  };

  exports["delete"] = function (m) {
    return function (k) {
      return function () {
        delete m[k];
        return m;
      };
    };
  };
})(PS["Data.StrMap.ST"] = PS["Data.StrMap.ST"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Helper functions for working with mutable maps using the `ST` effect.
 *  |
 *  | This module can be used when performance is important and mutation is a local effect.
 */  
  "use strict";
  var $foreign = PS["Data.StrMap.ST"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_ST = PS["Control.Monad.ST"];
  var Data_Maybe = PS["Data.Maybe"];
  exports["delete"] = $foreign["delete"];
  exports["poke"] = $foreign.poke;
  exports["new"] = $foreign["new"];
})(PS["Data.StrMap.ST"] = PS["Data.StrMap.ST"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a type of native Javascript maps which
 *  | require the keys to be strings.
 *  |
 *  | To maximize performance, Javascript objects are not wrapped,
 *  | and some native code is used even when it's not necessary.
 */  
  "use strict";
  var $foreign = PS["Data.StrMap"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_List = PS["Data.List"];
  var Control_Monad_ST = PS["Control.Monad.ST"];
  var Data_StrMap_ST = PS["Data.StrMap.ST"];

  /**
 *  | Convert an immutable map into a mutable map
 */  
  var thawST = $foreign._copyEff;
  var pureST = function (f) {
      return Control_Monad_Eff.runPure($foreign.runST(f));
  };
  var mutate = function (f) {
      return function (m) {
          return pureST(function __do() {
              var v = thawST(m)();
              f(v)();
              return v;
          });
      };
  };                                                                                 

  /**
 *  | Lookup the value for a key in a map
 */  
  var lookup = Data_Function.runFn4($foreign._lookup)(Data_Maybe.Nothing.value)(Data_Maybe.Just.create);

  /**
 *  | Insert a key and value into a map
 */  
  var insert = function (k) {
      return function (v) {
          return mutate(function (s) {
              return Data_StrMap_ST.poke(s)(k)(v);
          });
      };
  };                                                          

  /**
 *  | Create a map from a foldable collection of key/value pairs
 */  
  var fromFoldable = function (dictFoldable) {
      return function (l) {
          return pureST(function __do() {
              var v = Data_StrMap_ST["new"]();
              Data_Foldable.for_(Control_Monad_Eff.applicativeEff)(dictFoldable)(l)(function (v1) {
                  return Data_StrMap_ST.poke(v)(v1.value0)(v1.value1);
              })();
              return v;
          });
      };
  };

  /**
 *  | Delete a key and value from a map
 */  
  var $$delete = function (k) {
      return mutate(function (s) {
          return Data_StrMap_ST["delete"](s)(k);
      });
  };

  /**
 *  | Insert, remove or update a value for a key in a map
 */  
  var alter = function (f) {
      return function (k) {
          return function (m) {
              var $36 = f(lookup(k)(m));
              if ($36 instanceof Data_Maybe.Nothing) {
                  return $$delete(k)(m);
              };
              if ($36 instanceof Data_Maybe.Just) {
                  return insert(k)($36.value0)(m);
              };
              throw new Error("Failed pattern match at Data.StrMap line 178, column 15 - line 183, column 1: " + [ $36.constructor.name ]);
          };
      };
  };
  exports["thawST"] = thawST;
  exports["alter"] = alter;
  exports["fromFoldable"] = fromFoldable;
  exports["lookup"] = lookup;
  exports["insert"] = insert;
  exports["keys"] = $foreign.keys;
  exports["empty"] = $foreign.empty;
})(PS["Data.StrMap"] = PS["Data.StrMap"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Op = PS["Data.Op"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Foldable = PS["Data.Foldable"];
  var semigroupOptions = new Prelude.Semigroup(function (v) {
      return function (v1) {
          return Prelude["<>"](Prelude.semigroupArray)(v)(v1);
      };
  });
  var runOptions = function (v) {
      return v;
  };

  /**
 *  | Convert an `Options` value into a JavaScript object, suitable for passing
 *  | to JavaScript APIs.
 */  
  var options = function ($9) {
      return Data_Foreign.toForeign(Data_StrMap.fromFoldable(Data_Foldable.foldableArray)(runOptions($9)));
  };
  var monoidOptions = new Data_Monoid.Monoid(function () {
      return semigroupOptions;
  }, [  ]);

  /**
 *  | The default method for turning a string property key into an
 *  | `Option`. This function simply calls `toForeign` on the value. If
 *  | you need some other behaviour, you can write your own function to replace
 *  | this one, and construct an `Option` yourself.
 */  
  var defaultToOptions = function (k) {
      return function (v) {
          return [ new Data_Tuple.Tuple(k, Data_Foreign.toForeign(v)) ];
      };
  };

  /**
 *  | The default way of creating `Option` values. Constructs an `Option` with
 *  | the given key, which passes the given value through unchanged.
 */  
  var opt = function ($10) {
      return Data_Op.Op(defaultToOptions($10));
  };

  /**
 *  | Associates a value with a specific option.
 */  
  var assoc = function (o) {
      return function (value) {
          return Data_Op.runOp(o)(value);
      };
  };

  /**
 *  | An infix version of `assoc`.
 */  
  var $colon$eq = assoc;
  exports["defaultToOptions"] = defaultToOptions;
  exports["opt"] = opt;
  exports[":="] = $colon$eq;
  exports["assoc"] = assoc;
  exports["options"] = options;
  exports["runOptions"] = runOptions;
  exports["semigroupOptions"] = semigroupOptions;
  exports["monoidOptions"] = monoidOptions;
})(PS["Data.Options"] = PS["Data.Options"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | A module defining some useful types and instances surrounding the `Ord`
 *  | type class.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Data_Monoid = PS["Data.Monoid"];

  /**
 *  | Test whether a value is between a minimum and a maximum. For example:
 *  |
 *  |     let f = between 0 10
 *  |     f (-5) == false
 *  |     f 5    == true
 *  |     f 15   == false
 *  |
 */  
  var between = function (dictOrd) {
      return function (low) {
          return function (hi) {
              return function (x) {
                  return Prelude["<="](dictOrd)(low)(x) && Prelude["<="](dictOrd)(x)(hi);
              };
          };
      };
  };
  exports["between"] = between;
})(PS["Data.Ord"] = PS["Data.Ord"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];        
  var SIGABRT = (function () {
      function SIGABRT() {

      };
      SIGABRT.value = new SIGABRT();
      return SIGABRT;
  })();
  var SIGALRM = (function () {
      function SIGALRM() {

      };
      SIGALRM.value = new SIGALRM();
      return SIGALRM;
  })();
  var SIGBUS = (function () {
      function SIGBUS() {

      };
      SIGBUS.value = new SIGBUS();
      return SIGBUS;
  })();
  var SIGCHLD = (function () {
      function SIGCHLD() {

      };
      SIGCHLD.value = new SIGCHLD();
      return SIGCHLD;
  })();
  var SIGCLD = (function () {
      function SIGCLD() {

      };
      SIGCLD.value = new SIGCLD();
      return SIGCLD;
  })();
  var SIGCONT = (function () {
      function SIGCONT() {

      };
      SIGCONT.value = new SIGCONT();
      return SIGCONT;
  })();
  var SIGEMT = (function () {
      function SIGEMT() {

      };
      SIGEMT.value = new SIGEMT();
      return SIGEMT;
  })();
  var SIGFPE = (function () {
      function SIGFPE() {

      };
      SIGFPE.value = new SIGFPE();
      return SIGFPE;
  })();
  var SIGHUP = (function () {
      function SIGHUP() {

      };
      SIGHUP.value = new SIGHUP();
      return SIGHUP;
  })();
  var SIGILL = (function () {
      function SIGILL() {

      };
      SIGILL.value = new SIGILL();
      return SIGILL;
  })();
  var SIGINFO = (function () {
      function SIGINFO() {

      };
      SIGINFO.value = new SIGINFO();
      return SIGINFO;
  })();
  var SIGINT = (function () {
      function SIGINT() {

      };
      SIGINT.value = new SIGINT();
      return SIGINT;
  })();
  var SIGIO = (function () {
      function SIGIO() {

      };
      SIGIO.value = new SIGIO();
      return SIGIO;
  })();
  var SIGIOT = (function () {
      function SIGIOT() {

      };
      SIGIOT.value = new SIGIOT();
      return SIGIOT;
  })();
  var SIGKILL = (function () {
      function SIGKILL() {

      };
      SIGKILL.value = new SIGKILL();
      return SIGKILL;
  })();
  var SIGLOST = (function () {
      function SIGLOST() {

      };
      SIGLOST.value = new SIGLOST();
      return SIGLOST;
  })();
  var SIGPIPE = (function () {
      function SIGPIPE() {

      };
      SIGPIPE.value = new SIGPIPE();
      return SIGPIPE;
  })();
  var SIGPOLL = (function () {
      function SIGPOLL() {

      };
      SIGPOLL.value = new SIGPOLL();
      return SIGPOLL;
  })();
  var SIGPROF = (function () {
      function SIGPROF() {

      };
      SIGPROF.value = new SIGPROF();
      return SIGPROF;
  })();
  var SIGPWR = (function () {
      function SIGPWR() {

      };
      SIGPWR.value = new SIGPWR();
      return SIGPWR;
  })();
  var SIGQUIT = (function () {
      function SIGQUIT() {

      };
      SIGQUIT.value = new SIGQUIT();
      return SIGQUIT;
  })();
  var SIGSEGV = (function () {
      function SIGSEGV() {

      };
      SIGSEGV.value = new SIGSEGV();
      return SIGSEGV;
  })();
  var SIGSTKFLT = (function () {
      function SIGSTKFLT() {

      };
      SIGSTKFLT.value = new SIGSTKFLT();
      return SIGSTKFLT;
  })();
  var SIGSTOP = (function () {
      function SIGSTOP() {

      };
      SIGSTOP.value = new SIGSTOP();
      return SIGSTOP;
  })();
  var SIGSYS = (function () {
      function SIGSYS() {

      };
      SIGSYS.value = new SIGSYS();
      return SIGSYS;
  })();
  var SIGTERM = (function () {
      function SIGTERM() {

      };
      SIGTERM.value = new SIGTERM();
      return SIGTERM;
  })();
  var SIGTRAP = (function () {
      function SIGTRAP() {

      };
      SIGTRAP.value = new SIGTRAP();
      return SIGTRAP;
  })();
  var SIGTSTP = (function () {
      function SIGTSTP() {

      };
      SIGTSTP.value = new SIGTSTP();
      return SIGTSTP;
  })();
  var SIGTTIN = (function () {
      function SIGTTIN() {

      };
      SIGTTIN.value = new SIGTTIN();
      return SIGTTIN;
  })();
  var SIGTTOU = (function () {
      function SIGTTOU() {

      };
      SIGTTOU.value = new SIGTTOU();
      return SIGTTOU;
  })();
  var SIGUNUSED = (function () {
      function SIGUNUSED() {

      };
      SIGUNUSED.value = new SIGUNUSED();
      return SIGUNUSED;
  })();
  var SIGURG = (function () {
      function SIGURG() {

      };
      SIGURG.value = new SIGURG();
      return SIGURG;
  })();
  var SIGUSR1 = (function () {
      function SIGUSR1() {

      };
      SIGUSR1.value = new SIGUSR1();
      return SIGUSR1;
  })();
  var SIGUSR2 = (function () {
      function SIGUSR2() {

      };
      SIGUSR2.value = new SIGUSR2();
      return SIGUSR2;
  })();
  var SIGVTALRM = (function () {
      function SIGVTALRM() {

      };
      SIGVTALRM.value = new SIGVTALRM();
      return SIGVTALRM;
  })();
  var SIGWINCH = (function () {
      function SIGWINCH() {

      };
      SIGWINCH.value = new SIGWINCH();
      return SIGWINCH;
  })();
  var SIGXCPU = (function () {
      function SIGXCPU() {

      };
      SIGXCPU.value = new SIGXCPU();
      return SIGXCPU;
  })();
  var SIGXFSZ = (function () {
      function SIGXFSZ() {

      };
      SIGXFSZ.value = new SIGXFSZ();
      return SIGXFSZ;
  })();

  /**
 *  | Convert a Signal to a String. Suitable for Node.js APIs.
 */  
  var toString = function (s) {
      if (s instanceof SIGABRT) {
          return "SIGABRT";
      };
      if (s instanceof SIGALRM) {
          return "SIGALRM";
      };
      if (s instanceof SIGBUS) {
          return "SIGBUS";
      };
      if (s instanceof SIGCHLD) {
          return "SIGCHLD";
      };
      if (s instanceof SIGCLD) {
          return "SIGCLD";
      };
      if (s instanceof SIGCONT) {
          return "SIGCONT";
      };
      if (s instanceof SIGEMT) {
          return "SIGEMT";
      };
      if (s instanceof SIGFPE) {
          return "SIGFPE";
      };
      if (s instanceof SIGHUP) {
          return "SIGHUP";
      };
      if (s instanceof SIGILL) {
          return "SIGILL";
      };
      if (s instanceof SIGINFO) {
          return "SIGINFO";
      };
      if (s instanceof SIGINT) {
          return "SIGINT";
      };
      if (s instanceof SIGIO) {
          return "SIGIO";
      };
      if (s instanceof SIGIOT) {
          return "SIGIOT";
      };
      if (s instanceof SIGKILL) {
          return "SIGKILL";
      };
      if (s instanceof SIGLOST) {
          return "SIGLOST";
      };
      if (s instanceof SIGPIPE) {
          return "SIGPIPE";
      };
      if (s instanceof SIGPOLL) {
          return "SIGPOLL";
      };
      if (s instanceof SIGPROF) {
          return "SIGPROF";
      };
      if (s instanceof SIGPWR) {
          return "SIGPWR";
      };
      if (s instanceof SIGQUIT) {
          return "SIGQUIT";
      };
      if (s instanceof SIGSEGV) {
          return "SIGSEGV";
      };
      if (s instanceof SIGSTKFLT) {
          return "SIGSTKFLT";
      };
      if (s instanceof SIGSTOP) {
          return "SIGSTOP";
      };
      if (s instanceof SIGSYS) {
          return "SIGSYS";
      };
      if (s instanceof SIGTERM) {
          return "SIGTERM";
      };
      if (s instanceof SIGTRAP) {
          return "SIGTRAP";
      };
      if (s instanceof SIGTSTP) {
          return "SIGTSTP";
      };
      if (s instanceof SIGTTIN) {
          return "SIGTTIN";
      };
      if (s instanceof SIGTTOU) {
          return "SIGTTOU";
      };
      if (s instanceof SIGUNUSED) {
          return "SIGUNUSED";
      };
      if (s instanceof SIGURG) {
          return "SIGURG";
      };
      if (s instanceof SIGUSR1) {
          return "SIGUSR1";
      };
      if (s instanceof SIGUSR2) {
          return "SIGUSR2";
      };
      if (s instanceof SIGVTALRM) {
          return "SIGVTALRM";
      };
      if (s instanceof SIGWINCH) {
          return "SIGWINCH";
      };
      if (s instanceof SIGXCPU) {
          return "SIGXCPU";
      };
      if (s instanceof SIGXFSZ) {
          return "SIGXFSZ";
      };
      throw new Error("Failed pattern match at Data.Posix.Signal line 49, column 14 - line 95, column 1: " + [ s.constructor.name ]);
  };
  var showSignal = new Prelude.Show(toString);

  /**
 *  | Try to parse a Signal from a String. Suitable for use with Node.js APIs.
 *  | This function is a partial inverse of `toString`; in code, that means, for
 *  | all `sig :: Signal`:
 *  |
 *  |   `fromString (toString sig) == Just sig`
 *  |
 */  
  var fromString = function (s) {
      if (s === "SIGABRT") {
          return new Data_Maybe.Just(SIGABRT.value);
      };
      if (s === "SIGALRM") {
          return new Data_Maybe.Just(SIGALRM.value);
      };
      if (s === "SIGBUS") {
          return new Data_Maybe.Just(SIGBUS.value);
      };
      if (s === "SIGCHLD") {
          return new Data_Maybe.Just(SIGCHLD.value);
      };
      if (s === "SIGCLD") {
          return new Data_Maybe.Just(SIGCLD.value);
      };
      if (s === "SIGCONT") {
          return new Data_Maybe.Just(SIGCONT.value);
      };
      if (s === "SIGEMT") {
          return new Data_Maybe.Just(SIGEMT.value);
      };
      if (s === "SIGFPE") {
          return new Data_Maybe.Just(SIGFPE.value);
      };
      if (s === "SIGHUP") {
          return new Data_Maybe.Just(SIGHUP.value);
      };
      if (s === "SIGILL") {
          return new Data_Maybe.Just(SIGILL.value);
      };
      if (s === "SIGINFO") {
          return new Data_Maybe.Just(SIGINFO.value);
      };
      if (s === "SIGINT") {
          return new Data_Maybe.Just(SIGINT.value);
      };
      if (s === "SIGIO") {
          return new Data_Maybe.Just(SIGIO.value);
      };
      if (s === "SIGIOT") {
          return new Data_Maybe.Just(SIGIOT.value);
      };
      if (s === "SIGKILL") {
          return new Data_Maybe.Just(SIGKILL.value);
      };
      if (s === "SIGLOST") {
          return new Data_Maybe.Just(SIGLOST.value);
      };
      if (s === "SIGPIPE") {
          return new Data_Maybe.Just(SIGPIPE.value);
      };
      if (s === "SIGPOLL") {
          return new Data_Maybe.Just(SIGPOLL.value);
      };
      if (s === "SIGPROF") {
          return new Data_Maybe.Just(SIGPROF.value);
      };
      if (s === "SIGPWR") {
          return new Data_Maybe.Just(SIGPWR.value);
      };
      if (s === "SIGQUIT") {
          return new Data_Maybe.Just(SIGQUIT.value);
      };
      if (s === "SIGSEGV") {
          return new Data_Maybe.Just(SIGSEGV.value);
      };
      if (s === "SIGSTKFLT") {
          return new Data_Maybe.Just(SIGSTKFLT.value);
      };
      if (s === "SIGSTOP") {
          return new Data_Maybe.Just(SIGSTOP.value);
      };
      if (s === "SIGSYS") {
          return new Data_Maybe.Just(SIGSYS.value);
      };
      if (s === "SIGTERM") {
          return new Data_Maybe.Just(SIGTERM.value);
      };
      if (s === "SIGTRAP") {
          return new Data_Maybe.Just(SIGTRAP.value);
      };
      if (s === "SIGTSTP") {
          return new Data_Maybe.Just(SIGTSTP.value);
      };
      if (s === "SIGTTIN") {
          return new Data_Maybe.Just(SIGTTIN.value);
      };
      if (s === "SIGTTOU") {
          return new Data_Maybe.Just(SIGTTOU.value);
      };
      if (s === "SIGUNUSED") {
          return new Data_Maybe.Just(SIGUNUSED.value);
      };
      if (s === "SIGURG") {
          return new Data_Maybe.Just(SIGURG.value);
      };
      if (s === "SIGUSR1") {
          return new Data_Maybe.Just(SIGUSR1.value);
      };
      if (s === "SIGUSR2") {
          return new Data_Maybe.Just(SIGUSR2.value);
      };
      if (s === "SIGVTALRM") {
          return new Data_Maybe.Just(SIGVTALRM.value);
      };
      if (s === "SIGWINCH") {
          return new Data_Maybe.Just(SIGWINCH.value);
      };
      if (s === "SIGXCPU") {
          return new Data_Maybe.Just(SIGXCPU.value);
      };
      if (s === "SIGXFSZ") {
          return new Data_Maybe.Just(SIGXFSZ.value);
      };
      return Data_Maybe.Nothing.value;
  };
  exports["SIGABRT"] = SIGABRT;
  exports["SIGALRM"] = SIGALRM;
  exports["SIGBUS"] = SIGBUS;
  exports["SIGCHLD"] = SIGCHLD;
  exports["SIGCLD"] = SIGCLD;
  exports["SIGCONT"] = SIGCONT;
  exports["SIGEMT"] = SIGEMT;
  exports["SIGFPE"] = SIGFPE;
  exports["SIGHUP"] = SIGHUP;
  exports["SIGILL"] = SIGILL;
  exports["SIGINFO"] = SIGINFO;
  exports["SIGINT"] = SIGINT;
  exports["SIGIO"] = SIGIO;
  exports["SIGIOT"] = SIGIOT;
  exports["SIGKILL"] = SIGKILL;
  exports["SIGLOST"] = SIGLOST;
  exports["SIGPIPE"] = SIGPIPE;
  exports["SIGPOLL"] = SIGPOLL;
  exports["SIGPROF"] = SIGPROF;
  exports["SIGPWR"] = SIGPWR;
  exports["SIGQUIT"] = SIGQUIT;
  exports["SIGSEGV"] = SIGSEGV;
  exports["SIGSTKFLT"] = SIGSTKFLT;
  exports["SIGSTOP"] = SIGSTOP;
  exports["SIGSYS"] = SIGSYS;
  exports["SIGTERM"] = SIGTERM;
  exports["SIGTRAP"] = SIGTRAP;
  exports["SIGTSTP"] = SIGTSTP;
  exports["SIGTTIN"] = SIGTTIN;
  exports["SIGTTOU"] = SIGTTOU;
  exports["SIGUNUSED"] = SIGUNUSED;
  exports["SIGURG"] = SIGURG;
  exports["SIGUSR1"] = SIGUSR1;
  exports["SIGUSR2"] = SIGUSR2;
  exports["SIGVTALRM"] = SIGVTALRM;
  exports["SIGWINCH"] = SIGWINCH;
  exports["SIGXCPU"] = SIGXCPU;
  exports["SIGXFSZ"] = SIGXFSZ;
  exports["fromString"] = fromString;
  exports["toString"] = toString;
  exports["showSignal"] = showSignal;
})(PS["Data.Posix.Signal"] = PS["Data.Posix.Signal"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a type of sets as balanced 2-3 trees, based on
 *  | <http://www.cs.princeton.edu/~dpw/courses/cos326-12/ass/2-3-trees.pdf>
 *  |
 *  | Qualified import is encouraged, so as to avoid name clashes with other modules.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Foldable_1 = PS["Data.Foldable"];
  var Data_List_1 = PS["Data.List"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Map = PS["Data.Map"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_ST = PS["Control.Monad.ST"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Data_Array = PS["Data.Array"];
  var Data_Array_ST = PS["Data.Array.ST"];
  var Data_Array_Unsafe = PS["Data.Array.Unsafe"];
  var Data_List_1 = PS["Data.List"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable_1 = PS["Data.Foldable"];
  var Data_Unfoldable = PS["Data.Unfoldable"];        

  /**
 *  | `Set a` represents a set of values of type `a`
 */  
  var $$Set = (function () {
      function Set(value0) {
          this.value0 = value0;
      };
      Set.create = function (value0) {
          return new Set(value0);
      };
      return Set;
  })();

  /**
 *  | Form the union of two sets
 *  |
 *  | Running time: `O(n * log(m))`
 */  
  var union = function (dictOrd) {
      return function (v) {
          return function (v1) {
              return new $$Set(Data_Map.union(dictOrd)(v.value0)(v1.value0));
          };
      };
  };

  /**
 *  | Convert a set to a list
 */  
  var toList = function (v) {
      return Data_Map.keys(v.value0);
  };

  /**
 *  | Create a set with one element
 */  
  var singleton = function (a) {
      return new $$Set(Data_Map.singleton(a)(Prelude.unit));
  };

  /**
 *  | Insert a value into a set
 */  
  var insert = function (dictOrd) {
      return function (a) {
          return function (v) {
              return new $$Set(Data_Map.insert(dictOrd)(a)(Prelude.unit)(v.value0));
          };
      };
  };

  /**
 *  | An empty set
 */  
  var empty = new $$Set(Data_Map.empty);

  /**
 *  | Create a set from a foldable collection of elements
 */  
  var fromFoldable = function (dictFoldable) {
      return function (dictOrd) {
          return Data_Foldable_1.foldl(dictFoldable)(function (m) {
              return function (a) {
                  return insert(dictOrd)(a)(m);
              };
          })(empty);
      };
  };

  /**
 *  | Create a set from a list of elements
 */  
  var fromList = function (dictOrd) {
      return fromFoldable(Data_List_1.foldableList)(dictOrd);
  };

  /**
 *  | Form the union of a collection of sets
 */  
  var unions = function (dictOrd) {
      return Data_Foldable_1.foldl(Data_List_1.foldableList)(union(dictOrd))(empty);
  };
  exports["unions"] = unions;
  exports["union"] = union;
  exports["fromList"] = fromList;
  exports["toList"] = toList;
  exports["fromFoldable"] = fromFoldable;
  exports["insert"] = insert;
  exports["singleton"] = singleton;
  exports["empty"] = empty;
})(PS["Data.Set"] = PS["Data.Set"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports["regex'"] = function (s1) {
    return function (s2) {
      return new RegExp(s1, s2);
    };
  };
})(PS["Data.String.Regex"] = PS["Data.String.Regex"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Wraps Javascript's `RegExp` object that enables matching strings with
 *  | patternes defined by regular expressions.
 *  | For details of the underlying implementation, see [RegExp Reference at MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp).
 */  
  "use strict";
  var $foreign = PS["Data.String.Regex"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_String = PS["Data.String"];                                            

  /**
 *  | Returns the string representation of the given `RegexFlags`.
 */  
  var renderFlags = function (f) {
      return (function () {
          if (f.global) {
              return "g";
          };
          if (!f.global) {
              return "";
          };
          throw new Error("Failed pattern match at Data.String.Regex line 65, column 4 - line 65, column 32: " + [ f.global.constructor.name ]);
      })() + ((function () {
          if (f.ignoreCase) {
              return "i";
          };
          if (!f.ignoreCase) {
              return "";
          };
          throw new Error("Failed pattern match at Data.String.Regex line 66, column 4 - line 66, column 36: " + [ f.ignoreCase.constructor.name ]);
      })() + ((function () {
          if (f.multiline) {
              return "m";
          };
          if (!f.multiline) {
              return "";
          };
          throw new Error("Failed pattern match at Data.String.Regex line 67, column 4 - line 67, column 35: " + [ f.multiline.constructor.name ]);
      })() + ((function () {
          if (f.sticky) {
              return "y";
          };
          if (!f.sticky) {
              return "";
          };
          throw new Error("Failed pattern match at Data.String.Regex line 68, column 4 - line 68, column 32: " + [ f.sticky.constructor.name ]);
      })() + (function () {
          if (f.unicode) {
              return "u";
          };
          if (!f.unicode) {
              return "";
          };
          throw new Error("Failed pattern match at Data.String.Regex line 69, column 4 - line 69, column 33: " + [ f.unicode.constructor.name ]);
      })())));
  };

  /**
 *  | Constructs a `Regex` from a pattern string and flags.
 */  
  var regex = function (s) {
      return function (f) {
          return $foreign["regex'"](s)(renderFlags(f));
      };
  };

  /**
 *  | All flags set to false.
 */  
  var noFlags = {
      global: false, 
      ignoreCase: false, 
      multiline: false, 
      sticky: false, 
      unicode: false
  };
  exports["noFlags"] = noFlags;
  exports["renderFlags"] = renderFlags;
  exports["regex"] = regex;
})(PS["Data.String.Regex"] = PS["Data.String.Regex"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Utilities for n-tuples: sequences longer than two components built from
 *  | nested pairs.
 *  |
 *  | Nested tuples arise naturally in product combinators. You shouldn't
 *  | represent data using nested tuples, but if combinators you're working with
 *  | create them, utilities in this module will allow to to more easily work
 *  | with them, including translating to and from more traditional product types.
 *  |
 *  | ```purescript
 *  | data Address = Address String City (Maybe Province) Country
 *  |
 *  | exampleAddress1 = makeAddress "221B Baker Street" London Nothing UK
 *  | exampleAddress2 = makeAddressT $ "221B Baker Street" /\ London /\ Nothing /\ UK
 *  |
 *  | makeAddressT :: Tuple4 String City (Maybe Province) Country -> Address
 *  | makeAddressT = uncurry4 Address
 *  |
 *  | makeAddress :: String -> City -> (Maybe Province) -> Country -> Address
 *  | makeAddress = curry4 makeAddressT
 *  |
 *  | tupleAddress :: Address -> Tuple4 String City (Maybe Province) Country
 *  | tupleAddress (Address a b c d) = tuple4 a b c d
 *  | ```
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Tuple = PS["Data.Tuple"];        

  /**
 *  | Shorthand for constructing n-tuples as nested pairs.
 *  | `a /\ b /\ c /\ d` becomes `Tuple (Tuple (Tuple a b) c ) d`
 */  
  var $div$bslash = function (a) {
      return function (b) {
          return new Data_Tuple.Tuple(a, b);
      };
  };
  exports["/\\"] = $div$bslash;
})(PS["Data.Tuple.Nested"] = PS["Data.Tuple.Nested"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_String = PS["Data.String"];
  var Data_Foldable = PS["Data.Foldable"];        

  /**
 *  | `Position` represents the position of the parser in the input.
 *  |
 *  | - `line` is the current line in the input
 *  | - `column` is the column of the next character in the current line that will be parsed
 */  
  var Position = (function () {
      function Position(value0) {
          this.value0 = value0;
      };
      Position.create = function (value0) {
          return new Position(value0);
      };
      return Position;
  })();
  var showPosition = new Prelude.Show(function (v) {
      return "Position { line: " + (Prelude.show(Prelude.showInt)(v.value0.line) + (", column: " + (Prelude.show(Prelude.showInt)(v.value0.column) + " }")));
  });

  /**
 *  | The `Position` before any input has been parsed.
 */  
  var initialPos = new Position({
      line: 1, 
      column: 1
  });
  exports["Position"] = Position;
  exports["initialPos"] = initialPos;
  exports["showPosition"] = showPosition;
})(PS["Text.Parsing.Parser.Pos"] = PS["Text.Parsing.Parser.Pos"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Tuple = PS["Data.Tuple"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Control_Monad_Trans = PS["Control.Monad.Trans"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_Plus = PS["Control.Plus"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];        

  /**
 *  | A parsing error, consisting of a message and position information.
 */  
  var ParseError = (function () {
      function ParseError(value0) {
          this.value0 = value0;
      };
      ParseError.create = function (value0) {
          return new ParseError(value0);
      };
      return ParseError;
  })();

  /**
 *  | `PState` contains the remaining input and current position.
 */  
  var PState = (function () {
      function PState(value0) {
          this.value0 = value0;
      };
      PState.create = function (value0) {
          return new PState(value0);
      };
      return PState;
  })();

  /**
 *  | The Parser monad transformer.
 *  |
 *  | The first type argument is the stream type. Typically, this is either `String`, or some sort of token stream.
 */  
  var ParserT = function (x) {
      return x;
  };

  /**
 *  | Apply a parser by providing an initial state.
 */  
  var unParserT = function (v) {
      return v;
  };
  var showParseError = new Prelude.Show(function (v) {
      return "ParseError { message: " + (v.value0.message + (", position: " + (Prelude.show(Text_Parsing_Parser_Pos.showPosition)(v.value0.position) + " }")));
  });

  /**
 *  | Apply a parser, keeping only the parsed result.
 */  
  var runParserT = function (dictMonad) {
      return function (s) {
          return function (p) {
              return Prelude.bind(dictMonad["__superclass_Prelude.Bind_1"]())(unParserT(p)(s))(function (v) {
                  return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())(v.result);
              });
          };
      };
  };

  /**
 *  | Apply a parser, keeping only the parsed result.
 */  
  var runParser = function (s) {
      return function ($54) {
          return Data_Identity.runIdentity(runParserT(Data_Identity.monadIdentity)(new PState({
              input: s, 
              position: Text_Parsing_Parser_Pos.initialPos
          }))($54));
      };
  };

  /**
 *  | Creates a failed parser state for the remaining input `s` and current position
 *  | with an error message.
 *  |
 *  | Most of the time, `fail` should be used instead.
 */  
  var parseFailed = function (s) {
      return function (pos) {
          return function (message) {
              return {
                  input: s, 
                  consumed: false, 
                  result: new Data_Either.Left(new ParseError({
                      message: message, 
                      position: pos
                  })), 
                  position: pos
              };
          };
      };
  };
  var monadTransParserT = new Control_Monad_Trans.MonadTrans(function (dictMonad) {
      return function (m) {
          return ParserT(function (v) {
              return Prelude["<$>"](((dictMonad["__superclass_Prelude.Bind_1"]())["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]())(function (a) {
                  return {
                      input: v.value0.input, 
                      consumed: false, 
                      result: new Data_Either.Right(a), 
                      position: v.value0.position
                  };
              })(m);
          });
      };
  });
  var lazyParserT = new Control_Lazy.Lazy(function (f) {
      return ParserT(function (s) {
          return unParserT(f(Prelude.unit))(s);
      });
  });
  var functorParserT = function (dictFunctor) {
      return new Prelude.Functor(function (f) {
          return function (p) {
              var f$prime = function (o) {
                  return {
                      input: o.input, 
                      result: Prelude["<$>"](Data_Either.functorEither)(f)(o.result), 
                      consumed: o.consumed, 
                      position: o.position
                  };
              };
              return ParserT(function (s) {
                  return Prelude["<$>"](dictFunctor)(f$prime)(unParserT(p)(s));
              });
          };
      });
  };

  /**
 *  | Fail with a message.
 */  
  var fail = function (dictMonad) {
      return function (message) {
          return ParserT(function (v) {
              return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())(parseFailed(v.value0.input)(v.value0.position)(message));
          });
      };
  };
  var monadParserT = function (dictMonad) {
      return new Prelude.Monad(function () {
          return applicativeParserT(dictMonad);
      }, function () {
          return bindParserT(dictMonad);
      });
  };
  var bindParserT = function (dictMonad) {
      return new Prelude.Bind(function () {
          return applyParserT(dictMonad);
      }, function (p) {
          return function (f) {
              var updateConsumedFlag = function (c) {
                  return function (o) {
                      return {
                          input: o.input, 
                          consumed: c || o.consumed, 
                          result: o.result, 
                          position: o.position
                      };
                  };
              };
              return ParserT(function (s) {
                  return Prelude[">>="](dictMonad["__superclass_Prelude.Bind_1"]())(unParserT(p)(s))(function (o) {
                      if (o.result instanceof Data_Either.Left) {
                          return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())({
                              input: o.input, 
                              result: new Data_Either.Left(o.result.value0), 
                              consumed: o.consumed, 
                              position: o.position
                          });
                      };
                      if (o.result instanceof Data_Either.Right) {
                          return Prelude["<$>"](((dictMonad["__superclass_Prelude.Bind_1"]())["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]())(updateConsumedFlag(o.consumed))(unParserT(f(o.result.value0))(new PState({
                              input: o.input, 
                              position: o.position
                          })));
                      };
                      throw new Error("Failed pattern match at Text.Parsing.Parser line 80, column 5 - line 83, column 5: " + [ o.result.constructor.name ]);
                  });
              });
          };
      });
  };
  var applyParserT = function (dictMonad) {
      return new Prelude.Apply(function () {
          return functorParserT(((dictMonad["__superclass_Prelude.Bind_1"]())["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]());
      }, Prelude.ap(monadParserT(dictMonad)));
  };
  var applicativeParserT = function (dictMonad) {
      return new Prelude.Applicative(function () {
          return applyParserT(dictMonad);
      }, function (a) {
          return ParserT(function (v) {
              return Prelude.pure(dictMonad["__superclass_Prelude.Applicative_0"]())({
                  input: v.value0.input, 
                  result: new Data_Either.Right(a), 
                  consumed: false, 
                  position: v.value0.position
              });
          });
      });
  };
  var monadStateParserT = function (dictMonad) {
      return new Control_Monad_State_Class.MonadState(function () {
          return monadParserT(dictMonad);
      }, function (f) {
          return ParserT(function (v) {
              return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())((function () {
                  var $46 = f(v.value0.input);
                  return {
                      input: $46.value1, 
                      consumed: false, 
                      result: new Data_Either.Right($46.value0), 
                      position: v.value0.position
                  };
              })());
          });
      });
  };
  var altParserT = function (dictMonad) {
      return new Control_Alt.Alt(function () {
          return functorParserT(((dictMonad["__superclass_Prelude.Bind_1"]())["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]());
      }, function (p1) {
          return function (p2) {
              return ParserT(function (s) {
                  return Prelude[">>="](dictMonad["__superclass_Prelude.Bind_1"]())(unParserT(p1)(s))(function (o) {
                      if (o.result instanceof Data_Either.Left && !o.consumed) {
                          return unParserT(p2)(s);
                      };
                      return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())(o);
                  });
              });
          };
      });
  };
  var plusParserT = function (dictMonad) {
      return new Control_Plus.Plus(function () {
          return altParserT(dictMonad);
      }, fail(dictMonad)("No alternative"));
  };
  var alternativeParserT = function (dictMonad) {
      return new Control_Alternative.Alternative(function () {
          return plusParserT(dictMonad);
      }, function () {
          return applicativeParserT(dictMonad);
      });
  };
  var monadPlusParserT = function (dictMonad) {
      return new Control_MonadPlus.MonadPlus(function () {
          return alternativeParserT(dictMonad);
      }, function () {
          return monadParserT(dictMonad);
      });
  };
  exports["ParserT"] = ParserT;
  exports["PState"] = PState;
  exports["ParseError"] = ParseError;
  exports["parseFailed"] = parseFailed;
  exports["fail"] = fail;
  exports["runParser"] = runParser;
  exports["runParserT"] = runParserT;
  exports["unParserT"] = unParserT;
  exports["showParseError"] = showParseError;
  exports["functorParserT"] = functorParserT;
  exports["applyParserT"] = applyParserT;
  exports["applicativeParserT"] = applicativeParserT;
  exports["altParserT"] = altParserT;
  exports["plusParserT"] = plusParserT;
  exports["alternativeParserT"] = alternativeParserT;
  exports["bindParserT"] = bindParserT;
  exports["monadParserT"] = monadParserT;
  exports["monadPlusParserT"] = monadPlusParserT;
  exports["monadTransParserT"] = monadTransParserT;
  exports["monadStateParserT"] = monadStateParserT;
  exports["lazyParserT"] = lazyParserT;
})(PS["Text.Parsing.Parser"] = PS["Text.Parsing.Parser"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Combinators for creating parsers.
 *  |
 *  | ### Notes:
 *  | A few of the known combinators from Parsec are missing in this module. That
 *  | is because they have already been defined in other libraries.
 *  |
 *  | ```purescript
 *  | Text.Parsec.many  = Data.(Array|List).many
 *  | Text.Parsec.many1 = Data.(Array|List).some
 *  | Text.Parsec.(<|>) = Control.Alt.alt (<|>)
 *  | ```
 *  |
 *  | Because Strings are not Char Arrays in PureScript `many` and `some` on Char Parsers need to
 *  | be used in conjunction with `Data.String.fromCharArray` to achieve "Parsec-like" results.
 *  |
 *  | ```purescript
 *  | Text.Parsec.many  (char 'x') <=> fromCharArray <$> Data.Array.many (char 'x')
 *  | ```
 *  |
 *  | ===
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Plus = PS["Control.Plus"];
  var Control_Apply = PS["Control.Apply"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];        

  /**
 *  | Provide an error message in the case of failure.
 */  
  var $less$qmark$greater = function (dictMonad) {
      return function (p) {
          return function (msg) {
              return Control_Alt["<|>"](Text_Parsing_Parser.altParserT(dictMonad))(p)(Text_Parsing_Parser.fail(dictMonad)("Expected " + msg));
          };
      };
  };

  /**
 *  | In case of failure, reset the stream to the unconsumed state.
 */  
  var $$try = function (dictFunctor) {
      return function (p) {
          var try$prime = function (v) {
              return function (v1) {
                  return function (v2) {
                      if (v2.result instanceof Data_Either.Left) {
                          return {
                              input: v, 
                              result: v2.result, 
                              consumed: false, 
                              position: v1
                          };
                      };
                      return v2;
                  };
              };
          };
          return Text_Parsing_Parser.ParserT(function (v) {
              return Prelude["<$>"](dictFunctor)(try$prime(v.value0.input)(v.value0.position))(Text_Parsing_Parser.unParserT(p)(new Text_Parsing_Parser.PState({
                  input: v.value0.input, 
                  position: v.value0.position
              })));
          });
      };
  };

  /**
 *  | Parse phrases delimited by a separator, requiring at least one match.
 */  
  var sepBy1 = function (dictMonad) {
      return function (p) {
          return function (sep) {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(dictMonad))(p)(function (v) {
                  return Prelude.bind(Text_Parsing_Parser.bindParserT(dictMonad))(Data_List.many(Text_Parsing_Parser.alternativeParserT(dictMonad))(Text_Parsing_Parser.lazyParserT)(Prelude.bind(Text_Parsing_Parser.bindParserT(dictMonad))(sep)(function () {
                      return p;
                  })))(function (v1) {
                      return Prelude["return"](Text_Parsing_Parser.applicativeParserT(dictMonad))(Data_List[":"](v)(v1));
                  });
              });
          };
      };
  };

  /**
 *  | Parse phrases delimited by a separator.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | digit `sepBy` string ","
 *  | ```
 */  
  var sepBy = function (dictMonad) {
      return function (p) {
          return function (sep) {
              return Control_Alt["<|>"](Text_Parsing_Parser.altParserT(dictMonad))(sepBy1(dictMonad)(p)(sep))(Prelude["return"](Text_Parsing_Parser.applicativeParserT(dictMonad))(Data_List.Nil.value));
          };
      };
  };

  /**
 *  | Provide a default result in the case where a parser fails without consuming input.
 */  
  var option = function (dictMonad) {
      return function (a) {
          return function (p) {
              return Control_Alt["<|>"](Text_Parsing_Parser.altParserT(dictMonad))(p)(Prelude["return"](Text_Parsing_Parser.applicativeParserT(dictMonad))(a));
          };
      };
  };
  exports["sepBy1"] = sepBy1;
  exports["sepBy"] = sepBy;
  exports["try"] = $$try;
  exports["option"] = option;
  exports["<?>"] = $less$qmark$greater;
})(PS["Text.Parsing.Parser.Combinators"] = PS["Text.Parsing.Parser.Combinators"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Functions for working with streams of tokens.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];        

  /**
 *  | Create a parser which returns the first token in the stream.
 */  
  var token = function (dictMonad) {
      return function (tokpos) {
          return Text_Parsing_Parser.ParserT(function (v) {
              return Prelude["return"](dictMonad["__superclass_Prelude.Applicative_0"]())((function () {
                  if (v.value0.input instanceof Data_List.Cons) {
                      return {
                          consumed: true, 
                          input: v.value0.input.value1, 
                          result: new Data_Either.Right(v.value0.input.value0), 
                          position: tokpos(v.value0.input.value0)
                      };
                  };
                  return Text_Parsing_Parser.parseFailed(v.value0.input)(v.value0.position)("expected token, met EOF");
              })());
          });
      };
  };

  /**
 *  | Create a parser which matches any token satisfying the predicate.
 */  
  var when = function (dictMonad) {
      return function (tokpos) {
          return function (f) {
              return Text_Parsing_Parser_Combinators["try"](((dictMonad["__superclass_Prelude.Bind_1"]())["__superclass_Prelude.Apply_0"]())["__superclass_Prelude.Functor_0"]())(Prelude.bind(Text_Parsing_Parser.bindParserT(dictMonad))(token(dictMonad)(tokpos))(function (v) {
                  return Prelude.bind(Text_Parsing_Parser.bindParserT(dictMonad))(Control_MonadPlus.guard(Text_Parsing_Parser.monadPlusParserT(dictMonad))(f(v)))(function () {
                      return Prelude["return"](Text_Parsing_Parser.applicativeParserT(dictMonad))(v);
                  });
              }));
          };
      };
  };

  /**
 *  | Match the specified token at the head of the stream.
 */  
  var match = function (dictMonad) {
      return function (dictEq) {
          return function (tokpos) {
              return function (tok) {
                  return when(dictMonad)(tokpos)(function (v) {
                      return Prelude["=="](dictEq)(v)(tok);
                  });
              };
          };
      };
  };
  exports["match"] = match;
  exports["when"] = when;
  exports["token"] = token;
})(PS["Text.Parsing.Parser.Token"] = PS["Text.Parsing.Parser.Token"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Int = PS["Data.Int"];
  var Data_Char = PS["Data.Char"];
  var Data_String = PS["Data.String"];
  var Data_List = PS["Data.List"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Token = PS["Text.Parsing.Parser.Token"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Unfoldable = PS["Data.Unfoldable"];        
  var lieAboutPos = Prelude["const"](Text_Parsing_Parser_Pos.initialPos);
  var match$prime = Text_Parsing_Parser_Token.match(Data_Identity.monadIdentity)(Prelude.eqChar)(lieAboutPos);
  var when$prime = Text_Parsing_Parser_Token.when(Data_Identity.monadIdentity)(lieAboutPos);
  var isDigit = function (c) {
      return "0" <= c && c <= "9";
  };
  var nonNegativeInt = (function () {
      var fromDigits = function ($2) {
          return Data_Maybe_Unsafe.fromJust(Data_Int.fromString(Data_String.fromCharArray(Data_List.fromList(Data_Unfoldable.unfoldableArray)($2))));
      };
      return Prelude["<$>"](Text_Parsing_Parser.functorParserT(Data_Identity.functorIdentity))(fromDigits)(Data_List.some(Text_Parsing_Parser.alternativeParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser.lazyParserT)(Text_Parsing_Parser_Token.when(Data_Identity.monadIdentity)(lieAboutPos)(isDigit)));
  })();
  var isAsciiAlpha = function (ch) {
      return Data_Ord.between(Prelude.ordChar)("a")("z")(Data_Char.toLower(ch));
  };
  var eof = Prelude[">>="](Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Control_Monad_State_Class.get(Text_Parsing_Parser.monadStateParserT(Data_Identity.monadIdentity)))(function (v) {
      return Control_Monad.unless(Text_Parsing_Parser.monadParserT(Data_Identity.monadIdentity))(Data_List["null"](v))(Text_Parsing_Parser.fail(Data_Identity.monadIdentity)("expected eof"));
  });
  exports["eof"] = eof;
  exports["when'"] = when$prime;
  exports["match'"] = match$prime;
  exports["lieAboutPos"] = lieAboutPos;
  exports["nonNegativeInt"] = nonNegativeInt;
  exports["isAsciiAlpha"] = isAsciiAlpha;
  exports["isDigit"] = isDigit;
})(PS["Data.Version.Internal"] = PS["Data.Version.Internal"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines a `Version` data type, for representing software
 *  | versions, according to the [Semantic Versioning](http://semver.org)
 *  | specification. To summarize, a `Version` consists of:
 *  |
 *  | * a MAJOR, MINOR, and a PATCH component, all of which are nonnegative
 *  |   integers.
 *  | * optionally, a list of pre-release identifiers, consisting of ASCII
 *  |   letters, numbers, and hyphens, and which is separated from the three
 *  |   main components with a hyphen.
 *  | * optionally, build metadata, consisting of ASCII letters, numbers, and
 *  |   hyphens, and which is separated from the rest of the version with a plus
 *  |   symbol.
 *  |
 *  | Note that, according to the semver spec, version precedence must ignore
 *  | any build metadata. Therefore, the `Ord` instance ignores the build
 *  | metadata. In order to have the `Eq` instance agree with the `Ord`
 *  | instance, the `Eq` instance ignores build metadata too.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Int = PS["Data.Int"];
  var Data_String = PS["Data.String"];
  var Data_List = PS["Data.List"];
  var Data_Function = PS["Data.Function"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Apply = PS["Control.Apply"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Data_Version_Internal = PS["Data.Version.Internal"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Identity = PS["Data.Identity"];        
  var IInt = (function () {
      function IInt(value0) {
          this.value0 = value0;
      };
      IInt.create = function (value0) {
          return new IInt(value0);
      };
      return IInt;
  })();
  var IStr = (function () {
      function IStr(value0) {
          this.value0 = value0;
      };
      IStr.create = function (value0) {
          return new IStr(value0);
      };
      return IStr;
  })();

  /**
 *  | A semver version.
 */  
  var Version = (function () {
      function Version(value0, value1, value2, value3, value4) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
      };
      Version.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return new Version(value0, value1, value2, value3, value4);
                      };
                  };
              };
          };
      };
      return Version;
  })();
  var showIdentifier = function (i) {
      if (i instanceof IInt) {
          return Prelude.show(Prelude.showInt)(i.value0);
      };
      if (i instanceof IStr) {
          return i.value0;
      };
      throw new Error("Failed pattern match at Data.Version line 126, column 20 - line 130, column 1: " + [ i.constructor.name ]);
  };

  /**
 *  | Unpack a version. Useful for pattern matching.
 *  |
 *  | The reason we have this function instead of exporting the `Version`
 *  | constructor is that in this way we can guarantee that `Version` values are
 *  | always valid.
 */  
  var runVersion = function (f) {
      return function (v) {
          return f(v.value0)(v.value1)(v.value2)(v.value3)(v.value4);
      };
  };
  var showVersion = (function () {
      var sep = function (v) {
          return function (v1) {
              if (v1 instanceof Data_List.Nil) {
                  return "";
              };
              return (function (v2) {
                  return v + v2;
              })(Data_String.joinWith(".")(Prelude.map(Prelude.functorArray)(showIdentifier)(Data_List.fromList(Data_Unfoldable.unfoldableArray)(v1))));
          };
      };
      var go = function (maj) {
          return function (min) {
              return function (pat) {
                  return function (pre) {
                      return function (build) {
                          return Data_String.joinWith(".")(Prelude.map(Prelude.functorArray)(Prelude.show(Prelude.showInt))([ maj, min, pat ])) + (sep("-")(pre) + sep("+")(build));
                      };
                  };
              };
          };
      };
      return runVersion(go);
  })();
  var preRelease = function (v) {
      return v.value3;
  };
  var patch = function (v) {
      return v.value2;
  };
  var nonneg = function (x) {
      var $49 = x < 0;
      if ($49) {
          return 0;
      };
      if (!$49) {
          return x;
      };
      throw new Error("Failed pattern match at Data.Version line 169, column 12 - line 173, column 1: " + [ $49.constructor.name ]);
  };

  /**
 *  | Construct a numeric identifier.
 */  
  var numeric = function ($104) {
      return IInt.create(nonneg($104));
  };

  /**
 *  | Smart constructor for versions. Negative integer components will be
 *  | replaced with zeroes.
 */  
  var version = function (ma) {
      return function (mi) {
          return function (pa) {
              return function (pre) {
                  return function (meta) {
                      return new Version(nonneg(ma), nonneg(mi), nonneg(pa), pre, meta);
                  };
              };
          };
      };
  };
  var minor = function (v) {
      return v.value1;
  };
  var major = function (v) {
      return v.value0;
  };
  var ordIdentifier = new Prelude.Ord(function () {
      return eqIdentifier;
  }, function (v) {
      return function (v1) {
          if (v instanceof IInt && v1 instanceof IStr) {
              return Prelude.LT.value;
          };
          if (v instanceof IStr && v1 instanceof IInt) {
              return Prelude.GT.value;
          };
          if (v instanceof IInt && v1 instanceof IInt) {
              return Prelude.compare(Prelude.ordInt)(v.value0)(v1.value0);
          };
          if (v instanceof IStr && v1 instanceof IStr) {
              return Prelude.compare(Prelude.ordString)(v.value0)(v1.value0);
          };
          throw new Error("Failed pattern match at Data.Version line 204, column 3 - line 205, column 3: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var eqIdentifier = new Prelude.Eq(function (i1) {
      return function (i2) {
          return Prelude["=="](Prelude.eqOrdering)(Prelude.compare(ordIdentifier)(i1)(i2))(Prelude.EQ.value);
      };
  });
  var comparePre = function (v) {
      return function (v1) {
          if (v instanceof Data_List.Nil && v1 instanceof Data_List.Nil) {
              return Prelude.EQ.value;
          };
          if (v instanceof Data_List.Nil) {
              return Prelude.GT.value;
          };
          if (v1 instanceof Data_List.Nil) {
              return Prelude.LT.value;
          };
          if (v instanceof Data_List.Cons && v1 instanceof Data_List.Cons) {
              var helper = function (v2) {
                  return function (v3) {
                      if (v2 instanceof Data_List.Nil && v3 instanceof Data_List.Nil) {
                          return Prelude.EQ.value;
                      };
                      if (v2 instanceof Data_List.Nil) {
                          return Prelude.LT.value;
                      };
                      if (v3 instanceof Data_List.Nil) {
                          return Prelude.GT.value;
                      };
                      if (v2 instanceof Data_List.Cons && v3 instanceof Data_List.Cons) {
                          return Prelude["<>"](Prelude.semigroupOrdering)(Prelude.compare(ordIdentifier)(v2.value0)(v3.value0))(helper(v2.value1)(v3.value1));
                      };
                      throw new Error("Failed pattern match at Data.Version line 177, column 1 - line 178, column 1: " + [ v2.constructor.name, v3.constructor.name ]);
                  };
              };
              return Prelude["<>"](Prelude.semigroupOrdering)(Prelude.compare(ordIdentifier)(v.value0)(v1.value0))(helper(v.value1)(v1.value1));
          };
          throw new Error("Failed pattern match at Data.Version line 177, column 1 - line 178, column 1: " + [ v.constructor.name, v1.constructor.name ]);
      };
  };
  var ordVersion = new Prelude.Ord(function () {
      return eqVersion;
  }, function (v1) {
      return function (v2) {
          var comparePre$prime = Data_Function.on(comparePre)(preRelease);
          var compareNormal = Data_Function.on(Prelude.compare(Prelude.ordArray(Prelude.ordInt)))(runVersion(function (ma) {
              return function (mi) {
                  return function (pa) {
                      return function (v) {
                          return function (v3) {
                              return [ ma, mi, pa ];
                          };
                      };
                  };
              };
          }));
          return Prelude["<>"](Prelude.semigroupOrdering)(compareNormal(v1)(v2))(comparePre$prime(v1)(v2));
      };
  });
  var eqVersion = new Prelude.Eq(function (v1) {
      return function (v2) {
          return Prelude["=="](Prelude.eqOrdering)(Prelude.compare(ordVersion)(v1)(v2))(Prelude.EQ.value);
      };
  });

  /**
 *  | Bump the patch version, and discard any prerelease identifiers and build
 *  | metadata.
 */  
  var bumpPatch = function (v) {
      return version(major(v))(minor(v))(patch(v) + 1 | 0)(Data_List.Nil.value)(Data_List.Nil.value);
  };

  /**
 *  | Bump the minor version, and discard any prerelease identifiers and build
 *  | metadata.
 */  
  var bumpMinor = function (v) {
      return version(major(v))(minor(v) + 1 | 0)(0)(Data_List.Nil.value)(Data_List.Nil.value);
  };

  /**
 *  | Bump the major version, and discard any prerelease identifiers and build
 *  | metadata.
 */  
  var bumpMajor = function (v) {
      return version(major(v) + 1 | 0)(0)(0)(Data_List.Nil.value)(Data_List.Nil.value);
  };
  var acceptableIdentifier = function (ch) {
      return Data_Version_Internal.isDigit(ch) || (Data_Version_Internal.isAsciiAlpha(ch) || ch === "-");
  };

  /**
 *  | Construct a textual identifier.
 */  
  var textual = function (str) {
      var startsWith = function (str1) {
          return function ($106) {
              return Data_Maybe.isJust(Data_String.stripPrefix(str1)($106));
          };
      };
      var ok = function (x) {
          return Data_Foldable.all(Data_Foldable.foldableArray)(Prelude.booleanAlgebraBoolean)(function (v) {
              return v(x);
          })([ function ($107) {
              return !Data_Maybe.isJust(Data_Int.fromString($107));
          }, function ($108) {
              return !startsWith("0")($108);
          }, function ($109) {
              return Data_Foldable.all(Data_Foldable.foldableArray)(Prelude.booleanAlgebraBoolean)(acceptableIdentifier)(Data_String.toCharArray($109));
          } ]);
      };
      var $92 = ok(str);
      if ($92) {
          return new Data_Maybe.Just(new IStr(str));
      };
      if (!$92) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Version line 113, column 3 - line 114, column 3: " + [ $92.constructor.name ]);
  };
  var versionParser = (function () {
      var textIdent = Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_List.some(Text_Parsing_Parser.alternativeParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser.lazyParserT)(Data_Version_Internal["when'"](acceptableIdentifier)))(function (v) {
          var str = Data_String.fromCharArray(Data_List.fromList(Data_Unfoldable.unfoldableArray)(v));
          var $94 = textual(str);
          if ($94 instanceof Data_Maybe.Just) {
              return Prelude.pure(Text_Parsing_Parser.applicativeParserT(Data_Identity.monadIdentity))($94.value0);
          };
          if ($94 instanceof Data_Maybe.Nothing) {
              return Text_Parsing_Parser.fail(Data_Identity.monadIdentity)("invalid identifier: " + str);
          };
          throw new Error("Failed pattern match at Data.Version line 152, column 5 - line 156, column 1: " + [ $94.constructor.name ]);
      });
      var intIdent = Prelude["<$>"](Text_Parsing_Parser.functorParserT(Data_Identity.functorIdentity))(numeric)(Data_Version_Internal.nonNegativeInt);
      var identifier = Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Data_Identity.monadIdentity))(intIdent)(textIdent);
      var identifiers = Text_Parsing_Parser_Combinators.sepBy(Data_Identity.monadIdentity)(identifier)(Data_Version_Internal["match'"]("."));
      return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.nonNegativeInt)(function (v) {
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("."))(function () {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.nonNegativeInt)(function (v1) {
                  return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("."))(function () {
                      return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.nonNegativeInt)(function (v2) {
                          return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.option(Data_Identity.monadIdentity)(Data_List.Nil.value)(Control_Apply["*>"](Text_Parsing_Parser.applyParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("-"))(identifiers)))(function (v3) {
                              return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.option(Data_Identity.monadIdentity)(Data_List.Nil.value)(Control_Apply["*>"](Text_Parsing_Parser.applyParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("+"))(identifiers)))(function (v4) {
                                  return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.eof)(function () {
                                      return Prelude.pure(Text_Parsing_Parser.applicativeParserT(Data_Identity.monadIdentity))(new Version(v, v1, v2, v3, v4));
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  })();
  var parseVersion = function ($110) {
      return Prelude.flip(Text_Parsing_Parser.runParser)(versionParser)(Data_List.toList(Data_Foldable.foldableArray)(Data_String.toCharArray($110)));
  };
  exports["versionParser"] = versionParser;
  exports["parseVersion"] = parseVersion;
  exports["showVersion"] = showVersion;
  exports["numeric"] = numeric;
  exports["textual"] = textual;
  exports["bumpPatch"] = bumpPatch;
  exports["bumpMinor"] = bumpMinor;
  exports["bumpMajor"] = bumpMajor;
  exports["preRelease"] = preRelease;
  exports["minor"] = minor;
  exports["major"] = major;
  exports["runVersion"] = runVersion;
  exports["version"] = version;
  exports["eqVersion"] = eqVersion;
  exports["ordVersion"] = ordVersion;
  exports["eqIdentifier"] = eqIdentifier;
  exports["ordIdentifier"] = ordIdentifier;
})(PS["Data.Version"] = PS["Data.Version"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | A Version data type corresponding to the type in Haskell's `Data.Version`
 *  | module, from the `base` library (that is, the Haskell standard library).
 *  |
 *  | See also [the Haskell documentation](http://hackage.haskell.org/package/base-4.8.1.0/docs/Data-Version.html).
 *  |
 *  | You might need this module in order to deal with PureScript compiler
 *  | versions, as they do not always have 3 components, and therefore will not
 *  | work with the `Data.Version` module in this package. In most other cases,
 *  | though, you should probably be using `Data.Version`.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Data_String = PS["Data.String"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Data_Version_Internal = PS["Data.Version.Internal"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Foldable = PS["Data.Foldable"];        

  /**
 *  | A version consists of any number of integer components, and any number of
 *  | string components.
 */  
  var Version = (function () {
      function Version(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Version.create = function (value0) {
          return function (value1) {
              return new Version(value0, value1);
          };
      };
      return Version;
  })();
  var versionParser = (function () {
      var someAlphaNums = Data_List.some(Text_Parsing_Parser.alternativeParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser.lazyParserT)(Data_Version_Internal["when'"](function (c) {
          return Data_Version_Internal.isAsciiAlpha(c) || Data_Version_Internal.isDigit(c);
      }));
      var identifier = Prelude["<$>"](Text_Parsing_Parser.functorParserT(Data_Identity.functorIdentity))(function ($32) {
          return Data_String.fromCharArray(Data_List.fromList(Data_Unfoldable.unfoldableArray)($32));
      })(someAlphaNums);
      var hyphen = Data_Version_Internal["match'"]("-");
      return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.sepBy(Data_Identity.monadIdentity)(Data_Version_Internal.nonNegativeInt)(Data_Version_Internal["match'"](".")))(function (v) {
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.option(Data_Identity.monadIdentity)(Data_List.Nil.value)(Control_Apply["*>"](Text_Parsing_Parser.applyParserT(Data_Identity.monadIdentity))(hyphen)(Text_Parsing_Parser_Combinators.sepBy(Data_Identity.monadIdentity)(identifier)(hyphen))))(function (v1) {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.eof)(function () {
                  return Prelude.pure(Text_Parsing_Parser.applicativeParserT(Data_Identity.monadIdentity))(new Version(v, v1));
              });
          });
      });
  })();
  var showVersion = function (v) {
      var prefix = function (v1) {
          return function (v2) {
              if (v2 === "") {
                  return "";
              };
              return v1 + v2;
          };
      };
      var f = function ($33) {
          return Data_String.joinWith(".")(Data_List.fromList(Data_Unfoldable.unfoldableArray)(Prelude.map(Data_List.functorList)(Prelude.show(Prelude.showInt))($33)));
      };
      return f(v.value0) + prefix("-")(Data_String.joinWith("-")(Data_List.fromList(Data_Unfoldable.unfoldableArray)(v.value1)));
  };
  var parseVersion = function ($34) {
      return Prelude.flip(Text_Parsing_Parser.runParser)(versionParser)(Data_List.toList(Data_Foldable.foldableArray)(Data_String.toCharArray($34)));
  };
  var eqVersion = new Prelude.Eq(function (v) {
      return function (v1) {
          return Prelude["=="](Data_List.eqList(Prelude.eqInt))(v.value0)(v1.value0) && Prelude["=="](Data_List.eqList(Prelude.eqString))(v.value1)(v1.value1);
      };
  });
  var ordVersion = new Prelude.Ord(function () {
      return eqVersion;
  }, function (v) {
      return function (v1) {
          return Prelude["<>"](Prelude.semigroupOrdering)(Prelude.compare(Data_List.ordList(Prelude.ordInt))(v.value0)(v1.value0))(Prelude.compare(Data_List.ordList(Prelude.ordString))(v.value1)(v1.value1));
      };
  });
  exports["Version"] = Version;
  exports["parseVersion"] = parseVersion;
  exports["versionParser"] = versionParser;
  exports["showVersion"] = showVersion;
  exports["eqVersion"] = eqVersion;
  exports["ordVersion"] = ordVersion;
})(PS["Data.Version.Haskell"] = PS["Data.Version.Haskell"] || {});
(function(exports) {
  // module Main

  "use strict";

  exports.logStack = function logStack(err) {
    return function() {
      console.log(err.stack);
    };
  };
})(PS["Main"] = PS["Main"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Node.Encoding"];
  var Prelude = PS["Prelude"];        
  var ASCII = (function () {
      function ASCII() {

      };
      ASCII.value = new ASCII();
      return ASCII;
  })();
  var UTF8 = (function () {
      function UTF8() {

      };
      UTF8.value = new UTF8();
      return UTF8;
  })();
  var UTF16LE = (function () {
      function UTF16LE() {

      };
      UTF16LE.value = new UTF16LE();
      return UTF16LE;
  })();
  var UCS2 = (function () {
      function UCS2() {

      };
      UCS2.value = new UCS2();
      return UCS2;
  })();
  var Base64 = (function () {
      function Base64() {

      };
      Base64.value = new Base64();
      return Base64;
  })();
  var Binary = (function () {
      function Binary() {

      };
      Binary.value = new Binary();
      return Binary;
  })();
  var Hex = (function () {
      function Hex() {

      };
      Hex.value = new Hex();
      return Hex;
  })();
  var showEncoding = new Prelude.Show(function (v) {
      if (v instanceof ASCII) {
          return "ascii";
      };
      if (v instanceof UTF8) {
          return "utf8";
      };
      if (v instanceof UTF16LE) {
          return "utf16le";
      };
      if (v instanceof UCS2) {
          return "ucs2";
      };
      if (v instanceof Base64) {
          return "base64";
      };
      if (v instanceof Binary) {
          return "binary";
      };
      if (v instanceof Hex) {
          return "hex";
      };
      throw new Error("Failed pattern match at Node.Encoding line 18, column 3 - line 19, column 3: " + [ v.constructor.name ]);
  });
  exports["ASCII"] = ASCII;
  exports["UTF8"] = UTF8;
  exports["UTF16LE"] = UTF16LE;
  exports["UCS2"] = UCS2;
  exports["Base64"] = Base64;
  exports["Binary"] = Binary;
  exports["Hex"] = Hex;
  exports["showEncoding"] = showEncoding;
})(PS["Node.Encoding"] = PS["Node.Encoding"] || {});
(function(exports) {
  /* global exports */
  /* global Buffer */
  /* global require */
  "use strict";

  exports.fromStringImpl = function (str) {
    return function (encoding) {
      return function() {
        return new Buffer(str, encoding);
      };
    };
  };

  exports.toStringImpl = function (enc) {
    return function (buff) {
      return function() {
        return buff.toString(enc);
      };
    };
  };

  exports.size = function (buff) {
    return function() {
      return buff.length;
    };
  };
})(PS["Node.Buffer"] = PS["Node.Buffer"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Node.Buffer"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Maybe = PS["Data.Maybe"];
  var Node_Encoding = PS["Node.Encoding"];

  /**
 *  | Reads the buffer as a string with the specified encoding.
 */  
  var toString = function ($3) {
      return $foreign.toStringImpl(Prelude.show(Node_Encoding.showEncoding)($3));
  };                                                                                           

  /**
 *  | Creates a new buffer from a string with the specified encoding, sized to
 *  | match the string.
 */  
  var fromString = function (str) {
      return function ($7) {
          return $foreign.fromStringImpl(str)(Prelude.show(Node_Encoding.showEncoding)($7));
      };
  };
  exports["toString"] = toString;
  exports["fromString"] = fromString;
  exports["size"] = $foreign.size;
})(PS["Node.Buffer"] = PS["Node.Buffer"] || {});
(function(exports) {
  /* global require */
  /* global exports */
  "use strict";                                  

  exports.statsMethod = function (m, s) {
    return s[m]();
  }
})(PS["Node.FS.Stats"] = PS["Node.FS.Stats"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Node.FS.Stats"];
  var Prelude = PS["Prelude"];
  var Data_Date = PS["Data.Date"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];        

  /**
 *  | Stats wrapper to provide a usable interface to the underlying properties and methods.
 */  
  var Stats = (function () {
      function Stats(value0) {
          this.value0 = value0;
      };
      Stats.create = function (value0) {
          return new Stats(value0);
      };
      return Stats;
  })();
  var isFile = function (v) {
      return $foreign.statsMethod("isFile", v.value0);
  };
  var isDirectory = function (v) {
      return $foreign.statsMethod("isDirectory", v.value0);
  };
  exports["Stats"] = Stats;
  exports["isDirectory"] = isDirectory;
  exports["isFile"] = isFile;
})(PS["Node.FS.Stats"] = PS["Node.FS.Stats"] || {});
(function(exports) {
    "use strict";
  var path =require("path"); 

  exports.normalize = path.normalize;

  exports.concat = function (segments) {
    return path.join.apply(this, segments);
  };

  exports.resolve = function (from) {
    return function (to) {
      return path.resolve.apply(this, from.concat([to]));
    };
  };

  exports.dirname = function (p) {
    return path.normalize(path.dirname(p));
  };

  exports.basename = path.basename;

  exports.sep = path.sep;

  exports.delimiter = path.delimiter;

  exports.parse = path.parse;
})(PS["Node.Path"] = PS["Node.Path"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Node.Path"];
  exports["parse"] = $foreign.parse;
  exports["delimiter"] = $foreign.delimiter;
  exports["sep"] = $foreign.sep;
  exports["basename"] = $foreign.basename;
  exports["dirname"] = $foreign.dirname;
  exports["resolve"] = $foreign.resolve;
  exports["concat"] = $foreign.concat;
})(PS["Node.Path"] = PS["Node.Path"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Global = PS["Global"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];
  var Data_Char = PS["Data.Char"];
  var Data_String = PS["Data.String"];
  var Data_Int = PS["Data.Int"];

  /**
 *  | The "writable" permission.
 */  
  var write = {
      r: false, 
      w: true, 
      x: false
  };
  var semiringPerm = new Prelude.Semiring(function (v) {
      return function (v1) {
          return {
              r: v.r || v1.r, 
              w: v.w || v1.w, 
              x: v.x || v1.x
          };
      };
  }, function (v) {
      return function (v1) {
          return {
              r: v.r && v1.r, 
              w: v.w && v1.w, 
              x: v.x && v1.x
          };
      };
  }, {
      r: true, 
      w: true, 
      x: true
  }, {
      r: false, 
      w: false, 
      x: false
  });

  /**
 *  | The "readable" permission.
 */  
  var read = {
      r: true, 
      w: false, 
      x: false
  };

  /**
 *  | Convert a `Perm` to an octal digit. For example:
 *  |
 *  | * `permToInt r == 4`
 *  | * `permToInt w == 2`
 *  | * `permToInt (r + w) == 6`
 */  
  var permToInt = function (v) {
      return ((function () {
          if (v.r) {
              return 4;
          };
          if (!v.r) {
              return 0;
          };
          throw new Error("Failed pattern match at Node.FS.Perms line 158, column 8 - line 158, column 26: " + [ v.r.constructor.name ]);
      })() + (function () {
          if (v.w) {
              return 2;
          };
          if (!v.w) {
              return 0;
          };
          throw new Error("Failed pattern match at Node.FS.Perms line 159, column 8 - line 159, column 26: " + [ v.w.constructor.name ]);
      })() | 0) + (function () {
          if (v.x) {
              return 1;
          };
          if (!v.x) {
              return 0;
          };
          throw new Error("Failed pattern match at Node.FS.Perms line 160, column 8 - line 160, column 26: " + [ v.x.constructor.name ]);
      })() | 0;
  };

  /**
 *  | Convert a `Perm` to an octal string, via `permToInt`.
 */  
  var permToString = function ($95) {
      return Prelude.show(Prelude.showInt)(permToInt($95));
  };

  /**
 *  | Convert a `Perms` value to an octal string, in a format similar to that
 *  | accepted by `chmod`. For example:
 *  | `permsToString (mkPerms (read + write) read read) == "0644"`
 */  
  var permsToString = function (v) {
      return "0" + (permToString(v.u) + (permToString(v.g) + permToString(v.o)));
  };

  /**
 *  | No permissions. This is the identity of the `Semiring` operation `(+)`
 *  | for `Perm`; that is, it is the same as `zero`.
 */  
  var none = Prelude.zero(semiringPerm);

  /**
 *  | Create a `Perms` value. The arguments represent the owner's, group's, and
 *  | other users' permission sets, respectively.
 */  
  var mkPerms = function (u) {
      return function (g) {
          return function (o) {
              return {
                  u: u, 
                  g: g, 
                  o: o
              };
          };
      };
  }; 

  /**
 *  | All permissions: readable, writable, and executable. This is the identity
 *  | of the `Semiring` operation `(*)` for `Perm`; that is, it is the same as
 *  | `one`.
 */  
  var all = Prelude.one(semiringPerm);
  exports["permsToString"] = permsToString;
  exports["mkPerms"] = mkPerms;
  exports["all"] = all;
  exports["write"] = write;
  exports["read"] = read;
  exports["none"] = none;
  exports["semiringPerm"] = semiringPerm;
})(PS["Node.FS.Perms"] = PS["Node.FS.Perms"] || {});
(function(exports) {
    "use strict";
  // module Node.FS.Internal

  exports.unsafeRequireFS = require("fs");
})(PS["Node.FS.Internal"] = PS["Node.FS.Internal"] || {});
(function(exports) {
    "use strict";

  // module Unsafe.Coerce

  exports.unsafeCoerce = function(x) { return x; }
})(PS["Unsafe.Coerce"] = PS["Unsafe.Coerce"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Unsafe.Coerce"];
  exports["unsafeCoerce"] = $foreign.unsafeCoerce;
})(PS["Unsafe.Coerce"] = PS["Unsafe.Coerce"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Node.FS.Internal"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];        
  var mkEff = Unsafe_Coerce.unsafeCoerce;
  exports["mkEff"] = mkEff;
  exports["unsafeRequireFS"] = $foreign.unsafeRequireFS;
})(PS["Node.FS.Internal"] = PS["Node.FS.Internal"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_Date = PS["Data.Date"];
  var Data_Time = PS["Data.Time"];
  var Data_Function = PS["Data.Function"];
  var Data_Nullable = PS["Data.Nullable"];
  var Data_Int = PS["Data.Int"];
  var Data_Maybe = PS["Data.Maybe"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_FS_Internal = PS["Node.FS.Internal"];        
  var fs = Node_FS_Internal.unsafeRequireFS;

  /**
 *  | Reads the entire contents of a text file with the specified encoding.
 */  
  var readTextFile = function (encoding) {
      return function (file) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.readFileSync(file, {
                  encoding: Prelude.show(Node_Encoding.showEncoding)(encoding)
              });
          });
      };
  };
  exports["readTextFile"] = readTextFile;
})(PS["Node.FS.Sync"] = PS["Node.FS.Sync"] || {});
(function(exports) {
    "use strict";
  // module Node.Process

  /* global exports */
  /* global process */

  exports.process = process;

  exports.onSignalImpl = function(signal) {
      return function(callback) {
          return function() {
              process.on(signal, callback);
          };
      };
  };

  exports.chdir = function(dir) {
      return function() {
          process.chdir(dir);
      };
  };

  exports.setEnv = function(var_) {
      return function(val) {
          return function() {
              process.env[var_] = val;
          };
      };
  };

  exports.exit = function(code) {
      return function() {
          process.exit(code);
      };
  };
})(PS["Node.Process"] = PS["Node.Process"] || {});
(function(exports) {
  /* global exports */
  /* global Buffer */
  "use strict";

  exports.onError = function(s) {
      return function(f) {
          return function() {
              s.on('error', function(e) {
                  f(e)();
              });
          };
      };
  };

  exports.write = function(w) {
      return function(chunk) {
          return function(done) {
              return function() {
                  return w.write(chunk, null, done);
              };
          };
      };
  };

  exports.writeStringImpl = function(w) {
      return function(enc) {
          return function(s) {
              return function(done) {
                  return function() {
                      return w.write(s, enc, done);
                  };
              };
          };
      };
  };

  exports.end = function(w) {
      return function(done) {
          return function() {
              w.end(null, null, function() {
                  done();
              });
          };
      };
  };
})(PS["Node.Stream"] = PS["Node.Stream"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module provides a low-level wrapper for the Node Stream API.
 */  
  "use strict";
  var $foreign = PS["Node.Stream"];
  var Prelude = PS["Prelude"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Either = PS["Data.Either"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Buffer_1 = PS["Node.Buffer"];
  var Node_Buffer_1 = PS["Node.Buffer"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];        

  /**
 *  | Write a string in the specified encoding to a writable stream.
 */  
  var writeString = function (w) {
      return function (enc) {
          return $foreign.writeStringImpl(w)(Prelude.show(Node_Encoding.showEncoding)(enc));
      };
  };
  exports["writeString"] = writeString;
  exports["end"] = $foreign.end;
  exports["write"] = $foreign.write;
  exports["onError"] = $foreign.onError;
})(PS["Node.Stream"] = PS["Node.Stream"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines data type for the different platforms supported by
 *  | Node.js
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];        
  var Darwin = (function () {
      function Darwin() {

      };
      Darwin.value = new Darwin();
      return Darwin;
  })();
  var FreeBSD = (function () {
      function FreeBSD() {

      };
      FreeBSD.value = new FreeBSD();
      return FreeBSD;
  })();
  var Linux = (function () {
      function Linux() {

      };
      Linux.value = new Linux();
      return Linux;
  })();
  var SunOS = (function () {
      function SunOS() {

      };
      SunOS.value = new SunOS();
      return SunOS;
  })();
  var Win32 = (function () {
      function Win32() {

      };
      Win32.value = new Win32();
      return Win32;
  })();

  /**
 *  | The String representation for a platform, recognised by Node.js.
 */  
  var toString = function (v) {
      if (v instanceof Darwin) {
          return "darwin";
      };
      if (v instanceof FreeBSD) {
          return "freebsd";
      };
      if (v instanceof Linux) {
          return "linux";
      };
      if (v instanceof SunOS) {
          return "sunos";
      };
      if (v instanceof Win32) {
          return "win32";
      };
      throw new Error("Failed pattern match at Node.Platform line 18, column 1 - line 19, column 1: " + [ v.constructor.name ]);
  }; 
  var fromString = function (v) {
      if (v === "darwin") {
          return new Data_Maybe.Just(Darwin.value);
      };
      if (v === "freebsd") {
          return new Data_Maybe.Just(FreeBSD.value);
      };
      if (v === "linux") {
          return new Data_Maybe.Just(Linux.value);
      };
      if (v === "sunos") {
          return new Data_Maybe.Just(SunOS.value);
      };
      if (v === "win32") {
          return new Data_Maybe.Just(Win32.value);
      };
      return Data_Maybe.Nothing.value;
  };
  var eqPlatform = new Prelude.Eq(Data_Function.on(Prelude.eq(Prelude.eqString))(toString));
  exports["Darwin"] = Darwin;
  exports["FreeBSD"] = FreeBSD;
  exports["Linux"] = Linux;
  exports["SunOS"] = SunOS;
  exports["Win32"] = Win32;
  exports["fromString"] = fromString;
  exports["toString"] = toString;
  exports["eqPlatform"] = eqPlatform;
})(PS["Node.Platform"] = PS["Node.Platform"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Bindings to the global `process` object in Node.js. See also [the Node API documentation](https://nodejs.org/api/process.html)
 */  
  "use strict";
  var $foreign = PS["Node.Process"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];
  var Data_StrMap_1 = PS["Data.StrMap"];
  var Data_StrMap_1 = PS["Data.StrMap"];
  var Data_Posix = PS["Data.Posix"];
  var Data_Posix_Signal_1 = PS["Data.Posix.Signal"];
  var Data_Posix_Signal_1 = PS["Data.Posix.Signal"];
  var Node_Stream = PS["Node.Stream"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Node_Platform_1 = PS["Node.Platform"];
  var Node_Platform_1 = PS["Node.Platform"];        

  /**
 *  | Get the Node.js version.
 */  
  var version = $foreign.process.version;         

  /**
 *  | The standard output stream. Note that this stream cannot be closed; calling
 *  | `end` will result in an exception being thrown.
 */  
  var stdout = $foreign.process.stdout;

  /**
 *  | The standard input stream. Note that this stream will never emit an `end`
 *  | event, so any handlers attached via `onEnd` will never be called.
 */  
  var stdin = $foreign.process.stdin;             

  /**
 *  | The standard error stream. Note that this stream cannot be closed; calling
 *  | `end` will result in an exception being thrown.
 */  
  var stderr = $foreign.process.stderr;
  var platform = Data_Maybe_Unsafe.fromJust(Node_Platform_1.fromString($foreign.process.platform));

  /**
 *  | Install a handler for a particular signal.
 */  
  var onSignal = function (sig) {
      return $foreign.onSignalImpl(Data_Posix_Signal_1.toString(sig));
  };
  var mkEff = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Get a copy of the current environment.
 */  
  var getEnv = mkEff(function (v) {
      return $foreign.process.env;
  });

  /**
 *  | Lookup a particular environment variable.
 */  
  var lookupEnv = function (k) {
      return Prelude["<$>"](Control_Monad_Eff.functorEff)(Data_StrMap_1.lookup(k))(getEnv);
  }; 

  /**
 *  | Get the current working directory of the process.
 */  
  var cwd = $foreign.process.cwd;

  /**
 *  | Get an array containing the command line arguments. Be aware
 *  | that this can change over the course of the program.
 */  
  var argv = mkEff(function (v) {
      return $foreign.process.argv;
  });
  exports["version"] = version;
  exports["stderr"] = stderr;
  exports["stdout"] = stdout;
  exports["stdin"] = stdin;
  exports["platform"] = platform;
  exports["lookupEnv"] = lookupEnv;
  exports["getEnv"] = getEnv;
  exports["cwd"] = cwd;
  exports["argv"] = argv;
  exports["onSignal"] = onSignal;
  exports["exit"] = $foreign.exit;
  exports["setEnv"] = $foreign.setEnv;
  exports["chdir"] = $foreign.chdir;
})(PS["Node.Process"] = PS["Node.Process"] || {});
(function(exports) {
  // module Pulp.System.FFI

  "use strict";

  exports["runNode'"] = function runNode$prime(error, success, fn) {
    return function() {
      fn(function(err, val) {
        if (err) { error(err)(); } else { success(val)(); }
      });
    };
  };

  exports.unsafeInspect = function unsafeInspect(obj) {
    return require('util').inspect(obj);
  };
})(PS["Pulp.System.FFI"] = PS["Pulp.System.FFI"] || {});
(function(exports) {
    "use strict";

  // module Node.ChildProcess
  /* eslint-env node*/

  exports.unsafeFromNullable = function unsafeFromNullable(msg){
    return function(x) {
      if (x === null) {
        throw new Error(msg);
      } else {
        return x;
      };
    };
  };
  exports.spawnImpl = function spawnImpl(command) {
    return function(args) {
      return function(opts) {
        return function() {
          return require("child_process").spawn(command, args, opts);
        };
      };
    };
  };
  exports.fork = function fork(cmd) {
    return function(args) {
      return function() {
        return require("child_process").fork(cmd, args);
      };
    };
  };
  exports.mkOnExit = function mkOnExit(mkChildExit){
    return function onExit(cp){
      return function(cb){
        return function(){
          cp.on("exit", function(code, signal){
            cb(mkChildExit(code)(signal))();
          });
        };
      };
    };
  };
  exports.onError = function onError(cp){
    return function(cb){
      return function(){
        cp.on("error", function(err) {
          cb(err)()
        });
      };
    };
  };

  exports["undefined"] = undefined;
  exports.process = process;
})(PS["Node.ChildProcess"] = PS["Node.ChildProcess"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module contains various types and functions to allow you to spawn and
 *  | interact with child processes.
 *  |
 *  | It is intended to be imported qualified, as follows:
 *  |
 *  | ```purescript
 *  | import Node.ChildProcess (ChildProcess(), CHILD_PROCESS())
 *  | import Node.ChildProcess as ChildProcess
 *  | ```
 *  |
 *  | The [Node.js documentation](https://nodejs.org/api/child_process.html)
 *  | will probably also be useful to read if you want to use this module.
 */  
  "use strict";
  var $foreign = PS["Node.ChildProcess"];
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Exception_Unsafe = PS["Control.Monad.Eff.Exception.Unsafe"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Function = PS["Data.Function"];
  var Data_Nullable = PS["Data.Nullable"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Posix = PS["Data.Posix"];
  var Data_Posix_Signal_1 = PS["Data.Posix.Signal"];
  var Data_Posix_Signal_1 = PS["Data.Posix.Signal"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_FS = PS["Node.FS"];
  var Node_Stream = PS["Node.Stream"];        

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var Pipe = (function () {
      function Pipe() {

      };
      Pipe.value = new Pipe();
      return Pipe;
  })();

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var Ignore = (function () {
      function Ignore() {

      };
      Ignore.value = new Ignore();
      return Ignore;
  })();

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var ShareStream = (function () {
      function ShareStream(value0) {
          this.value0 = value0;
      };
      ShareStream.create = function (value0) {
          return new ShareStream(value0);
      };
      return ShareStream;
  })();

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var ShareFD = (function () {
      function ShareFD(value0) {
          this.value0 = value0;
      };
      ShareFD.create = function (value0) {
          return new ShareFD(value0);
      };
      return ShareFD;
  })();

  /**
 *  | Specifies how a child process exited; normally (with an exit code), or
 *  | due to a signal.
 */  
  var Normally = (function () {
      function Normally(value0) {
          this.value0 = value0;
      };
      Normally.create = function (value0) {
          return new Normally(value0);
      };
      return Normally;
  })();

  /**
 *  | Specifies how a child process exited; normally (with an exit code), or
 *  | due to a signal.
 */  
  var BySignal = (function () {
      function BySignal(value0) {
          this.value0 = value0;
      };
      BySignal.create = function (value0) {
          return new BySignal(value0);
      };
      return BySignal;
  })();

  /**
 *  | Convert a ChildProcess.Error to a standard Error, which can then be thrown
 *  | inside an Eff or Aff computation (for example).
 */  
  var toStandardError = Unsafe_Coerce.unsafeCoerce;
  var toActualStdIOBehaviour = function (b) {
      if (b instanceof Pipe) {
          return Unsafe_Coerce.unsafeCoerce("pipe");
      };
      if (b instanceof Ignore) {
          return Unsafe_Coerce.unsafeCoerce("ignore");
      };
      if (b instanceof ShareFD) {
          return Unsafe_Coerce.unsafeCoerce(b.value0);
      };
      if (b instanceof ShareStream) {
          return Unsafe_Coerce.unsafeCoerce(b.value0);
      };
      throw new Error("Failed pattern match at Node.ChildProcess line 367, column 28 - line 372, column 3: " + [ b.constructor.name ]);
  };
  var toActualStdIOOptions = Prelude.map(Prelude.functorArray)(function ($31) {
      return Data_Nullable.toNullable(Prelude.map(Data_Maybe.functorMaybe)(toActualStdIOBehaviour)($31));
  });

  /**
 *  | Spawn a child process. Note that, in the event that a child process could
 *  | not be spawned (for example, if the executable was not found) this will
 *  | not throw an error. Instead, the `ChildProcess` will be created anyway,
 *  | but it will immediately emit an 'error' event.
 */  
  var spawn = function (cmd) {
      return function (args) {
          return function (opts) {
              var convertOpts = function (opts1) {
                  return {
                      cwd: Data_Maybe.fromMaybe($foreign["undefined"])(opts1.cwd), 
                      stdio: toActualStdIOOptions(opts1.stdio), 
                      env: Data_Nullable.toNullable(opts1.env), 
                      detached: opts1.detached, 
                      uid: Data_Maybe.fromMaybe($foreign["undefined"])(opts1.uid), 
                      gid: Data_Maybe.fromMaybe($foreign["undefined"])(opts1.gid)
                  };
              };
              return $foreign.spawnImpl(cmd)(args)(convertOpts(opts));
          };
      };
  }; 
  var runChildProcess = function (v) {
      return v;
  };

  /**
 *  | Create pipes for each of the three standard IO streams.
 */  
  var pipe = Prelude.map(Prelude.functorArray)(Data_Maybe.Just.create)([ Pipe.value, Pipe.value, Pipe.value ]);

  /**
 *  | The process ID of a child process. Note that if the process has already
 *  | exited, another process may have taken the same ID, so be careful!
 */  
  var pid = function ($32) {
      return (function (v) {
          return v.pid;
      })(runChildProcess($32));
  };                                                                                     
  var mkExit = function (code) {
      return function (signal) {
          var fromSignal = Control_Bind[">=>"](Data_Maybe.bindMaybe)(Data_Nullable.toMaybe)(function ($33) {
              return Prelude.map(Data_Maybe.functorMaybe)(BySignal.create)(Data_Posix_Signal_1.fromString($33));
          });
          var fromCode = function ($34) {
              return Prelude.map(Data_Maybe.functorMaybe)(Normally.create)(Data_Nullable.toMaybe($34));
          };
          var $20 = Control_Alt["<|>"](Data_Maybe.altMaybe)(fromCode(code))(fromSignal(signal));
          if ($20 instanceof Data_Maybe.Just) {
              return $20.value0;
          };
          if ($20 instanceof Data_Maybe.Nothing) {
              return Control_Monad_Eff_Exception_Unsafe.unsafeThrow("Node.ChildProcess.mkExit: Invalid arguments");
          };
          throw new Error("Failed pattern match at Node.ChildProcess line 153, column 3 - line 156, column 3: " + [ $20.constructor.name ]);
      };
  };                                       
  var onExit = $foreign.mkOnExit(mkExit);
  var mkEff = Unsafe_Coerce.unsafeCoerce;
  var missingStream = function (str) {
      return "Node.ChildProcess: stream not available: " + (str + ("\nThis is probably " + ("because you passed something other than Pipe to the stdio option when " + "you spawned it.")));
  };

  /**
 *  | The standard error stream of a child process. Note that this is only
 *  | available if the process was spawned with the stderr option set to "pipe".
 */  
  var stderr = function ($35) {
      return $foreign.unsafeFromNullable(missingStream("stderr"))((function (v) {
          return v.stderr;
      })(runChildProcess($35)));
  };

  /**
 *  | The standard input stream of a child process. Note that this is only
 *  | available if the process was spawned with the stdin option set to "pipe".
 */  
  var stdin = function ($36) {
      return $foreign.unsafeFromNullable(missingStream("stdin"))((function (v) {
          return v.stdin;
      })(runChildProcess($36)));
  };

  /**
 *  | The standard output stream of a child process. Note that this is only
 *  | available if the process was spawned with the stdout option set to "pipe".
 */  
  var stdout = function ($37) {
      return $foreign.unsafeFromNullable(missingStream("stdout"))((function (v) {
          return v.stdout;
      })(runChildProcess($37)));
  };

  /**
 *  | Send a signal to a child process. It's an unfortunate historical decision
 *  | that this function is called "kill", as sending a signal to a child
 *  | process won't necessarily kill it.
 */  
  var kill = function (sig) {
      return function (v) {
          return mkEff(function (v1) {
              return v.kill(Data_Posix_Signal_1.toString(sig));
          });
      };
  };

  /**
 *  | Share stdin with stdin, stdout with stdout, and stderr with stderr.
 */  
  var inherit = Prelude.map(Prelude.functorArray)(Data_Maybe.Just.create)([ new ShareStream($foreign.process.stdin), new ShareStream($foreign.process.stdout), new ShareStream($foreign.process.stderr) ]);
  var defaultSpawnOptions = {
      cwd: Data_Maybe.Nothing.value, 
      stdio: pipe, 
      env: Data_Maybe.Nothing.value, 
      detached: false, 
      uid: Data_Maybe.Nothing.value, 
      gid: Data_Maybe.Nothing.value
  };
  exports["Pipe"] = Pipe;
  exports["Ignore"] = Ignore;
  exports["ShareStream"] = ShareStream;
  exports["ShareFD"] = ShareFD;
  exports["Normally"] = Normally;
  exports["BySignal"] = BySignal;
  exports["inherit"] = inherit;
  exports["pipe"] = pipe;
  exports["defaultSpawnOptions"] = defaultSpawnOptions;
  exports["spawn"] = spawn;
  exports["onExit"] = onExit;
  exports["toStandardError"] = toStandardError;
  exports["kill"] = kill;
  exports["pid"] = pid;
  exports["stdin"] = stdin;
  exports["stdout"] = stdout;
  exports["stderr"] = stderr;
  exports["fork"] = $foreign.fork;
  exports["onError"] = $foreign.onError;
})(PS["Node.ChildProcess"] = PS["Node.ChildProcess"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.FFI"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Aff_AVar = PS["Control.Monad.Aff.AVar"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Data_Function = PS["Data.Function"];
  var Node_FS = PS["Node.FS"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Process = PS["Node.Process"];
  var Node_ReadLine = PS["Node.ReadLine"];
  var Node_HTTP = PS["Node.HTTP"];        
  var runNode = function (fn) {
      return Control_Monad_Aff.makeAff(function (err) {
          return function (win) {
              return $foreign["runNode'"](err, win, fn);
          };
      });
  };
  exports["runNode"] = runNode;
  exports["unsafeInspect"] = $foreign.unsafeInspect;
})(PS["Pulp.System.FFI"] = PS["Pulp.System.FFI"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Map = PS["Data.Map"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_List = PS["Data.List"];
  var Data_Foreign = PS["Data.Foreign"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var runAction = function (v) {
      return v;
  };
  var option = function (name) {
      return function (match) {
          return function (parser) {
              return function (desc) {
                  return {
                      name: name, 
                      match: match, 
                      parser: parser, 
                      desc: desc, 
                      defaultValue: Data_Maybe.Nothing.value
                  };
              };
          };
      };
  };
  var optionDefault = function (n) {
      return function (m) {
          return function (p) {
              return function (d) {
                  return function (defaultValue) {
                      var $2 = {};
                      for (var $3 in option(n)(m)(p)(d)) {
                          if ((option(n)(m)(p)(d)).hasOwnProperty($3)) {
                              $2[$3] = (option(n)(m)(p)(d))[$3];
                          };
                      };
                      $2.defaultValue = new Data_Maybe.Just(Data_Foreign.toForeign(defaultValue));
                      return $2;
                  };
              };
          };
      };
  };
  var command = function (name) {
      return function (desc) {
          return function (passthroughDesc) {
              return function (action) {
                  return function (options) {
                      return {
                          name: name, 
                          desc: desc, 
                          passthroughDesc: passthroughDesc, 
                          options: options, 
                          action: action, 
                          "arguments": [  ]
                      };
                  };
              };
          };
      };
  };
  var commandWithArgs = function (name) {
      return function (desc) {
          return function (passthroughDesc) {
              return function (action) {
                  return function (options) {
                      return function (args) {
                          var $4 = {};
                          for (var $5 in command(name)(desc)(passthroughDesc)(action)(options)) {
                              if ((command(name)(desc)(passthroughDesc)(action)(options)).hasOwnProperty($5)) {
                                  $4[$5] = (command(name)(desc)(passthroughDesc)(action)(options))[$5];
                              };
                          };
                          $4.arguments = args;
                          return $4;
                      };
                  };
              };
          };
      };
  };
  var argument = function (name) {
      return function (parser) {
          return function (desc) {
              return function (required) {
                  return {
                      name: name, 
                      parser: parser, 
                      desc: desc, 
                      required: required
                  };
              };
          };
      };
  };
  exports["commandWithArgs"] = commandWithArgs;
  exports["command"] = command;
  exports["argument"] = argument;
  exports["optionDefault"] = optionDefault;
  exports["option"] = option;
  exports["runAction"] = runAction;
})(PS["Pulp.Args"] = PS["Pulp.Args"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Functions for getting data back out of an `Options` value.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_String = PS["Data.String"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Map = PS["Data.Map"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Args = PS["Pulp.Args"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var internalError = function (msg) {
      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Internal error in Pulp.Args.Get: " + (msg + ("\n" + "This is a bug. Please report it.\n"))));
  };
  var readForeign = function (dictIsForeign) {
      return function (name) {
          return function (thing) {
              var $4 = Data_Foreign_Class.read(dictIsForeign)(thing);
              if ($4 instanceof Data_Either.Left) {
                  return internalError(Data_String.joinWith("\n")([ "Failed to read option: " + name, "The value was: " + Pulp_System_FFI.unsafeInspect(thing), "Data.Foreign.read failed: " + Prelude.show(Data_Foreign.showForeignError)($4.value0) ]));
              };
              if ($4 instanceof Data_Either.Right) {
                  return Prelude.pure(Control_Monad_Aff.applicativeAff)($4.value0);
              };
              throw new Error("Failed pattern match at Pulp.Args.Get line 71, column 3 - line 81, column 1: " + [ $4.constructor.name ]);
          };
      };
  };

  /**
 *  | Get an option out of the `Options` value. If the option has no default and
 *  | was not specified at the command line, the result will be `Nothing`. For
 *  | options which do have defaults, you probably want the primed version
 *  | instead, `getOption'`.
 */  
  var getOption = function (dictIsForeign) {
      return function (name) {
          return function (opts) {
              var $7 = Data_Map.lookup(Prelude.ordString)(name)(opts);
              if ($7 instanceof Data_Maybe.Just && $7.value0 instanceof Data_Maybe.Just) {
                  return Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Maybe.Just.create)(readForeign(dictIsForeign)(name)($7.value0.value0));
              };
              if ($7 instanceof Data_Maybe.Just && $7.value0 instanceof Data_Maybe.Nothing) {
                  var msg = "Tried to read a flag as an option: " + name;
                  return internalError(msg);
              };
              if ($7 instanceof Data_Maybe.Nothing) {
                  return Prelude.pure(Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
              };
              throw new Error("Failed pattern match at Pulp.Args.Get line 28, column 3 - line 39, column 1: " + [ $7.constructor.name ]);
          };
      };
  };

  /**
 *  | Get an option which was declared with a default value, and therefore
 *  | should always have a value.
 */  
  var getOption$prime = function (dictIsForeign) {
      return function (name) {
          return function (opts) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(getOption(dictIsForeign)(name)(opts))(function (v) {
                  if (v instanceof Data_Maybe.Just) {
                      return Prelude.pure(Control_Monad_Aff.applicativeAff)(v.value0);
                  };
                  if (v instanceof Data_Maybe.Nothing) {
                      var msg = "Missing default value for option: " + name;
                      return internalError(msg);
                  };
                  throw new Error("Failed pattern match at Pulp.Args.Get line 42, column 3 - line 51, column 1: " + [ v.constructor.name ]);
              });
          };
      };
  };

  /**
 *  | True if a given option exists in the `Options` map, false otherwise.
 */  
  var hasOption = function (name) {
      return function (opts) {
          var opt = getOption(Data_Foreign_Class.foreignIsForeign)(name)(opts);
          return Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Maybe.isJust)(opt);
      };
  };

  /**
 *  | Get a flag out of the `Options` value. If it was specified at the command
 *  | line, the result is `true`, otherwise, `false`.
 */  
  var getFlag = function (name) {
      return function (opts) {
          var $14 = Data_Map.lookup(Prelude.ordString)(name)(opts);
          if ($14 instanceof Data_Maybe.Just && $14.value0 instanceof Data_Maybe.Just) {
              var msg = "Tried to read an option as a flag: " + name;
              return internalError(msg);
          };
          if ($14 instanceof Data_Maybe.Just && $14.value0 instanceof Data_Maybe.Nothing) {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)(true);
          };
          if ($14 instanceof Data_Maybe.Nothing) {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)(false);
          };
          throw new Error("Failed pattern match at Pulp.Args.Get line 53, column 3 - line 63, column 1: " + [ $14.constructor.name ]);
      };
  };
  exports["hasOption"] = hasOption;
  exports["getFlag"] = getFlag;
  exports["getOption'"] = getOption$prime;
  exports["getOption"] = getOption;
})(PS["Pulp.Args.Get"] = PS["Pulp.Args.Get"] || {});
(function(exports) {
  // module Pulp.Args.Help
  "use strict";

  exports.pad = function pad(n) {
    return new Array(n + 1).join(" ");
  };

  exports.wrap = function wrap(s) {
    return function(indent) {
      return function() {
        var cols = process.stdout.columns;
        return cols ? require("wordwrap")(indent, cols)(s).slice(indent) : s;
      };
    };
  };
})(PS["Pulp.Args.Help"] = PS["Pulp.Args.Help"] || {});
(function(exports) {
  /* global require */
  /* global exports */
  "use strict";

  // module Node.FS.Async

  exports.handleCallbackImpl = function (left, right, f) {
    return function (err, value) {
      if (err) {
        f(left(err))();
      } else {
        f(right(value))();
      }
    };
  };
})(PS["Node.FS.Async"] = PS["Node.FS.Async"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Node.FS.Async"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_Date = PS["Data.Date"];
  var Data_Time = PS["Data.Time"];
  var Data_Either = PS["Data.Either"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Nullable = PS["Data.Nullable"];
  var Node_Buffer = PS["Node.Buffer"];
  var Data_Int = PS["Data.Int"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_FS_Internal = PS["Node.FS.Internal"];        
  var handleCallback = function (cb) {
      return $foreign.handleCallbackImpl(Data_Either.Left.create, Data_Either.Right.create, cb);
  };
  var fs = Node_FS_Internal.unsafeRequireFS;

  /**
 *  | Makes a new directory with the specified permissions.
 */  
  var mkdir$prime = function (file) {
      return function (perms) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.mkdir(file, Node_FS_Perms.permsToString(perms), handleCallback(cb));
              });
          };
      };
  };

  /**
 *  | Makes a new directory.
 */  
  var mkdir = Prelude.flip(mkdir$prime)(Node_FS_Perms.mkPerms(Node_FS_Perms.all)(Node_FS_Perms.all)(Node_FS_Perms.all));

  /**
 *  | Reads the entire contents of a file returning the result as a raw buffer.
 */  
  var readFile = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.readFile(file, {}, handleCallback(cb));
          });
      };
  };

  /**
 *  | Reads the entire contents of a text file with the specified encoding.
 */  
  var readTextFile = function (encoding) {
      return function (file) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.readFile(file, {
                      encoding: Prelude.show(Node_Encoding.showEncoding)(encoding)
                  }, handleCallback(cb));
              });
          };
      };
  };

  /**
 *  | Gets file statistics.
 */  
  var stat = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.stat(file, handleCallback(function ($58) {
                  return cb(Prelude["<$>"](Data_Either.functorEither)(Node_FS_Stats.Stats.create)($58));
              }));
          });
      };
  };

  /**
 *  | Deletes a file.
 */  
  var unlink = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.unlink(file, handleCallback(cb));
          });
      };
  };

  /**
 *  | Writes a buffer to a file.
 */  
  var writeFile = function (file) {
      return function (buff) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.writeFile(file, buff, {}, handleCallback(cb));
              });
          };
      };
  };

  /**
 *  | Writes text to a file using the specified encoding.
 */  
  var writeTextFile = function (encoding) {
      return function (file) {
          return function (buff) {
              return function (cb) {
                  return Node_FS_Internal.mkEff(function (v) {
                      return fs.writeFile(file, buff, {
                          encoding: Prelude.show(Node_Encoding.showEncoding)(encoding)
                      }, handleCallback(cb));
                  });
              };
          };
      };
  };

  /**
 *  | Write to a file asynchronously. See the [Node Documentation](https://nodejs.org/api/fs.html#fs_fs_write_fd_buffer_offset_length_position_callback)
 *  | for details.
 */  
  var fdWrite = function (fd) {
      return function (buff) {
          return function (off) {
              return function (len) {
                  return function (pos) {
                      return function (cb) {
                          return Node_FS_Internal.mkEff(function (v) {
                              return fs.write(fd, buff, off, len, Data_Nullable.toNullable(pos), handleCallback(cb));
                          });
                      };
                  };
              };
          };
      };
  };

  /**
 *  | Close a file asynchronously. See the [Node Documentation](https://nodejs.org/api/fs.html#fs_fs_close_fd_callback)
 *  | for details.
 */  
  var fdClose = function (fd) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.close(fd, handleCallback(cb));
          });
      };
  };

  /**
 *  | Convenience function to append the whole buffer to the current
 *  | file position.
 */  
  var fdAppend = function (fd) {
      return function (buff) {
          return function (cb) {
              return function __do() {
                  var v = Node_Buffer.size(buff)();
                  return fdWrite(fd)(buff)(0)(v)(Data_Maybe.Nothing.value)(cb)();
              };
          };
      };
  };

  /**
 *  | Check if the path exists.
 */  
  var exists = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.exists(file, function (b) {
                  return Control_Monad_Eff.runPure(Control_Monad_Eff_Unsafe.unsafeInterleaveEff(cb(b)));
              });
          });
      };
  };

  /**
 *  | Changes the permissions of a file.
 */  
  var chmod = function (file) {
      return function (perms) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.chmod(file, Node_FS_Perms.permsToString(perms), handleCallback(cb));
              });
          };
      };
  };
  exports["fdClose"] = fdClose;
  exports["fdAppend"] = fdAppend;
  exports["fdWrite"] = fdWrite;
  exports["exists"] = exists;
  exports["writeTextFile"] = writeTextFile;
  exports["writeFile"] = writeFile;
  exports["readTextFile"] = readTextFile;
  exports["readFile"] = readFile;
  exports["mkdir"] = mkdir;
  exports["unlink"] = unlink;
  exports["stat"] = stat;
  exports["chmod"] = chmod;
})(PS["Node.FS.Async"] = PS["Node.FS.Async"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Data_Date = PS["Data.Date"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Either = PS["Data.Either"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Async = PS["Node.FS.Async"];        
  var toAff = function (p) {
      return Control_Monad_Aff.makeAff(function (e) {
          return function (a) {
              return p(Data_Either.either(e)(a));
          };
      });
  };
  var toAff1 = function (f) {
      return function (a) {
          return toAff(f(a));
      };
  };

  /**
 *  |
 *  | Deletes a file.
 *  |
 */  
  var unlink = toAff1(Node_FS_Async.unlink);
  var toAff2 = function (f) {
      return function (a) {
          return function (b) {
              return toAff(f(a)(b));
          };
      };
  };                                              
  var toAff3 = function (f) {
      return function (a) {
          return function (b) {
              return function (c) {
                  return toAff(f(a)(b)(c));
              };
          };
      };
  };                                        

  /**
 *  |
 *  | Writes text to a file using the specified encoding.
 *  |
 */  
  var writeTextFile = toAff3(Node_FS_Async.writeTextFile);

  /**
 *  |
 *  | Gets file statistics.
 *  |
 */  
  var stat = toAff1(Node_FS_Async.stat);      

  /**
 *  |
 *  | Reads the entire contents of a text file with the specified encoding.
 *  |
 */  
  var readTextFile = toAff2(Node_FS_Async.readTextFile);

  /**
 *  |
 *  | Makes a new directory.
 *  |
 */  
  var mkdir = toAff1(Node_FS_Async.mkdir);  

  /**
 *  | Close a file asynchronously. See the [Node Documentation](https://nodejs.org/api/fs.html#fs_fs_close_fd_callback)
 *  | for details.
 */  
  var fdClose = toAff1(Node_FS_Async.fdClose);

  /**
 *  | Convenience function to append the whole buffer to the current
 *  | file position.
 */  
  var fdAppend = toAff2(Node_FS_Async.fdAppend);

  /**
 *  |
 *  | Check to see if a file exists.
 *  |
 */  
  var exists = function (file) {
      return Control_Monad_Aff.makeAff(function (v) {
          return function (a) {
              return Node_FS_Async.exists(file)(a);
          };
      });
  };                                      

  /**
 *  |
 *  | Changes the permissions of a file.
 *  |
 */  
  var chmod = toAff2(Node_FS_Async.chmod);
  exports["fdClose"] = fdClose;
  exports["fdAppend"] = fdAppend;
  exports["exists"] = exists;
  exports["writeTextFile"] = writeTextFile;
  exports["readTextFile"] = readTextFile;
  exports["mkdir"] = mkdir;
  exports["unlink"] = unlink;
  exports["stat"] = stat;
  exports["chmod"] = chmod;
})(PS["Node.FS.Aff"] = PS["Node.FS.Aff"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Trans = PS["Control.Monad.Trans"];
  var Control_Alt = PS["Control.Alt"];
  var Data_Array = PS["Data.Array"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_List_1 = PS["Data.List"];
  var Data_List_1 = PS["Data.List"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Map = PS["Data.Map"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Text_Parsing_Parser_Token = PS["Text.Parsing.Parser.Token"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        

  /**
 *  | A version of Text.Parsing.Parser.Token.token which lies about the position,
 *  | since we don't care about it here.
 */  
  var token = function (dictMonad) {
      return Text_Parsing_Parser_Token.token(dictMonad)(Prelude["const"](Text_Parsing_Parser_Pos.initialPos));
  };
  var matchOpt = function (o) {
      return function (key) {
          return Data_Foldable.elem(Data_Foldable.foldableArray)(Prelude.eqString)(key)(o.match);
      };
  };

  /**
 *  halt err = ParserT $ \s ->
 *    return { consumed: true, input: s, result: Left (strMsg err) }
 */  
  var matchNamed = function (dictEq) {
      return function (o) {
          return function (key) {
              return Prelude["=="](dictEq)(o.name)(key);
          };
      };
  };
  var lookup = function (dictMonad) {
      return function (dictEq) {
          return function (dictShow) {
              return function (match) {
                  return function (table) {
                      return Prelude.bind(Text_Parsing_Parser.bindParserT(dictMonad))(token(dictMonad))(function (v) {
                          var $18 = Data_Foldable.find(Data_Foldable.foldableArray)(function (i) {
                              return match(i)(v);
                          })(table);
                          if ($18 instanceof Data_Maybe.Just) {
                              return Prelude["return"](Text_Parsing_Parser.applicativeParserT(dictMonad))(new Data_Tuple.Tuple(v, $18.value0));
                          };
                          if ($18 instanceof Data_Maybe.Nothing) {
                              return Text_Parsing_Parser.fail(dictMonad)("Unknown command: " + Prelude.show(dictShow)(v));
                          };
                          throw new Error("Failed pattern match at Pulp.Args.Parser line 48, column 3 - line 52, column 1: " + [ $18.constructor.name ]);
                      });
                  };
              };
          };
      };
  };
  var lookupCmd = lookup(Control_Monad_Aff.monadAff)(Prelude.eqString)(Prelude.showString)(matchNamed(Prelude.eqString));
  var lookupOpt = lookup(Control_Monad_Aff.monadAff)(Prelude.eqString)(Prelude.showString)(matchOpt);
  var opt = function (opts) {
      return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(lookupOpt(opts))(function (v) {
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(v.value1.parser.parser(v.value0))(function (v1) {
              return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Map.singleton(v.value1.name)(v1));
          });
      });
  };
  var halt = function (err) {
      return Control_Monad_Trans.lift(Text_Parsing_Parser.monadTransParserT)(Control_Monad_Aff.monadAff)(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error(err)));
  };
  var extractDefault = function (o) {
      if (o.defaultValue instanceof Data_Maybe.Just) {
          return Data_Map.singleton(o.name)(new Data_Maybe.Just(Data_Foreign.toForeign(o.defaultValue.value0)));
      };
      if (o.defaultValue instanceof Data_Maybe.Nothing) {
          return Data_Map.empty;
      };
      throw new Error("Failed pattern match at Pulp.Args.Parser line 83, column 3 - line 89, column 1: " + [ o.defaultValue.constructor.name ]);
  };
  var cmd = function (cmds) {
      return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser_Combinators["<?>"](Control_Monad_Aff.monadAff)(lookupCmd(cmds))("command"))(function (v) {
          return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(v.value1);
      });
  };
  var arg = function (a) {
      if (a.required) {
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(token(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.fail(Control_Monad_Aff.monadAff)("Required argument \"" + (a.name + "\" missing."))))(function (v) {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(a.parser(v))(function (v1) {
                  return Prelude.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Map.singleton(a.name)(new Data_Maybe.Just(v1)));
              });
          });
      };
      return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser_Combinators["try"](Control_Monad_Aff.functorAff)(Prelude["<$>"](Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(Data_Maybe.Just.create)(Prelude[">>="](Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(token(Control_Monad_Aff.monadAff))(a.parser))))(Prelude.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Maybe.Nothing.value)))(function (v) {
          return Prelude.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Maybe.maybe(Data_Map.empty)(function ($40) {
              return Data_Map.singleton(a.name)(Data_Maybe.Just.create($40));
          })(v));
      });
  };
  var parseArgv = function (globals) {
      return function (commands) {
          var defs = Prelude.map(Prelude.functorArray)(extractDefault);
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Array.many(Text_Parsing_Parser.alternativeParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.lazyParserT)(Text_Parsing_Parser_Combinators["try"](Control_Monad_Aff.functorAff)(opt(globals))))(function (v) {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(cmd(commands))(function (v1) {
                  return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Traversable.traverse(Data_Traversable.traversableArray)(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(arg)(v1["arguments"]))(function (v2) {
                      return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Array.many(Text_Parsing_Parser.alternativeParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.lazyParserT)(Text_Parsing_Parser_Combinators["try"](Control_Monad_Aff.functorAff)(opt(v1.options))))(function (v3) {
                          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Array.many(Text_Parsing_Parser.alternativeParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.lazyParserT)(token(Control_Monad_Aff.monadAff)))(function (v4) {
                              return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))({
                                  globalOpts: Data_Map.unions(Prelude.ordString)(Data_Foldable.foldableArray)(Prelude["++"](Prelude.semigroupArray)(v)(defs(globals))), 
                                  command: v1, 
                                  commandOpts: Data_Map.unions(Prelude.ordString)(Data_Foldable.foldableArray)(Prelude["++"](Prelude.semigroupArray)(v3)(defs(v1.options))), 
                                  commandArgs: Data_Map.unions(Prelude.ordString)(Data_Foldable.foldableArray)(v2), 
                                  remainder: v4
                              });
                          });
                      });
                  });
              });
          });
      };
  };
  var parse = function (globals) {
      return function (commands) {
          return function (s) {
              var initialState = new Text_Parsing_Parser.PState({
                  input: Data_List_1.fromFoldable(Data_Foldable.foldableArray)(s), 
                  position: Text_Parsing_Parser_Pos.initialPos
              });
              return Text_Parsing_Parser.runParserT(Control_Monad_Aff.monadAff)(initialState)(parseArgv(globals)(commands));
          };
      };
  };
  exports["parse"] = parse;
  exports["parseArgv"] = parseArgv;
  exports["extractDefault"] = extractDefault;
  exports["cmd"] = cmd;
  exports["arg"] = arg;
  exports["opt"] = opt;
  exports["lookupCmd"] = lookupCmd;
  exports["lookupOpt"] = lookupOpt;
  exports["lookup"] = lookup;
  exports["token"] = token;
  exports["matchOpt"] = matchOpt;
  exports["matchNamed"] = matchNamed;
  exports["halt"] = halt;
})(PS["Pulp.Args.Parser"] = PS["Pulp.Args.Parser"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Defines a VersionBump type and associated functions.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_String = PS["Data.String"];
  var Data_Version_1 = PS["Data.Version"];
  var Data_Version_1 = PS["Data.Version"];        
  var Major = (function () {
      function Major() {

      };
      Major.value = new Major();
      return Major;
  })();
  var Minor = (function () {
      function Minor() {

      };
      Minor.value = new Minor();
      return Minor;
  })();
  var Patch = (function () {
      function Patch() {

      };
      Patch.value = new Patch();
      return Patch;
  })();
  var ToExact = (function () {
      function ToExact(value0) {
          this.value0 = value0;
      };
      ToExact.create = function (value0) {
          return new ToExact(value0);
      };
      return ToExact;
  })();
  var parseBump = function (str) {
      var $3 = Data_String.toLower(str);
      if ($3 === "major") {
          return new Data_Maybe.Just(Major.value);
      };
      if ($3 === "minor") {
          return new Data_Maybe.Just(Minor.value);
      };
      if ($3 === "patch") {
          return new Data_Maybe.Just(Patch.value);
      };
      return Prelude["<$>"](Data_Maybe.functorMaybe)(ToExact.create)(Data_Either.either(Prelude["const"](Data_Maybe.Nothing.value))(Data_Maybe.Just.create)(Data_Version_1.parseVersion(str)));
  };
  var applyBump = function (b) {
      if (b instanceof Major) {
          return Data_Version_1.bumpMajor;
      };
      if (b instanceof Minor) {
          return Data_Version_1.bumpMinor;
      };
      if (b instanceof Patch) {
          return Data_Version_1.bumpPatch;
      };
      if (b instanceof ToExact) {
          return Prelude["const"](b.value0);
      };
      throw new Error("Failed pattern match at Pulp.VersionBump line 28, column 15 - line 32, column 22: " + [ b.constructor.name ]);
  };
  exports["Major"] = Major;
  exports["Minor"] = Minor;
  exports["Patch"] = Patch;
  exports["ToExact"] = ToExact;
  exports["applyBump"] = applyBump;
  exports["parseBump"] = parseBump;
})(PS["Pulp.VersionBump"] = PS["Pulp.VersionBump"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Monad_Trans = PS["Control.Monad.Trans"];
  var Data_String = PS["Data.String"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Int = PS["Data.Int"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Path = PS["Node.Path"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Parser = PS["Pulp.Args.Parser"];
  var Pulp_VersionBump = PS["Pulp.VersionBump"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        

  /**
 *  TODO: this is gross; we end up parsing the version twice. Probably should
 *  fix this by parameterising OptionParsers and ArgumentParsers based on the
 *  type of the thing they parse.
 */  
  var versionBump = function (arg) {
      var $6 = Pulp_VersionBump.parseBump(arg);
      if ($6 instanceof Data_Maybe.Just) {
          return Prelude.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Foreign.toForeign(arg));
      };
      if ($6 instanceof Data_Maybe.Nothing) {
          return Text_Parsing_Parser.fail(Control_Monad_Aff.monadAff)("Not a valid version bump. Must be: 'major', 'minor', 'patch', " + "or a version.");
      };
      throw new Error("Failed pattern match at Pulp.Args.Types line 104, column 3 - line 109, column 31: " + [ $6.constructor.name ]);
  };
  var require = function (pred) {
      return function (typ) {
          return function (path) {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Control_Monad_Trans.lift(Text_Parsing_Parser.monadTransParserT)(Control_Monad_Aff.monadAff)(Node_FS_Aff.stat(path)))(Pulp_Args_Parser.halt(typ + (" '" + (path + "' not found.")))))(function (v) {
                  return Control_Monad.unless(Text_Parsing_Parser.monadParserT(Control_Monad_Aff.monadAff))(pred(v))(Pulp_Args_Parser.halt("Path '" + (path + ("' is not a " + (typ + ".")))));
              });
          };
      };
  };
  var requireDirectory = require(Node_FS_Stats.isDirectory)("Directory");
  var requireFile = require(Node_FS_Stats.isFile)("File");
  var flag = {
      name: Data_Maybe.Nothing.value, 
      parser: function (v) {
          return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Maybe.Nothing.value);
      }
  };
  var argErr = function (arg) {
      return function (msg) {
          return Pulp_Args_Parser.halt("Argument " + (arg + (": " + msg)));
      };
  };
  var directories = {
      name: new Data_Maybe.Just("<dir:dir:...>"), 
      parser: function (arg) {
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a directory argument.")))(function (v) {
              var paths$prime = Data_String.split(Node_Path.delimiter)(v);
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Foldable.for_(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Foldable.foldableArray)(paths$prime)(requireDirectory))(function () {
                  return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(paths$prime)));
              });
          });
      }
  };
  var directory = {
      name: new Data_Maybe.Just("<dir>"), 
      parser: function (arg) {
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a directory argument.")))(function (v) {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(requireDirectory(v))(function () {
                  return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(v)));
              });
          });
      }
  };
  var file = {
      name: new Data_Maybe.Just("<file>"), 
      parser: function (arg) {
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a file argument.")))(function (v) {
              return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(requireFile(v))(function () {
                  return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(v)));
              });
          });
      }
  };
  var $$int = {
      name: new Data_Maybe.Just("<int>"), 
      parser: function (arg) {
          var err = argErr(arg)("Needs an int argument.");
          return Prelude.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Prelude["<$>"](Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(Data_Int.fromString)(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(err)))(function (v) {
              if (v instanceof Data_Maybe.Just) {
                  return Prelude["return"](Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(v.value0)));
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return err;
              };
              throw new Error("Failed pattern match at Pulp.Args.Types line 54, column 5 - line 57, column 3: " + [ v.constructor.name ]);
          });
      }
  };
  var string = {
      name: new Data_Maybe.Just("<string>"), 
      parser: function (arg) {
          return Prelude["<$>"](Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(function ($16) {
              return Data_Maybe.Just.create(Data_Foreign.toForeign($16));
          })(Control_Alt["<|>"](Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a string argument.")));
      }
  };
  exports["versionBump"] = versionBump;
  exports["directories"] = directories;
  exports["directory"] = directory;
  exports["int"] = $$int;
  exports["file"] = file;
  exports["string"] = string;
  exports["flag"] = flag;
})(PS["Pulp.Args.Types"] = PS["Pulp.Args.Types"] || {});
(function(exports) {
  // module Pulp.System.Stream
  "use strict";

  exports["concatStreamToBuffer'"] = function concatStream$prime(stream, callback) {
    var concat = require("concat-stream");

    var onSuccess = function(buf) {
      callback(null, buf);
    };

    var onError = function(err) {
      callback(err, null);
    };

    stream.on('error', onError);
    stream.pipe(concat(onSuccess));
  };

  exports.createGzip = require("zlib").createGzip;
})(PS["Pulp.System.Stream"] = PS["Pulp.System.Stream"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.Stream"];
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Node_Stream = PS["Node.Stream"];
  var Node_Buffer_1 = PS["Node.Buffer"];
  var Node_Buffer_1 = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];        
  var write = function (stream) {
      return function (str) {
          return Control_Monad_Aff.makeAff(function (v) {
              return function (done) {
                  return Prelude["void"](Control_Monad_Eff.functorEff)(Node_Stream.writeString(stream)(Node_Encoding.UTF8.value)(str)(done(Prelude.unit)));
              };
          });
      };
  };                                      
  var end = function (stream) {
      return Control_Monad_Aff.makeAff(function (v) {
          return function (done) {
              return Prelude["void"](Control_Monad_Eff.functorEff)(Node_Stream.end(stream)(done(Prelude.unit)));
          };
      });
  };
  var concatStreamToBuffer = function (stream) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["concatStreamToBuffer'"])(stream));
  };
  var concatStream = function (stream) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(concatStreamToBuffer(stream))(function (v) {
          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Buffer_1.toString(Node_Encoding.UTF8.value)(v));
      });
  };
  exports["concatStreamToBuffer"] = concatStreamToBuffer;
  exports["concatStream"] = concatStream;
  exports["write"] = write;
  exports["end"] = end;
  exports["createGzip"] = $foreign.createGzip;
})(PS["Pulp.System.Stream"] = PS["Pulp.System.Stream"] || {});
(function(exports) {
  // module Pulp.System.SupportsColor
  "use strict";

  // The MIT License (MIT)
  // 
  // Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)
  // 
  // Permission is hereby granted, free of charge, to any person obtaining a copy
  // of this software and associated documentation files (the "Software"), to deal
  // in the Software without restriction, including without limitation the rights
  // to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  // copies of the Software, and to permit persons to whom the Software is
  // furnished to do so, subject to the following conditions:
  // 
  // The above copyright notice and this permission notice shall be included in
  // all copies or substantial portions of the Software.
  // 
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  // OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  // THE SOFTWARE.

  exports.supportLevel = (function() {
    if (process.stderr && !process.stderr.isTTY) {
      return 0;
    }

    if (process.platform === 'win32') {
      return 1;
    }

    if ('COLORTERM' in process.env) {
      return 1;
    }

    if (process.env.TERM === 'dumb') {
      return 0;
    }

    if (/^xterm-256(?:color)?/.test(process.env.TERM)) {
      return 2;
    }

    if (/^screen|^xterm|^vt100|color|ansi|cygwin|linux/i.test(process.env.TERM)) {
      return 1;
    }

    return 0;
  })();
})(PS["Pulp.System.SupportsColor"] = PS["Pulp.System.SupportsColor"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.SupportsColor"];
  var Prelude = PS["Prelude"];        
  var hasBasic = $foreign.supportLevel >= 1;
  exports["hasBasic"] = hasBasic;
})(PS["Pulp.System.SupportsColor"] = PS["Pulp.System.SupportsColor"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Ansi_Codes = PS["Ansi.Codes"];
  var Ansi_Output = PS["Ansi.Output"];
  var Node_Process = PS["Node.Process"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_System_SupportsColor = PS["Pulp.System.SupportsColor"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var monochromeOutputter = (function () {
      var monobullet = function (text) {
          return Pulp_System_Stream.write(Node_Process.stderr)("* " + (text + "\n"));
      };
      return {
          log: monobullet, 
          err: monobullet, 
          write: Pulp_System_Stream.write(Node_Process.stderr), 
          bolded: Pulp_System_Stream.write(Node_Process.stderr), 
          monochrome: true
      };
  })();
  var bullet = function (stream) {
      return function (color) {
          return function (text) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Ansi_Output.withGraphics(Control_Monad_Aff.monadAff)(Pulp_System_Stream.write(stream))(Ansi_Output.foreground(color))("* "))(function () {
                  return Pulp_System_Stream.write(stream)(text + "\n");
              });
          };
      };
  };
  var ansiOutputter = {
      log: bullet(Node_Process.stderr)(Ansi_Codes.Green.value), 
      err: bullet(Node_Process.stderr)(Ansi_Codes.Red.value), 
      write: Pulp_System_Stream.write(Node_Process.stderr), 
      bolded: Ansi_Output.withGraphics(Control_Monad_Aff.monadAff)(Pulp_System_Stream.write(Node_Process.stderr))(Ansi_Output.bold), 
      monochrome: false
  };

  /**
 *  | Get an outputter. The argument represents "monochrome"; if true is
 *  | supplied, the returned logger will never use color. Otherwise, whether or
 *  | not colour is used depends on the "supports-color" module. Note that the
 *  | `monochrome` attribute of the returned outputter might not necessarily
 *  | be the same as the argument supplied.
 */  
  var makeOutputter = function (monochrome) {
      var $0 = !monochrome && Pulp_System_SupportsColor.hasBasic;
      if ($0) {
          return ansiOutputter;
      };
      if (!$0) {
          return monochromeOutputter;
      };
      throw new Error("Failed pattern match at Pulp.Outputter line 38, column 3 - line 42, column 1: " + [ $0.constructor.name ]);
  };

  /**
 *  | Get an outputter, with monochrome based on the command line arguments.
 */  
  var getOutputter = function (args) {
      return Prelude["<$>"](Control_Monad_Aff.functorAff)(makeOutputter)(Pulp_Args_Get.getFlag("monochrome")(args.globalOpts));
  };
  exports["makeOutputter"] = makeOutputter;
  exports["getOutputter"] = getOutputter;
})(PS["Pulp.Outputter"] = PS["Pulp.Outputter"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.Args.Help"];
  var Prelude = PS["Prelude"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Data_Either = PS["Data.Either"];
  var Data_Array = PS["Data.Array"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_Unsafe = PS["Data.Maybe.Unsafe"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_String = PS["Data.String"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Node_Process = PS["Node.Process"];
  var Node_Path = PS["Node.Path"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Types = PS["Pulp.Args.Types"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var prepareCmds = (function () {
      var foldCmds = function (n) {
          return Data_StrMap.insert(n.name)(n.desc);
      };
      return Data_Foldable.foldr(Data_Foldable.foldableArray)(foldCmds)(Data_StrMap.empty);
  })();
  var prepareArguments = (function () {
      var formatKey = function (arg) {
          return Data_String.toUpper(arg.name);
      };
      var foldOpts = function (arg) {
          return Data_StrMap.insert(formatKey(arg))(arg.desc);
      };
      return Data_Foldable.foldr(Data_Foldable.foldableArray)(foldOpts)(Data_StrMap.empty);
  })();
  var helpOpt = Pulp_Args.option("help")([ "--help", "-h" ])(Pulp_Args_Types.flag)("Show this help message.");
  var getCommandName = Prelude["<$>"](Control_Monad_Eff.functorEff)(function ($25) {
      return Data_Maybe.maybe("pulp")(function ($26) {
          return (function (v) {
              return v.name;
          })(Node_Path.parse($26));
      })((function (v) {
          return Data_Array["!!"](v)(1);
      })($25));
  })(Node_Process.argv);
  var formatTable = function (table) {
      var headers = Data_Array.sort(Prelude.ordString)(Data_StrMap.keys(table));
      var longest = Data_Maybe.fromMaybe(0)(Data_Foldable.maximum(Prelude.ordInt)(Data_Foldable.foldableArray)(Prelude["<#>"](Prelude.functorArray)(headers)(Data_String.length)));
      var formatEntry = function (key) {
          return (function (entry) {
              var padding = longest - Data_String.length(key);
              return function __do() {
                  var v = $foreign.wrap(entry)(longest + 4 | 0)();
                  return "  " + (key + ($foreign.pad(padding + 2 | 0) + (v + "\n")));
              };
          })(Data_Maybe_Unsafe.fromJust(Data_StrMap.lookup(key)(table)));
      };
      return function __do() {
          var v = Data_Traversable.sequence(Data_Traversable.traversableArray)(Control_Monad_Eff.applicativeEff)(Prelude["<#>"](Prelude.functorArray)(headers)(formatEntry))();
          return Data_String.joinWith("")(v);
      };
  };
  var formatPassThrough = function (mdesc) {
      var desc = Data_Maybe.fromMaybe("Passthrough options are ignored.")(mdesc);
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)($foreign.wrap("  " + desc)(2));
  };
  var formatCmds = function ($27) {
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(formatTable(prepareCmds($27)));
  };
  var formatArguments = function ($28) {
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(formatTable(prepareArguments($28)));
  };
  var describeOpt = function (opt) {
      var tryDefault = function (def) {
          var $9 = Data_Foreign_Class.read(Data_Foreign_Class.stringIsForeign)(def);
          if ($9 instanceof Data_Either.Right) {
              return new Data_Maybe.Just(Prelude.show(Prelude.showString)($9.value0));
          };
          if ($9 instanceof Data_Either.Left) {
              var $11 = Data_Foreign_Class.read(Data_Foreign_Class.intIsForeign)(def);
              if ($11 instanceof Data_Either.Right) {
                  return new Data_Maybe.Just(Prelude.show(Prelude.showInt)($11.value0));
              };
              if ($11 instanceof Data_Either.Left) {
                  return Data_Maybe.Nothing.value;
              };
              throw new Error("Failed pattern match at Pulp.Args.Help line 55, column 9 - line 61, column 1: " + [ $11.constructor.name ]);
          };
          throw new Error("Failed pattern match at Pulp.Args.Help line 51, column 5 - line 61, column 1: " + [ $9.constructor.name ]);
      };
      return opt.desc + (function () {
          if (opt.defaultValue instanceof Data_Maybe.Nothing) {
              return "";
          };
          if (opt.defaultValue instanceof Data_Maybe.Just) {
              return Data_Maybe.maybe("")(function (d) {
                  return " [Default: " + (d + "]");
              })(tryDefault(opt.defaultValue.value0));
          };
          throw new Error("Failed pattern match at Pulp.Args.Help line 46, column 19 - line 49, column 3: " + [ opt.defaultValue.constructor.name ]);
      })();
  };
  var prepareOpts = (function () {
      var formatKey = function (n) {
          return Data_String.joinWith(" ")(n.match) + (function () {
              if (n.parser.name instanceof Data_Maybe.Nothing) {
                  return "";
              };
              if (n.parser.name instanceof Data_Maybe.Just) {
                  return " " + n.parser.name.value0;
              };
              throw new Error("Failed pattern match at Pulp.Args.Help line 63, column 23 - line 66, column 9: " + [ n.parser.name.constructor.name ]);
          })();
      };
      var foldOpts = function (n) {
          return Data_StrMap.insert(formatKey(n))(describeOpt(n));
      };
      return Data_Foldable.foldr(Data_Foldable.foldableArray)(foldOpts)(Data_StrMap.empty);
  })();
  var formatOpts = function ($29) {
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(formatTable(prepareOpts($29)));
  };
  var printHelp = function (out) {
      return function (globals) {
          return function (commands) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(getCommandName))(function (v) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("Usage: " + (v + " [global-options] <command> [command-options]\n")))(function () {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("\nGlobal options:\n"))(function () {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude[">>="](Control_Monad_Aff.bindAff)(formatOpts(Prelude["++"](Prelude.semigroupArray)(globals)([ helpOpt ])))(out.write))(function () {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("\nCommands:\n"))(function () {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude[">>="](Control_Monad_Aff.bindAff)(formatCmds(commands))(out.write))(function () {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)($foreign.wrap("Use `" + (v + (" <command> --help` to " + "learn about command specific options.")))(2)))(function (v1) {
                                          return out.write("\n" + (v1 + "\n\n"));
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          };
      };
  };
  var argumentSynopsis = (function () {
      var format = function (arg) {
          return Data_String.toUpper((function () {
              if (arg.required) {
                  return arg.name;
              };
              if (!arg.required) {
                  return "[" + (arg.name + "]");
              };
              throw new Error("Failed pattern match at Pulp.Args.Help line 95, column 5 - line 100, column 1: " + [ arg.required.constructor.name ]);
          })());
      };
      return function ($30) {
          return Data_String.joinWith(" ")(Prelude.map(Prelude.functorArray)(format)($30));
      };
  })();
  var printCommandHelp = function (out) {
      return function (globals) {
          return function (command) {
              var hasCommandOpts = !Data_Array["null"](command.options);
              var hasArguments = !Data_Array["null"](command["arguments"]);
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(getCommandName))(function (v) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("Usage: " + (v + (" [global-options] " + (command.name + (" " + ((function () {
                      if (hasArguments) {
                          return argumentSynopsis(command["arguments"]) + " ";
                      };
                      if (!hasArguments) {
                          return "";
                      };
                      throw new Error("Failed pattern match at Pulp.Args.Help line 122, column 20 - line 122, column 90: " + [ hasArguments.constructor.name ]);
                  })() + ((function () {
                      if (hasCommandOpts) {
                          return "[command-options]";
                      };
                      if (!hasCommandOpts) {
                          return "";
                      };
                      throw new Error("Failed pattern match at Pulp.Args.Help line 123, column 20 - line 123, column 70: " + [ hasCommandOpts.constructor.name ]);
                  })() + "\n"))))))))(function () {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("\nCommand: " + (command.name + "\n")))(function () {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("  " + (command.desc + "\n")))(function () {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.when(Control_Monad_Aff.monadAff)(hasArguments)(Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("\nArguments:\n"))(function () {
                                  return Prelude[">>="](Control_Monad_Aff.bindAff)(formatArguments(command["arguments"]))(out.write);
                              })))(function () {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.when(Control_Monad_Aff.monadAff)(hasCommandOpts)(Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("\nCommand options:\n"))(function () {
                                      return Prelude[">>="](Control_Monad_Aff.bindAff)(formatOpts(command.options))(out.write);
                                  })))(function () {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("\nGlobal options:\n"))(function () {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude[">>="](Control_Monad_Aff.bindAff)(formatOpts(Prelude["++"](Prelude.semigroupArray)(globals)([ helpOpt ])))(out.write))(function () {
                                              return Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("\nPassthrough options:\n"))(function () {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude[">>="](Control_Monad_Aff.bindAff)(formatPassThrough(command.passthroughDesc))(out.write))(function () {
                                                      return out.write("\n");
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          };
      };
  };
  exports["printCommandHelp"] = printCommandHelp;
  exports["printHelp"] = printHelp;
})(PS["Pulp.Args.Help"] = PS["Pulp.Args.Help"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_String = PS["Data.String"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Aff_AVar = PS["Control.Monad.Aff.AVar"];
  var Data_Posix_Signal = PS["Data.Posix.Signal"];
  var Node_Process = PS["Node.Process"];
  var Node_Platform = PS["Node.Platform"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];        

  /**
 *  | A slightly weird combination of `onError` and `onExit` into one.
 */  
  var wait = function (child) {
      return Control_Monad_Aff.makeAff(function (v) {
          return function (win) {
              return function __do() {
                  Node_ChildProcess.onExit(child)(function ($30) {
                      return win(Data_Either.Right.create($30));
                  })();
                  return Node_ChildProcess.onError(child)(function ($31) {
                      return win(Data_Either.Left.create($31));
                  })();
              };
          };
      });
  };
  var showExit = function (v) {
      if (v instanceof Node_ChildProcess.Normally) {
          return "with exit code " + Prelude.show(Prelude.showInt)(v.value0);
      };
      if (v instanceof Node_ChildProcess.BySignal) {
          return "as a result of receiving " + Prelude.show(Data_Posix_Signal.showSignal)(v.value0);
      };
      throw new Error("Failed pattern match at Pulp.Exec line 131, column 1 - line 132, column 1: " + [ v.constructor.name ]);
  };
  var handleErrors = function (cmd) {
      return function (retry) {
          return function (err) {
              if (err.code === "ENOENT") {
                  var $13 = Prelude["=="](Node_Platform.eqPlatform)(Node_Process.platform)(Node_Platform.Win32.value);
                  if ($13) {
                      var $14 = Data_String.stripSuffix(".cmd")(cmd);
                      if ($14 instanceof Data_Maybe.Nothing) {
                          return retry(cmd + ".cmd");
                      };
                      if ($14 instanceof Data_Maybe.Just) {
                          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("`" + ($14.value0 + ("` executable not found. (nor `" + (cmd + "`)")))));
                      };
                      throw new Error("Failed pattern match at Pulp.Exec line 139, column 13 - line 143, column 8: " + [ $14.constructor.name ]);
                  };
                  if (!$13) {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("`" + (cmd + "` executable not found.")));
                  };
                  throw new Error("Failed pattern match at Pulp.Exec line 138, column 6 - line 146, column 3: " + [ $13.constructor.name ]);
              };
              if (Prelude.otherwise) {
                  return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Node_ChildProcess.toStandardError(err));
              };
              throw new Error("Failed pattern match at Pulp.Exec line 135, column 1 - line 147, column 40: " + [ cmd.constructor.name, retry.constructor.name, err.constructor.name ]);
          };
      };
  };
  var execQuietWithStderr = function (stderrBehaviour) {
      return function (cmd) {
          return function (args) {
              return function (env) {
                  var retry = function (newCmd) {
                      return execQuietWithStderr(stderrBehaviour)(newCmd)(args)(env);
                  };
                  var onExit = function (outVar) {
                      return function (exit) {
                          return Prelude[">>="](Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.takeVar(outVar))(function (childOut) {
                              if (exit instanceof Node_ChildProcess.Normally && exit.value0 === 0) {
                                  return Prelude.pure(Control_Monad_Aff.applicativeAff)(childOut);
                              };
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.write(Node_Process.stderr)(childOut))(function () {
                                  return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Subcommand terminated " + showExit(exit)));
                              });
                          });
                      };
                  };
                  var stdio = [ new Data_Maybe.Just(new Node_ChildProcess.ShareStream(Unsafe_Coerce.unsafeCoerce(Node_Process.stdin))), new Data_Maybe.Just(Node_ChildProcess.Pipe.value), new Data_Maybe.Just(stderrBehaviour) ];
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.spawn(cmd)(args)((function () {
                      var $18 = {};
                      for (var $19 in Node_ChildProcess.defaultSpawnOptions) {
                          if (Node_ChildProcess.defaultSpawnOptions.hasOwnProperty($19)) {
                              $18[$19] = Node_ChildProcess.defaultSpawnOptions[$19];
                          };
                      };
                      $18.env = env;
                      $18.stdio = stdio;
                      return $18;
                  })())))(function (v) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.makeVar)(function (v1) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.forkAff(Prelude[">>="](Control_Monad_Aff.bindAff)(Pulp_System_Stream.concatStream(Node_ChildProcess.stdout(v)))(Control_Monad_Aff_AVar.putVar(v1))))(function () {
                              return Prelude[">>="](Control_Monad_Aff.bindAff)(wait(v))(Data_Either.either(handleErrors(cmd)(retry))(onExit(v1)));
                          });
                      });
                  });
              };
          };
      };
  };

  /**
 *  | Same as exec, except instead of relaying stdout immediately, it is
 *  | captured and returned as a String.
 */  
  var execQuiet = execQuietWithStderr(new Node_ChildProcess.ShareStream(Unsafe_Coerce.unsafeCoerce(Node_Process.stderr)));
  var pscBundle = function (files) {
      return function (args) {
          return function (env) {
              return execQuiet("psc-bundle")(Prelude["<>"](Prelude.semigroupArray)(files)(args))(env);
          };
      };
  };
  var exec = function (cmd) {
      return function (args) {
          return function (env) {
              var retry = function (newCmd) {
                  return exec(newCmd)(args)(env);
              };
              var onExit = function (exit) {
                  if (exit instanceof Node_ChildProcess.Normally && exit.value0 === 0) {
                      return Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit);
                  };
                  return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Subcommand terminated " + showExit(exit)));
              };
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.spawn(cmd)(args)((function () {
                  var $24 = {};
                  for (var $25 in Node_ChildProcess.defaultSpawnOptions) {
                      if (Node_ChildProcess.defaultSpawnOptions.hasOwnProperty($25)) {
                          $24[$25] = Node_ChildProcess.defaultSpawnOptions[$25];
                      };
                  };
                  $24.env = env;
                  $24.stdio = Node_ChildProcess.inherit;
                  return $24;
              })())))(function (v) {
                  return Prelude[">>="](Control_Monad_Aff.bindAff)(wait(v))(Data_Either.either(handleErrors(cmd)(retry))(onExit));
              });
          };
      };
  };

  /**
 *  | A version of `exec` which installs signal handlers to make sure that the
 *  | signals SIGINT and SIGTERM are relayed to the child process, if received.
 */  
  var execInteractive = function (cmd) {
      return function (args) {
          return function (env) {
              var retry = function (newCmd) {
                  return exec(newCmd)(args)(env);
              };
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.spawn(cmd)(args)((function () {
                  var $27 = {};
                  for (var $28 in Node_ChildProcess.defaultSpawnOptions) {
                      if (Node_ChildProcess.defaultSpawnOptions.hasOwnProperty($28)) {
                          $27[$28] = Node_ChildProcess.defaultSpawnOptions[$28];
                      };
                  };
                  $27.env = env;
                  $27.stdio = Node_ChildProcess.inherit;
                  return $27;
              })())))(function (v) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Data_Foldable.for_(Control_Monad_Eff.applicativeEff)(Data_Foldable.foldableArray)([ Data_Posix_Signal.SIGTERM.value, Data_Posix_Signal.SIGINT.value ])(function (sig) {
                      return Node_Process.onSignal(sig)(Prelude["void"](Control_Monad_Eff.functorEff)(Node_ChildProcess.kill(sig)(v)));
                  })))(function () {
                      return Prelude[">>="](Control_Monad_Aff.bindAff)(wait(v))(Data_Either.either(handleErrors(cmd)(retry))(Prelude["const"](Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit))));
                  });
              });
          };
      };
  };
  var compiler = function (name) {
      return function (deps) {
          return function (args) {
              return function (env) {
                  return execQuiet(name)(Prelude["<>"](Prelude.semigroupArray)(args)(deps))(env);
              };
          };
      };
  };
  var psa = compiler("psa");
  var psc = compiler("psc");
  exports["pscBundle"] = pscBundle;
  exports["psc"] = psc;
  exports["psa"] = psa;
  exports["execInteractive"] = execInteractive;
  exports["execQuietWithStderr"] = execQuietWithStderr;
  exports["execQuiet"] = execQuiet;
  exports["exec"] = exec;
})(PS["Pulp.Exec"] = PS["Pulp.Exec"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Data_String = PS["Data.String"];
  var Data_Version_Haskell = PS["Data.Version.Haskell"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var minimumPscVersion = new Data_Version_Haskell.Version(Data_List.toList(Data_Foldable.foldableArray)([ 0, 9, 0 ]), Data_List.Nil.value);
  var getPscVersion = function (out) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_String.trim)(Pulp_Exec.execQuiet("psc")([ "--version" ])(Data_Maybe.Nothing.value)))(function (v) {
          var $3 = Data_Version_Haskell.parseVersion(v);
          if ($3 instanceof Data_Either.Right) {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)($3.value0);
          };
          if ($3 instanceof Data_Either.Left) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.err("Unable to parse the version from psc. (It was: " + (v + ")")))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.err("Please check that the right psc is on your PATH."))(function () {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Couldn't parse version from psc"));
                  });
              });
          };
          throw new Error("Failed pattern match at Pulp.Validate line 35, column 3 - line 43, column 1: " + [ $3.constructor.name ]);
      });
  };
  var validate = function (out) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(getPscVersion(out))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.when(Control_Monad_Aff.monadAff)(Prelude["<"](Data_Version_Haskell.ordVersion)(v)(minimumPscVersion))(Prelude.bind(Control_Monad_Aff.bindAff)(out.err("This version of Pulp requires version " + (Data_Version_Haskell.showVersion(minimumPscVersion) + (" of the PureScript compiler " + "or higher."))))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.err("Your installed version is " + (Data_Version_Haskell.showVersion(v) + ".")))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.err("Please either upgrade PureScript or downgrade Pulp to version 8.x."))(function () {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Minimum psc version not satisfied"));
                  });
              });
          })))(function () {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)(v);
          });
      });
  };
  exports["validate"] = validate;
})(PS["Pulp.Validate"] = PS["Pulp.Validate"] || {});
(function(exports) {
    "use strict";
  /* global exports */
  /* global require */
  /* global __dirname */
  /* global __filename  */

  // module Node.Globals

  exports.__dirname = __dirname;
  exports.__filename = __filename;
})(PS["Node.Globals"] = PS["Node.Globals"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | Global objects exposed by Node.js. See also the [Node.js API
 *  | documentation](https://nodejs.org/api/globals.html).
 */  
  "use strict";
  var $foreign = PS["Node.Globals"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Node_FS = PS["Node.FS"];
  exports["__filename"] = $foreign.__filename;
  exports["__dirname"] = $foreign.__dirname;
})(PS["Node.Globals"] = PS["Node.Globals"] || {});
(function(exports) {
  // module Pulp.System.Which

  "use strict";

  exports["which'"] = require("which");
})(PS["Pulp.System.Which"] = PS["Pulp.System.Which"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.Which"];
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];        
  var which = function (cmd) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["which'"])(cmd));
  };
  exports["which"] = which;
})(PS["Pulp.System.Which"] = PS["Pulp.System.Which"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_String = PS["Data.String"];
  var Data_Version = PS["Data.Version"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Exception_Unsafe = PS["Control.Monad.Eff.Exception.Unsafe"];
  var Node_FS_Sync = PS["Node.FS.Sync"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Path = PS["Node.Path"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Node_Globals = PS["Node.Globals"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Which = PS["Pulp.System.Which"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];        
  var versionString = Control_Monad_Eff_Unsafe.unsafePerformEff(function __do() {
      var v = Node_FS_Sync.readTextFile(Node_Encoding.UTF8.value)(Node_Path.concat([ Node_Globals.__dirname, "package.json" ]))();
      var $4 = Prelude[">>="](Data_Either.bindEither)(Data_Foreign.parseJSON(v))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("version"));
      if ($4 instanceof Data_Either.Left) {
          return Control_Monad_Eff_Exception.throwException(Control_Monad_Eff_Exception.error("pulp: Unable to parse package.json: " + Prelude.show(Data_Foreign.showForeignError)($4.value0)))();
      };
      if ($4 instanceof Data_Either.Right) {
          return $4.value0;
      };
      throw new Error("Failed pattern match at Pulp.Version line 37, column 5 - line 43, column 1: " + [ $4.constructor.name ]);
  });
  var version = (function () {
      var $7 = Data_Version.parseVersion(versionString);
      if ($7 instanceof Data_Either.Right) {
          return $7.value0;
      };
      if ($7 instanceof Data_Either.Left) {
          return Control_Monad_Eff_Exception_Unsafe.unsafeThrow("pulp: Unable to parse version from package.json: " + Prelude.show(Text_Parsing_Parser.showParseError)($7.value0));
      };
      throw new Error("Failed pattern match at Pulp.Version line 28, column 3 - line 33, column 1: " + [ $7.constructor.name ]);
  })();
  var printVersion = Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.execQuiet("psc")([ "--version" ])(Data_Maybe.Nothing.value))(function (v) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_System_Which.which("psc")))(function (v1) {
          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Control_Monad_Eff_Console.log("Pulp version " + (Data_Version.showVersion(version) + ("\npsc version " + (Data_String.trim(v) + Data_Either.either(Prelude["const"](""))(function (p) {
              return " using " + Data_String.trim(p);
          })(v1))))));
      });
  });
  exports["printVersion"] = printVersion;
  exports["versionString"] = versionString;
  exports["version"] = version;
})(PS["Pulp.Version"] = PS["Pulp.Version"] || {});
(function(exports) {
  // module Pulp.System.Files

  "use strict";

  exports.isEEXIST = function isEEXIST(err) {
    return err && err.code === 'EEXIST';
  };

  var temp = require('temp').track();
  exports["openTemp'"] = function openTemp$prime(opts, callback) {
    temp.open(opts, callback);
  };

  exports.createWriteStream = function createWriteStream(path) {
    return function() {
      return require('fs').createWriteStream(path);
    };
  };

  exports.isENOENT = function isENOENT(error) {
    return error.code === "ENOENT";
  };

  exports["touch'"] = function touch$prime(path, callback) {
    require("touch")(path, callback);
  };
})(PS["Pulp.System.Files"] = PS["Pulp.System.Files"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.Files"];
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var touch = function (path) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["touch'"])(path));
  };
  var openTemp = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["openTemp'"])(opts));
  };
  var mkdirIfNotExist = function (dir) {
      return Control_Monad_Error_Class.catchJust(Control_Monad_Aff.monadErrorAff)(function (e) {
          var $0 = $foreign.isEEXIST(e);
          if ($0) {
              return new Data_Maybe.Just(Prelude.unit);
          };
          if (!$0) {
              return Data_Maybe.Nothing.value;
          };
          throw new Error("Failed pattern match at Pulp.System.Files line 26, column 20 - line 26, column 61: " + [ $0.constructor.name ]);
      })(Node_FS_Aff.mkdir(dir))(Prelude.pure(Control_Monad_Aff.applicativeAff));
  };
  exports["touch"] = touch;
  exports["openTemp"] = openTemp;
  exports["mkdirIfNotExist"] = mkdirIfNotExist;
  exports["isENOENT"] = $foreign.isENOENT;
  exports["createWriteStream"] = $foreign.createWriteStream;
})(PS["Pulp.System.Files"] = PS["Pulp.System.Files"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Path = PS["Node.Path"];
  var Node_Process = PS["Node.Process"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];        
  var Project = function (x) {
      return x;
  };

  /**
 *  | Read a project's bower file at the given path and construct a Project
 *  | value.
 */  
  var readConfig = function (configFilePath) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)(configFilePath))(function (v) {
          var $8 = Data_Foreign.parseJSON(v);
          if ($8 instanceof Data_Either.Left) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to parse bower.json: " + Prelude.show(Data_Foreign.showForeignError)($8.value0)));
          };
          if ($8 instanceof Data_Either.Right) {
              var path = Node_Path.dirname(configFilePath);
              var cachePath = Node_Path.resolve([ path ])(".pulp-cache");
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.chdir(path)))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.mkdirIfNotExist(cachePath))(function () {
                      return Prelude["return"](Control_Monad_Aff.applicativeAff)({
                          bowerFile: $8.value0, 
                          cache: cachePath, 
                          path: path
                      });
                  });
              });
          };
          throw new Error("Failed pattern match at Pulp.Project line 51, column 3 - line 62, column 1: " + [ $8.constructor.name ]);
      });
  };
  var isForeignProject = new Data_Foreign_Class.IsForeign(function (o) {
      return Prelude.map(Data_Either.functorEither)(Project)(Prelude.bind(Data_Either.bindEither)(Data_Foreign_Class.readProp(Data_Foreign_Class.foreignIsForeign)(Data_Foreign_Index.indexString)("bowerFile")(o))(function (v) {
          return Prelude.bind(Data_Either.bindEither)(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("path")(o))(function (v1) {
              return Prelude.bind(Data_Either.bindEither)(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("cache")(o))(function (v2) {
                  return Prelude["return"](Data_Either.applicativeEither)({
                      bowerFile: v, 
                      path: v1, 
                      cache: v2
                  });
              });
          });
      }));
  });
  var findIn = function (path) {
      return function (file) {
          var fullPath = Node_Path.concat([ path, file ]);
          return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.exists(fullPath))(function (v) {
              if (v) {
                  return Prelude["return"](Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just(fullPath));
              };
              if (!v) {
                  var parent = Node_Path.dirname(path);
                  var $16 = path === parent;
                  if ($16) {
                      return Prelude["return"](Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
                  };
                  if (!$16) {
                      return findIn(parent)(file);
                  };
                  throw new Error("Failed pattern match at Pulp.Project line 42, column 10 - line 48, column 1: " + [ $16.constructor.name ]);
              };
              throw new Error("Failed pattern match at Pulp.Project line 38, column 3 - line 48, column 1: " + [ v.constructor.name ]);
          });
      };
  };

  /**
 *  | Use the provided bower file, or if it is Nothing, try to find a bower file
 *  | path in this or any parent directory.
 */  
  var getBowerFile = (function () {
      var search = Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(findIn(v)("bower.json"))(function (v1) {
              if (v1 instanceof Data_Maybe.Just) {
                  return Prelude.pure(Control_Monad_Aff.applicativeAff)(v1.value0);
              };
              if (v1 instanceof Data_Maybe.Nothing) {
                  return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("No bower.json found in current or parent directories. Are you in a PureScript project?"));
              };
              throw new Error("Failed pattern match at Pulp.Project line 68, column 5 - line 73, column 1: " + [ v1.constructor.name ]);
          });
      });
      return Data_Maybe.maybe(search)(Prelude.pure(Control_Monad_Aff.applicativeAff));
  })();
  var getProject = function (args) {
      return Prelude[">>="](Control_Monad_Aff.bindAff)(Prelude[">>="](Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("bowerFile")(args))(getBowerFile))(readConfig);
  };
  exports["Project"] = Project;
  exports["getProject"] = getProject;
  exports["isForeignProject"] = isForeignProject;
})(PS["Pulp.Project"] = PS["Pulp.Project"] || {});
(function(exports) {
  // module Pulp.Init
  "use strict";

  exports.bowerFile = function bowerFile(name) {
    return JSON.stringify({
      name: name,
      ignore: [
        "**/.*",
        "node_modules",
        "bower_components",
        "output"
      ],
      dependencies: {
        "purescript-console": "^1.0.0"
      },
      devDependencies: {
        "purescript-psci-support": "^1.0.0"
      },
    }, null, 2) + "\n";
  };
})(PS["Pulp.Init"] = PS["Pulp.Init"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Which = PS["Pulp.System.Which"];
  var Pulp_Outputter = PS["Pulp.Outputter"];        
  var launchBower = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_System_Which.which("bower")))(function (v) {
          return Data_Either.either(Prelude["const"](Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("No `bower` executable found.\nPulp no longer bundles Bower. You'll need to install it manually:\n\n   $ npm install -g bower\n"))))(function (e) {
              return Pulp_Exec.exec(e)(args)(Data_Maybe.Nothing.value);
          })(v);
      });
  };
  var printHelp = function (out) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(out.bolded("Dependency Management with Bower\n\n"))(function () {
          return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("The `pulp dep` command invokes the Bower package manager.\n"))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("Run Bower commands like eg. `pulp dep install` instead of `bower install`.\n\n"))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("Consult Bower's help page for the available commands:\n"))(function () {
                      return launchBower(Prelude["++"](Prelude.semigroupArray)([ "--help" ])((function () {
                          if (out.monochrome) {
                              return [ "--no-color" ];
                          };
                          if (!out.monochrome) {
                              return [  ];
                          };
                          throw new Error("Failed pattern match at Pulp.Bower line 46, column 16 - line 46, column 75: " + [ out.monochrome.constructor.name ]);
                      })()));
                  });
              });
          });
      });
  };
  var action = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(v.err("[warn] `pulp dep` is deprecated. Please use `bower` directly instead."))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(launchBower(args.remainder))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(v.err("[warn] Just in case you missed the earlier warning:"))(function () {
                      return v.err("[warn] `pulp dep` is deprecated. Please use `bower` directly instead.");
                  });
              });
          });
      });
  };
  exports["printHelp"] = printHelp;
  exports["launchBower"] = launchBower;
  exports["action"] = action;
})(PS["Pulp.Bower"] = PS["Pulp.Bower"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.Init"];
  var Prelude = PS["Prelude"];
  var Data_String = PS["Data.String"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad = PS["Control.Monad"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Process = PS["Node.Process"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Foldable = PS["Data.Foldable"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_Bower = PS["Pulp.Bower"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var unlines = function (arr) {
      return Data_String.joinWith("\n")(arr) + "\n";
  };
  var testFile = unlines([ "module Test.Main where", "", "import Prelude", "import Control.Monad.Eff (Eff)", "import Control.Monad.Eff.Console (CONSOLE, log)", "", "main :: forall e. Eff (console :: CONSOLE | e) Unit", "main = do", "  log \"You should add some tests.\"" ]);
  var mainFile = unlines([ "module Main where", "", "import Prelude", "import Control.Monad.Eff (Eff)", "import Control.Monad.Eff.Console (CONSOLE, log)", "", "main :: forall e. Eff (console :: CONSOLE | e) Unit", "main = do", "  log \"Hello sailor!\"" ]);
  var gitignore = unlines([ "/bower_components/", "/node_modules/", "/.pulp-cache/", "/output/", "/.psci*", "/src/.webpack.js" ]);
  var projectFiles = function (pathRoot) {
      return function (projectName) {
          var fullPath = function (pathParts) {
              return Node_Path.concat(Prelude["++"](Prelude.semigroupArray)([ pathRoot ])(pathParts));
          };
          return [ {
              path: fullPath([ "bower.json" ]), 
              content: $foreign.bowerFile(projectName)
          }, {
              path: fullPath([ ".gitignore" ]), 
              content: gitignore
          }, {
              path: fullPath([ "src", "Main.purs" ]), 
              content: mainFile
          }, {
              path: fullPath([ "test", "Main.purs" ]), 
              content: testFile
          } ];
      };
  };
  var init = function (force) {
      return function (out) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v) {
              var projectName = Node_Path.basename(v);
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Generating project skeleton in " + v))(function () {
                  var files = projectFiles(v)(projectName);
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.when(Control_Monad_Aff.monadAff)(!force)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(files)(function (f) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.exists(f.path))(function (v1) {
                          return Control_Monad.when(Control_Monad_Aff.monadAff)(v1)(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Found " + (f.path + (": " + ("There's already a project here. Run `pulp init --force` " + "if you're sure you want to overwrite it."))))));
                      });
                  })))(function () {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Data_Traversable["for"](Control_Monad_Aff.applicativeAff)(Data_Traversable.traversableArray)(files)(function (f) {
                          var dir = Node_Path.dirname(f.path);
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.when(Control_Monad_Aff.monadAff)(dir !== v)(Pulp_System_Files.mkdirIfNotExist(dir)))(function () {
                              return Node_FS_Aff.writeTextFile(Node_Encoding.UTF8.value)(f.path)(f.content);
                          });
                      }))(function () {
                          return Pulp_Bower.launchBower([ "update" ]);
                      });
                  });
              });
          });
      };
  };
  var action = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("force")(args.commandOpts))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v1) {
              return init(v)(v1);
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.Init"] = PS["Pulp.Init"] || {});
(function(exports) {
  // module Pulp.Files

  "use strict";

  exports["glob'"] = function glob$prime(pat, callback) {
    require("glob")(pat, {}, callback);
  };
})(PS["Pulp.Files"] = PS["Pulp.Files"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.Files"];
  var Prelude = PS["Prelude"];
  var Data_Array = PS["Data.Array"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Function = PS["Data.Function"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_List = PS["Data.List"];
  var Data_Set_1 = PS["Data.Set"];
  var Data_Set_1 = PS["Data.Set"];
  var Data_Traversable = PS["Data.Traversable"];
  var Node_Path = PS["Node.Path"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var recursiveGlobWithExtension = function (ext) {
      return function ($7) {
          return Prelude.map(Prelude.functorArray)(function (v) {
              return v + ("/**/*." + ext);
          })(Data_List.fromList(Data_Unfoldable.unfoldableArray)(Data_Set_1.toList($7)));
      };
  };
  var sources = recursiveGlobWithExtension("purs");
  var outputModules = function (buildPath) {
      return [ buildPath + "/*/*.js" ];
  };
  var includeGlobs = function (opts) {
      var mkSet = function ($8) {
          return Data_Set_1.fromList(Prelude.ordString)(Data_List.toList(Data_Foldable.foldableArray)(Data_Maybe.fromMaybe([  ])($8)));
      };
      return Prelude["<$>"](Control_Monad_Aff.functorAff)(mkSet)(Pulp_Args_Get.getOption(Data_Foreign_Class.arrayIsForeign(Data_Foreign_Class.stringIsForeign))("includePaths")(opts));
  };
  var globsFromOption$prime = function (dictIsForeign) {
      return function (f) {
          return function (name) {
              return function (opts) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(dictIsForeign)(name)(opts))(function (v) {
                      return Prelude.pure(Control_Monad_Aff.applicativeAff)((function () {
                          if (v instanceof Data_Maybe.Just) {
                              return Data_Set_1.singleton(f(v.value0));
                          };
                          if (v instanceof Data_Maybe.Nothing) {
                              return Data_Set_1.empty;
                          };
                          throw new Error("Failed pattern match at Pulp.Files line 43, column 3 - line 47, column 1: " + [ v.constructor.name ]);
                      })());
                  });
              };
          };
      };
  };
  var globsFromOption = function (dictIsForeign) {
      return globsFromOption$prime(dictIsForeign)(Prelude.id(Prelude.categoryFn));
  };
  var localGlobs = globsFromOption(Data_Foreign_Class.stringIsForeign)("srcPath");
  var testGlobs = globsFromOption(Data_Foreign_Class.stringIsForeign)("testPath");
  var glob = function (pattern) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["glob'"])(pattern));
  };
  var resolveGlobs = function (patterns) {
      return Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Array.concat)(Data_Traversable.traverse(Data_Traversable.traversableArray)(Control_Monad_Aff.applicativeAff)(glob)(patterns));
  };
  var ffis = recursiveGlobWithExtension("js");
  var dependencyGlobs = globsFromOption$prime(Data_Foreign_Class.stringIsForeign)(function (path) {
      return Node_Path.concat([ path, "purescript-*", "src" ]);
  })("dependencyPath");
  var defaultGlobs = function (opts) {
      return Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Set_1.unions(Prelude.ordString))(Data_Traversable.sequence(Data_List.traversableList)(Control_Monad_Aff.applicativeAff)(Data_List.toList(Data_Foldable.foldableArray)([ localGlobs(opts), dependencyGlobs(opts), includeGlobs(opts) ])));
  };
  exports["glob"] = glob;
  exports["resolveGlobs"] = resolveGlobs;
  exports["outputModules"] = outputModules;
  exports["defaultGlobs"] = defaultGlobs;
  exports["includeGlobs"] = includeGlobs;
  exports["dependencyGlobs"] = dependencyGlobs;
  exports["testGlobs"] = testGlobs;
  exports["localGlobs"] = localGlobs;
  exports["ffis"] = ffis;
  exports["sources"] = sources;
})(PS["Pulp.Files"] = PS["Pulp.Files"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_String = PS["Data.String"];
  var Data_Set = PS["Data.Set"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Node_Process = PS["Node.Process"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_System_Which = PS["Pulp.System.Which"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        
  var NormalBuild = (function () {
      function NormalBuild() {

      };
      NormalBuild.value = new NormalBuild();
      return NormalBuild;
  })();
  var TestBuild = (function () {
      function TestBuild() {

      };
      TestBuild.value = new TestBuild();
      return TestBuild;
  })();

  /**
 *  | Get a writable stream which output should be written to, based on the
 *  | value of the 'to' option.
 */  
  var withOutputStream = function (opts) {
      return function (aff) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("to")(opts))(function (v) {
              if (v instanceof Data_Maybe.Just) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Pulp_System_Files.createWriteStream(v.value0)))(function (v1) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(aff(v1))(function () {
                          return Pulp_System_Stream.end(v1);
                      });
                  });
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return aff(Node_Process.stdout);
              };
              throw new Error("Failed pattern match at Pulp.Build line 116, column 3 - line 122, column 19: " + [ v.constructor.name ]);
          });
      };
  };
  var eqBuildType = new Prelude.Eq(function (v) {
      return function (v1) {
          if (v instanceof NormalBuild && v1 instanceof NormalBuild) {
              return true;
          };
          if (v instanceof TestBuild && v1 instanceof TestBuild) {
              return true;
          };
          return false;
      };
  });
  var bundle = function (args) {
      var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Bundling JavaScript..."))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v1) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(function ($47) {
                      return Data_Maybe.fromMaybe([  ])(Prelude.map(Data_Maybe.functorMaybe)(Data_String.split(","))($47));
                  })(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("modules")(opts)))(function (v2) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v3) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("skipEntryPoint")(opts))(function (v4) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.pscBundle(Pulp_Files.outputModules(v3))(Prelude["++"](Prelude.semigroupArray)([ "--module=" + v1 ])((function () {
                                  if (v4) {
                                      return [  ];
                                  };
                                  if (!v4) {
                                      return Prelude["++"](Prelude.semigroupArray)([ "--main=" + v1 ])(Prelude["++"](Prelude.semigroupArray)(Prelude.map(Prelude.functorArray)(function (m) {
                                          return "--module=" + m;
                                      })(v2))(args.remainder));
                                  };
                                  throw new Error("Failed pattern match at Pulp.Build line 98, column 27 - line 103, column 44: " + [ v4.constructor.name ]);
                              })()))(Data_Maybe.Nothing.value))(function (v5) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(withOutputStream(opts)(function (out$prime) {
                                      return Pulp_System_Stream.write(out$prime)(v5);
                                  }))(function () {
                                      return v.log("Bundled.");
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  var go = function (buildType) {
      return function (args) {
          var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Building project in " + v1))(function () {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<*>"](Control_Monad_Aff.applyAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Set.union(Prelude.ordString))(Pulp_Files.defaultGlobs(opts)))((function () {
                          var $34 = Prelude["=="](eqBuildType)(buildType)(TestBuild.value);
                          if ($34) {
                              return Pulp_Files.testGlobs(opts);
                          };
                          if (!$34) {
                              return Prelude.pure(Control_Monad_Aff.applicativeAff)(Data_Set.empty);
                          };
                          throw new Error("Failed pattern match at Pulp.Build line 54, column 27 - line 56, column 48: " + [ $34.constructor.name ]);
                      })()))(function (v2) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(args.commandOpts))(function (v3) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("noPsa")(args.commandOpts))(function (v4) {
                                  var sourceGlobs = Pulp_Files.sources(v2);
                                  var binArgs = Prelude["++"](Prelude.semigroupArray)([ "-o", v3 ])(args.remainder);
                                  var runPsc = Pulp_Exec.psc(sourceGlobs)(binArgs)(Data_Maybe.Nothing.value);
                                  return Prelude.bind(Control_Monad_Aff.bindAff)((function () {
                                      if (v4) {
                                          return runPsc;
                                      };
                                      if (!v4) {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_System_Which.which("psa")))(function (v5) {
                                              if (v5 instanceof Data_Either.Left) {
                                                  return runPsc;
                                              };
                                              if (v5 instanceof Data_Either.Right) {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("monochrome")(args.globalOpts))(function (v6) {
                                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("dependencyPath")(args.commandOpts))(function (v7) {
                                                          var binArgs$prime = Prelude["++"](Prelude.semigroupArray)(binArgs)(Prelude["++"](Prelude.semigroupArray)([ "--is-lib=" + v7 ])((function () {
                                                              if (v6) {
                                                                  return [ "--monochrome" ];
                                                              };
                                                              if (!v6) {
                                                                  return [  ];
                                                              };
                                                              throw new Error("Failed pattern match at Pulp.Build line 75, column 38 - line 77, column 47: " + [ v6.constructor.name ]);
                                                          })()));
                                                          return Pulp_Exec.psa(sourceGlobs)(binArgs$prime)(Data_Maybe.Nothing.value);
                                                      });
                                                  });
                                              };
                                              throw new Error("Failed pattern match at Pulp.Build line 69, column 7 - line 80, column 3: " + [ v5.constructor.name ]);
                                          });
                                      };
                                      throw new Error("Failed pattern match at Pulp.Build line 65, column 3 - line 80, column 3: " + [ v4.constructor.name ]);
                                  })())(function () {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Build successful."))(function () {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<*>"](Control_Monad_Aff.applyAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Prelude["||"](Prelude.booleanAlgebraBoolean))(Pulp_Args_Get.getFlag("optimise")(opts)))(Pulp_Args_Get.hasOption("to")(opts)))(function (v5) {
                                              return Control_Monad.when(Control_Monad_Aff.monadAff)(v5)(bundle(args));
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      };
  };
  var testBuild = Pulp_Args.runAction(go(TestBuild.value));
  var action = go(NormalBuild.value);
  var build = Pulp_Args.runAction(action);
  exports["withOutputStream"] = withOutputStream;
  exports["testBuild"] = testBuild;
  exports["build"] = build;
  exports["action"] = action;
})(PS["Pulp.Build"] = PS["Pulp.Build"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_StrMap_1 = PS["Data.StrMap"];
  var Data_StrMap_1 = PS["Data.StrMap"];
  var Data_String = PS["Data.String"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Process = PS["Node.Process"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        
  var prependPath = function (newPath) {
      return function (paths) {
          return Data_Maybe.Just.create((function () {
              if (paths instanceof Data_Maybe.Nothing) {
                  return newPath;
              };
              if (paths instanceof Data_Maybe.Just) {
                  return newPath + (Node_Path.delimiter + paths.value0);
              };
              throw new Error("Failed pattern match at Pulp.Run line 61, column 3 - line 66, column 1: " + [ paths.constructor.name ]);
          })());
      };
  };

  /**
 *  | Given a build path, create an environment that is just like this process'
 *  | environment, except with NODE_PATH set up for commands like `pulp run`.
 */  
  var setupEnv = function (buildPath) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.getEnv))(function (v) {
          return Prelude.pure(Control_Monad_Aff.applicativeAff)(Data_StrMap_1.alter(prependPath(Node_Path.resolve([  ])(buildPath)))("NODE_PATH")(v));
      });
  };

  /**
 *  | Escape a string for insertion into a JS string literal.
 */  
  var jsEscape = function ($22) {
      return Data_String.replace("'")("\\'")(Data_String.replace("\\")("\\\\")($22));
  };

  /**
 *  | Construct a JS string to be used as an entry point from a module name.
 */  
  var makeEntry = function (main) {
      return "require('" + (jsEscape(main) + "').main();\n");
  };
  var action = function (args) {
      var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Building project in" + v1))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Files.defaultGlobs(opts))(function (v2) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v3) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.psc(Pulp_Files.sources(v2))([ "-o", v3 ])(Data_Maybe.Nothing.value))(function () {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Build successful."))(function () {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v4) {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Buffer.fromString(makeEntry(v4))(Node_Encoding.UTF8.value)))(function (v5) {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.openTemp({
                                              prefix: "pulp-run", 
                                              suffix: ".js"
                                          }))(function (v6) {
                                              return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdAppend(v6.fd)(v5))(function () {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdClose(v6.fd))(function () {
                                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("runtime")(opts))(function (v7) {
                                                          return Prelude.bind(Control_Monad_Aff.bindAff)(setupEnv(v3))(function (v8) {
                                                              return Pulp_Exec.exec(v7)(Prelude["++"](Prelude.semigroupArray)([ v6.path ])(args.remainder))(new Data_Maybe.Just(v8));
                                                          });
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["makeEntry"] = makeEntry;
  exports["jsEscape"] = jsEscape;
  exports["prependPath"] = prependPath;
  exports["setupEnv"] = setupEnv;
  exports["action"] = action;
})(PS["Pulp.Run"] = PS["Pulp.Run"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_Foreign = PS["Data.Foreign"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Build = PS["Pulp.Build"];
  var Pulp_Run = PS["Pulp.Run"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        
  var action = function (args) {
      var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("runtime")(opts))(function (v1) {
              var isNode = v1 === "node";
              var changeOpts = (function () {
                  if (isNode) {
                      return Prelude.id(Prelude.categoryFn);
                  };
                  if (!isNode) {
                      return Data_Map.insert(Prelude.ordString)("to")(new Data_Maybe.Just(Data_Foreign.toForeign("./output/test.js")));
                  };
                  throw new Error("Failed pattern match at Pulp.Test line 25, column 20 - line 29, column 3: " + [ isNode.constructor.name ]);
              })();
              var buildArgs = (function () {
                  var $9 = {};
                  for (var $10 in args) {
                      if (args.hasOwnProperty($10)) {
                          $9[$10] = args[$10];
                      };
                  };
                  $9.remainder = [  ];
                  $9.commandOpts = changeOpts(args.commandOpts);
                  return $9;
              })();
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Build.testBuild(buildArgs))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Running tests..."))(function () {
                      return Prelude.bind(Control_Monad_Aff.bindAff)((function () {
                          if (isNode) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v2) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v3) {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Run.setupEnv(v3))(function (v4) {
                                          return Pulp_Exec.exec(v1)(Prelude["++"](Prelude.semigroupArray)([ "-e", "require('" + (v2 + "').main()") ])(args.remainder))(new Data_Maybe.Just(v4));
                                      });
                                  });
                              });
                          };
                          if (!isNode) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("to")(buildArgs.commandOpts))(function (v2) {
                                  return Pulp_Exec.exec(v1)(Prelude["++"](Prelude.semigroupArray)([ v2 ])(args.remainder))(Data_Maybe.Nothing.value);
                              });
                          };
                          throw new Error("Failed pattern match at Pulp.Test line 35, column 3 - line 47, column 3: " + [ isNode.constructor.name ]);
                      })())(function () {
                          return v.log("Tests OK.");
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.Test"] = PS["Pulp.Test"] || {});
(function(exports) {
  // module Pulp.Browserify

  "use strict";

  function write(input, output, callback) {
    var pipe = require("through")();
    input.pipe(pipe);
    pipe.pipe(output, {end: false});
    pipe.on("end", callback);
  }

  exports["browserifyBundle'"] = function browserifyBundle$prime(opts, callback) {
    var StringStream = require("string-stream");
    var browserify = require("browserify");

    var b = browserify({
      basedir: opts.basedir,
      entries: new StringStream(opts.src),
      standalone: opts.standalone
    });
    if (opts.transform) b.transform(opts.transform);
    write(b.bundle(), opts.out, callback);
  };

  exports["browserifyIncBundle'"] = function browserifyIncBundle$prime(opts, callback) {
    var browserifyInc = require("browserify-incremental");

    var b = browserifyInc({
      basedir: opts.buildPath,
      cacheFile: opts.cachePath,
      standalone: opts.standalone
    });
    b.add(opts.path);
    if (opts.transform) b.transform(opts.transform);
    write(b.bundle(), opts.out, callback);
  };
})(PS["Pulp.Browserify"] = PS["Pulp.Browserify"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.Browserify"];
  var Prelude = PS["Prelude"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_Nullable = PS["Data.Nullable"];
  var Node_Path = PS["Node.Path"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Process = PS["Node.Process"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_Build = PS["Pulp.Build"];
  var Pulp_Run = PS["Pulp.Run"];
  var Pulp_Project = PS["Pulp.Project"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        

  /**
 *  | Given the build path, modify this process' NODE_PATH environment variable
 *  | for browserify.
 */  
  var setupNodePath = function (buildPath) {
      return function __do() {
          var v = Node_Process.lookupEnv("NODE_PATH")();
          var buildPath$prime = Node_Path.resolve([  ])(buildPath);
          return Node_Process.setEnv("NODE_PATH")((function () {
              if (v instanceof Data_Maybe.Just) {
                  return buildPath$prime + (Node_Path.delimiter + v.value0);
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return buildPath$prime;
              };
              throw new Error("Failed pattern match at Pulp.Browserify line 139, column 3 - line 144, column 1: " + [ v.constructor.name ]);
          })())();
      };
  };
  var makeOptExport = function (main) {
      return "module.exports = PS[\"" + (Pulp_Run.jsEscape(main) + "\"];\n");
  };
  var makeExport = function (main) {
      return function ($$export) {
          if ($$export) {
              return "module.exports = require(\"" + (Pulp_Run.jsEscape(main) + "\");\n");
          };
          if (!$$export) {
              return Pulp_Run.makeEntry(main);
          };
          throw new Error("Failed pattern match at Pulp.Browserify line 44, column 3 - line 48, column 1: " + [ $$export.constructor.name ]);
      };
  };
  var browserifyIncBundle = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["browserifyIncBundle'"])(opts));
  };
  var incremental = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          var munge = Data_Map["delete"](Prelude.ordString)("to");
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Build.build((function () {
              var $26 = {};
              for (var $27 in args) {
                  if (args.hasOwnProperty($27)) {
                      $26[$27] = args[$27];
                  };
              };
              $26.commandOpts = munge(args.commandOpts);
              return $26;
          })()))(function () {
              var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
              return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Browserifying..."))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v1) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(setupNodePath(v1)))(function () {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("force")(opts))(function (v2) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Pulp_Project.isForeignProject)("_project")(opts))(function (v3) {
                                  var cachePath = Node_Path.resolve([ v3.cache ])("browserify.json");
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.when(Control_Monad_Aff.monadAff)(v2)(Control_Monad_Aff.apathize(Node_FS_Aff.unlink(cachePath))))(function () {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("transform")(opts))(function (v4) {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("standalone")(opts))(function (v5) {
                                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("skipEntryPoint")(opts))(function (v6) {
                                                  var skipEntryPoint = v6 && Data_Maybe.isNothing(v5);
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v7) {
                                                      return Prelude.bind(Control_Monad_Aff.bindAff)((function () {
                                                          if (skipEntryPoint) {
                                                              return Prelude.pure(Control_Monad_Aff.applicativeAff)(Node_Path.concat([ v1, v7 ]));
                                                          };
                                                          if (!skipEntryPoint) {
                                                              var entryJs = makeExport(v7)(Data_Maybe.isJust(v5));
                                                              var entryPath = Node_Path.concat([ v1, "browserify.js" ]);
                                                              return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.writeTextFile(Node_Encoding.UTF8.value)(entryPath)(entryJs))(function () {
                                                                  return Prelude.pure(Control_Monad_Aff.applicativeAff)(entryPath);
                                                              });
                                                          };
                                                          throw new Error("Failed pattern match at Pulp.Browserify line 114, column 11 - line 123, column 3: " + [ skipEntryPoint.constructor.name ]);
                                                      })())(function (v8) {
                                                          return Pulp_Build.withOutputStream(opts)(function (out$prime) {
                                                              return browserifyIncBundle({
                                                                  basedir: v1, 
                                                                  cacheFile: cachePath, 
                                                                  path: v8, 
                                                                  transform: Data_Nullable.toNullable(v4), 
                                                                  standalone: Data_Nullable.toNullable(v5), 
                                                                  out: out$prime
                                                              });
                                                          });
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  var browserifyBundle = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["browserifyBundle'"])(opts));
  };
  var optimising = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          var munge = function ($53) {
              return Data_Map["delete"](Prelude.ordString)("optimise")(Data_Map["delete"](Prelude.ordString)("to")($53));
          };
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Build.build((function () {
              var $38 = {};
              for (var $39 in args) {
                  if (args.hasOwnProperty($39)) {
                      $38[$39] = args[$39];
                  };
              };
              $38.commandOpts = munge(args.commandOpts);
              return $38;
          })()))(function () {
              var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Files.defaultGlobs(opts))(function (v1) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v2) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v3) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("transform")(opts))(function (v4) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("standalone")(opts))(function (v5) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("skipEntryPoint")(opts))(function (v6) {
                                      var skipEntryPoint = v6 || Data_Maybe.isJust(v5);
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.pscBundle(Pulp_Files.outputModules(v2))(Prelude["++"](Prelude.semigroupArray)([ "--module=" + v3 ])((function () {
                                          if (skipEntryPoint) {
                                              return [  ];
                                          };
                                          if (!skipEntryPoint) {
                                              return Prelude["++"](Prelude.semigroupArray)([ "--main=" + v3 ])(args.remainder);
                                          };
                                          throw new Error("Failed pattern match at Pulp.Browserify line 69, column 27 - line 73, column 44: " + [ skipEntryPoint.constructor.name ]);
                                      })()))(Data_Maybe.Nothing.value))(function (v7) {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Browserifying..."))(function () {
                                              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(setupNodePath(v2)))(function () {
                                                  return Pulp_Build.withOutputStream(opts)(function (out$prime) {
                                                      return browserifyBundle({
                                                          basedir: Node_Path.resolve([  ])(v2), 
                                                          src: v7 + (function () {
                                                              var $48 = Data_Maybe.isJust(v5);
                                                              if ($48) {
                                                                  return makeOptExport(v3);
                                                              };
                                                              if (!$48) {
                                                                  return "";
                                                              };
                                                              throw new Error("Failed pattern match at Pulp.Browserify line 83, column 14 - line 84, column 7: " + [ $48.constructor.name ]);
                                                          })(), 
                                                          transform: Data_Nullable.toNullable(v4), 
                                                          standalone: Data_Nullable.toNullable(v5), 
                                                          out: out$prime
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  var action = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Browserifying project in " + v1))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("optimise")(args.commandOpts))(function (v2) {
                      var act = (function () {
                          if (v2) {
                              return optimising;
                          };
                          if (!v2) {
                              return incremental;
                          };
                          throw new Error("Failed pattern match at Pulp.Browserify line 36, column 13 - line 38, column 3: " + [ v2.constructor.name ]);
                      })();
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args.runAction(act)(args))(function () {
                          return v.log("Browserified.");
                      });
                  });
              });
          });
      });
  };
  exports["browserifyIncBundle"] = browserifyIncBundle;
  exports["browserifyBundle"] = browserifyBundle;
  exports["setupNodePath"] = setupNodePath;
  exports["incremental"] = incremental;
  exports["optimising"] = optimising;
  exports["makeOptExport"] = makeOptExport;
  exports["makeExport"] = makeExport;
  exports["action"] = action;
})(PS["Pulp.Browserify"] = PS["Pulp.Browserify"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Array = PS["Data.Array"];
  var Data_Set = PS["Data.Set"];
  var Data_Map = PS["Data.Map"];
  var Data_String = PS["Data.String"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Traversable = PS["Data.Traversable"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Process = PS["Node.Process"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Monoid = PS["Data.Monoid"];        
  var showModuleName = Data_String.joinWith(".");

  /**
 *  | Given a line in a PureScript source file, attempt to extract its name.
 */  
  var moduleNameFromLine = function ($29) {
      return Prelude.map(Data_Maybe.functorMaybe)(function ($30) {
          return Data_String.split(".")(Data_String.takeWhile(function ($31) {
              return !(function (v) {
                  return Data_Foldable.elem(Data_Foldable.foldableArray)(Prelude.eqChar)(v)([ " ", "(" ]);
              })($31);
          })($30));
      })(Data_String.stripPrefix("module ")($29));
  };

  /**
 *  | Given a PureScript source file path, extract its module name (or throw
 *  | an error).
 */  
  var extractModuleName = function (path) {
      var go = function ($32) {
          return (function ($33) {
              return Data_Array.head(Data_Array.catMaybes($33));
          })(Prelude.map(Prelude.functorArray)(moduleNameFromLine)(Data_String.split("\n")($32)));
      };
      return Prelude["<$>"](Control_Monad_Aff.functorAff)(go)(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)(path));
  };

  /**
 *  | Given a module name, return the file path where its documentation should
 *  | be written to.
 */  
  var docPath = function (mn) {
      return "docs/" + (Data_String.joinWith("/")(mn) + ".md");
  };

  /**
 *  | Given a file path to be included in the documentation, return a --docgen
 *  | argument for it, to be passsed to psc-docs.
 */  
  var makeDocgen = function (path) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(extractModuleName(path))(function (v) {
          return Prelude.pure(Control_Monad_Aff.applicativeAff)((function () {
              if (v instanceof Data_Maybe.Just) {
                  return new Data_Tuple.Tuple([ "--docgen", showModuleName(v.value0) + (":" + docPath(v.value0)) ], [  ]);
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return new Data_Tuple.Tuple([  ], [ path ]);
              };
              throw new Error("Failed pattern match at Pulp.Docs line 63, column 3 - line 71, column 1: " + [ v.constructor.name ]);
          })());
      });
  };
  var action = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Generating documentation in " + v1))(function () {
                  var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("withTests")(opts))(function (v2) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("withDependencies")(opts))(function (v3) {
                          var includeWhen = function (b) {
                              return function (act) {
                                  if (b) {
                                      return act;
                                  };
                                  if (!b) {
                                      return Prelude.pure(Control_Monad_Aff.applicativeAff)(Data_Set.empty);
                                  };
                                  throw new Error("Failed pattern match at Pulp.Docs line 38, column 27 - line 39, column 3: " + [ b.constructor.name ]);
                              };
                          };
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<*>"](Control_Monad_Aff.applyAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Set.union(Prelude.ordString))(includeWhen(v2)(Pulp_Files.testGlobs(opts))))(includeWhen(v3)(Pulp_Files.dependencyGlobs(opts))))(function (v4) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Set.union(Prelude.ordString)(v4))(Pulp_Files.defaultGlobs(opts)))(function (v5) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Set.union(Prelude.ordString)(v4))(Pulp_Files.localGlobs(opts)))(function (v6) {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Files.resolveGlobs(Pulp_Files.sources(v6)))(function (v7) {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Foldable.mconcat(Data_Foldable.foldableArray)(Data_Tuple.monoidTuple(Data_Monoid.monoidArray)(Data_Monoid.monoidArray)))(Data_Traversable.traverse(Data_Traversable.traversableArray)(Control_Monad_Aff.applicativeAff)(makeDocgen)(v7)))(function (v8) {
                                              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.unless(Control_Monad_Aff.monadAff)(Data_Array["null"](v8.value1))(Prelude.bind(Control_Monad_Aff.bindAff)(v.err("Unable to extract module name from the following modules:"))(function () {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(v8.value1)(function ($34) {
                                                      return v.log((function (v9) {
                                                          return "  " + v9;
                                                      })($34));
                                                  }))(function () {
                                                      return v.err("This may be a bug.");
                                                  });
                                              })))(function () {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.execQuiet("psc-docs")(Prelude["<>"](Prelude.semigroupArray)(args.remainder)(Prelude["<>"](Prelude.semigroupArray)(Pulp_Files.sources(v5))(v8.value0)))(Data_Maybe.Nothing.value))(function (v9) {
                                                      return v.log("Documentation generated.");
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["moduleNameFromLine"] = moduleNameFromLine;
  exports["extractModuleName"] = extractModuleName;
  exports["showModuleName"] = showModuleName;
  exports["docPath"] = docPath;
  exports["makeDocgen"] = makeDocgen;
  exports["action"] = action;
})(PS["Pulp.Docs"] = PS["Pulp.Docs"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_Set = PS["Data.Set"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var action = function (args) {
      var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
      return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<*>"](Control_Monad_Aff.applyAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Set.union(Prelude.ordString))(Pulp_Files.defaultGlobs(opts)))(Pulp_Files.testGlobs(opts)))(function (v) {
          return Pulp_Exec.execInteractive("psci")(Prelude["<>"](Prelude.semigroupArray)(Pulp_Files.sources(v))(args.remainder))(Data_Maybe.Nothing.value);
      });
  };
  exports["action"] = action;
})(PS["Pulp.Psci"] = PS["Pulp.Psci"] || {});
(function(exports) {
  // module Pulp.Server
  "use strict";

  exports.webpackOptions = function webpackOptions(args) {
    return function() {
      return {
        noInfo: args.noInfo,
        quiet: args.quiet,
        stats: {
          cached: false,
          cachedAssets: false,
          colors: args.colors
        }
      };
    };
  };

  exports.makeDevServer = function makeDevServer(config) {
    return function(options) {
      return function() {
        var webpack = require("webpack");
        var Server = require("webpack-dev-server");
        return new Server(webpack(config), options);
      };
    };
  };

  exports["listen'"] = function listen$prime(server, host, port, callback) {
    server.listen(port, host, callback);
  };
})(PS["Pulp.Server"] = PS["Pulp.Server"] || {});
(function(exports) {
  // module Pulp.System.Require
  "use strict";

  exports.unsafeRequire = function unsafeRequire(path) {
    return function() {
      return require(path);
    };
  };
})(PS["Pulp.System.Require"] = PS["Pulp.System.Require"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.Require"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  exports["unsafeRequire"] = $foreign.unsafeRequire;
})(PS["Pulp.System.Require"] = PS["Pulp.System.Require"] || {});
(function(exports) {
  // module Pulp.Watch

  "use strict";

  exports.watch = function watch(directories) {
    return function(act) {
      return function() {
        var Watchpack = require("watchpack");
        var watchpack = new Watchpack();
        watchpack.watch([], directories, Date.now() - 10000);
        watchpack.on("change", function(path) {
          act(path)();
        });
      };
    };
  };

  exports.minimatch = function(str) {
    return function(glob) {
      return require("minimatch")(str, glob);
    };
  };
})(PS["Pulp.Watch"] = PS["Pulp.Watch"] || {});
(function(exports) {
  // module Pulp.System.TreeKill
  "use strict";

  exports.treeKill = function treeKill(pid) {
    return function(signal) {
      return function() {
        require("tree-kill")(pid, signal);
      };
    };
  };
})(PS["Pulp.System.TreeKill"] = PS["Pulp.System.TreeKill"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.TreeKill"];
  var Prelude = PS["Prelude"];
  var Data_Posix = PS["Data.Posix"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  exports["treeKill"] = $foreign.treeKill;
})(PS["Pulp.System.TreeKill"] = PS["Pulp.System.TreeKill"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.Watch"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Array = PS["Data.Array"];
  var Data_Set = PS["Data.Set"];
  var Data_Map = PS["Data.Map"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Aff_AVar = PS["Control.Monad.Aff.AVar"];
  var Node_Process = PS["Node.Process"];
  var Node_Globals = PS["Node.Globals"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_TreeKill = PS["Pulp.System.TreeKill"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        
  var watchAff = function (dirs) {
      return function (callback) {
          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)($foreign.watch(dirs)(function (path) {
              return Control_Monad_Aff.launchAff(callback(path));
          }));
      };
  };
  var action = function (args) {
      var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Prelude["<$>"](Control_Monad_Eff.functorEff)(function ($19) {
              return Data_Array.filter(function (v1) {
                  return Data_Foldable.notElem(Data_Foldable.foldableArray)(Prelude.eqString)(v1)([ "-w", "--watch" ]);
              })(Data_Array.drop(2)($19));
          })(Node_Process.argv)))(function (v1) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.makeVar)(function (v2) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude[">>="](Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.fork(Node_Globals.__filename)(v1)))(Control_Monad_Aff_AVar.putVar(v2)))(function () {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("srcPath")(opts))(function (v3) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("testPath")(opts))(function (v4) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("dependencyPath")(opts))(function (v5) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Maybe.fromMaybe([  ]))(Pulp_Args_Get.getOption(Data_Foreign_Class.arrayIsForeign(Data_Foreign_Class.stringIsForeign))("includePaths")(opts)))(function (v6) {
                                      var directories = Prelude["++"](Prelude.semigroupArray)([ v3, v4, v5 ])(v6);
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<*>"](Control_Monad_Aff.applyAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Set.union(Prelude.ordString))(Pulp_Files.defaultGlobs(opts)))(Pulp_Files.testGlobs(opts)))(function (v7) {
                                          var fileGlobs = Prelude["<>"](Prelude.semigroupArray)(Pulp_Files.sources(v7))(Pulp_Files.ffis(v7));
                                          return watchAff(directories)(function (path) {
                                              return Control_Monad.when(Control_Monad_Aff.monadAff)(Data_Foldable.any(Data_Foldable.foldableArray)(Prelude.booleanAlgebraBoolean)($foreign.minimatch(path))(fileGlobs))(Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.takeVar(v2))(function (v8) {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Pulp_System_TreeKill.treeKill(Node_ChildProcess.pid(v8))("SIGTERM")))(function () {
                                                      return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Source tree changed; restarting:"))(function () {
                                                          return Prelude[">>="](Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.fork(Node_Globals.__filename)(v1)))(Control_Monad_Aff_AVar.putVar(v2));
                                                      });
                                                  });
                                              }));
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
  exports["watchAff"] = watchAff;
  exports["minimatch"] = $foreign.minimatch;
})(PS["Pulp.Watch"] = PS["Pulp.Watch"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.Server"];
  var Prelude = PS["Prelude"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_String = PS["Data.String"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_String_Regex = PS["Data.String.Regex"];
  var Data_Function = PS["Data.Function"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Process = PS["Node.Process"];
  var Node_Globals = PS["Node.Globals"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Require = PS["Pulp.System.Require"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_Run = PS["Pulp.Run"];
  var Pulp_Watch = PS["Pulp.Watch"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        
  var listen = function (server) {
      return function (host) {
          return function (port) {
              return Pulp_System_FFI.runNode(Data_Function.runFn4($foreign["listen'"])(server)(host)(port));
          };
      };
  };
  var getWebpackOptions = function (opts) {
      return function (out) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("noInfo")(opts))(function (v) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("quiet")(opts))(function (v1) {
                  var colors = !out.monochrome;
                  return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)($foreign.webpackOptions({
                      noInfo: v, 
                      quiet: v1, 
                      colors: colors
                  }));
              });
          });
      };
  };
  var defaultConfig = function (opts) {
      return Data_Foreign.toForeign({
          cache: true, 
          context: opts.context, 
          entry: "./.webpack.js", 
          debug: true, 
          devtool: "source-map", 
          output: {
              path: opts.dir, 
              pathinfo: true, 
              filename: "app.js"
          }, 
          module: {
              loaders: [ {
                  test: Data_String_Regex.regex("\\.purs$")(Data_String_Regex.noFlags), 
                  loader: "purs-loader?output=" + (opts.buildPath + ("&" + Data_String.joinWith("&")(Prelude["++"](Prelude.semigroupArray)(opts.sources)(opts.ffis))))
              } ]
          }, 
          resolve: {
              modulesDirectories: [ "node_modules", "bower_components/purescript-prelude/src", opts.buildPath ], 
              extensions: [ "", ".js", ".purs" ]
          }, 
          resolveLoader: {
              root: opts.nodeModulesPath
          }
      });
  };
  var getDefaultConfig = function (buildPath) {
      return function (sources) {
          return function (ffis) {
              return function __do() {
                  var v = Control_Monad_Eff_Class.liftEff(Control_Monad_Eff_Class.monadEffEff)(Node_Process.cwd)();
                  var nodeModulesPath = Node_Path.resolve([ Node_Globals.__dirname ])("node_modules");
                  var context = Node_Path.resolve([ v ])("src");
                  return defaultConfig({
                      dir: v, 
                      buildPath: buildPath, 
                      sources: sources, 
                      ffis: ffis, 
                      nodeModulesPath: nodeModulesPath, 
                      context: context
                  });
              };
          };
      };
  };
  var action = function (args) {
      var opts = Data_Map.union(Prelude.ordString)(args.globalOpts)(args.commandOpts);
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Node_Path.resolve([  ]))(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts)))(function (v1) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Files.defaultGlobs(opts))(function (v2) {
                  var sources$prime = Prelude.map(Prelude.functorArray)(function (v3) {
                      return "src[]=" + v3;
                  })(Pulp_Files.sources(v2));
                  var ffis$prime = Prelude.map(Prelude.functorArray)(function (v3) {
                      return "ffi[]=" + v3;
                  })(Pulp_Files.ffis(v2));
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Files.resolveGlobs(sources$prime))(function (v3) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(function ($34) {
                          return (function (v4) {
                              return "." + Node_Path.sep + v4;
                          })((function (v4) {
                              return v4 + ".purs";
                          })(Data_String.replace(".")(Node_Path.sep)($34)));
                      })(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts)))(function (v4) {
                          var entryPath = Node_Path.concat([ "src", ".webpack.js" ]);
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.writeTextFile(Node_Encoding.UTF8.value)(entryPath)(Pulp_Run.makeEntry(v4)))(function () {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("config")(opts))(function (v5) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)((function () {
                                      if (v5 instanceof Data_Maybe.Just) {
                                          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Pulp_System_Require.unsafeRequire(Node_Path.resolve([  ])(v5.value0)));
                                      };
                                      if (v5 instanceof Data_Maybe.Nothing) {
                                          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(getDefaultConfig(v1)(sources$prime)(ffis$prime));
                                      };
                                      throw new Error("Failed pattern match at Pulp.Server line 49, column 13 - line 53, column 3: " + [ v5.constructor.name ]);
                                  })())(function (v6) {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(getWebpackOptions(opts)(v))(function (v7) {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)($foreign.makeDevServer(v6)(v7)))(function (v8) {
                                              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("host")(opts))(function (v9) {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.intIsForeign)("port")(opts))(function (v10) {
                                                      return Prelude.bind(Control_Monad_Aff.bindAff)(listen(v8)(v9)(v10))(function () {
                                                          return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Server listening on http://" + (v9 + (":" + (Prelude.show(Prelude.showInt)(v10) + "/")))))(function () {
                                                              return Pulp_Watch.watchAff([ "src" ])(function (path) {
                                                                  return Control_Monad.when(Control_Monad_Aff.monadAff)(Pulp_Watch.minimatch(path)("src/**/*.js"))(Pulp_System_Files.touch(Node_Path.concat([ "src", v4 ])));
                                                              });
                                                          });
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.Server"] = PS["Pulp.Server"] || {});
(function(exports) {
    "use strict";
  var http =require("http");
  var https =require("https"); 

  exports.requestImpl = function(opts) {
    return function(k) {
      return function() {
        var lib = opts.protocol === 'https:' ? https : http;
        return lib.request(opts, function(res) {
          k(res)();
        });
      };
    };
  };
})(PS["Node.HTTP.Client"] = PS["Node.HTTP.Client"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0

  /**
 *  | This module defines low-level bindings to the Node HTTP client.
 */  
  "use strict";
  var $foreign = PS["Node.HTTP.Client"];
  var Prelude = PS["Prelude"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Options = PS["Data.Options"];
  var Data_StrMap = PS["Data.StrMap"];
  var Node_HTTP = PS["Node.HTTP"];
  var Node_Stream = PS["Node.Stream"];
  var Node_URL = PS["Node.URL"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];

  /**
 *  | Get the response status message
 */  
  var statusMessage = function ($4) {
      return (function (v) {
          return v.statusMessage;
      })(Unsafe_Coerce.unsafeCoerce($4));
  };

  /**
 *  | Get the response status code
 */  
  var statusCode = function ($5) {
      return (function (v) {
          return v.statusCode;
      })(Unsafe_Coerce.unsafeCoerce($5));
  };

  /**
 *  | Create a readable stream from a response object.
 */  
  var responseAsStream = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Create a writable stream from a request object.
 */  
  var requestAsStream = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Make a HTTP request using the specified options and response callback.
 */  
  var request = function ($8) {
      return $foreign.requestImpl(Data_Options.options($8));
  };

  /**
 *  | The protocol to use
 */  
  var protocol = Data_Options.opt("protocol");

  /**
 *  | The request path, including query string if appropriate.
 */  
  var path = Data_Options.opt("path");

  /**
 *  | The HTTP request method: GET, POST, etc.
 */  
  var method = Data_Options.opt("method");

  /**
 *  | Domain name or IP
 */  
  var hostname = Data_Options.opt("hostname");
  var headers = Data_Options.opt("headers");
  exports["statusMessage"] = statusMessage;
  exports["statusCode"] = statusCode;
  exports["responseAsStream"] = responseAsStream;
  exports["requestAsStream"] = requestAsStream;
  exports["request"] = request;
  exports["headers"] = headers;
  exports["path"] = path;
  exports["method"] = method;
  exports["hostname"] = hostname;
  exports["protocol"] = protocol;
})(PS["Node.HTTP.Client"] = PS["Node.HTTP.Client"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Options = PS["Data.Options"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_HTTP_Client = PS["Node.HTTP.Client"];
  var Node_Stream = PS["Node.Stream"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];        
  var httpRequest = function (reqOptions) {
      return function (reqBody) {
          var maybeWrite = function (v) {
              return function (v1) {
                  return function (next) {
                      if (v1 instanceof Data_Maybe.Just) {
                          return Prelude["void"](Control_Monad_Eff.functorEff)(Node_Stream.write(v)(v1.value0)(next));
                      };
                      if (v1 instanceof Data_Maybe.Nothing) {
                          return next;
                      };
                      throw new Error("Failed pattern match at Pulp.System.HTTP line 23, column 3 - line 24, column 3: " + [ v.constructor.name, v1.constructor.name, next.constructor.name ]);
                  };
              };
          };
          return Control_Monad_Aff.makeAff(function (err) {
              return function (done) {
                  return function __do() {
                      var v = Node_HTTP_Client.request(reqOptions)(done)();
                      var reqStream = Node_HTTP_Client.requestAsStream(v);
                      Node_Stream.onError(reqStream)(err)();
                      return maybeWrite(reqStream)(reqBody)(Node_Stream.end(reqStream)(Prelude.pure(Control_Monad_Eff.applicativeEff)(Prelude.unit)))();
                  };
              };
          });
      };
  };
  exports["httpRequest"] = httpRequest;
})(PS["Pulp.System.HTTP"] = PS["Pulp.System.HTTP"] || {});
(function(exports) {
  // module Pulp.System.Read

  "use strict";

  exports["read'"] = require("read");
})(PS["Pulp.System.Read"] = PS["Pulp.System.Read"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Pulp.System.Read"];
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];        
  var read = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function.runFn2($foreign["read'"])(opts));
  };
  exports["read"] = read;
})(PS["Pulp.System.Read"] = PS["Pulp.System.Read"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple_Nested = PS["Data.Tuple.Nested"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_String = PS["Data.String"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Options = PS["Data.Options"];
  var Node_Process = PS["Node.Process"];
  var Node_Platform = PS["Node.Platform"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_HTTP_Client = PS["Node.HTTP.Client"];
  var Pulp_System_HTTP = PS["Pulp.System.HTTP"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_System_Read = PS["Pulp.System.Read"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Version = PS["Pulp.Version"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];        
  var obtainTokenFromStdin = function (out) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("Please obtain a GitHub personal access token at:\n"))(function () {
          return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("  https://github.com/settings/tokens/new\n"))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("No scopes are required, so don't check any of the boxes.\n"))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("\n"))(function () {
                      return Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_String.trim)(Pulp_System_Read.read({
                          prompt: "After you've done that, paste it in here: ", 
                          silent: true
                      }));
                  });
              });
          });
      });
  };
  var mkdirIfNotExist = function (dirname) {
      return Control_Monad_Error_Class.catchError(Control_Monad_Aff.monadErrorAff)(Node_FS_Aff.mkdir(dirname))(function (v) {
          var code = Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("code")(Data_Foreign.toForeign(v));
          if (code instanceof Data_Either.Right && code.value0 === "EEXIST") {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit);
          };
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(v);
      });
  };
  var getHome = (function () {
      var homeVar = (function () {
          var $10 = Prelude["=="](Node_Platform.eqPlatform)(Node_Process.platform)(Node_Platform.Win32.value);
          if ($10) {
              return "USERPROFILE";
          };
          if (!$10) {
              return "HOME";
          };
          throw new Error("Failed pattern match at Pulp.Login line 122, column 17 - line 123, column 3: " + [ $10.constructor.name ]);
      })();
      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.lookupEnv(homeVar)))(function (v) {
          if (v instanceof Data_Maybe.Just) {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)(v.value0);
          };
          if (v instanceof Data_Maybe.Nothing) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("The " + (homeVar + " environment variable is not set.")));
          };
          throw new Error("Failed pattern match at Pulp.Login line 124, column 3 - line 129, column 66: " + [ v.constructor.name ]);
      });
  })();
  var tokenFilePath = Prelude["<*>"](Control_Monad_Aff.applyAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Prelude["<>"](Prelude.semigroupString))(getHome))(Prelude.pure(Control_Monad_Aff.applicativeAff)("/.pulp/github-oauth-token"));
  var writeTokenFile = function (token) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(tokenFilePath)(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(mkdirIfNotExist(Node_Path.dirname(v)))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.writeTextFile(Node_Encoding.UTF8.value)(v)(token))(function () {
                  return Node_FS_Aff.chmod(v)(Node_FS_Perms.mkPerms(Prelude["+"](Node_FS_Perms.semiringPerm)(Node_FS_Perms.read)(Node_FS_Perms.write))(Node_FS_Perms.none)(Node_FS_Perms.none));
              });
          });
      });
  };
  var checkToken = function (out) {
      return function (token) {
          var reqOptions = Data_Foldable.fold(Data_Foldable.foldableArray)(Data_Options.monoidOptions)([ Data_Options[":="](Node_HTTP_Client.protocol)("https:"), Data_Options[":="](Node_HTTP_Client.hostname)("api.github.com"), Data_Options[":="](Node_HTTP_Client.path)("/user"), Data_Options[":="](Node_HTTP_Client.headers)(Data_StrMap.fromFoldable(Data_Foldable.foldableArray)([ Data_Tuple_Nested["/\\"]("Accept")("application/vnd.github.v3+json"), Data_Tuple_Nested["/\\"]("Authorization")("token " + token), Data_Tuple_Nested["/\\"]("User-Agent")("Pulp-" + Pulp_Version.versionString) ])) ]);
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_HTTP.httpRequest(reqOptions)(Data_Maybe.Nothing.value))(function (v) {
              var statusCode = Node_HTTP_Client.statusCode(v);
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.concatStream(Node_HTTP_Client.responseAsStream(v)))(function (v1) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.unless(Control_Monad_Aff.monadAff)(statusCode === 200)(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error((function () {
                      if (statusCode === 401) {
                          return "Your token was not accepted (401 Unauthorized).";
                      };
                      var header = "Something went wrong (HTTP " + (Prelude.show(Prelude.showInt)(statusCode) + (" " + (Node_HTTP_Client.statusMessage(v) + ").")));
                      return header + ("\n" + v1);
                  })()))))(function () {
                      var $18 = Prelude[">>="](Data_Either.bindEither)(Data_Foreign.parseJSON(v1))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("login"));
                      if ($18 instanceof Data_Either.Right) {
                          return out.write("Successfully authenticated as " + ($18.value0 + ".\n"));
                      };
                      if ($18 instanceof Data_Either.Left) {
                          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unexpected response from GitHub API: " + Prelude.show(Data_Foreign.showForeignError)($18.value0)));
                      };
                      throw new Error("Failed pattern match at Pulp.Login line 81, column 3 - line 87, column 3: " + [ $18.constructor.name ]);
                  });
              });
          });
      };
  };

  /**
 *  TODO: Obtain tokens automatically after prompting for a username and
 *  password.
 * 
 *  Unfortunately it is not easy to do this without exposing the client secret,
 *  so I think we need to add a route to Pursuit itself to support this, so that
 *  Pursuit sort of proxies to GitHub and adds its client secret itself.
 */  
  var action = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(obtainTokenFromStdin(v))(function (v1) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(checkToken(v)(v1))(function () {
                  return writeTokenFile(v1);
              });
          });
      });
  };
  exports["tokenFilePath"] = tokenFilePath;
  exports["action"] = action;
})(PS["Pulp.Login"] = PS["Pulp.Login"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Either = PS["Data.Either"];
  var Data_Array = PS["Data.Array"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Version_1 = PS["Data.Version"];
  var Data_Version_1 = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Exec = PS["Pulp.Exec"];        

  /**
 *  | Throw an error if the git working tree is dirty.
 */  
  var requireCleanGitWorkingTree = Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.execQuiet("git")([ "status", "--porcelain" ])(Data_Maybe.Nothing.value))(function (v) {
      var $2 = Data_Foldable.all(Data_Foldable.foldableArray)(Prelude.booleanAlgebraBoolean)(Data_String["null"])(Data_String.split("\n")(v));
      if ($2) {
          return Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit);
      };
      if (!$2) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Your git working tree is dirty. Please commit or stash your changes " + "first."));
      };
      throw new Error("Failed pattern match at Pulp.Git line 25, column 3 - line 32, column 1: " + [ $2.constructor.name ]);
  });
  var dropPrefix = function (prefix) {
      return function (str) {
          return Data_Maybe.fromMaybe(str)(Data_String.stripPrefix(prefix)(str));
      };
  };

  /**
 *  | Given a number of lines of text, attempt to parse each line as a version,
 *  | and return the maximum.
 */  
  var maxVersion = (function () {
      var parseMay = function (str) {
          return Prelude.map(Data_Maybe.functorMaybe)(Data_Tuple.Tuple.create(str))(Data_Either.either(Prelude["const"](Data_Maybe.Nothing.value))(Data_Maybe.Just.create)(Data_Version_1.parseVersion(dropPrefix("v")(str))));
      };
      return function ($3) {
          return Data_Foldable.maximumBy(Data_Foldable.foldableArray)(Data_Function.on(Prelude.compare(Data_Version_1.ordVersion))(Data_Tuple.snd))(Data_Array.mapMaybe(function ($4) {
              return parseMay(Data_String.trim($4));
          })(Data_String.split("\n")($3)));
      };
  })();

  /**
 *  | Get the most recently tagged version from the git tag.
 */  
  var getVersionFromGitTag = (function () {
    
      /**
     *  Run a command, piping stderr to /dev/null
     */  
      var run = Pulp_Exec.execQuietWithStderr(Node_ChildProcess.Ignore.value);
      return Prelude.map(Control_Monad_Aff.functorAff)(Data_Either.either(Prelude["const"](Data_Maybe.Nothing.value))(maxVersion))(Control_Monad_Aff.attempt(run("git")([ "describe", "--tags", "--abbrev=0", "HEAD" ])(Data_Maybe.Nothing.value)));
  })();
  exports["dropPrefix"] = dropPrefix;
  exports["maxVersion"] = maxVersion;
  exports["getVersionFromGitTag"] = getVersionFromGitTag;
  exports["requireCleanGitWorkingTree"] = requireCleanGitWorkingTree;
})(PS["Pulp.Git"] = PS["Pulp.Git"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Version_1 = PS["Data.Version"];
  var Data_Version_1 = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_VersionBump = PS["Pulp.VersionBump"];
  var Pulp_System_Read = PS["Pulp.System.Read"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Git = PS["Pulp.Git"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        
  var untilJust = function (dictMonad) {
      return function (act) {
          return Prelude.bind(dictMonad["__superclass_Prelude.Bind_1"]())(act)(function (v) {
              if (v instanceof Data_Maybe.Just) {
                  return Prelude.pure(dictMonad["__superclass_Prelude.Applicative_0"]())(v.value0);
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return untilJust(dictMonad)(act);
              };
              throw new Error("Failed pattern match at Pulp.BumpVersion line 139, column 3 - line 145, column 1: " + [ v.constructor.name ]);
          });
      };
  };
  var tagNewVersion = function (version) {
      var versionStr = "v" + Data_Version_1.showVersion(version);
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.exec("git")([ "commit", "--allow-empty", "--message=" + versionStr ])(Data_Maybe.Nothing.value))(function () {
          return Pulp_Exec.exec("git")([ "tag", "--annotate", "--message=" + versionStr, versionStr ])(Data_Maybe.Nothing.value);
      });
  };

  /**
 *  | Prompt and ask the user what to use as the initial version.
 */  
  var promptInitial = function (out) {
      var vers = function (major) {
          return function (minor) {
              return function (patch) {
                  return Data_Version_1.version(major)(minor)(patch)(Data_List.Nil.value)(Data_List.Nil.value);
              };
          };
      };
      var initialOptions = [ new Data_Tuple.Tuple("a", vers(1)(0)(0)), new Data_Tuple.Tuple("b", vers(0)(1)(0)), new Data_Tuple.Tuple("c", vers(0)(0)(1)) ];
      return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Initial version"))(function () {
          return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("You can release this code as:\n"))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(initialOptions)(function (v) {
                  return out.write(v.value0 + (") v" + (Data_Version_1.showVersion(v.value1) + "\n")));
              }))(function () {
                  return untilJust(Control_Monad_Aff.monadAff)(Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Read.read({
                      prompt: "Choose one, or enter a specific version:", 
                      silent: false
                  }))(function (v) {
                      var $19 = Data_Tuple.lookup(Data_Foldable.foldableArray)(Prelude.eqString)(Data_String.toLower(v))(initialOptions);
                      if ($19 instanceof Data_Maybe.Just) {
                          return Prelude.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just($19.value0));
                      };
                      if ($19 instanceof Data_Maybe.Nothing) {
                          var $21 = Data_Version_1.parseVersion(Pulp_Git.dropPrefix("v")(v));
                          if ($21 instanceof Data_Either.Right) {
                              return Prelude.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just($21.value0));
                          };
                          if ($21 instanceof Data_Either.Left) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Sorry, that choice wasn't understood."))(function () {
                                  return Prelude.pure(Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
                              });
                          };
                          throw new Error("Failed pattern match at Pulp.BumpVersion line 89, column 9 - line 96, column 3: " + [ $21.constructor.name ]);
                      };
                      throw new Error("Failed pattern match at Pulp.BumpVersion line 85, column 5 - line 96, column 3: " + [ $19.constructor.name ]);
                  }));
              });
          });
      });
  };
  var promptCurrent = function (out) {
      return function (current) {
          var bumpOptions = [ new Data_Tuple.Tuple("a", Pulp_VersionBump.Major.value), new Data_Tuple.Tuple("b", Pulp_VersionBump.Minor.value), new Data_Tuple.Tuple("c", Pulp_VersionBump.Patch.value) ];
          return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("The current version is v" + Data_Version_1.showVersion(current)))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("You can bump the version to:\n"))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(bumpOptions)(function (v) {
                      return out.write(v.value0 + (") v" + (Data_Version_1.showVersion(Pulp_VersionBump.applyBump(v.value1)(current)) + "\n")));
                  }))(function () {
                      return untilJust(Control_Monad_Aff.monadAff)(Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Read.read({
                          prompt: "Choose one, or enter a specific version:", 
                          silent: false
                      }))(function (v) {
                          var $28 = Data_Tuple.lookup(Data_Foldable.foldableArray)(Prelude.eqString)(Data_String.toLower(v))(bumpOptions);
                          if ($28 instanceof Data_Maybe.Just) {
                              return Prelude.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just(Pulp_VersionBump.applyBump($28.value0)(current)));
                          };
                          if ($28 instanceof Data_Maybe.Nothing) {
                              var $30 = Data_Version_1.parseVersion(Pulp_Git.dropPrefix("v")(v));
                              if ($30 instanceof Data_Either.Right) {
                                  return Prelude.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just($30.value0));
                              };
                              if ($30 instanceof Data_Either.Left) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Sorry, that choice wasn't understood."))(function () {
                                      return Prelude.pure(Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
                                  });
                              };
                              throw new Error("Failed pattern match at Pulp.BumpVersion line 122, column 9 - line 129, column 3: " + [ $30.constructor.name ]);
                          };
                          throw new Error("Failed pattern match at Pulp.BumpVersion line 118, column 5 - line 129, column 3: " + [ $28.constructor.name ]);
                      }));
                  });
              });
          });
      };
  };
  var internalError = function (msg) {
      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Internal error in Pulp.BumpVersion: " + (msg + ("\n" + "This is a bug. Please report it.\n"))));
  };

  /**
 *  | Try running `psc-publish --dry-run` to make sure the code is suitable for
 *  | release.
 */  
  var checkPscPublish = function (out) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Checking your package using psc-publish..."))(function () {
          return Pulp_Exec.exec("psc-publish")([ "--dry-run" ])(Data_Maybe.Nothing.value);
      });
  };

  /**
 *  | Returns the new version that we should bump to.
 */  
  var bumpVersion = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("bump")(args.commandArgs))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude.map(Control_Monad_Aff.functorAff)(Prelude.map(Data_Maybe.functorMaybe)(Data_Tuple.snd))(Pulp_Git.getVersionFromGitTag))(function (v1) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v2) {
                  if (v instanceof Data_Maybe.Just) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Data_Maybe.maybe(internalError("invalid bump"))(Prelude.pure(Control_Monad_Aff.applicativeAff))(Pulp_VersionBump.parseBump(v.value0)))(function (v3) {
                          return Data_Maybe.maybe(promptInitial(v2))(function ($41) {
                              return Prelude.pure(Control_Monad_Aff.applicativeAff)(Pulp_VersionBump.applyBump(v3)($41));
                          })(v1);
                      });
                  };
                  if (v instanceof Data_Maybe.Nothing) {
                      return Data_Maybe.maybe(promptInitial(v2))(promptCurrent(v2))(v1);
                  };
                  throw new Error("Failed pattern match at Pulp.BumpVersion line 48, column 3 - line 56, column 1: " + [ v.constructor.name ]);
              });
          });
      });
  };
  var action = function (args) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Git.requireCleanGitWorkingTree)(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(checkPscPublish(v))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(bumpVersion(args))(function (v1) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(tagNewVersion(v1))(function () {
                          return v.log("Bumped to: v" + Data_Version_1.showVersion(v1));
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.BumpVersion"] = PS["Pulp.BumpVersion"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Tuple_Nested = PS["Data.Tuple.Nested"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Version_1 = PS["Data.Version"];
  var Data_Version_1 = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Options = PS["Data.Options"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_HTTP_Client = PS["Node.HTTP.Client"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_HTTP = PS["Pulp.System.HTTP"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_System_Read = PS["Pulp.System.Read"];
  var Pulp_Git = PS["Pulp.Git"];
  var Pulp_Login = PS["Pulp.Login"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var uploadPursuitDocs = function (out) {
      return function (authToken) {
          return function (gzippedJson) {
              var headers = Data_StrMap.fromFoldable(Data_Foldable.foldableArray)([ Data_Tuple_Nested["/\\"]("Accept")("application/json"), Data_Tuple_Nested["/\\"]("Authorization")("token " + authToken), Data_Tuple_Nested["/\\"]("Content-Encoding")("gzip") ]);
              var reqOptions = Data_Foldable.fold(Data_Foldable.foldableArray)(Data_Options.monoidOptions)([ Data_Options[":="](Node_HTTP_Client.method)("POST"), Data_Options[":="](Node_HTTP_Client.protocol)("https:"), Data_Options[":="](Node_HTTP_Client.hostname)("pursuit.purescript.org"), Data_Options[":="](Node_HTTP_Client.path)("/packages"), Data_Options[":="](Node_HTTP_Client.headers)(headers) ]);
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_HTTP.httpRequest(reqOptions)(new Data_Maybe.Just(gzippedJson)))(function (v) {
                  var $19 = Node_HTTP_Client.statusCode(v);
                  if ($19 === 201) {
                      return Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit);
                  };
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Bind["=<<"](Control_Monad_Aff.bindAff)(out.err)(Pulp_System_Stream.concatStream(Node_HTTP_Client.responseAsStream(v))))(function () {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Expected an HTTP 201 response from Pursuit, got: " + Prelude.show(Prelude.showInt)($19)));
                  });
              });
          };
      };
  };
  var readTokenFile = Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Login.tokenFilePath)(function (v) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)(v)))(function (v1) {
          if (v1 instanceof Data_Either.Right) {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)(v1.value0);
          };
          if (v1 instanceof Data_Either.Left && Pulp_System_Files.isENOENT(v1.value0)) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Pursuit authentication token not found. Try running `pulp login` " + "first."));
          };
          if (v1 instanceof Data_Either.Left) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(v1.value0);
          };
          throw new Error("Failed pattern match at Pulp.Publish line 146, column 3 - line 156, column 1: " + [ v1.constructor.name ]);
      });
  });
  var readBowerJson = Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)("bower.json"))(function (v) {
      var $27 = Data_Foreign.parseJSON(v);
      if ($27 instanceof Data_Either.Right) {
          return Prelude.pure(Control_Monad_Aff.applicativeAff)($27.value0);
      };
      if ($27 instanceof Data_Either.Left) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to parse bower.json:" + Prelude.show(Data_Foreign.showForeignError)($27.value0)));
      };
      throw new Error("Failed pattern match at Pulp.Publish line 117, column 3 - line 124, column 1: " + [ $27.constructor.name ]);
  });
  var pursuitUrl = function (name) {
      return function (vers) {
          return "https://pursuit.purescript.org/packages/" + (name + ("/" + Data_Version_1.showVersion(vers)));
      };
  };
  var pscPublish = Pulp_Exec.execQuiet("psc-publish")([  ])(Data_Maybe.Nothing.value);
  var gzip = function (str) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Pulp_System_Stream.createGzip))(function (v) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.write(v)(str))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.end(v))(function () {
                  return Pulp_System_Stream.concatStreamToBuffer(v);
              });
          });
      });
  };
  var getBowerRepositoryUrl = function (v) {
      var $32 = Prelude[">>="](Data_Either.bindEither)(Data_Foreign_Class.readProp(Data_Foreign_Class.foreignIsForeign)(Data_Foreign_Index.indexString)("repository")(v))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("url"));
      if ($32 instanceof Data_Either.Right) {
          return Prelude.pure(Control_Monad_Aff.applicativeAff)($32.value0);
      };
      if ($32 instanceof Data_Either.Left) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to read property 'repository.url' from bower.json:" + Prelude.show(Data_Foreign.showForeignError)($32.value0)));
      };
      throw new Error("Failed pattern match at Pulp.Publish line 135, column 3 - line 142, column 1: " + [ $32.constructor.name ]);
  };
  var getBowerName = function (v) {
      var $36 = Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("name")(v);
      if ($36 instanceof Data_Either.Right) {
          return Prelude.pure(Control_Monad_Aff.applicativeAff)($36.value0);
      };
      if ($36 instanceof Data_Either.Left) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to read property 'name' from bower.json:" + Prelude.show(Data_Foreign.showForeignError)($36.value0)));
      };
      throw new Error("Failed pattern match at Pulp.Publish line 126, column 3 - line 133, column 1: " + [ $36.constructor.name ]);
  };
  var confirm = function (q) {
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Read.read({
          prompt: q + " [y/n] ", 
          silent: false
      }))(function (v) {
          var $40 = Data_String.trim(Data_String.toLower(v));
          if ($40 === "y") {
              return Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit);
          };
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Aborted"));
      });
  };
  var confirmRun = function (out) {
      return function (cmd) {
          return function (args) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("About to execute:"))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(out.write("> " + (cmd + (" " + (Data_String.joinWith(" ")(args) + "\n")))))(function () {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(confirm("Ok?"))(function () {
                          return Pulp_Exec.exec(cmd)(args)(Data_Maybe.Nothing.value);
                      });
                  });
              });
          };
      };
  };
  var registerOnBowerIfNecessary = function (out) {
      return function (name) {
          return function (repoUrl) {
            
              /**
             *  Run a command, sending stderr to /dev/null
             */  
              var run = Pulp_Exec.execQuietWithStderr(Node_ChildProcess.Ignore.value);
              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(run("bower")([ "info", name, "--json" ])(Data_Maybe.Nothing.value)))(function (v) {
                  if (v instanceof Data_Either.Left) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Registering your package on Bower..."))(function () {
                          return confirmRun(out)("bower")([ "register", name, repoUrl ]);
                      });
                  };
                  if (v instanceof Data_Either.Right) {
                      return Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit);
                  };
                  throw new Error("Failed pattern match at Pulp.Publish line 163, column 3 - line 170, column 3: " + [ v.constructor.name ]);
              });
          };
      };
  };

  /**
 *  TODO:
 *  * Check that the 'origin' remote matches with bower.json
 *  * Better handling for the situation where the person running 'pulp publish'
 *    doesn't actually own the repo.
 */  
  var action = (function () {
      var getVersion = Prelude[">>="](Control_Monad_Aff.bindAff)(Pulp_Git.getVersionFromGitTag)(Data_Maybe.maybe(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Internal error: No version could be extracted from the git tags" + (" in this repository. This should not have happened. Please" + " report this: https://github.com/bodil/pulp/issues/new"))))(Prelude.pure(Control_Monad_Aff.applicativeAff)));
      return function (args) {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Git.requireCleanGitWorkingTree)(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(readTokenFile)(function (v1) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude[">>="](Control_Monad_Aff.bindAff)(pscPublish)(gzip))(function (v2) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(getVersion)(function (v3) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(readBowerJson)(function (v4) {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(getBowerName(v4))(function (v5) {
                                      return Prelude.bind(Control_Monad_Aff.bindAff)(confirm("Publishing " + (v5 + (" at v" + (Data_Version_1.showVersion(v3.value1) + ". Is this ok?")))))(function () {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("noPush")(args.commandOpts))(function (v6) {
                                              return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad.unless(Control_Monad_Aff.monadAff)(v6)(Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("pushTo")(args.commandOpts))(function (v7) {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(confirmRun(v)("git")([ "push", v7, "HEAD", "refs/tags/" + v3.value0 ]))(function () {
                                                      return Prelude.bind(Control_Monad_Aff.bindAff)(getBowerRepositoryUrl(v4))(function (v8) {
                                                          return registerOnBowerIfNecessary(v)(v5)(v8);
                                                      });
                                                  });
                                              })))(function () {
                                                  return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Uploading documentation to Pursuit..."))(function () {
                                                      return Prelude.bind(Control_Monad_Aff.bindAff)(uploadPursuitDocs(v)(v1)(v2))(function () {
                                                          return Prelude.bind(Control_Monad_Aff.bindAff)(v.log("Done."))(function () {
                                                              return v.log("You can view your package's documentation at: " + pursuitUrl(v5)(v3.value1));
                                                          });
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      };
  })();
  exports["action"] = action;
})(PS["Pulp.Publish"] = PS["Pulp.Publish"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Process = PS["Node.Process"];
  var Node_Platform = PS["Node.Platform"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];        
  var shell$prime = function (out) {
      return function (cmd) {
          return function (opts) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Executing " + cmd))(function () {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Buffer.fromString(cmd)(Node_Encoding.UTF8.value)))(function (v) {
                      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.openTemp({
                          prefix: "pulp-cmd-", 
                          suffix: opts.extension
                      }))(function (v1) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdAppend(v1.fd)(v))(function () {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdClose(v1.fd))(function () {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.exec(opts.executable)(Prelude["++"](Prelude.semigroupArray)(opts.extraArgs)([ v1.path ]))(Data_Maybe.Nothing.value))(function () {
                                      return out.log("Done.");
                                  });
                              });
                          });
                      });
                  });
              });
          };
      };
  };
  var shell = function (out) {
      return function (cmd) {
          var $4 = Prelude["=="](Node_Platform.eqPlatform)(Node_Process.platform)(Node_Platform.Win32.value);
          if ($4) {
              return shell$prime(out)(cmd)({
                  extension: ".cmd", 
                  executable: "cmd", 
                  extraArgs: [ "/s", "/c" ]
              });
          };
          if (!$4) {
              return shell$prime(out)(cmd)({
                  extension: ".sh", 
                  executable: "sh", 
                  extraArgs: [  ]
              });
          };
          throw new Error("Failed pattern match at Pulp.Shell line 20, column 3 - line 32, column 1: " + [ $4.constructor.name ]);
      };
  };
  exports["shell"] = shell;
})(PS["Pulp.Shell"] = PS["Pulp.Shell"] || {});
(function(exports) {
  // Generated by psc version 0.8.5.0
  "use strict";
  var $foreign = PS["Main"];
  var Prelude = PS["Prelude"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_Map = PS["Data.Map"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Array = PS["Data.Array"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List = PS["Data.List"];
  var Data_Version = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS_Sync = PS["Node.FS.Sync"];
  var Node_Path = PS["Node.Path"];
  var Node_Process = PS["Node.Process"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Args_Help = PS["Pulp.Args.Help"];
  var Pulp_Args_Types = PS["Pulp.Args.Types"];
  var Pulp_Args_Parser = PS["Pulp.Args.Parser"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Validate = PS["Pulp.Validate"];
  var Pulp_Version = PS["Pulp.Version"];
  var Pulp_Project = PS["Pulp.Project"];
  var Pulp_Init = PS["Pulp.Init"];
  var Pulp_Bower = PS["Pulp.Bower"];
  var Pulp_Build = PS["Pulp.Build"];
  var Pulp_Run = PS["Pulp.Run"];
  var Pulp_Test = PS["Pulp.Test"];
  var Pulp_Browserify = PS["Pulp.Browserify"];
  var Pulp_Docs = PS["Pulp.Docs"];
  var Pulp_Psci = PS["Pulp.Psci"];
  var Pulp_Server = PS["Pulp.Server"];
  var Pulp_Login = PS["Pulp.Login"];
  var Pulp_BumpVersion = PS["Pulp.BumpVersion"];
  var Pulp_Publish = PS["Pulp.Publish"];
  var Pulp_Watch = PS["Pulp.Watch"];
  var Pulp_Shell = PS["Pulp.Shell"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];        
  var succeeded = Prelude["const"](Prelude.pure(Control_Monad_Eff.applicativeEff)(Prelude.unit));
  var requireNodeAtLeast = function (minimum) {
      var stripV = function (str) {
          return Data_Maybe.fromMaybe(str)(Data_String.stripPrefix("v")(str));
      };
      var $11 = Data_Version.parseVersion(stripV(Node_Process.version));
      if ($11 instanceof Data_Either.Left) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Failed to parse node.js version: " + $11.value0.value0.message));
      };
      if ($11 instanceof Data_Either.Right) {
          return Control_Monad.when(Control_Monad_Aff.monadAff)(Prelude["<"](Data_Version.ordVersion)($11.value0)(minimum))(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Your node.js version is too old " + ("(required: " + (Data_Version.showVersion(minimum) + (", actual: " + (Data_Version.showVersion($11.value0) + ")")))))));
      };
      throw new Error("Failed pattern match at Main line 290, column 3 - line 300, column 3: " + [ $11.constructor.name ]);
  };
  var remainderToTest = new Data_Maybe.Just("Passthrough options are sent to the test program. " + "This can be useful for only running one particular test, for instance.");
  var remainderToPsci = new Data_Maybe.Just("Passthrough options are sent to `psci`.");
  var remainderToPscDocs = new Data_Maybe.Just("Passthrough options are sent to `psc-docs`.");
  var remainderToPsc = new Data_Maybe.Just("Passthrough options are sent to `psc`.");
  var remainderToProgram = new Data_Maybe.Just("Passthrough options are sent to your program.");
  var remainderToBundle = new Data_Maybe.Just("Passthrough options are sent to `psc-bundle`.");

  /**
 *  TODO: This is possibly just a temporary separation from buildArgs; at the
 *        moment, the browserify action doesn't support this option, but it's
 *        definitely in the realm of possibility.
 */  
  var moduleArgs = [ Pulp_Args.option("modules")([ "--modules" ])(Pulp_Args_Types.string)("Additional modules to be included in the output bundle (comma-separated list).") ];
  var globals = [ Pulp_Args.option("bowerFile")([ "--bower-file", "-b" ])(Pulp_Args_Types.file)("Read this bower.json file instead of autodetecting it."), Pulp_Args.option("watch")([ "--watch", "-w" ])(Pulp_Args_Types.flag)("Watch source directories and re-run command if something changes."), Pulp_Args.option("monochrome")([ "--monochrome" ])(Pulp_Args_Types.flag)("Don't colourise log output."), Pulp_Args.option("before")([ "--before" ])(Pulp_Args_Types.string)("Run a shell command before the operation begins. Useful with `--watch`, eg. `--watch --before clear`."), Pulp_Args.option("then")([ "--then" ])(Pulp_Args_Types.string)("Run a shell command after the operation finishes successfully. Useful with `--watch`, eg. `--watch --then 'say Done'`"), Pulp_Args.option("else")([ "--else" ])(Pulp_Args_Types.string)("Run a shell command if an operation finishes. Useful with `--watch`, eg. `--watch --then 'say Done' --else 'say Failed'`"), Pulp_Args.option("version")([ "--version", "-v" ])(Pulp_Args_Types.flag)("Show current pulp version.") ];
  var runArgs = function (args) {
    
      /**
     *  This is really quite gross, especially with _project. Not sure exactly
     *  how to go about improving this.
     */  
      var runShellForOption = function (option) {
          return function (opts) {
              return function (out) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)(option)(opts))(function (v) {
                      if (v instanceof Data_Maybe.Just) {
                          return Pulp_Shell.shell(out)(v.value0);
                      };
                      if (v instanceof Data_Maybe.Nothing) {
                          return Prelude.pure(Control_Monad_Aff.applicativeAff)(Prelude.unit);
                      };
                      throw new Error("Failed pattern match at Main line 284, column 5 - line 288, column 1: " + [ v.constructor.name ]);
                  });
              };
          };
      };
      var noProject = [ "init", "login" ];
      var addProject = function (args1) {
          var $19 = Data_Foldable.elem(Data_Foldable.foldableArray)(Prelude.eqString)(args1.command.name)(noProject);
          if ($19) {
              return Prelude["return"](Control_Monad_Aff.applicativeAff)(args1);
          };
          if (!$19) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Project.getProject(args1.globalOpts))(function (v) {
                  var globalOpts$prime = Data_Map.insert(Prelude.ordString)("_project")(new Data_Maybe.Just(Data_Foreign.toForeign(v)))(args1.globalOpts);
                  return Prelude["return"](Control_Monad_Aff.applicativeAff)((function () {
                      var $21 = {};
                      for (var $22 in args1) {
                          if (args1.hasOwnProperty($22)) {
                              $21[$22] = args1[$22];
                          };
                      };
                      $21.globalOpts = globalOpts$prime;
                      return $21;
                  })());
              });
          };
          throw new Error("Failed pattern match at Main line 276, column 5 - line 282, column 3: " + [ $19.constructor.name ]);
      };
      return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          var $24 = Data_Foldable.elem(Data_Foldable.foldableArray)(Prelude.eqString)("--help")(args.remainder);
          if ($24) {
              var $25 = args.command.name === "dep";
              if ($25) {
                  return Pulp_Bower.printHelp(v);
              };
              if (!$25) {
                  return Pulp_Args_Help.printCommandHelp(v)(globals)(args.command);
              };
              throw new Error("Failed pattern match at Main line 252, column 10 - line 255, column 5: " + [ $25.constructor.name ]);
          };
          if (!$24) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Validate.validate(v))(function (v1) {
                  return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("watch")(args.globalOpts))(function (v2) {
                      if (v2) {
                          return Pulp_Args.runAction(Pulp_Watch.action)(args);
                      };
                      if (!v2) {
                          return Prelude.bind(Control_Monad_Aff.bindAff)(addProject(args))(function (v3) {
                              return Prelude.bind(Control_Monad_Aff.bindAff)(runShellForOption("before")(v3.globalOpts)(v))(function () {
                                  return Prelude.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_Args.runAction(args.command.action)(v3)))(function (v4) {
                                      if (v4 instanceof Data_Either.Left) {
                                          return Prelude.bind(Control_Monad_Aff.bindAff)(runShellForOption("else")(v3.globalOpts)(v))(function () {
                                              return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Control_Monad_Eff_Exception.throwException(v4.value0));
                                          });
                                      };
                                      if (v4 instanceof Data_Either.Right) {
                                          return runShellForOption("then")(v3.globalOpts)(v);
                                      };
                                      throw new Error("Failed pattern match at Main line 265, column 11 - line 271, column 3: " + [ v4.constructor.name ]);
                                  });
                              });
                          });
                      };
                      throw new Error("Failed pattern match at Main line 258, column 7 - line 271, column 3: " + [ v2.constructor.name ]);
                  });
              });
          };
          throw new Error("Failed pattern match at Main line 251, column 3 - line 271, column 3: " + [ $24.constructor.name ]);
      });
  };
  var failed = function (err) {
      return function __do() {
          Control_Monad_Eff_Console.error("* ERROR: " + Control_Monad_Eff_Exception.message(err))();
          return Node_Process.exit(1)();
      };
  };
  var defaultDependencyPath = (function () {
      var readFromBowerRc = function __do() {
          var v = Node_FS_Sync.readTextFile(Node_Encoding.UTF8.value)(".bowerrc")();
          var $35 = Prelude[">>="](Data_Either.bindEither)(Data_Foreign.parseJSON(v))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("directory"));
          if ($35 instanceof Data_Either.Right) {
              return $35.value0;
          };
          if ($35 instanceof Data_Either.Left) {
              return Control_Monad_Eff_Exception.throwException(Control_Monad_Eff_Exception.error(Prelude.show(Data_Foreign.showForeignError)($35.value0)))();
          };
          throw new Error("Failed pattern match at Main line 78, column 5 - line 83, column 1: " + [ $35.constructor.name ]);
      };
      return Control_Monad_Eff_Unsafe.unsafePerformEff(Control_Monad_Eff_Exception.catchException(Prelude["const"](Prelude.pure(Control_Monad_Eff.applicativeEff)("bower_components")))(readFromBowerRc));
  })();

  /**
 *  | Options for any command requiring paths
 */  
  var pathArgs = [ Pulp_Args.optionDefault("includePaths")([ "--include", "-I" ])(Pulp_Args_Types.directories)("Additional directories for PureScript source files, separated by `" + (Node_Path.delimiter + "`."))([  ]), Pulp_Args.optionDefault("srcPath")([ "--src-path" ])(Pulp_Args_Types.directory)("Directory for PureScript source files.")("src"), Pulp_Args.optionDefault("testPath")([ "--test-path" ])(Pulp_Args_Types.directory)("Directory for PureScript test files.")("test"), Pulp_Args.optionDefault("dependencyPath")([ "--dependency-path" ])(Pulp_Args_Types.directory)("Directory for PureScript dependency files.")(defaultDependencyPath) ];

  /**
 *  | Options common to 'build', 'test', and 'browserify'
 */  
  var buildishArgs = Prelude["++"](Prelude.semigroupArray)([ Pulp_Args.optionDefault("buildPath")([ "--build-path", "-o" ])(Pulp_Args_Types.string)("Path for compiler output.")("./output"), Pulp_Args.option("noPsa")([ "--no-psa" ])(Pulp_Args_Types.flag)("Do not attempt to use the psa frontend instead of psc") ])(pathArgs);
  var buildArgs = Prelude["++"](Prelude.semigroupArray)([ Pulp_Args.optionDefault("main")([ "--main", "-m" ])(Pulp_Args_Types.string)("Application's entry point.")("Main"), Pulp_Args.option("to")([ "--to", "-t" ])(Pulp_Args_Types.string)("Output file name (stdout if not specified)."), Pulp_Args.option("optimise")([ "--optimise", "-O" ])(Pulp_Args_Types.flag)("Perform dead code elimination."), Pulp_Args.option("skipEntryPoint")([ "--skip-entry-point" ])(Pulp_Args_Types.flag)("Don't add code to automatically invoke Main.") ])(buildishArgs);
  var commands = [ Pulp_Args.command("init")("Generate an example PureScript project.")(Data_Maybe.Nothing.value)(Pulp_Init.action)([ Pulp_Args.option("force")([ "--force" ])(Pulp_Args_Types.flag)("Overwrite any project found in the current directory.") ]), Pulp_Args.command("dep")("Invoke Bower for package management.")(Data_Maybe.Nothing.value)(Pulp_Bower.action)([  ]), Pulp_Args.command("build")("Build the project.")(remainderToPsc)(Pulp_Build.action)(Prelude["++"](Prelude.semigroupArray)(buildArgs)(moduleArgs)), Pulp_Args.command("test")("Run project tests.")(remainderToTest)(Pulp_Test.action)(Prelude["++"](Prelude.semigroupArray)([ Pulp_Args.optionDefault("main")([ "--main", "-m" ])(Pulp_Args_Types.string)("Test entry point.")("Test.Main"), Pulp_Args.optionDefault("runtime")([ "--runtime", "-r" ])(Pulp_Args_Types.string)("Run test script using this command instead of Node.")("node") ])(buildishArgs)), Pulp_Args.command("browserify")("Produce a deployable bundle using Browserify.")(remainderToBundle)(Pulp_Browserify.action)(Prelude["++"](Prelude.semigroupArray)([ Pulp_Args.option("transform")([ "--transform" ])(Pulp_Args_Types.string)("Apply a Browserify transform."), Pulp_Args.option("sourceMap")([ "--source-map" ])(Pulp_Args_Types.string)("Generate source maps."), Pulp_Args.option("force")([ "--force" ])(Pulp_Args_Types.flag)("Force a non-incremental build by deleting the build cache."), Pulp_Args.option("standalone")([ "--standalone" ])(Pulp_Args_Types.string)("Output a UMD bundle with the given external module name.") ])(buildArgs)), Pulp_Args.command("run")("Compile and run the project.")(remainderToProgram)(Pulp_Run.action)(Prelude["++"](Prelude.semigroupArray)([ Pulp_Args.optionDefault("runtime")([ "--runtime", "-r" ])(Pulp_Args_Types.string)("Run the program using this command instead of Node.")("node") ])(buildArgs)), Pulp_Args.command("docs")("Generate project documentation.")(remainderToPscDocs)(Pulp_Docs.action)(Prelude["++"](Prelude.semigroupArray)([ Pulp_Args.option("withTests")([ "--with-tests", "-t" ])(Pulp_Args_Types.flag)("Include tests."), Pulp_Args.option("withDependencies")([ "--with-dependencies", "-d" ])(Pulp_Args_Types.flag)("Include external dependencies.") ])(pathArgs)), Pulp_Args.command("psci")("Launch a PureScript REPL configured for the project.")(remainderToPsci)(Pulp_Psci.action)(pathArgs), Pulp_Args.command("server")("Launch a Webpack development server.")(Data_Maybe.Nothing.value)(Pulp_Server.action)(Prelude["++"](Prelude.semigroupArray)([ Pulp_Args.optionDefault("main")([ "--main", "-m" ])(Pulp_Args_Types.string)("Application's entry point.")("Main"), Pulp_Args.option("config")([ "--config", "-c" ])(Pulp_Args_Types.file)("Override the default Webpack config."), Pulp_Args.optionDefault("port")([ "--port", "-p" ])(Pulp_Args_Types["int"])("Port number to listen on.")(1337), Pulp_Args.optionDefault("host")([ "--host" ])(Pulp_Args_Types.string)("IP address to bind the server to.")("localhost"), Pulp_Args.option("noInfo")([ "--no-info" ])(Pulp_Args_Types.flag)("Display no info to the console, only warnings and errors."), Pulp_Args.option("quiet")([ "--quiet", "-q" ])(Pulp_Args_Types.flag)("Display nothing to the console when rebuilding.") ])(buildishArgs)), Pulp_Args.command("login")("Obtain and store a token for uploading packages to Pursuit.")(Data_Maybe.Nothing.value)(Pulp_Login.action)([  ]), Pulp_Args.commandWithArgs("version")("Bump and tag a new version in preparation for release.")(Data_Maybe.Nothing.value)(Pulp_BumpVersion.action)([  ])([ Pulp_Args.argument("bump")(Pulp_Args_Types.versionBump)("How to bump the version. Acceptable values: 'major', 'minor', 'patch', or any specific version. If omitted, Pulp will prompt you for a version.")(false) ]), Pulp_Args.command("publish")("Publish a previously tagged version to Bower and Pursuit.")(Data_Maybe.Nothing.value)(Pulp_Publish.action)([ Pulp_Args.optionDefault("pushTo")([ "--push-to" ])(Pulp_Args_Types.string)("The Git remote to push commits and tags to.")("origin"), Pulp_Args.option("noPush")([ "--no-push" ])(Pulp_Args_Types.flag)("Skip pushing commits or tags to any remote.") ]) ];
  var main = (function () {
      var out = Pulp_Outputter.makeOutputter(false);
      var handleParseError = function (v) {
          return function (err) {
              if (v instanceof Data_Maybe.Just) {
                  if (Data_Foldable.elem(Data_Foldable.foldableArray)(Prelude.eqString)(v.value0)([ "--version", "-v" ])) {
                      return Pulp_Version.printVersion;
                  };
                  if (Data_Foldable.elem(Data_Foldable.foldableArray)(Prelude.eqString)(v.value0)([ "--help", "-h" ])) {
                      return Pulp_Args_Help.printHelp(out)(globals)(commands);
                  };
              };
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.err("Error: " + err))(function () {
                  return Pulp_Args_Help.printHelp(out)(globals)(commands);
              });
          };
      };
      return Control_Monad_Aff.runAff(failed)(succeeded)(Prelude.bind(Control_Monad_Aff.bindAff)(requireNodeAtLeast(Data_Version.version(4)(0)(0)(Data_List.Nil.value)(Data_List.Nil.value)))(function () {
          return Prelude.bind(Control_Monad_Aff.bindAff)(Prelude["<$>"](Control_Monad_Aff.functorAff)(Data_Array.drop(2))(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.argv)))(function (v) {
              return Prelude.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Parser.parse(globals)(commands)(v))(function (v1) {
                  if (v1 instanceof Data_Either.Left) {
                      return handleParseError(Data_Array.head(v))(v1.value0.value0.message);
                  };
                  if (v1 instanceof Data_Either.Right) {
                      return runArgs(v1.value0);
                  };
                  throw new Error("Failed pattern match at Main line 230, column 3 - line 235, column 3: " + [ v1.constructor.name ]);
              });
          });
      }));
  })();
  var argsParserDiagnostics = function (opts) {
      var out = Pulp_Outputter.makeOutputter(false);
      return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Globals: " + Prelude.show(Data_Map.showMap(Prelude.showString)(Data_Maybe.showMaybe(Prelude.showString)))(Prelude.map(Data_Map.functorMap)(Prelude.map(Data_Maybe.functorMaybe)(Pulp_System_FFI.unsafeInspect))(opts.globalOpts))))(function () {
          return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Command: " + opts.command.name))(function () {
              return Prelude.bind(Control_Monad_Aff.bindAff)(out.log("Locals: " + Prelude.show(Data_Map.showMap(Prelude.showString)(Data_Maybe.showMaybe(Prelude.showString)))(Prelude.map(Data_Map.functorMap)(Prelude.map(Data_Maybe.functorMaybe)(Pulp_System_FFI.unsafeInspect))(opts.commandOpts))))(function () {
                  return out.log("Remainder: " + Prelude.show(Prelude.showArray(Prelude.showString))(opts.remainder));
              });
          });
      });
  };
  exports["argsParserDiagnostics"] = argsParserDiagnostics;
  exports["requireNodeAtLeast"] = requireNodeAtLeast;
  exports["runArgs"] = runArgs;
  exports["main"] = main;
  exports["succeeded"] = succeeded;
  exports["failed"] = failed;
  exports["commands"] = commands;
  exports["remainderToPsci"] = remainderToPsci;
  exports["remainderToPscDocs"] = remainderToPscDocs;
  exports["remainderToProgram"] = remainderToProgram;
  exports["remainderToBundle"] = remainderToBundle;
  exports["remainderToTest"] = remainderToTest;
  exports["remainderToPsc"] = remainderToPsc;
  exports["moduleArgs"] = moduleArgs;
  exports["buildArgs"] = buildArgs;
  exports["buildishArgs"] = buildishArgs;
  exports["pathArgs"] = pathArgs;
  exports["defaultDependencyPath"] = defaultDependencyPath;
  exports["globals"] = globals;
  exports["logStack"] = $foreign.logStack;
})(PS["Main"] = PS["Main"] || {});
PS["Main"].main();