/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Draw/Hatch/Tests/HatchTest00.js
// Timestamp   : 2011-08-16 14:34:21
// Description : contour, pattern HOUND, scale 0.5, angle 15°

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function HatchTest00() {
    TdbTest.call(this, 'scripts/Draw/Hatch/Tests/HatchTest00.js');
}

HatchTest00.prototype = new TdbTest();

HatchTest00.prototype.test00 = function() {
    qDebug('running HatchTest00.test00()...');
    this.setUp();
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonPress, new QPoint(39, 449), Qt.LeftButton, 1, 0);
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonRelease, new QPoint(39, 449), Qt.LeftButton, 0, 0);
    this.importFile('scripts/Draw/Hatch/Tests/data/contour.dxf');
    this.selectAll();
    this.dlgStart();
    this.dlgAppendCode('var map = new Map()');
    this.dlgAppendCode("map.put('DialogOpenedByTdb/Type', 'HatchPattern')");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/Pattern', 'HOUND')");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/Scale',  [ 0.5, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/Angle',  [ 15, 0 ] )");
    this.dlgAppendCode("WidgetFactory.restoreState(dialog, 'DialogOpenedByTdb', undefined, false, undefined, map)");
    this.dlgEnd();
    TdbTest.clickOnWidget('MainWindow::CadToolBar::MainToolsPanel::HatchButton');
    this.verifyDrawing('HatchTest00_000.dxf');
    this.tearDown();
    qDebug('finished HatchTest00.test00()');
};

