/*
 * This declarations of the PIC16F753 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:22:59 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F753_H__
#define __PIC16F753_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTC_ADDR              0x0007
#define IOCAF_ADDR              0x0008
#define IOCCF_ADDR              0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define PIR2_ADDR               0x000D
#define TMR1_ADDR               0x000F
#define TMR1L_ADDR              0x000F
#define TMR1H_ADDR              0x0010
#define T1CON_ADDR              0x0011
#define T1GCON_ADDR             0x0012
#define CCPR1_ADDR              0x0013
#define CCPR1L_ADDR             0x0013
#define CCPR1H_ADDR             0x0014
#define CCP1CON_ADDR            0x0015
#define ADRES_ADDR              0x001C
#define ADRESL_ADDR             0x001C
#define ADRESH_ADDR             0x001D
#define ADCON0_ADDR             0x001E
#define ADCON1_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISC_ADDR              0x0087
#define IOCAP_ADDR              0x0088
#define IOCCP_ADDR              0x0089
#define PIE1_ADDR               0x008C
#define PIE2_ADDR               0x008D
#define OSCCON_ADDR             0x008F
#define FVR1CON0_ADDR           0x0090
#define DAC1CON0_ADDR           0x0091
#define DAC1REFL_ADDR           0x0092
#define DAC1REFH_ADDR           0x0093
#define OPA1CON_ADDR            0x0096
#define OPA1CON0_ADDR           0x0096
#define C2CON0_ADDR             0x009B
#define CM2CON0_ADDR            0x009B
#define C2CON1_ADDR             0x009C
#define CM2CON1_ADDR            0x009C
#define C1CON0_ADDR             0x009D
#define CM1CON0_ADDR            0x009D
#define C1CON1_ADDR             0x009E
#define CM1CON1_ADDR            0x009E
#define CMOUT_ADDR              0x009F
#define MCOUT_ADDR              0x009F
#define LATA_ADDR               0x0105
#define LATC_ADDR               0x0107
#define IOCAN_ADDR              0x0108
#define IOCCN_ADDR              0x0109
#define WPUA_ADDR               0x010C
#define WPUC_ADDR               0x010D
#define SLRCONC_ADDR            0x010E
#define PCON_ADDR               0x010F
#define TMR2_ADDR               0x0110
#define PR2_ADDR                0x0111
#define T2CON_ADDR              0x0112
#define HLTMR1_ADDR             0x0113
#define HLTPR1_ADDR             0x0114
#define HLT1CON0_ADDR           0x0115
#define HLT1CON1_ADDR           0x0116
#define HLTMR2_ADDR             0x0117
#define HLTPR2_ADDR             0x0118
#define HLT2CON0_ADDR           0x0119
#define HLT2CON1_ADDR           0x011A
#define SLPC1CON0_ADDR          0x011E
#define SLPCCON0_ADDR           0x011E
#define SLPC1CON1_ADDR          0x011F
#define SLPCCON1_ADDR           0x011F
#define ANSELA_ADDR             0x0185
#define ANSELC_ADDR             0x0187
#define APFCON_ADDR             0x0188
#define OSCTUNE_ADDR            0x0189
#define PMCON1_ADDR             0x018C
#define PMCON2_ADDR             0x018D
#define PMADR_ADDR              0x018E
#define PMADRL_ADDR             0x018E
#define PMADRH_ADDR             0x018F
#define PMDAT_ADDR              0x0190
#define PMDATL_ADDR             0x0190
#define PMDATH_ADDR             0x0191
#define COG1PHR_ADDR            0x0192
#define COG1PHF_ADDR            0x0193
#define COG1BKR_ADDR            0x0194
#define COG1BKF_ADDR            0x0195
#define COG1DBR_ADDR            0x0196
#define COG1DBF_ADDR            0x0197
#define COG1CON0_ADDR           0x0198
#define COG1CON1_ADDR           0x0199
#define COG1RIS_ADDR            0x019A
#define COG1RSIM_ADDR           0x019B
#define COG1FIS_ADDR            0x019C
#define COG1FSIM_ADDR           0x019D
#define COG1ASD0_ADDR           0x019E
#define COG1ASD1_ADDR           0x019F

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC                 : 6;
    unsigned                    : 2;
    };
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0008) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0008) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0009) __sfr IOCCF;

typedef union
  {
  struct
    {
    unsigned IOCCF0             : 1;
    unsigned IOCCF1             : 1;
    unsigned IOCCF2             : 1;
    unsigned IOCCF3             : 1;
    unsigned IOCCF4             : 1;
    unsigned IOCCF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCF              : 6;
    unsigned                    : 2;
    };
  } __IOCCFbits_t;

extern __at(0x0009) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef struct
  {
  unsigned IOCIF                : 1;
  unsigned INTF                 : 1;
  unsigned T0IF                 : 1;
  unsigned IOCIE                : 1;
  unsigned INTE                 : 1;
  unsigned T0IE                 : 1;
  unsigned PEIE                 : 1;
  unsigned GIE                  : 1;
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned HLTMR1IF             : 1;
  unsigned HLTMR2IF             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _HLTMR1IF               0x04
#define _HLTMR2IF               0x08
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x000D) __sfr PIR2;

typedef struct
  {
  unsigned CCP1IF               : 1;
  unsigned                      : 1;
  unsigned COG1IF               : 1;
  unsigned                      : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x000D) volatile __PIR2bits_t PIR2bits;

#define _CCP1IF                 0x01
#define _COG1IF                 0x04
#define _C1IF                   0x10
#define _C2IF                   0x20

//==============================================================================

extern __at(0x000F) __sfr TMR1;
extern __at(0x000F) __sfr TMR1L;
extern __at(0x0010) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0011) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned                    : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0011) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0012) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0012) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GGO                  0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x0013) __sfr CCPR1;
extern __at(0x0013) __sfr CCPR1L;
extern __at(0x0014) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0015) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0015) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20

//==============================================================================

extern __at(0x001C) __sfr ADRES;
extern __at(0x001C) __sfr ADRESL;
extern __at(0x001D) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001E) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001E) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x001F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x001F) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF1                0x01
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RAPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RAPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISC              : 6;
    unsigned                    : 2;
    };
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0088) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0088) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0089) __sfr IOCCP;

typedef union
  {
  struct
    {
    unsigned IOCCP0             : 1;
    unsigned IOCCP1             : 1;
    unsigned IOCCP2             : 1;
    unsigned IOCCP3             : 1;
    unsigned IOCCP4             : 1;
    unsigned IOCCP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCP              : 6;
    unsigned                    : 2;
    };
  } __IOCCPbits_t;

extern __at(0x0089) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned HLTMR1IE             : 1;
  unsigned HLTMR2IE             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _HLTMR1IE               0x04
#define _HLTMR2IE               0x08
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x008D) __sfr PIE2;

typedef struct
  {
  unsigned CCP1IE               : 1;
  unsigned                      : 1;
  unsigned COG1IE               : 1;
  unsigned                      : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x008D) volatile __PIE2bits_t PIE2bits;

#define _CCP1IE                 0x01
#define _COG1IE                 0x04
#define _C1IE                   0x10
#define _C2IE                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x008F) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned LTS                : 1;
    unsigned HTS                : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 2;
    unsigned                    : 2;
    };
  } __OSCCONbits_t;

extern __at(0x008F) volatile __OSCCONbits_t OSCCONbits;

#define _LTS                    0x02
#define _HTS                    0x04
#define _IRCF0                  0x10
#define _IRCF1                  0x20

//==============================================================================


//==============================================================================
//        FVR1CON0 Bits

extern __at(0x0090) __sfr FVR1CON0;

typedef union
  {
  struct
    {
    unsigned FVRBUFEN           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVRBUSS0           : 1;
    unsigned FVRBUSS1           : 1;
    unsigned FVROE              : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned FVRBUSS            : 2;
    unsigned                    : 3;
    };
  } __FVR1CON0bits_t;

extern __at(0x0090) volatile __FVR1CON0bits_t FVR1CON0bits;

#define _FVRBUFEN               0x01
#define _FVRBUSS0               0x08
#define _FVRBUSS1               0x10
#define _FVROE                  0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DAC1CON0 Bits

extern __at(0x0091) __sfr DAC1CON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACFM              : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __DAC1CON0bits_t;

extern __at(0x0091) volatile __DAC1CON0bits_t DAC1CON0bits;

#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE                  0x20
#define _DACFM                  0x40
#define _DACEN                  0x80

//==============================================================================

extern __at(0x0092) __sfr DAC1REFL;
extern __at(0x0093) __sfr DAC1REFH;

//==============================================================================
//        OPA1CON Bits

extern __at(0x0096) __sfr OPA1CON;

typedef union
  {
  struct
    {
    unsigned OPA1PCH0           : 1;
    unsigned OPA1PCH1           : 1;
    unsigned OPA1NCH0           : 1;
    unsigned OPA1NCH1           : 1;
    unsigned OPAUGM             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPAEN              : 1;
    };

  struct
    {
    unsigned OPA1PCH            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned OPA1NCH            : 2;
    unsigned                    : 4;
    };
  } __OPA1CONbits_t;

extern __at(0x0096) volatile __OPA1CONbits_t OPA1CONbits;

#define _OPA1PCH0               0x01
#define _OPA1PCH1               0x02
#define _OPA1NCH0               0x04
#define _OPA1NCH1               0x08
#define _OPAUGM                 0x10
#define _OPAEN                  0x80

//==============================================================================


//==============================================================================
//        OPA1CON0 Bits

extern __at(0x0096) __sfr OPA1CON0;

typedef union
  {
  struct
    {
    unsigned OPA1PCH0           : 1;
    unsigned OPA1PCH1           : 1;
    unsigned OPA1NCH0           : 1;
    unsigned OPA1NCH1           : 1;
    unsigned OPAUGM             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPAEN              : 1;
    };

  struct
    {
    unsigned OPA1PCH            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned OPA1NCH            : 2;
    unsigned                    : 4;
    };
  } __OPA1CON0bits_t;

extern __at(0x0096) volatile __OPA1CON0bits_t OPA1CON0bits;

#define _OPA1CON0_OPA1PCH0      0x01
#define _OPA1CON0_OPA1PCH1      0x02
#define _OPA1CON0_OPA1NCH0      0x04
#define _OPA1CON0_OPA1NCH1      0x08
#define _OPA1CON0_OPAUGM        0x10
#define _OPA1CON0_OPAEN         0x80

//==============================================================================


//==============================================================================
//        C2CON0 Bits

extern __at(0x009B) __sfr C2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned C2ZLF                : 1;
  unsigned C2POL                : 1;
  unsigned C2OE                 : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __C2CON0bits_t;

extern __at(0x009B) volatile __C2CON0bits_t C2CON0bits;

#define _C2SYNC                 0x01
#define _C2HYS                  0x02
#define _C2SP                   0x04
#define _C2ZLF                  0x08
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x009B) __sfr CM2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned C2ZLF                : 1;
  unsigned C2POL                : 1;
  unsigned C2OE                 : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __CM2CON0bits_t;

extern __at(0x009B) volatile __CM2CON0bits_t CM2CON0bits;

#define _CM2CON0_C2SYNC         0x01
#define _CM2CON0_C2HYS          0x02
#define _CM2CON0_C2SP           0x04
#define _CM2CON0_C2ZLF          0x08
#define _CM2CON0_C2POL          0x10
#define _CM2CON0_C2OE           0x20
#define _CM2CON0_C2OUT          0x40
#define _CM2CON0_C2ON           0x80

//==============================================================================


//==============================================================================
//        C2CON1 Bits

extern __at(0x009C) __sfr C2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C2PCH              : 3;
    unsigned                    : 2;
    };
  } __C2CON1bits_t;

extern __at(0x009C) volatile __C2CON1bits_t C2CON1bits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2NCH2                 0x04
#define _C2PCH0                 0x08
#define _C2PCH1                 0x10
#define _C2PCH2                 0x20
#define _C2INTN                 0x40
#define _C2INTP                 0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x009C) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C2PCH              : 3;
    unsigned                    : 2;
    };
  } __CM2CON1bits_t;

extern __at(0x009C) volatile __CM2CON1bits_t CM2CON1bits;

#define _CM2CON1_C2NCH0         0x01
#define _CM2CON1_C2NCH1         0x02
#define _CM2CON1_C2NCH2         0x04
#define _CM2CON1_C2PCH0         0x08
#define _CM2CON1_C2PCH1         0x10
#define _CM2CON1_C2PCH2         0x20
#define _CM2CON1_C2INTN         0x40
#define _CM2CON1_C2INTP         0x80

//==============================================================================


//==============================================================================
//        C1CON0 Bits

extern __at(0x009D) __sfr C1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned C1ZLF                : 1;
  unsigned C1POL                : 1;
  unsigned C1OE                 : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __C1CON0bits_t;

extern __at(0x009D) volatile __C1CON0bits_t C1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1ZLF                  0x08
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x009D) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned C1ZLF                : 1;
  unsigned C1POL                : 1;
  unsigned C1OE                 : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x009D) volatile __CM1CON0bits_t CM1CON0bits;

#define _CM1CON0_C1SYNC         0x01
#define _CM1CON0_C1HYS          0x02
#define _CM1CON0_C1SP           0x04
#define _CM1CON0_C1ZLF          0x08
#define _CM1CON0_C1POL          0x10
#define _CM1CON0_C1OE           0x20
#define _CM1CON0_C1OUT          0x40
#define _CM1CON0_C1ON           0x80

//==============================================================================


//==============================================================================
//        C1CON1 Bits

extern __at(0x009E) __sfr C1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C1PCH              : 3;
    unsigned                    : 2;
    };
  } __C1CON1bits_t;

extern __at(0x009E) volatile __C1CON1bits_t C1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1PCH0                 0x08
#define _C1PCH1                 0x10
#define _C1PCH2                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x009E) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C1PCH              : 3;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x009E) volatile __CM1CON1bits_t CM1CON1bits;

#define _CM1CON1_C1NCH0         0x01
#define _CM1CON1_C1NCH1         0x02
#define _CM1CON1_C1NCH2         0x04
#define _CM1CON1_C1PCH0         0x08
#define _CM1CON1_C1PCH1         0x10
#define _CM1CON1_C1PCH2         0x20
#define _CM1CON1_C1INTN         0x40
#define _CM1CON1_C1INTP         0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x009F) __sfr CMOUT;

typedef struct
  {
  unsigned MCOUT1               : 1;
  unsigned MCOUT2               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x009F) volatile __CMOUTbits_t CMOUTbits;

#define _MCOUT1                 0x01
#define _MCOUT2                 0x02

//==============================================================================


//==============================================================================
//        MCOUT Bits

extern __at(0x009F) __sfr MCOUT;

typedef struct
  {
  unsigned MCOUT1               : 1;
  unsigned MCOUT2               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __MCOUTbits_t;

extern __at(0x009F) volatile __MCOUTbits_t MCOUTbits;

#define _MCOUT_MCOUT1           0x01
#define _MCOUT_MCOUT2           0x02

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0105) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x0105) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0107) __sfr LATC;

typedef union
  {
  struct
    {
    unsigned LATC0              : 1;
    unsigned LATC1              : 1;
    unsigned LATC2              : 1;
    unsigned LATC3              : 1;
    unsigned LATC4              : 1;
    unsigned LATC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATC               : 6;
    unsigned                    : 2;
    };
  } __LATCbits_t;

extern __at(0x0107) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0108) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0108) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0109) __sfr IOCCN;

typedef union
  {
  struct
    {
    unsigned IOCCN0             : 1;
    unsigned IOCCN1             : 1;
    unsigned IOCCN2             : 1;
    unsigned IOCCN3             : 1;
    unsigned IOCCN4             : 1;
    unsigned IOCCN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCN              : 6;
    unsigned                    : 2;
    };
  } __IOCCNbits_t;

extern __at(0x0109) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x010C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x010C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x010D) __sfr WPUC;

typedef union
  {
  struct
    {
    unsigned WPUC0              : 1;
    unsigned WPUC1              : 1;
    unsigned WPUC2              : 1;
    unsigned WPUC3              : 1;
    unsigned WPUC4              : 1;
    unsigned WPUC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUC               : 6;
    unsigned                    : 2;
    };
  } __WPUCbits_t;

extern __at(0x010D) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x010E) __sfr SLRCONC;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SLRC4                : 1;
  unsigned SLRC5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONCbits_t;

extern __at(0x010E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC4                  0x10
#define _SLRC5                  0x20

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x010F) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PCONbits_t;

extern __at(0x010F) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02

//==============================================================================

extern __at(0x0110) __sfr TMR2;
extern __at(0x0111) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0112) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0112) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0113) __sfr HLTMR1;
extern __at(0x0114) __sfr HLTPR1;

//==============================================================================
//        HLT1CON0 Bits

extern __at(0x0115) __sfr HLT1CON0;

typedef union
  {
  struct
    {
    unsigned H1CKPS0            : 1;
    unsigned H1CKPS1            : 1;
    unsigned H1ON               : 1;
    unsigned H1OUTPS0           : 1;
    unsigned H1OUTPS1           : 1;
    unsigned H1OUTPS2           : 1;
    unsigned H1OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned H1CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned H1OUTPS            : 4;
    unsigned                    : 1;
    };
  } __HLT1CON0bits_t;

extern __at(0x0115) volatile __HLT1CON0bits_t HLT1CON0bits;

#define _H1CKPS0                0x01
#define _H1CKPS1                0x02
#define _H1ON                   0x04
#define _H1OUTPS0               0x08
#define _H1OUTPS1               0x10
#define _H1OUTPS2               0x20
#define _H1OUTPS3               0x40

//==============================================================================


//==============================================================================
//        HLT1CON1 Bits

extern __at(0x0116) __sfr HLT1CON1;

typedef union
  {
  struct
    {
    unsigned H1REREN            : 1;
    unsigned H1FEREN            : 1;
    unsigned H1ERS0             : 1;
    unsigned H1ERS1             : 1;
    unsigned H1ERS2             : 1;
    unsigned                    : 1;
    unsigned H1RES              : 1;
    unsigned H1FES              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned H1ERS              : 3;
    unsigned                    : 3;
    };
  } __HLT1CON1bits_t;

extern __at(0x0116) volatile __HLT1CON1bits_t HLT1CON1bits;

#define _H1REREN                0x01
#define _H1FEREN                0x02
#define _H1ERS0                 0x04
#define _H1ERS1                 0x08
#define _H1ERS2                 0x10
#define _H1RES                  0x40
#define _H1FES                  0x80

//==============================================================================

extern __at(0x0117) __sfr HLTMR2;
extern __at(0x0118) __sfr HLTPR2;

//==============================================================================
//        HLT2CON0 Bits

extern __at(0x0119) __sfr HLT2CON0;

typedef union
  {
  struct
    {
    unsigned H2CKPS0            : 1;
    unsigned H2CKPS1            : 1;
    unsigned H2ON               : 1;
    unsigned H2OUTPS0           : 1;
    unsigned H2OUTPS1           : 1;
    unsigned H2OUTPS2           : 1;
    unsigned H2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned H2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned H2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __HLT2CON0bits_t;

extern __at(0x0119) volatile __HLT2CON0bits_t HLT2CON0bits;

#define _H2CKPS0                0x01
#define _H2CKPS1                0x02
#define _H2ON                   0x04
#define _H2OUTPS0               0x08
#define _H2OUTPS1               0x10
#define _H2OUTPS2               0x20
#define _H2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        HLT2CON1 Bits

extern __at(0x011A) __sfr HLT2CON1;

typedef union
  {
  struct
    {
    unsigned H2REREN            : 1;
    unsigned H2FEREN            : 1;
    unsigned H2ERS0             : 1;
    unsigned H2ERS1             : 1;
    unsigned H2ERS2             : 1;
    unsigned                    : 1;
    unsigned H2RES              : 1;
    unsigned H2FES              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned H2ERS              : 3;
    unsigned                    : 3;
    };
  } __HLT2CON1bits_t;

extern __at(0x011A) volatile __HLT2CON1bits_t HLT2CON1bits;

#define _H2REREN                0x01
#define _H2FEREN                0x02
#define _H2ERS0                 0x04
#define _H2ERS1                 0x08
#define _H2ERS2                 0x10
#define _H2RES                  0x40
#define _H2FES                  0x80

//==============================================================================


//==============================================================================
//        SLPC1CON0 Bits

extern __at(0x011E) __sfr SLPC1CON0;

typedef union
  {
  struct
    {
    unsigned SC1INS             : 1;
    unsigned                    : 1;
    unsigned SCS1TSS0           : 1;
    unsigned SCS1TSS1           : 1;
    unsigned SC1POL             : 1;
    unsigned SC1MRPE            : 1;
    unsigned                    : 1;
    unsigned SC1EN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned SCS1TSS            : 2;
    unsigned                    : 4;
    };
  } __SLPC1CON0bits_t;

extern __at(0x011E) volatile __SLPC1CON0bits_t SLPC1CON0bits;

#define _SC1INS                 0x01
#define _SCS1TSS0               0x04
#define _SCS1TSS1               0x08
#define _SC1POL                 0x10
#define _SC1MRPE                0x20
#define _SC1EN                  0x80

//==============================================================================


//==============================================================================
//        SLPCCON0 Bits

extern __at(0x011E) __sfr SLPCCON0;

typedef union
  {
  struct
    {
    unsigned SC1INS             : 1;
    unsigned                    : 1;
    unsigned SCS1TSS0           : 1;
    unsigned SCS1TSS1           : 1;
    unsigned SC1POL             : 1;
    unsigned SC1MRPE            : 1;
    unsigned                    : 1;
    unsigned SC1EN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned SCS1TSS            : 2;
    unsigned                    : 4;
    };
  } __SLPCCON0bits_t;

extern __at(0x011E) volatile __SLPCCON0bits_t SLPCCON0bits;

#define _SLPCCON0_SC1INS        0x01
#define _SLPCCON0_SCS1TSS0      0x04
#define _SLPCCON0_SCS1TSS1      0x08
#define _SLPCCON0_SC1POL        0x10
#define _SLPCCON0_SC1MRPE       0x20
#define _SLPCCON0_SC1EN         0x80

//==============================================================================


//==============================================================================
//        SLPC1CON1 Bits

extern __at(0x011F) __sfr SLPC1CON1;

typedef union
  {
  struct
    {
    unsigned SC1ISET0           : 1;
    unsigned SC1ISET1           : 1;
    unsigned SC1ISET2           : 1;
    unsigned SC1ISET3           : 1;
    unsigned SC1RNG             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SC1ISET            : 4;
    unsigned                    : 4;
    };
  } __SLPC1CON1bits_t;

extern __at(0x011F) volatile __SLPC1CON1bits_t SLPC1CON1bits;

#define _SC1ISET0               0x01
#define _SC1ISET1               0x02
#define _SC1ISET2               0x04
#define _SC1ISET3               0x08
#define _SC1RNG                 0x10

//==============================================================================


//==============================================================================
//        SLPCCON1 Bits

extern __at(0x011F) __sfr SLPCCON1;

typedef union
  {
  struct
    {
    unsigned SC1ISET0           : 1;
    unsigned SC1ISET1           : 1;
    unsigned SC1ISET2           : 1;
    unsigned SC1ISET3           : 1;
    unsigned SC1RNG             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SC1ISET            : 4;
    unsigned                    : 4;
    };
  } __SLPCCON1bits_t;

extern __at(0x011F) volatile __SLPCCON1bits_t SLPCCON1bits;

#define _SLPCCON1_SC1ISET0      0x01
#define _SLPCCON1_SC1ISET1      0x02
#define _SLPCCON1_SC1ISET2      0x04
#define _SLPCCON1_SC1ISET3      0x08
#define _SLPCCON1_SC1RNG        0x10

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x0185) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x0185) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x0187) __sfr ANSELC;

typedef union
  {
  struct
    {
    unsigned ANSC0              : 1;
    unsigned ANSC1              : 1;
    unsigned ANSC2              : 1;
    unsigned ANSC3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSC               : 4;
    unsigned                    : 4;
    };
  } __ANSELCbits_t;

extern __at(0x0187) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x0188) __sfr APFCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned T1GSEL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __APFCONbits_t;

extern __at(0x0188) volatile __APFCONbits_t APFCONbits;

#define _T1GSEL                 0x10

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0189) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 5;
    unsigned                    : 3;
    };
  } __OSCTUNEbits_t;

extern __at(0x0189) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10

//==============================================================================


//==============================================================================
//        PMCON1 Bits

extern __at(0x018C) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x018C) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04

//==============================================================================

extern __at(0x018D) __sfr PMCON2;
extern __at(0x018E) __sfr PMADR;
extern __at(0x018E) __sfr PMADRL;
extern __at(0x018F) __sfr PMADRH;
extern __at(0x0190) __sfr PMDAT;
extern __at(0x0190) __sfr PMDATL;
extern __at(0x0191) __sfr PMDATH;

//==============================================================================
//        COG1PHR Bits

extern __at(0x0192) __sfr COG1PHR;

typedef union
  {
  struct
    {
    unsigned G1PHR0             : 1;
    unsigned G1PHR1             : 1;
    unsigned G1PHR2             : 1;
    unsigned G1PHR3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHR              : 4;
    unsigned                    : 4;
    };
  } __COG1PHRbits_t;

extern __at(0x0192) volatile __COG1PHRbits_t COG1PHRbits;

#define _G1PHR0                 0x01
#define _G1PHR1                 0x02
#define _G1PHR2                 0x04
#define _G1PHR3                 0x08

//==============================================================================


//==============================================================================
//        COG1PHF Bits

extern __at(0x0193) __sfr COG1PHF;

typedef union
  {
  struct
    {
    unsigned G1PHF0             : 1;
    unsigned G1PHF1             : 1;
    unsigned G1PHF2             : 1;
    unsigned G1PHF3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHF              : 4;
    unsigned                    : 4;
    };
  } __COG1PHFbits_t;

extern __at(0x0193) volatile __COG1PHFbits_t COG1PHFbits;

#define _G1PHF0                 0x01
#define _G1PHF1                 0x02
#define _G1PHF2                 0x04
#define _G1PHF3                 0x08

//==============================================================================


//==============================================================================
//        COG1BKR Bits

extern __at(0x0194) __sfr COG1BKR;

typedef union
  {
  struct
    {
    unsigned G1BKR0             : 1;
    unsigned G1BKR1             : 1;
    unsigned G1BKR2             : 1;
    unsigned G1BKR3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BKR              : 4;
    unsigned                    : 4;
    };
  } __COG1BKRbits_t;

extern __at(0x0194) volatile __COG1BKRbits_t COG1BKRbits;

#define _G1BKR0                 0x01
#define _G1BKR1                 0x02
#define _G1BKR2                 0x04
#define _G1BKR3                 0x08

//==============================================================================


//==============================================================================
//        COG1BKF Bits

extern __at(0x0195) __sfr COG1BKF;

typedef union
  {
  struct
    {
    unsigned G1BKF0             : 1;
    unsigned G1BKF1             : 1;
    unsigned G1BKF2             : 1;
    unsigned G1BKF3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BKF              : 4;
    unsigned                    : 4;
    };
  } __COG1BKFbits_t;

extern __at(0x0195) volatile __COG1BKFbits_t COG1BKFbits;

#define _G1BKF0                 0x01
#define _G1BKF1                 0x02
#define _G1BKF2                 0x04
#define _G1BKF3                 0x08

//==============================================================================


//==============================================================================
//        COG1DBR Bits

extern __at(0x0196) __sfr COG1DBR;

typedef union
  {
  struct
    {
    unsigned G1DBR0             : 1;
    unsigned G1DBR1             : 1;
    unsigned G1DBR2             : 1;
    unsigned G1DBR3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBR              : 4;
    unsigned                    : 4;
    };
  } __COG1DBRbits_t;

extern __at(0x0196) volatile __COG1DBRbits_t COG1DBRbits;

#define _G1DBR0                 0x01
#define _G1DBR1                 0x02
#define _G1DBR2                 0x04
#define _G1DBR3                 0x08

//==============================================================================


//==============================================================================
//        COG1DBF Bits

extern __at(0x0197) __sfr COG1DBF;

typedef union
  {
  struct
    {
    unsigned G1DBF0             : 1;
    unsigned G1DBF1             : 1;
    unsigned G1DBF2             : 1;
    unsigned G1DBF3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBF              : 4;
    unsigned                    : 4;
    };
  } __COG1DBFbits_t;

extern __at(0x0197) volatile __COG1DBFbits_t COG1DBFbits;

#define _G1DBF0                 0x01
#define _G1DBF1                 0x02
#define _G1DBF2                 0x04
#define _G1DBF3                 0x08

//==============================================================================


//==============================================================================
//        COG1CON0 Bits

extern __at(0x0198) __sfr COG1CON0;

typedef union
  {
  struct
    {
    unsigned G1MD               : 1;
    unsigned                    : 1;
    unsigned G1LD               : 1;
    unsigned G1POL0             : 1;
    unsigned G1POL1             : 1;
    unsigned G1OE0              : 1;
    unsigned G1OE1              : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned G1POL              : 2;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 5;
    unsigned G1OE               : 2;
    unsigned                    : 1;
    };
  } __COG1CON0bits_t;

extern __at(0x0198) volatile __COG1CON0bits_t COG1CON0bits;

#define _G1MD                   0x01
#define _G1LD                   0x04
#define _G1POL0                 0x08
#define _G1POL1                 0x10
#define _G1OE0                  0x20
#define _G1OE1                  0x40
#define _G1EN                   0x80

//==============================================================================


//==============================================================================
//        COG1CON1 Bits

extern __at(0x0199) __sfr COG1CON1;

typedef union
  {
  struct
    {
    unsigned G1CS0              : 1;
    unsigned G1CS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1FDBTS            : 1;
    unsigned G1RDBTS            : 1;
    };

  struct
    {
    unsigned G1CS               : 2;
    unsigned                    : 6;
    };
  } __COG1CON1bits_t;

extern __at(0x0199) volatile __COG1CON1bits_t COG1CON1bits;

#define _G1CS0                  0x01
#define _G1CS1                  0x02
#define _G1FDBTS                0x40
#define _G1RDBTS                0x80

//==============================================================================


//==============================================================================
//        COG1RIS Bits

extern __at(0x019A) __sfr COG1RIS;

typedef struct
  {
  unsigned G1RIC1               : 1;
  unsigned G1RIC2               : 1;
  unsigned C1RICCP1             : 1;
  unsigned G1RIFLT              : 1;
  unsigned G1RIT2M              : 1;
  unsigned G1R1HLT1             : 1;
  unsigned G1RIHLT2             : 1;
  unsigned                      : 1;
  } __COG1RISbits_t;

extern __at(0x019A) volatile __COG1RISbits_t COG1RISbits;

#define _G1RIC1                 0x01
#define _G1RIC2                 0x02
#define _C1RICCP1               0x04
#define _G1RIFLT                0x08
#define _G1RIT2M                0x10
#define _G1R1HLT1               0x20
#define _G1RIHLT2               0x40

//==============================================================================


//==============================================================================
//        COG1RSIM Bits

extern __at(0x019B) __sfr COG1RSIM;

typedef struct
  {
  unsigned G1RMC1               : 1;
  unsigned G1RMC2               : 1;
  unsigned G1RMCCP1             : 1;
  unsigned G1RMFLT              : 1;
  unsigned G1RTM2M              : 1;
  unsigned G1RMHLT1             : 1;
  unsigned G1RMHLT2             : 1;
  unsigned                      : 1;
  } __COG1RSIMbits_t;

extern __at(0x019B) volatile __COG1RSIMbits_t COG1RSIMbits;

#define _G1RMC1                 0x01
#define _G1RMC2                 0x02
#define _G1RMCCP1               0x04
#define _G1RMFLT                0x08
#define _G1RTM2M                0x10
#define _G1RMHLT1               0x20
#define _G1RMHLT2               0x40

//==============================================================================


//==============================================================================
//        COG1FIS Bits

extern __at(0x019C) __sfr COG1FIS;

typedef struct
  {
  unsigned G1FIC1               : 1;
  unsigned G1FIC2               : 1;
  unsigned G1FICCP1             : 1;
  unsigned G1FIFLT              : 1;
  unsigned G1FIT2M              : 1;
  unsigned G1FIHLT1             : 1;
  unsigned G1FIHLT2             : 1;
  unsigned                      : 1;
  } __COG1FISbits_t;

extern __at(0x019C) volatile __COG1FISbits_t COG1FISbits;

#define _G1FIC1                 0x01
#define _G1FIC2                 0x02
#define _G1FICCP1               0x04
#define _G1FIFLT                0x08
#define _G1FIT2M                0x10
#define _G1FIHLT1               0x20
#define _G1FIHLT2               0x40

//==============================================================================


//==============================================================================
//        COG1FSIM Bits

extern __at(0x019D) __sfr COG1FSIM;

typedef struct
  {
  unsigned G1FMC1               : 1;
  unsigned G1FMC2               : 1;
  unsigned G1FMCCP1             : 1;
  unsigned G1FMFLT              : 1;
  unsigned G1FMT2M              : 1;
  unsigned G1FMHLT1             : 1;
  unsigned G1FMHLT2             : 1;
  unsigned                      : 1;
  } __COG1FSIMbits_t;

extern __at(0x019D) volatile __COG1FSIMbits_t COG1FSIMbits;

#define _G1FMC1                 0x01
#define _G1FMC2                 0x02
#define _G1FMCCP1               0x04
#define _G1FMFLT                0x08
#define _G1FMT2M                0x10
#define _G1FMHLT1               0x20
#define _G1FMHLT2               0x40

//==============================================================================


//==============================================================================
//        COG1ASD0 Bits

extern __at(0x019E) __sfr COG1ASD0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ASD0L0           : 1;
    unsigned G1ASD0L1           : 1;
    unsigned G1ASD1L0           : 1;
    unsigned G1ASD1L1           : 1;
    unsigned G1ARSEN            : 1;
    unsigned G1ASDE             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned G1ASD0L            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G1ASD1L            : 2;
    unsigned                    : 2;
    };
  } __COG1ASD0bits_t;

extern __at(0x019E) volatile __COG1ASD0bits_t COG1ASD0bits;

#define _G1ASD0L0               0x04
#define _G1ASD0L1               0x08
#define _G1ASD1L0               0x10
#define _G1ASD1L1               0x20
#define _G1ARSEN                0x40
#define _G1ASDE                 0x80

//==============================================================================


//==============================================================================
//        COG1ASD1 Bits

extern __at(0x019F) __sfr COG1ASD1;

typedef struct
  {
  unsigned G1ASDSFLT            : 1;
  unsigned G1ASDSC1             : 1;
  unsigned G1ASDSC2             : 1;
  unsigned G1ASDSHLT1           : 1;
  unsigned G1ASDSHLT2           : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __COG1ASD1bits_t;

extern __at(0x019F) volatile __COG1ASD1bits_t COG1ASD1bits;

#define _G1ASDSFLT              0x01
#define _G1ASDSC1               0x02
#define _G1ASDSC2               0x04
#define _G1ASDSHLT1             0x08
#define _G1ASDSHLT2             0x10

//==============================================================================


//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG                 0x2007

//----------------------------- CONFIG Options -------------------------------

#define _FOSC0_INT              0x3FFE  // Internal oscillator mode.  I/O function on RA5/CLKIN.
#define _FOSC0_EC               0x3FFF  // EC oscillator mode.  CLKIN function on RA5/CLKIN.
#define _WDTE_OFF               0x3FF7  // Watchdog Timer disabled.
#define _WDTE_ON                0x3FFF  // Watchdog Timer enabled.
#define _PWRTE_ON               0x3FEF  // Power-up Timer enabled.
#define _PWRTE_OFF              0x3FFF  // Power-up Timer disabled.
#define _MCLRE_OFF              0x3FDF  // MCLR pin is alternate function.
#define _MCLRE_ON               0x3FFF  // MCLR pin is MCLR function with internal weak pullup.
#define _CP_ON                  0x3FBF  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_DIS              0x3CFF  // BOR disabled.
#define _BOREN_SLEEP_DIS        0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOREN_EN               0x3FFF  // BOR enabled.
#define _WRT_ALL                0x33FF  // 000h to 3FFh self-write protected.
#define _WRT_HALF               0x37FF  // 000h to 1FFh self-write protected.
#define _WRT_FOURTH             0x3BFF  // 000h to 0FFh self-write protected.
#define _WRT_OFF                0x3FFF  // Flash self-write protection off.
#define _CLKOUTEN_ON            0x2FFF  // CLKOUT function enabled.  CLKOUT pin is CLKOUT.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function disabled.  CLKOUT pin acts as I/O.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define ADFM                    ADCON0bits.ADFM                 // bit 7

#define ADPREF1                 ADCON1bits.ADPREF1              // bit 0
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3

#define T1GSEL                  APFCONbits.T1GSEL               // bit 4

#define C1SYNC                  C1CON0bits.C1SYNC               // bit 0
#define C1HYS                   C1CON0bits.C1HYS                // bit 1
#define C1SP                    C1CON0bits.C1SP                 // bit 2
#define C1ZLF                   C1CON0bits.C1ZLF                // bit 3
#define C1POL                   C1CON0bits.C1POL                // bit 4
#define C1OE                    C1CON0bits.C1OE                 // bit 5
#define C1OUT                   C1CON0bits.C1OUT                // bit 6
#define C1ON                    C1CON0bits.C1ON                 // bit 7

#define C1NCH0                  C1CON1bits.C1NCH0               // bit 0
#define C1NCH1                  C1CON1bits.C1NCH1               // bit 1
#define C1NCH2                  C1CON1bits.C1NCH2               // bit 2
#define C1PCH0                  C1CON1bits.C1PCH0               // bit 3
#define C1PCH1                  C1CON1bits.C1PCH1               // bit 4
#define C1PCH2                  C1CON1bits.C1PCH2               // bit 5
#define C1INTN                  C1CON1bits.C1INTN               // bit 6
#define C1INTP                  C1CON1bits.C1INTP               // bit 7

#define C2SYNC                  C2CON0bits.C2SYNC               // bit 0
#define C2HYS                   C2CON0bits.C2HYS                // bit 1
#define C2SP                    C2CON0bits.C2SP                 // bit 2
#define C2ZLF                   C2CON0bits.C2ZLF                // bit 3
#define C2POL                   C2CON0bits.C2POL                // bit 4
#define C2OE                    C2CON0bits.C2OE                 // bit 5
#define C2OUT                   C2CON0bits.C2OUT                // bit 6
#define C2ON                    C2CON0bits.C2ON                 // bit 7

#define C2NCH0                  C2CON1bits.C2NCH0               // bit 0
#define C2NCH1                  C2CON1bits.C2NCH1               // bit 1
#define C2NCH2                  C2CON1bits.C2NCH2               // bit 2
#define C2PCH0                  C2CON1bits.C2PCH0               // bit 3
#define C2PCH1                  C2CON1bits.C2PCH1               // bit 4
#define C2PCH2                  C2CON1bits.C2PCH2               // bit 5
#define C2INTN                  C2CON1bits.C2INTN               // bit 6
#define C2INTP                  C2CON1bits.C2INTP               // bit 7

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5

#define MCOUT1                  CMOUTbits.MCOUT1                // bit 0
#define MCOUT2                  CMOUTbits.MCOUT2                // bit 1

#define G1ASD0L0                COG1ASD0bits.G1ASD0L0           // bit 2
#define G1ASD0L1                COG1ASD0bits.G1ASD0L1           // bit 3
#define G1ASD1L0                COG1ASD0bits.G1ASD1L0           // bit 4
#define G1ASD1L1                COG1ASD0bits.G1ASD1L1           // bit 5
#define G1ARSEN                 COG1ASD0bits.G1ARSEN            // bit 6
#define G1ASDE                  COG1ASD0bits.G1ASDE             // bit 7

#define G1ASDSFLT               COG1ASD1bits.G1ASDSFLT          // bit 0
#define G1ASDSC1                COG1ASD1bits.G1ASDSC1           // bit 1
#define G1ASDSC2                COG1ASD1bits.G1ASDSC2           // bit 2
#define G1ASDSHLT1              COG1ASD1bits.G1ASDSHLT1         // bit 3
#define G1ASDSHLT2              COG1ASD1bits.G1ASDSHLT2         // bit 4

#define G1BKF0                  COG1BKFbits.G1BKF0              // bit 0
#define G1BKF1                  COG1BKFbits.G1BKF1              // bit 1
#define G1BKF2                  COG1BKFbits.G1BKF2              // bit 2
#define G1BKF3                  COG1BKFbits.G1BKF3              // bit 3

#define G1BKR0                  COG1BKRbits.G1BKR0              // bit 0
#define G1BKR1                  COG1BKRbits.G1BKR1              // bit 1
#define G1BKR2                  COG1BKRbits.G1BKR2              // bit 2
#define G1BKR3                  COG1BKRbits.G1BKR3              // bit 3

#define G1MD                    COG1CON0bits.G1MD               // bit 0
#define G1LD                    COG1CON0bits.G1LD               // bit 2
#define G1POL0                  COG1CON0bits.G1POL0             // bit 3
#define G1POL1                  COG1CON0bits.G1POL1             // bit 4
#define G1OE0                   COG1CON0bits.G1OE0              // bit 5
#define G1OE1                   COG1CON0bits.G1OE1              // bit 6
#define G1EN                    COG1CON0bits.G1EN               // bit 7

#define G1CS0                   COG1CON1bits.G1CS0              // bit 0
#define G1CS1                   COG1CON1bits.G1CS1              // bit 1
#define G1FDBTS                 COG1CON1bits.G1FDBTS            // bit 6
#define G1RDBTS                 COG1CON1bits.G1RDBTS            // bit 7

#define G1DBF0                  COG1DBFbits.G1DBF0              // bit 0
#define G1DBF1                  COG1DBFbits.G1DBF1              // bit 1
#define G1DBF2                  COG1DBFbits.G1DBF2              // bit 2
#define G1DBF3                  COG1DBFbits.G1DBF3              // bit 3

#define G1DBR0                  COG1DBRbits.G1DBR0              // bit 0
#define G1DBR1                  COG1DBRbits.G1DBR1              // bit 1
#define G1DBR2                  COG1DBRbits.G1DBR2              // bit 2
#define G1DBR3                  COG1DBRbits.G1DBR3              // bit 3

#define G1FIC1                  COG1FISbits.G1FIC1              // bit 0
#define G1FIC2                  COG1FISbits.G1FIC2              // bit 1
#define G1FICCP1                COG1FISbits.G1FICCP1            // bit 2
#define G1FIFLT                 COG1FISbits.G1FIFLT             // bit 3
#define G1FIT2M                 COG1FISbits.G1FIT2M             // bit 4
#define G1FIHLT1                COG1FISbits.G1FIHLT1            // bit 5
#define G1FIHLT2                COG1FISbits.G1FIHLT2            // bit 6

#define G1FMC1                  COG1FSIMbits.G1FMC1             // bit 0
#define G1FMC2                  COG1FSIMbits.G1FMC2             // bit 1
#define G1FMCCP1                COG1FSIMbits.G1FMCCP1           // bit 2
#define G1FMFLT                 COG1FSIMbits.G1FMFLT            // bit 3
#define G1FMT2M                 COG1FSIMbits.G1FMT2M            // bit 4
#define G1FMHLT1                COG1FSIMbits.G1FMHLT1           // bit 5
#define G1FMHLT2                COG1FSIMbits.G1FMHLT2           // bit 6

#define G1PHF0                  COG1PHFbits.G1PHF0              // bit 0
#define G1PHF1                  COG1PHFbits.G1PHF1              // bit 1
#define G1PHF2                  COG1PHFbits.G1PHF2              // bit 2
#define G1PHF3                  COG1PHFbits.G1PHF3              // bit 3

#define G1PHR0                  COG1PHRbits.G1PHR0              // bit 0
#define G1PHR1                  COG1PHRbits.G1PHR1              // bit 1
#define G1PHR2                  COG1PHRbits.G1PHR2              // bit 2
#define G1PHR3                  COG1PHRbits.G1PHR3              // bit 3

#define G1RIC1                  COG1RISbits.G1RIC1              // bit 0
#define G1RIC2                  COG1RISbits.G1RIC2              // bit 1
#define C1RICCP1                COG1RISbits.C1RICCP1            // bit 2
#define G1RIFLT                 COG1RISbits.G1RIFLT             // bit 3
#define G1RIT2M                 COG1RISbits.G1RIT2M             // bit 4
#define G1R1HLT1                COG1RISbits.G1R1HLT1            // bit 5
#define G1RIHLT2                COG1RISbits.G1RIHLT2            // bit 6

#define G1RMC1                  COG1RSIMbits.G1RMC1             // bit 0
#define G1RMC2                  COG1RSIMbits.G1RMC2             // bit 1
#define G1RMCCP1                COG1RSIMbits.G1RMCCP1           // bit 2
#define G1RMFLT                 COG1RSIMbits.G1RMFLT            // bit 3
#define G1RTM2M                 COG1RSIMbits.G1RTM2M            // bit 4
#define G1RMHLT1                COG1RSIMbits.G1RMHLT1           // bit 5
#define G1RMHLT2                COG1RSIMbits.G1RMHLT2           // bit 6

#define DACPSS0                 DAC1CON0bits.DACPSS0            // bit 2
#define DACPSS1                 DAC1CON0bits.DACPSS1            // bit 3
#define DACOE                   DAC1CON0bits.DACOE              // bit 5
#define DACFM                   DAC1CON0bits.DACFM              // bit 6
#define DACEN                   DAC1CON0bits.DACEN              // bit 7

#define FVRBUFEN                FVR1CON0bits.FVRBUFEN           // bit 0
#define FVRBUSS0                FVR1CON0bits.FVRBUSS0           // bit 3
#define FVRBUSS1                FVR1CON0bits.FVRBUSS1           // bit 4
#define FVROE                   FVR1CON0bits.FVROE              // bit 5
#define FVRRDY                  FVR1CON0bits.FVRRDY             // bit 6
#define FVREN                   FVR1CON0bits.FVREN              // bit 7

#define H1CKPS0                 HLT1CON0bits.H1CKPS0            // bit 0
#define H1CKPS1                 HLT1CON0bits.H1CKPS1            // bit 1
#define H1ON                    HLT1CON0bits.H1ON               // bit 2
#define H1OUTPS0                HLT1CON0bits.H1OUTPS0           // bit 3
#define H1OUTPS1                HLT1CON0bits.H1OUTPS1           // bit 4
#define H1OUTPS2                HLT1CON0bits.H1OUTPS2           // bit 5
#define H1OUTPS3                HLT1CON0bits.H1OUTPS3           // bit 6

#define H1REREN                 HLT1CON1bits.H1REREN            // bit 0
#define H1FEREN                 HLT1CON1bits.H1FEREN            // bit 1
#define H1ERS0                  HLT1CON1bits.H1ERS0             // bit 2
#define H1ERS1                  HLT1CON1bits.H1ERS1             // bit 3
#define H1ERS2                  HLT1CON1bits.H1ERS2             // bit 4
#define H1RES                   HLT1CON1bits.H1RES              // bit 6
#define H1FES                   HLT1CON1bits.H1FES              // bit 7

#define H2CKPS0                 HLT2CON0bits.H2CKPS0            // bit 0
#define H2CKPS1                 HLT2CON0bits.H2CKPS1            // bit 1
#define H2ON                    HLT2CON0bits.H2ON               // bit 2
#define H2OUTPS0                HLT2CON0bits.H2OUTPS0           // bit 3
#define H2OUTPS1                HLT2CON0bits.H2OUTPS1           // bit 4
#define H2OUTPS2                HLT2CON0bits.H2OUTPS2           // bit 5
#define H2OUTPS3                HLT2CON0bits.H2OUTPS3           // bit 6

#define H2REREN                 HLT2CON1bits.H2REREN            // bit 0
#define H2FEREN                 HLT2CON1bits.H2FEREN            // bit 1
#define H2ERS0                  HLT2CON1bits.H2ERS0             // bit 2
#define H2ERS1                  HLT2CON1bits.H2ERS1             // bit 3
#define H2ERS2                  HLT2CON1bits.H2ERS2             // bit 4
#define H2RES                   HLT2CON1bits.H2RES              // bit 6
#define H2FES                   HLT2CON1bits.H2FES              // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define T0IF                    INTCONbits.T0IF                 // bit 2
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define T0IE                    INTCONbits.T0IE                 // bit 5
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5

#define OPA1PCH0                OPA1CONbits.OPA1PCH0            // bit 0
#define OPA1PCH1                OPA1CONbits.OPA1PCH1            // bit 1
#define OPA1NCH0                OPA1CONbits.OPA1NCH0            // bit 2
#define OPA1NCH1                OPA1CONbits.OPA1NCH1            // bit 3
#define OPAUGM                  OPA1CONbits.OPAUGM              // bit 4
#define OPAEN                   OPA1CONbits.OPAEN               // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RAPU                OPTION_REGbits.NOT_RAPU         // bit 7

#define LTS                     OSCCONbits.LTS                  // bit 1
#define HTS                     OSCCONbits.HTS                  // bit 2
#define IRCF0                   OSCCONbits.IRCF0                // bit 4
#define IRCF1                   OSCCONbits.IRCF1                // bit 5

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define HLTMR1IE                PIE1bits.HLTMR1IE               // bit 2
#define HLTMR2IE                PIE1bits.HLTMR2IE               // bit 3
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP1IE                  PIE2bits.CCP1IE                 // bit 0
#define COG1IE                  PIE2bits.COG1IE                 // bit 2
#define C1IE                    PIE2bits.C1IE                   // bit 4
#define C2IE                    PIE2bits.C2IE                   // bit 5

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define HLTMR1IF                PIR1bits.HLTMR1IF               // bit 2
#define HLTMR2IF                PIR1bits.HLTMR2IF               // bit 3
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP1IF                  PIR2bits.CCP1IF                 // bit 0
#define COG1IF                  PIR2bits.COG1IF                 // bit 2
#define C1IF                    PIR2bits.C1IF                   // bit 4
#define C2IF                    PIR2bits.C2IF                   // bit 5

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5

#define SC1INS                  SLPC1CON0bits.SC1INS            // bit 0
#define SCS1TSS0                SLPC1CON0bits.SCS1TSS0          // bit 2
#define SCS1TSS1                SLPC1CON0bits.SCS1TSS1          // bit 3
#define SC1POL                  SLPC1CON0bits.SC1POL            // bit 4
#define SC1MRPE                 SLPC1CON0bits.SC1MRPE           // bit 5
#define SC1EN                   SLPC1CON0bits.SC1EN             // bit 7

#define SC1ISET0                SLPC1CON1bits.SC1ISET0          // bit 0
#define SC1ISET1                SLPC1CON1bits.SC1ISET1          // bit 1
#define SC1ISET2                SLPC1CON1bits.SC1ISET2          // bit 2
#define SC1ISET3                SLPC1CON1bits.SC1ISET3          // bit 3
#define SC1RNG                  SLPC1CON1bits.SC1RNG            // bit 4

#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3, shadows bit in T1GCONbits
#define T1GGO                   T1GCONbits.T1GGO                // bit 3, shadows bit in T1GCONbits
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F753_H__
