/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.testing.TestClassLoaderFactory;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.testng.TestNGDetector;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestClassProcessor;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGTestFramework
implements TestFramework {
    private TestNGOptions options;
    private final TestNGDetector detector;
    private final Test testTask;
    private final DefaultTestFilter filter;
    private final TestClassLoaderFactory classLoaderFactory;

    public TestNGTestFramework(final Test testTask, DefaultTestFilter filter, Instantiator instantiator, ClassLoaderCache classLoaderCache) {
        this.testTask = testTask;
        this.filter = filter;
        this.options = (TestNGOptions)((Object)instantiator.newInstance(TestNGOptions.class, new Object[]{testTask.getProject().getProjectDir()}));
        DeprecationLogger.whileDisabled((Runnable)new Runnable(){

            public void run() {
                TestNGTestFramework.this.options.setAnnotationsOnSourceCompatibility(JavaVersion.toVersion((Object)testTask.getProject().property("sourceCompatibility")));
            }
        });
        TestNGTestFramework.conventionMapOutputDirectory(this.options, testTask.getReports().getHtml());
        this.detector = new TestNGDetector(new ClassFileExtractionManager((Factory<File>)testTask.getTemporaryDirFactory()));
        this.classLoaderFactory = new TestClassLoaderFactory(classLoaderCache, testTask);
    }

    private static void conventionMapOutputDirectory(TestNGOptions options, final DirectoryReport html) {
        new DslObject((Object)options).getConventionMapping().map("outputDirectory", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return html.getDestination();
            }
        });
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        this.verifyConfigFailurePolicy();
        this.verifyPreserveOrder();
        this.verifyGroupByInstances();
        DeprecationLogger.whileDisabled((Runnable)new Runnable(){

            public void run() {
                TestNGTestFramework.this.options.setTestResources(TestNGTestFramework.this.testTask.getTestSrcDirs());
            }
        });
        List<File> suiteFiles = this.options.getSuites(this.testTask.getTemporaryDir());
        TestNGSpec spec = (TestNGSpec)DeprecationLogger.whileDisabled((Factory)new Factory<TestNGSpec>(){

            public TestNGSpec create() {
                return new TestNGSpec(TestNGTestFramework.this.options, TestNGTestFramework.this.filter);
            }
        });
        return new TestClassProcessorFactoryImpl(this.options.getOutputDirectory(), spec, suiteFiles);
    }

    private void verifyConfigFailurePolicy() {
        if (!this.options.getConfigFailurePolicy().equals("skip")) {
            this.verifyMethodExists("setConfigFailurePolicy", String.class, String.format("The version of TestNG used does not support setting config failure policy to '%s'.", this.options.getConfigFailurePolicy()));
        }
    }

    private void verifyPreserveOrder() {
        if (this.options.getPreserveOrder()) {
            this.verifyMethodExists("setPreserveOrder", Boolean.TYPE, "Preserving the order of tests is not supported by this version of TestNG.");
        }
    }

    private void verifyGroupByInstances() {
        if (this.options.getGroupByInstances()) {
            this.verifyMethodExists("setGroupByInstances", Boolean.TYPE, "Grouping tests by instances is not supported by this version of TestNG.");
        }
    }

    private void verifyMethodExists(String methodName, Class<?> parameterType, String failureMessage) {
        try {
            this.createTestNg().getMethod(methodName, parameterType);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidUserDataException(failureMessage, (Throwable)e);
        }
    }

    private Class<?> createTestNg() {
        try {
            return this.classLoaderFactory.create().loadClass("org.testng.TestNG");
        }
        catch (ClassNotFoundException e) {
            throw new GradleException("Could not load TestNG.", (Throwable)e);
        }
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return new Action<WorkerProcessBuilder>(){

            public void execute(WorkerProcessBuilder workerProcessBuilder) {
                workerProcessBuilder.sharedPackages(new String[]{"org.testng"});
            }
        };
    }

    @Override
    public TestNGOptions getOptions() {
        return this.options;
    }

    void setOptions(TestNGOptions options) {
        this.options = options;
    }

    @Override
    public TestNGDetector getDetector() {
        return this.detector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassProcessorFactoryImpl
    implements WorkerTestClassProcessorFactory,
    Serializable {
        private final File testReportDir;
        private final TestNGSpec options;
        private final List<File> suiteFiles;

        public TestClassProcessorFactoryImpl(File testReportDir, TestNGSpec options, List<File> suiteFiles) {
            this.testReportDir = testReportDir;
            this.options = options;
            this.suiteFiles = suiteFiles;
        }

        public TestClassProcessor create(ServiceRegistry serviceRegistry) {
            return new TestNGTestClassProcessor(this.testReportDir, this.options, this.suiteFiles, (IdGenerator)serviceRegistry.get(IdGenerator.class), (TimeProvider)serviceRegistry.get(TimeProvider.class), (ActorFactory)serviceRegistry.get(ActorFactory.class));
        }
    }
}

