/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeProjectComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectArtifactBuilder;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.service.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeProjectArtifactBuilder
implements ProjectArtifactBuilder {
    private final GradleLauncherFactory gradleLauncherFactory;
    private final StartParameter requestedStartParameter;
    private final ServiceRegistry serviceRegistry;
    private final Set<ProjectComponentIdentifier> executingProjects = Sets.newHashSet();
    private final Multimap<ProjectComponentIdentifier, String> executedTasks = LinkedHashMultimap.create();

    public CompositeProjectArtifactBuilder(GradleLauncherFactory gradleLauncherFactory, StartParameter requestedStartParameter, ServiceRegistry serviceRegistry) {
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.requestedStartParameter = requestedStartParameter;
        this.serviceRegistry = serviceRegistry;
    }

    private synchronized void buildStarted(ProjectComponentIdentifier project) {
        if (!this.executingProjects.add(project)) {
            DefaultProjectComponentSelector selector = new DefaultProjectComponentSelector(project.getProjectPath());
            throw new ModuleVersionResolveException((ComponentSelector)selector, "Dependency cycle including " + project);
        }
    }

    private synchronized void buildCompleted(ProjectComponentIdentifier project) {
        this.executingProjects.remove(project);
    }

    @Override
    public void build(ComponentArtifactMetaData artifact) {
        if (artifact instanceof CompositeProjectComponentArtifactMetaData) {
            CompositeProjectComponentArtifactMetaData artifactMetaData = (CompositeProjectComponentArtifactMetaData)artifact;
            this.build(artifactMetaData.getComponentId(), artifactMetaData.getRootDirectory(), artifactMetaData.getTasks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(ProjectComponentIdentifier project, File buildDirectory, Iterable<String> taskNames) {
        this.buildStarted(project);
        try {
            this.doBuild(project, buildDirectory, taskNames);
        }
        finally {
            this.buildCompleted(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBuild(ProjectComponentIdentifier project, File buildDirectory, Iterable<String> taskNames) {
        ArrayList tasksToExecute = Lists.newArrayList();
        for (String taskName : taskNames) {
            if (!this.executedTasks.put((Object)project, (Object)taskName)) continue;
            tasksToExecute.add(taskName);
        }
        if (tasksToExecute.isEmpty()) {
            return;
        }
        StartParameter param = this.requestedStartParameter.newInstance();
        param.setProjectDir(buildDirectory);
        param.setTaskNames((Iterable)tasksToExecute);
        GradleLauncher launcher = this.gradleLauncherFactory.newInstance(param, this.serviceRegistry);
        try {
            launcher.run();
        }
        finally {
            launcher.stop();
        }
    }
}

