/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.standalone;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import org.gradle.gradleplugin.userinterface.swing.standalone.Application;
import org.gradle.internal.UncheckedException;

public class BlockingApplication {
    public static void launchAndBlock() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Cannot launch and block from the Event Dispatch Thread!");
        }
        final CountDownLatch completed = new CountDownLatch(1);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    new Application(new Application.LifecycleListener(){

                        public void hasShutDown() {
                            completed.countDown();
                        }
                    });
                }
            });
            completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
        }
    }
}

