/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.market;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.encog.ml.data.market.MarketDataDescription;
import org.encog.ml.data.market.MarketError;
import org.encog.ml.data.market.TickerSymbol;
import org.encog.ml.data.market.loader.LoadedMarketData;
import org.encog.ml.data.market.loader.MarketLoader;
import org.encog.ml.data.temporal.TemporalDataDescription;
import org.encog.ml.data.temporal.TemporalMLDataSet;
import org.encog.ml.data.temporal.TemporalPoint;
import org.encog.neural.data.NeuralData;
import org.encog.util.time.TimeUnit;

public class MarketMLDataSet
extends TemporalMLDataSet {
    private static final long serialVersionUID = 170791819906003867L;
    private final MarketLoader loader;
    private final Map<Integer, TemporalPoint> pointIndex = new HashMap<Integer, TemporalPoint>();

    public MarketMLDataSet(MarketLoader loader, int inputWindowSize, int predictWindowSize) {
        super(inputWindowSize, predictWindowSize);
        this.loader = loader;
        this.setSequenceGrandularity(TimeUnit.DAYS);
    }

    @Override
    public void addDescription(TemporalDataDescription desc) {
        if (!(desc instanceof MarketDataDescription)) {
            String str = "Only MarketDataDescription objects may be used with the MarketNeuralDataSet container.";
            throw new MarketError("Only MarketDataDescription objects may be used with the MarketNeuralDataSet container.");
        }
        super.addDescription(desc);
    }

    @Override
    public TemporalPoint createPoint(Date when) {
        int sequence = this.getSequenceFromDate(when);
        TemporalPoint result = this.pointIndex.get(sequence);
        if (result == null) {
            result = super.createPoint(when);
            this.pointIndex.put(result.getSequence(), result);
        }
        return result;
    }

    public NeuralData generateInputForPrediction(Date date) {
        return null;
    }

    public MarketLoader getLoader() {
        return this.loader;
    }

    public void load(Date begin, Date end) {
        if (this.getStartingPoint() == null) {
            this.setStartingPoint(begin);
        }
        this.getPoints().clear();
        HashSet<TickerSymbol> set = new HashSet<TickerSymbol>();
        for (TemporalDataDescription desc : this.getDescriptions()) {
            MarketDataDescription mdesc = (MarketDataDescription)desc;
            set.add(mdesc.getTicker());
        }
        for (TickerSymbol symbol : set) {
            this.loadSymbol(symbol, begin, end);
        }
        this.sortPoints();
    }

    private void loadPointFromMarketData(TickerSymbol ticker, TemporalPoint point, LoadedMarketData item) {
        for (TemporalDataDescription desc : this.getDescriptions()) {
            MarketDataDescription mdesc = (MarketDataDescription)desc;
            if (!mdesc.getTicker().equals(ticker)) continue;
            point.setData(mdesc.getIndex(), item.getData(mdesc.getDataType()));
        }
    }

    private void loadSymbol(TickerSymbol ticker, Date from, Date to) {
        Collection<LoadedMarketData> data = this.getLoader().load(ticker, null, from, to);
        for (LoadedMarketData item : data) {
            TemporalPoint point = this.createPoint(item.getWhen());
            this.loadPointFromMarketData(ticker, point, item);
        }
    }
}

