/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.schedule;

import org.encog.ml.graph.BasicEdge;
import org.encog.ml.schedule.ActionNode;
import org.encog.ml.schedule.ScheduleGraph;

public class CalculateScheduleTimes {
    public void forward(ActionNode node) {
        double m = Double.NEGATIVE_INFINITY;
        for (BasicEdge edge : node.getBackConnections()) {
            double d = ((ActionNode)edge.getFrom()).getEarliestStartTime() + ((ActionNode)edge.getFrom()).getDuration();
            m = Math.max(d, m);
        }
        node.setEarliestStartTime(m);
        for (BasicEdge edge : node.getConnections()) {
            this.forward((ActionNode)edge.getTo());
        }
    }

    public void backward(ActionNode node) {
        double m = Double.POSITIVE_INFINITY;
        for (BasicEdge edge : node.getConnections()) {
            double d = ((ActionNode)edge.getTo()).getLatestStartTime() - ((ActionNode)edge.getFrom()).getDuration();
            m = Math.min(d, m);
        }
        node.setLatestStartTime(m);
        for (BasicEdge edge : node.getBackConnections()) {
            this.backward((ActionNode)edge.getFrom());
        }
    }

    public void calculate(ScheduleGraph graph) {
        graph.getStartNode().setEarliestStartTime(0.0);
        for (BasicEdge edge : graph.getStartNode().getConnections()) {
            this.forward((ActionNode)edge.getTo());
        }
        graph.getFinishNode().setLatestStartTime(graph.getFinishNode().getEarliestStartTime());
        for (BasicEdge edge : graph.getFinishNode().getBackConnections()) {
            this.backward((ActionNode)edge.getFrom());
        }
    }
}

