/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class MapViewState {
    private final Projection projection;
    private final int viewWidth;
    private final int viewHeight;
    private final double scale;
    private final EastNorth topLeft;
    private final Point topLeftOnScreen;
    private final Point topLeftInWindow;

    private MapViewState(Projection projection, int n, int n2, double d, EastNorth eastNorth) {
        this.projection = projection;
        this.scale = d;
        this.topLeft = eastNorth;
        this.viewWidth = n;
        this.viewHeight = n2;
        this.topLeftInWindow = new Point(0, 0);
        this.topLeftOnScreen = new Point(0, 0);
    }

    private MapViewState(EastNorth eastNorth, MapViewState mapViewState) {
        this.projection = mapViewState.projection;
        this.scale = mapViewState.scale;
        this.topLeft = eastNorth;
        this.viewWidth = mapViewState.viewWidth;
        this.viewHeight = mapViewState.viewHeight;
        this.topLeftInWindow = mapViewState.topLeftInWindow;
        this.topLeftOnScreen = mapViewState.topLeftOnScreen;
    }

    private MapViewState(double d, MapViewState mapViewState) {
        this.projection = mapViewState.projection;
        this.scale = d;
        this.topLeft = mapViewState.topLeft;
        this.viewWidth = mapViewState.viewWidth;
        this.viewHeight = mapViewState.viewHeight;
        this.topLeftInWindow = mapViewState.topLeftInWindow;
        this.topLeftOnScreen = mapViewState.topLeftOnScreen;
    }

    private MapViewState(JComponent jComponent, MapViewState mapViewState) {
        this.projection = mapViewState.projection;
        this.scale = mapViewState.scale;
        this.topLeft = mapViewState.topLeft;
        this.viewWidth = jComponent.getWidth();
        this.viewHeight = jComponent.getHeight();
        this.topLeftInWindow = new Point();
        for (Container container = jComponent; container != null; container = container.getParent()) {
            this.topLeftInWindow.x += ((Component)container).getX();
            this.topLeftInWindow.y += ((Component)container).getY();
        }
        try {
            this.topLeftOnScreen = jComponent.getLocationOnScreen();
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("position", jComponent).put("parent", jComponent::getParent);
        }
    }

    private MapViewState(Projection projection, MapViewState mapViewState) {
        this.projection = projection;
        this.scale = mapViewState.scale;
        this.topLeft = mapViewState.topLeft;
        this.viewWidth = mapViewState.viewWidth;
        this.viewHeight = mapViewState.viewHeight;
        this.topLeftInWindow = mapViewState.topLeftInWindow;
        this.topLeftOnScreen = mapViewState.topLeftOnScreen;
    }

    public double getScale() {
        return this.scale;
    }

    public MapViewPoint getForView(double d, double d2) {
        return new MapViewViewPoint(d, d2);
    }

    public MapViewPoint getPointFor(EastNorth eastNorth) {
        return new MapViewEastNorthPoint(eastNorth);
    }

    public MapViewPoint getPointFor(LatLon latLon) {
        return this.getPointFor(this.getProjection().latlon2eastNorth(latLon));
    }

    public MapViewRectangle getViewArea() {
        return this.getForView(0.0, 0.0).rectTo(this.getForView(this.viewWidth, this.viewHeight));
    }

    public MapViewRectangle getViewArea(Rectangle rectangle) {
        return this.getForView(rectangle.getMinX(), rectangle.getMinY()).rectTo(this.getForView(rectangle.getMaxX(), rectangle.getMaxY()));
    }

    public MapViewPoint getCenter() {
        return this.getForView((double)this.viewWidth / 2.0, (double)this.viewHeight / 2.0);
    }

    public double getViewWidth() {
        return this.viewWidth;
    }

    public double getViewHeight() {
        return this.viewHeight;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(1.0 / this.scale, 0.0, 0.0, -1.0 / this.scale, -this.topLeft.east() / this.scale, this.topLeft.north() / this.scale);
    }

    public MapViewState usingCenter(EastNorth eastNorth) {
        return this.movedTo(this.getCenter(), eastNorth);
    }

    public MapViewState movedTo(MapViewPoint mapViewPoint, EastNorth eastNorth) {
        EastNorth eastNorth2 = eastNorth.subtract(mapViewPoint.getEastNorth());
        if (eastNorth2.distanceSq(0.0, 0.0) < 1.0E-21) {
            return this;
        }
        return new MapViewState(this.topLeft.add(eastNorth2), this);
    }

    public MapViewState usingScale(double d) {
        return new MapViewState(d, this);
    }

    public MapViewState usingLocation(JComponent jComponent) {
        EastNorth eastNorth = this.getCenter().getEastNorth();
        return new MapViewState(jComponent, this).usingCenter(eastNorth);
    }

    public MapViewState usingProjection(Projection projection) {
        if (projection.equals(this.projection)) {
            return this;
        }
        return new MapViewState(projection, this);
    }

    public static MapViewState createDefaultState(int n, int n2) {
        Projection projection = Main.getProjection();
        double d = projection.getDefaultZoomInPPD();
        MapViewState mapViewState = new MapViewState(projection, n, n2, d, new EastNorth(0.0, 0.0));
        EastNorth eastNorth = MapViewState.calculateDefaultCenter();
        return mapViewState.movedTo(mapViewState.getCenter(), eastNorth);
    }

    private static EastNorth calculateDefaultCenter() {
        Bounds bounds = DownloadDialog.getSavedDownloadBounds();
        if (bounds == null) {
            bounds = Main.getProjection().getWorldBoundsLatLon();
        }
        return Main.getProjection().latlon2eastNorth(bounds.getCenter());
    }

    public class MapViewRectangle {
        private final MapViewPoint p1;
        private final MapViewPoint p2;

        MapViewRectangle(MapViewPoint mapViewPoint, MapViewPoint mapViewPoint2) {
            this.p1 = mapViewPoint;
            this.p2 = mapViewPoint2;
        }

        public ProjectionBounds getProjectionBounds() {
            ProjectionBounds projectionBounds = new ProjectionBounds(this.p1.getEastNorth());
            projectionBounds.extend(this.p2.getEastNorth());
            return projectionBounds;
        }

        public Bounds getCornerBounds() {
            Bounds bounds = new Bounds(this.p1.getLatLon());
            bounds.extend(this.p2.getLatLon());
            return bounds;
        }

        public Bounds getLatLonBoundsBox() {
            return MapViewState.this.projection.getLatLonBoundsBox(this.getProjectionBounds());
        }

        public Rectangle2D getInView() {
            double d = this.p1.getInViewX();
            double d2 = this.p1.getInViewY();
            double d3 = this.p2.getInViewX();
            double d4 = this.p2.getInViewY();
            return new Rectangle2D.Double(Math.min(d, d3), Math.min(d2, d4), Math.abs(d - d3), Math.abs(d2 - d4));
        }
    }

    private class MapViewEastNorthPoint
    extends MapViewPoint {
        private final EastNorth eastNorth;

        MapViewEastNorthPoint(EastNorth eastNorth) {
            this.eastNorth = eastNorth;
        }

        @Override
        protected double getInViewX() {
            return (this.eastNorth.east() - MapViewState.this.topLeft.east()) / MapViewState.this.scale;
        }

        @Override
        protected double getInViewY() {
            return (MapViewState.this.topLeft.north() - this.eastNorth.north()) / MapViewState.this.scale;
        }

        @Override
        public EastNorth getEastNorth() {
            return this.eastNorth;
        }

        public String toString() {
            return "MapViewEastNorthPoint [eastNorth=" + this.eastNorth + ']';
        }
    }

    private class MapViewViewPoint
    extends MapViewPoint {
        private final double x;
        private final double y;

        MapViewViewPoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        @Override
        protected double getInViewX() {
            return this.x;
        }

        @Override
        protected double getInViewY() {
            return this.y;
        }

        public String toString() {
            return "MapViewViewPoint [x=" + this.x + ", y=" + this.y + ']';
        }
    }

    public abstract class MapViewPoint {
        public Point2D getInView() {
            return new Point2D.Double(this.getInViewX(), this.getInViewY());
        }

        protected abstract double getInViewX();

        protected abstract double getInViewY();

        public Point2D getInWindow() {
            return this.getUsingCorner(MapViewState.this.topLeftInWindow);
        }

        public Point2D getOnScreen() {
            return this.getUsingCorner(MapViewState.this.topLeftOnScreen);
        }

        private Point2D.Double getUsingCorner(Point point) {
            return new Point2D.Double(point.getX() + this.getInViewX(), point.getY() + this.getInViewY());
        }

        public EastNorth getEastNorth() {
            return new EastNorth(MapViewState.this.topLeft.east() + this.getInViewX() * MapViewState.this.scale, MapViewState.this.topLeft.north() - this.getInViewY() * MapViewState.this.scale);
        }

        public MapViewRectangle rectTo(MapViewPoint mapViewPoint) {
            return new MapViewRectangle(this, mapViewPoint);
        }

        public LatLon getLatLon() {
            return MapViewState.this.projection.eastNorth2latlon(this.getEastNorth());
        }

        public MapViewPoint add(EastNorth eastNorth) {
            return new MapViewEastNorthPoint(this.getEastNorth().add(eastNorth));
        }
    }
}

