/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.data;

import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;

public final class PrimitiveTransferData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(PrimitiveTransferData.class, "OSM Primitives");
    private final ArrayList<PrimitiveData> direct;
    private final ArrayList<PrimitiveData> referenced;

    private PrimitiveTransferData(Collection<? extends OsmPrimitive> collection, ReferenceGetter referenceGetter) {
        HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        this.direct = new ArrayList(hashSet.size());
        this.referenced = new ArrayList();
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : hashSet) {
            this.direct.add(osmPrimitive.save());
            linkedList.addAll(referenceGetter.getReferredPrimitives(osmPrimitive));
        }
        while (!linkedList.isEmpty()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)linkedList.poll();
            if (!hashSet.add(osmPrimitive)) continue;
            this.referenced.add(osmPrimitive.save());
            linkedList.addAll(referenceGetter.getReferredPrimitives(osmPrimitive));
        }
    }

    public Collection<PrimitiveData> getDirectlyAdded() {
        return Collections.unmodifiableList(this.direct);
    }

    public Collection<PrimitiveData> getReferenced() {
        return Collections.unmodifiableList(this.referenced);
    }

    public Collection<PrimitiveData> getAll() {
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>();
        arrayList.addAll(this.direct);
        arrayList.addAll(this.referenced);
        return arrayList;
    }

    public static PrimitiveTransferData getData(Collection<? extends OsmPrimitive> collection) {
        return new PrimitiveTransferData(collection, osmPrimitive -> Collections.emptyList());
    }

    public static PrimitiveTransferData getDataWithReferences(Collection<? extends OsmPrimitive> collection) {
        return new PrimitiveTransferData(collection, new GetReferences());
    }

    public EastNorth getCenter() {
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (PrimitiveData primitiveData : this.getAll()) {
            if (!(primitiveData instanceof NodeData) || primitiveData.isIncomplete()) continue;
            boundingXYVisitor.visit(((NodeData)primitiveData).getEastNorth());
        }
        ProjectionBounds projectionBounds = boundingXYVisitor.getBounds();
        if (projectionBounds == null) {
            return null;
        }
        return projectionBounds.getCenter();
    }

    public boolean hasIncompleteData() {
        for (PrimitiveData primitiveData : this.getAll()) {
            if (!primitiveData.isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    private static interface ReferenceGetter {
        public Collection<? extends OsmPrimitive> getReferredPrimitives(OsmPrimitive var1);
    }

    private static final class GetReferences
    implements ReferenceGetter {
        private GetReferences() {
        }

        @Override
        public Collection<? extends OsmPrimitive> getReferredPrimitives(OsmPrimitive osmPrimitive) {
            if (osmPrimitive instanceof Way) {
                return ((Way)osmPrimitive).getNodes();
            }
            if (osmPrimitive instanceof Relation) {
                return ((Relation)osmPrimitive).getMemberPrimitives();
            }
            return Collections.emptyList();
        }
    }
}

