/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class CertificateAmendment {
    private static final String[] CERT_AMEND = new String[]{"resource://data/security/DST_Root_CA_X3.pem", "resource://data/security/StartCom_Certification_Authority.pem"};
    private static final String[] SHA_HASHES = new String[]{"0687260331a72403d909f105e69bcf0d32e1bd2493ffc6d9206d11bcd6770739", "c766a9bef2d4071c863a31aa4920e813b2d198608cb7b7cfe21143b836df09ea"};

    private CertificateAmendment() {
    }

    public static void addMissingCertificates() throws IOException, GeneralSecurityException {
        Object object;
        if (!Main.pref.getBoolean("tls.add-missing-certificates", true)) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path path = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        try (Object object2 = Files.newInputStream(path, new OpenOption[0]);){
            keyStore.load((InputStream)object2, "changeit".toCharArray());
        }
        object2 = CertificateFactory.getInstance("X.509");
        boolean bl = false;
        for (int i = 0; i < CERT_AMEND.length; ++i) {
            object = new CachedFile(CERT_AMEND[i]);
            Throwable throwable = null;
            try {
                byte[] byArray = ((CachedFile)object).getByteContent();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                X509Certificate x509Certificate = (X509Certificate)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                String string = Utils.toHexString(messageDigest.digest(x509Certificate.getEncoded()));
                if (!SHA_HASHES[i].equals(string)) {
                    throw new IllegalStateException(I18n.tr("Error adding certificate {0} - certificate fingerprint mismatch. Expected {1}, was {2}", CERT_AMEND[i], SHA_HASHES[i], string));
                }
                if (!CertificateAmendment.certificateIsMissing(keyStore, x509Certificate)) continue;
                if (Main.isDebugEnabled()) {
                    Main.debug(I18n.tr("Adding certificate for TLS connections: {0}", x509Certificate.getSubjectX500Principal().getName()));
                }
                String string2 = "josm:" + new File(CERT_AMEND[i]).getName();
                keyStore.setCertificateEntry(string2, x509Certificate);
                bl = true;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((CachedFile)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((CachedFile)object).close();
                    }
                }
            }
        }
        if (bl) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            object = SSLContext.getInstance("TLS");
            ((SSLContext)object).init(null, trustManagerFactory.getTrustManagers(), null);
            SSLContext.setDefault((SSLContext)object);
        }
    }

    private static boolean certificateIsMissing(KeyStore keyStore, X509Certificate x509Certificate) throws KeyStoreException, InvalidAlgorithmParameterException {
        PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
        String string = x509Certificate.getSubjectX500Principal().getName();
        for (TrustAnchor trustAnchor : pKIXParameters.getTrustAnchors()) {
            X509Certificate x509Certificate2 = trustAnchor.getTrustedCert();
            if (!Objects.equals(string, x509Certificate2.getSubjectX500Principal().getName())) continue;
            return false;
        }
        return true;
    }
}

