/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

public class ImagerySessionExporter
extends AbstractSessionExporter<ImageryLayer> {
    public ImagerySessionExporter(ImageryLayer imageryLayer) {
        super(imageryLayer);
    }

    public ImagerySessionExporter(TMSLayer tMSLayer) {
        super(tMSLayer);
    }

    public ImagerySessionExporter(WMSLayer wMSLayer) {
        super(wMSLayer);
    }

    public ImagerySessionExporter(WMTSLayer wMTSLayer) {
        super(wMTSLayer);
    }

    @Override
    public Component getExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(((ImageryLayer)this.layer).getName(), ((ImageryLayer)this.layer).getIcon(), 2);
        jLabel.setToolTipText(((ImageryLayer)this.layer).getToolTipText());
        jLabel.setLabelFor(this.export);
        jPanel.add((Component)this.export, GBC.std());
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        return jPanel;
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "imagery");
        element.setAttribute("version", "0.1");
        ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = new ImageryInfo.ImageryPreferenceEntry(((ImageryLayer)this.layer).getInfo());
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(Preferences.serializeStruct(imageryPreferenceEntry, ImageryInfo.ImageryPreferenceEntry.class));
        if (this.layer instanceof AbstractTileSourceLayer) {
            AbstractTileSourceLayer abstractTileSourceLayer = (AbstractTileSourceLayer)this.layer;
            abstractTileSourceLayer.getDisplaySettings().storeTo(linkedHashMap);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Element element2 = exportSupport.createElement((String)entry.getKey());
            element.appendChild(element2);
            element2.appendChild(exportSupport.createTextNode((String)entry.getValue()));
        }
        return element;
    }
}

