/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.awt.GraphicsEnvironment;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportDialog;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static boolean handlingInProgress;
    private static volatile BugReporterThread bugReporterThread;
    private static int exceptionCounter;
    private static boolean suppressExceptionDialogs;

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        BugReportExceptionHandler.handleException(throwable);
    }

    public static synchronized void handleException(Throwable throwable) {
        if (handlingInProgress || suppressExceptionDialogs) {
            return;
        }
        if (bugReporterThread != null && bugReporterThread.isAlive()) {
            return;
        }
        handlingInProgress = true;
        ++exceptionCounter;
        try {
            Main.error(throwable);
            if (Main.parent != null) {
                if (throwable instanceof OutOfMemoryError) {
                    JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
                    return;
                }
                bugReporterThread = new BugReporterThread(throwable);
                bugReporterThread.start();
            }
        }
        finally {
            handlingInProgress = false;
        }
    }

    public static boolean exceptionHandlingInProgress() {
        return handlingInProgress;
    }

    static final class BugReporterThread
    extends Thread {
        private final Throwable e;

        private BugReporterThread(Throwable throwable) {
            super("Bug Reporter");
            this.e = throwable;
        }

        static void askForBugReport(Throwable throwable) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            BugReport bugReport = new BugReport(BugReport.intercept(throwable));
            BugReportDialog bugReportDialog = new BugReportDialog(bugReport);
            bugReportDialog.setShowSuppress(exceptionCounter > 1);
            bugReportDialog.setVisible(true);
            suppressExceptionDialogs = bugReportDialog.shouldSuppressFurtherErrors();
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new BugReporterWorker(PluginHandler.updateOrdisablePluginAfterException(this.e)));
        }

        private final class BugReporterWorker
        implements Runnable {
            private final PluginDownloadTask pluginDownloadTask;

            private BugReporterWorker(PluginDownloadTask pluginDownloadTask) {
                this.pluginDownloadTask = pluginDownloadTask;
            }

            @Override
            public void run() {
                if (this.pluginDownloadTask == null) {
                    BugReporterThread.askForBugReport(BugReporterThread.this.e);
                } else {
                    PluginPreference.notifyDownloadResults(Main.parent, this.pluginDownloadTask, !this.pluginDownloadTask.getDownloadedPlugins().isEmpty());
                }
            }
        }
    }
}

