/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WikiReader;

public class JosmUpdatePanel
extends JPanel {
    private final JMultilineLabel testedVersionField;
    private final int josmVersion = Version.getInstance().getVersion();

    public JosmUpdatePanel() {
        super(new GridBagLayout());
        this.add((Component)new JMultilineLabel(I18n.tr("Your current version of JOSM is {0}", this.josmVersion)), GBC.eop().fill(2));
        this.testedVersionField = new JMultilineLabel(I18n.tr("JOSM is searching for updates...", new Object[0]));
        this.add((Component)this.testedVersionField, GBC.eop().fill(2));
        this.checkCurrentVersion();
    }

    private void checkCurrentVersion() {
        new Thread(this::readCurrentVersion, "JOSM version checker").start();
    }

    private void readCurrentVersion() {
        int n = JosmUpdatePanel.getTestedVersion();
        if (n < 0) {
            SwingUtilities.invokeLater(this::displayError);
        } else if (this.josmVersion < n) {
            SwingUtilities.invokeLater(() -> this.displayOutOfDate(n));
        } else {
            SwingUtilities.invokeLater(this::displayUpToDate);
        }
    }

    private static int getTestedVersion() {
        try {
            String string = new WikiReader().read(Main.getJOSMWebsite() + "/wiki/TestedVersion?format=txt");
            return Integer.parseInt(string.trim());
        }
        catch (IOException | NumberFormatException exception) {
            Main.warn((Throwable)exception, "Unable to detect latest version of JOSM:");
            return -1;
        }
    }

    private void displayError() {
        this.testedVersionField.setText(I18n.tr("An error occured while checking if your JOSM instance is up to date.", new Object[0]));
        this.showUpdateButton();
    }

    private void displayUpToDate() {
        this.testedVersionField.setText(I18n.tr("JOSM is up to date.", new Object[0]));
    }

    private void displayOutOfDate(int n) {
        this.testedVersionField.setText(I18n.tr("JOSM is out of date. The current version is {0}. Try updateing JOSM.", n));
        this.showUpdateButton();
    }

    private void showUpdateButton() {
        this.add((Component)new JMultilineLabel(I18n.tr("Before you file a bug report make sure you have updated to the latest version of JOSM here:", new Object[0])), GBC.eol());
        this.add((Component)new UrlLabel(Main.getJOSMWebsite(), 2), GBC.eop().insets(8, 0, 0, 0));
        JButton jButton = new JButton(I18n.tr("Update JOSM", new Object[0]), ImageProvider.get("download"));
        jButton.addActionListener(actionEvent -> JosmUpdatePanel.openJosmUpdateSite());
        this.add((Component)jButton, GBC.eol().anchor(13));
    }

    private static void openJosmUpdateSite() {
        try {
            Main.platform.openUrl(Main.getJOSMWebsite());
        }
        catch (IOException iOException) {
            Main.warn((Throwable)iOException, "Unable to access JOSM website:");
        }
    }
}

