/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.IsTaintedNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;

public class TaintResultNode
extends RubyNode {
    private final boolean taintFromSelf;
    private final int taintFromParameter;
    private final ConditionProfile taintProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private RubyNode method;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    @Node.Child
    private TaintNode taintNode;

    public TaintResultNode(boolean taintFromSelf, int taintFromParameter, RubyNode method) {
        super(method.getContext(), method.getEncapsulatingSourceSection());
        this.taintFromSelf = taintFromSelf;
        this.taintFromParameter = taintFromParameter;
        this.method = method;
        this.isTaintedNode = IsTaintedNodeGen.create(null, null, null);
    }

    public TaintResultNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.taintFromSelf = false;
        this.taintFromParameter = -1;
        this.isTaintedNode = IsTaintedNodeGen.create(null, null, null);
    }

    public Object maybeTaint(DynamicObject source, DynamicObject result) {
        if (this.taintProfile.profile(this.isTaintedNode.executeIsTainted(source))) {
            if (this.taintNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintNode = this.insert(TaintNodeGen.create(null, null, null));
            }
            this.taintNode.executeTaint(result);
        }
        return result;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject result;
        try {
            result = this.method.executeDynamicObject(frame);
        }
        catch (DoNotTaint e) {
            return e.getResult();
        }
        catch (UnexpectedResultException e) {
            throw new UnsupportedOperationException(e);
        }
        if (result != this.nil()) {
            Object argument;
            if (this.taintFromSelf) {
                this.maybeTaint((DynamicObject)RubyArguments.getSelf(frame), result);
            }
            if (this.taintFromParameter < RubyArguments.getArgumentsCount(frame) && (argument = RubyArguments.getArgument(frame, this.taintFromParameter)) instanceof DynamicObject) {
                DynamicObject taintSource = (DynamicObject)argument;
                this.maybeTaint(taintSource, result);
            }
        }
        return result;
    }

    public static class DoNotTaint
    extends ControlFlowException {
        private static final long serialVersionUID = 5321304910918469059L;
        private final Object result;

        public DoNotTaint(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

